/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Pattern;

public class Base62 {
    private static final BigInteger BASE = BigInteger.valueOf(62L);
    private static final String DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    private Base62() {
    }

    static String encode(BigInteger number) {
        if (number.compareTo(BigInteger.ZERO) < 0) {
            Base62.throwIllegalArgumentException("number must not be negative", new Object[0]);
        }
        StringBuilder result = new StringBuilder();
        while (number.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] divmod = number.divideAndRemainder(BASE);
            number = divmod[0];
            int digit = divmod[1].intValue();
            result.insert(0, DIGITS.charAt(digit));
        }
        return result.length() == 0 ? DIGITS.substring(0, 1) : result.toString();
    }

    private static BigInteger throwIllegalArgumentException(String format, Object ... args) {
        throw new IllegalArgumentException(String.format(format, args));
    }

    static BigInteger decode(String string) {
        return Base62.decode(string, 128);
    }

    static BigInteger decode(String string, int bitLimit) {
        Objects.requireNonNull(string, "Decoded string must not be null");
        if (string.length() == 0) {
            return Base62.throwIllegalArgumentException("String '%s' must not be empty", string);
        }
        if (!Pattern.matches("[0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz]*", string)) {
            Base62.throwIllegalArgumentException("String '%s' contains illegal characters, only '%s' are allowed", string, DIGITS);
        }
        BigInteger result = BigInteger.ZERO;
        int digits = string.length();
        for (int index = 0; index < digits; ++index) {
            int digit = DIGITS.indexOf(string.charAt(digits - index - 1));
            result = result.add(BigInteger.valueOf(digit).multiply(BASE.pow(index)));
            if (bitLimit <= 0 || result.bitLength() <= bitLimit) continue;
            Base62.throwIllegalArgumentException("String contains '%s' more than 128bit information (%sbit)", string, result.bitLength());
        }
        return result;
    }
}

