/*
 * Decompiled with CFR 0.152.
 */
package nextflow.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import nextflow.file.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CopyMoveHelper {
    private static Logger log = LoggerFactory.getLogger(CopyMoveHelper.class);

    private CopyMoveHelper() {
    }

    private static CopyOption[] convertMoveToCopyOptions(CopyOption ... options) throws AtomicMoveNotSupportedException {
        int len = options.length;
        CopyOption[] newOptions = new CopyOption[len + 1];
        for (int i = 0; i < len; ++i) {
            CopyOption option = options[i];
            if (option == StandardCopyOption.ATOMIC_MOVE) {
                throw new AtomicMoveNotSupportedException(null, null, "Atomic move between providers is not supported");
            }
            newOptions[i] = option;
        }
        newOptions[len] = LinkOption.NOFOLLOW_LINKS;
        return newOptions;
    }

    private static void copyFile(Path source, Path target, boolean foreign, CopyOption ... options) throws IOException {
        if (!foreign) {
            source.getFileSystem().provider().copy(source, target, options);
            return;
        }
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            Files.copy(in, target, new CopyOption[0]);
        }
    }

    static void copyDirectory(final Path source, final Path target, final CopyOption ... options) throws IOException {
        final boolean foreign = source.getFileSystem().provider() != target.getFileSystem().provider();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path current, BasicFileAttributes attr) throws IOException {
                Path newFolder;
                Path rel = source.relativize(current);
                String delta = rel != null ? rel.toString() : null;
                Path path = newFolder = delta != null ? target.resolve(delta) : target;
                if (log.isTraceEnabled()) {
                    log.trace("Copy DIR: " + current + " -> " + newFolder);
                }
                Files.createDirectory(newFolder, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path current, BasicFileAttributes attr) throws IOException {
                Path newFile;
                Path rel = source.relativize(current);
                String delta = rel != null ? rel.toString() : null;
                Path path = newFile = delta != null ? target.resolve(delta) : target;
                if (log.isTraceEnabled()) {
                    log.trace("Copy file: " + current + " -> " + newFile.toUri());
                }
                CopyMoveHelper.copyFile(current, newFile, foreign, options);
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
    }

    static void copyToForeignTarget(Path source, Path target, CopyOption ... options) throws IOException {
        LinkOption[] linkOptionArray;
        CopyOptions opts = CopyOptions.parse(options);
        if (opts.followLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] linkOptions = linkOptionArray;
        BasicFileAttributes attrs = Files.readAttributes(source, BasicFileAttributes.class, linkOptions);
        if (attrs.isSymbolicLink()) {
            throw new IOException("Copying of symbolic links not supported");
        }
        if (opts.replaceExisting) {
            FileHelper.deletePath(target);
        } else if (Files.exists(target, new LinkOption[0])) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (attrs.isDirectory()) {
            CopyMoveHelper.copyDirectory(source, target, new CopyOption[0]);
        } else {
            CopyMoveHelper.copyFile(source, target, true, new CopyOption[0]);
        }
    }

    static void moveToForeignTarget(Path source, Path target, CopyOption ... options) throws IOException {
        CopyMoveHelper.copyToForeignTarget(source, target, CopyMoveHelper.convertMoveToCopyOptions(options));
        FileHelper.deletePath(source);
    }

    private static class CopyOptions {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean followLinks = true;

        private CopyOptions() {
        }

        static CopyOptions parse(CopyOption ... options) {
            CopyOptions result = new CopyOptions();
            for (CopyOption option : options) {
                if (option == StandardCopyOption.REPLACE_EXISTING) {
                    result.replaceExisting = true;
                    continue;
                }
                if (option == LinkOption.NOFOLLOW_LINKS) {
                    result.followLinks = false;
                    continue;
                }
                if (option == StandardCopyOption.COPY_ATTRIBUTES) {
                    result.copyAttributes = true;
                    continue;
                }
                if (option == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException("'" + option + "' is not a recognized copy option");
            }
            return result;
        }
    }
}

