/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMultiply;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EqualsAndHashCode(includes={"durationInMillis"})
public class Duration
implements Comparable<Duration>,
Serializable,
Cloneable,
GroovyObject {
    private static final Object FORMAT;
    private static final Object LEGACY;
    private static final List<String> MILLIS;
    private static final List<String> SECONDS;
    private static final List<String> MINUTES;
    private static final List<String> HOURS;
    private static final List<String> DAYS;
    public static final List<String> UNITS;
    private final long durationInMillis;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public Duration(long duration) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!(duration >= (long)0)) {
            StringBuffer stringBuffer = new StringBuffer("(duration >= 0). Values: ");
            stringBuffer.append((Object)"duration = ");
            stringBuffer.append(InvokerHelper.toString((Object)duration));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Duration unit cannot be a negative number");
        }
        long l = duration;
        this.durationInMillis = l;
    }

    private Duration() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        int n = 0;
        this.durationInMillis = n;
    }

    public Duration(String str) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        try {
            try {
                long l = this.parseSimple(str);
                this.durationInMillis = l;
            }
            catch (IllegalArgumentException e) {
                long l = this.parseLegacy(str);
                this.durationInMillis = l;
            }
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid duration value: ", ""})), e);
        }
    }

    public Duration(long value, TimeUnit unit) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!(value >= (long)0)) {
            StringBuffer stringBuffer = new StringBuffer("(value >= 0). Values: ");
            stringBuffer.append((Object)"value = ");
            stringBuffer.append(InvokerHelper.toString((Object)value));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Duration unit cannot be a negative number");
        }
        if (!(unit != null)) {
            StringBuffer stringBuffer = new StringBuffer("unit. Values: ");
            stringBuffer.append((Object)"unit = ");
            stringBuffer.append(InvokerHelper.toString((Object)((Object)unit)));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Time unit cannot be null");
        }
        long l = unit.toMillis(value);
        this.durationInMillis = l;
    }

    static {
        List list;
        Logger logger;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        Object object;
        Object object2;
        FORMAT = object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(\\d+\\.?\\d*)\\s*([a-zA-Z]+)");
        LEGACY = object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(\\d{1,2}):(\\d{1,2}):(\\d{1,2})$");
        MILLIS = list6 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"ms", "milli", "millis"});
        SECONDS = list5 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"s", "sec", "second", "seconds"});
        MINUTES = list4 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"m", "min", "minute", "minutes"});
        HOURS = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"h", "hour", "hours"});
        DAYS = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"d", "day", "days"});
        log = logger = LoggerFactory.getLogger((String)"nextflow.util.Duration");
        UNITS = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        UNITS.addAll(MILLIS);
        UNITS.addAll(SECONDS);
        UNITS.addAll(MINUTES);
        UNITS.addAll(HOURS);
        UNITS.addAll(DAYS);
    }

    private long parseLegacy(String str) {
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)str, (Object)LEGACY), Matcher.class);
        if (!matcher.matches()) {
            new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid duration value: ", ""})));
        }
        List groups = (List)ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), List.class);
        Integer hh = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)groups, (int)1), CharSequence.class)));
        Integer mm = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)groups, (int)2), CharSequence.class)));
        Integer ss = StringGroovyMethods.toInteger((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)groups, (int)3), CharSequence.class)));
        return TimeUnit.HOURS.toMillis(DefaultTypeTransformation.longUnbox((Object)hh)) + TimeUnit.MINUTES.toMillis(DefaultTypeTransformation.longUnbox((Object)mm)) + TimeUnit.SECONDS.toMillis(DefaultTypeTransformation.longUnbox((Object)ss));
    }

    private long parseSimple(String str) {
        long result = 0L;
        int i = 0;
        while (true) {
            String string;
            Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)str, (Object)FORMAT), Matcher.class);
            if (!matcher.find()) {
                if (!(i == 0 || DefaultTypeTransformation.booleanUnbox((Object)str))) break;
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid duration value: ", ""})));
            }
            List groups = (List)ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), List.class);
            String all = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)0));
            String digit = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)1));
            String unit = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)2));
            long cfr_ignored_0 = result + this.convert(StringGroovyMethods.toFloat((CharSequence)digit).floatValue(), unit);
            str = string = str.substring(all.length()).trim();
            int n = i;
            int cfr_ignored_1 = n + 1;
        }
        return result;
    }

    private long convert(float digit, String unit) {
        boolean bl = MILLIS == null ? unit == null : DefaultGroovyMethods.isCase(MILLIS, (Object)unit);
        if (bl) {
            return Math.round(digit);
        }
        boolean bl2 = SECONDS == null ? unit == null : DefaultGroovyMethods.isCase(SECONDS, (Object)unit);
        if (bl2) {
            return Math.round((float)((double)digit * (double)1000));
        }
        boolean bl3 = MINUTES == null ? unit == null : DefaultGroovyMethods.isCase(MINUTES, (Object)unit);
        if (bl3) {
            return Math.round((float)((double)digit * (double)60 * (double)1000));
        }
        boolean bl4 = HOURS == null ? unit == null : DefaultGroovyMethods.isCase(HOURS, (Object)unit);
        if (bl4) {
            return Math.round((float)((double)digit * (double)60 * (double)60 * (double)1000));
        }
        boolean bl5 = DAYS == null ? unit == null : DefaultGroovyMethods.isCase(DAYS, (Object)unit);
        if (bl5) {
            return Math.round((float)((double)digit * (double)24 * (double)60 * (double)60 * (double)1000));
        }
        throw (Throwable)new IllegalStateException();
    }

    public static Duration of(long value) {
        return new Duration(value);
    }

    public static Duration of(String str) {
        return new Duration(str);
    }

    public static Duration of(String str, Duration fallback) {
        Duration duration = new Duration(str);
        try {
            return duration;
        }
        catch (IllegalArgumentException e) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str, fallback}, new String[]{"Not a valid duration value: ", " -- Fallback on default value: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            Duration duration2 = fallback;
            return duration2;
        }
    }

    public static Duration between(Temporal start, Temporal end) {
        return new Duration(java.time.Duration.between(start, end).toMillis());
    }

    public long toMillis() {
        return this.durationInMillis;
    }

    public long getMillis() {
        return this.durationInMillis;
    }

    public long toSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.durationInMillis);
    }

    public long getSeconds() {
        return this.toSeconds();
    }

    public long toMinutes() {
        return TimeUnit.MILLISECONDS.toMinutes(this.durationInMillis);
    }

    public long getMinutes() {
        return this.toMinutes();
    }

    public long toHours() {
        return TimeUnit.MILLISECONDS.toHours(this.durationInMillis);
    }

    public long getHours() {
        return this.toHours();
    }

    public long toDays() {
        return TimeUnit.MILLISECONDS.toDays(this.durationInMillis);
    }

    public long getDays() {
        return this.toDays();
    }

    public String format(String fmt) {
        return DurationFormatUtils.formatDuration((long)this.durationInMillis, (String)fmt);
    }

    public String toString() {
        long l;
        long l2;
        long l3;
        long l4;
        if (this.durationInMillis < (long)1000) {
            return StringGroovyMethods.plus((Number)this.durationInMillis, (String)"ms");
        }
        if (this.durationInMillis < (long)60000) {
            return StringGroovyMethods.plus((String)String.valueOf(NumberNumberDiv.div((Number)Math.round(DefaultTypeTransformation.floatUnbox((Object)ScriptBytecodeAdapter.asType((Object)NumberNumberMultiply.multiply((Number)NumberNumberDiv.div((Number)this.durationInMillis, (Number)1000), (Number)10), Float.TYPE))), (Number)10)), (CharSequence)"s");
        }
        long secs = 0L;
        long mins = 0L;
        long hours = 0L;
        long days = 0L;
        List result = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        secs = l4 = Math.round(DefaultTypeTransformation.doubleUnbox((Object)NumberNumberDiv.div((Number)this.durationInMillis, (Number)1000)));
        Number number = DefaultGroovyMethods.intdiv((Number)secs, (Number)60);
        mins = DefaultTypeTransformation.longUnbox((Object)number);
        secs = l3 = secs % (long)60;
        if (secs != 0L) {
            result.add(StringGroovyMethods.plus((Number)secs, (String)"s"));
        }
        Number number2 = DefaultGroovyMethods.intdiv((Number)mins, (Number)60);
        hours = DefaultTypeTransformation.longUnbox((Object)number2);
        mins = l2 = mins % (long)60;
        if (mins != 0L) {
            result.add(0, StringGroovyMethods.plus((Number)mins, (String)"m"));
        }
        Number number3 = DefaultGroovyMethods.intdiv((Number)hours, (Number)24);
        days = DefaultTypeTransformation.longUnbox((Object)number3);
        hours = l = hours % (long)24;
        if (hours != 0L) {
            result.add(0, StringGroovyMethods.plus((Number)hours, (String)"h"));
        }
        if (days != 0L) {
            result.add(0, StringGroovyMethods.plus((Number)days, (String)"d"));
        }
        return DefaultGroovyMethods.join((Iterable)result, (String)" ");
    }

    public Object plus(Duration value) {
        return new Duration(this.durationInMillis + value.getDurationInMillis());
    }

    public Object minus(Duration value) {
        return new Duration(this.durationInMillis - value.getDurationInMillis());
    }

    public Object multiply(Number value) {
        return new Duration(DefaultTypeTransformation.longUnbox((Object)NumberNumberMultiply.multiply((Number)this.durationInMillis, (Number)value)));
    }

    public Object div(Number value) {
        return new Duration(Math.round(DefaultTypeTransformation.doubleUnbox((Object)NumberNumberDiv.div((Number)this.durationInMillis, (Number)value))));
    }

    public boolean asBoolean() {
        return this.durationInMillis != (long)0;
    }

    @Override
    public int compareTo(Duration that) {
        return ScriptBytecodeAdapter.compareTo((Object)this.durationInMillis, (Object)that.getDurationInMillis());
    }

    public static int compareTo(Duration left, Object right) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Duration duration = left;
            valueRecorder.record((Object)duration, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)duration)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert left", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (right == null) {
            throw (Throwable)new IllegalArgumentException("Not a valid duration value: null");
        }
        if (right instanceof Duration) {
            return left == (Duration)ScriptBytecodeAdapter.castToType((Object)right, Duration.class) ? 0 : (left == null ? -1 : ((Duration)ScriptBytecodeAdapter.castToType((Object)right, Duration.class) == null ? 1 : left.compareTo((Duration)ScriptBytecodeAdapter.castToType((Object)right, Duration.class))));
        }
        if (right instanceof Number) {
            return ScriptBytecodeAdapter.compareTo((Object)left.getDurationInMillis(), (Object)DefaultGroovyMethods.toLong((Number)((Number)ScriptBytecodeAdapter.castToType((Object)right, Number.class))));
        }
        if (right instanceof CharSequence) {
            return left == Duration.of(DefaultGroovyMethods.toString((Object)right)) ? 0 : (left == null ? -1 : (Duration.of(DefaultGroovyMethods.toString((Object)right)) == null ? 1 : left.compareTo(Duration.of(DefaultGroovyMethods.toString((Object)right)))));
        }
        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{right}, new String[]{"Not a valid duration value: ", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Duration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getDurationInMillis(), (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (long)this.getDurationInMillis());
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof Duration;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration otherTyped = (Duration)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        return !(!(this.getDurationInMillis() == otherTyped.getDurationInMillis()));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final long getDurationInMillis() {
        return this.durationInMillis;
    }
}

