/*
 * Decompiled with CFR 0.152.
 */
package nextflow.io;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.nio.file.Path;
import java.util.regex.Matcher;
import nextflow.util.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;

@ToString(includeNames=true, includePackage=false, ignoreNulls=false)
@EqualsAndHashCode(includeFields=true)
public class BucketParser
implements GroovyObject {
    private String scheme;
    private String bucket;
    private Path path;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected BucketParser(String s, String b, String p) {
        Path path;
        String string;
        String string2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.scheme = string2 = s;
        this.bucket = string = b;
        this.path = path = DefaultTypeTransformation.booleanUnbox((Object)p) ? (p.startsWith("/") || !DefaultTypeTransformation.booleanUnbox((Object)this.bucket) ? Path.of(p, new String[0]) : Path.of(StringGroovyMethods.plus((String)"/", (CharSequence)p), new String[0])) : Path.of("/", new String[0]);
    }

    protected BucketParser() {
        Path path;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.path = path = Path.of("/", new String[0]);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Path getPath() {
        return this.path;
    }

    public static BucketParser from(String uri) {
        return new BucketParser().parse(uri);
    }

    public BucketParser parse(String uri) {
        String string;
        Matcher m = StringUtils.URL_PROTOCOL.matcher(uri);
        if (!m.matches()) {
            Path path;
            this.path = path = Path.of(uri, new String[0]);
            return this;
        }
        this.scheme = string = m.group(1);
        String location = m.group(2);
        int p = location.indexOf("/");
        if (p == -1) {
            Path path;
            String string2;
            this.bucket = string2 = location;
            this.path = path = Path.of("/", new String[0]);
        } else {
            Path path;
            String string3;
            this.bucket = string3 = location.substring(0, p);
            this.path = path = Path.of(location.substring(p), new String[0]);
        }
        if (this.bucket.startsWith("/") || this.bucket.endsWith("/")) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{uri}, new String[]{"Invalid bucket URI path: ", ""})));
        }
        return this;
    }

    public String getKey() {
        String result = this.path.toString();
        return result.substring(1);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BucketParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("BucketParser(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("scheme:");
        _result.append(InvokerHelper.toString((Object)this.scheme));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("bucket:");
        _result.append(InvokerHelper.toString((Object)this.bucket));
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("path:");
        _result.append(InvokerHelper.toString((Object)this.path));
        Boolean bl7 = $toStringFirst;
        if (bl7 == null ? false : bl7) {
            Boolean bl8;
            $toStringFirst = bl8 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("key:");
        _result.append(InvokerHelper.toString((Object)this.getKey()));
        _result.append(")");
        return _result.toString();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.scheme, (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.scheme);
        }
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.bucket, (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.bucket);
        }
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.path, (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.path);
        }
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.metaClass, (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.metaClass);
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof BucketParser;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof BucketParser)) {
            return false;
        }
        BucketParser otherTyped = (BucketParser)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.scheme, (Object)otherTyped.getScheme())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.bucket, (Object)otherTyped.getBucket())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.path, (Object)otherTyped.getPath())) {
            return false;
        }
        if (!(this.scheme == otherTyped.getScheme())) {
            if (this.scheme == this && !(otherTyped.getScheme() == otherTyped) || !(this.scheme == this) && otherTyped.getScheme() == otherTyped) {
                return false;
            }
            if (!(this.scheme == this && otherTyped.getScheme() == otherTyped) && !ScriptBytecodeAdapter.compareEqual((Object)this.scheme, (Object)otherTyped.getScheme())) {
                return false;
            }
        }
        if (!(this.bucket == otherTyped.getBucket())) {
            if (this.bucket == this && !(otherTyped.getBucket() == otherTyped) || !(this.bucket == this) && otherTyped.getBucket() == otherTyped) {
                return false;
            }
            if (!(this.bucket == this && otherTyped.getBucket() == otherTyped) && !ScriptBytecodeAdapter.compareEqual((Object)this.bucket, (Object)otherTyped.getBucket())) {
                return false;
            }
        }
        if (!(this.path == otherTyped.getPath())) {
            if (this.path == this && !(otherTyped.getPath() == otherTyped) || !(this.path == this) && otherTyped.getPath() == otherTyped) {
                return false;
            }
            if (!(this.path == this && otherTyped.getPath() == otherTyped) && !ScriptBytecodeAdapter.compareEqual((Object)this.path, (Object)otherTyped.getPath())) {
                return false;
            }
        }
        if (!(this.metaClass == otherTyped.getMetaClass())) {
            if (this.metaClass == this && !(otherTyped.getMetaClass() == otherTyped) || !(this.metaClass == this) && otherTyped.getMetaClass() == otherTyped) {
                return false;
            }
            if (!(this.metaClass == this && otherTyped.getMetaClass() == otherTyped) && !ScriptBytecodeAdapter.compareEqual((Object)this.metaClass, (Object)otherTyped.getMetaClass())) {
                return false;
            }
        }
        return true;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

