/*
 * Decompiled with CFR 0.152.
 */
package nextflow.plugin;

import com.github.zafarkhaja.semver.Version;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nextflow.Const;
import nextflow.extension.FilesEx;
import nextflow.file.FileHelper;
import nextflow.file.FileMutex;
import nextflow.plugin.CustomPluginManager;
import nextflow.plugin.DefaultPlugins;
import nextflow.plugin.PluginSpec;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.pf4j.PluginDependency;
import org.pf4j.PluginManager;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.VersionManager;
import org.pf4j.update.DefaultUpdateRepository;
import org.pf4j.update.PluginInfo;
import org.pf4j.update.UpdateManager;
import org.pf4j.update.UpdateRepository;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUpdater
extends UpdateManager
implements GroovyObject {
    private CustomPluginManager pluginManager;
    private Path pluginsStore;
    private boolean pullOnly;
    private DefaultPlugins defaultPlugins;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected PluginUpdater(CustomPluginManager pluginManager) {
        super((PluginManager)pluginManager);
        CustomPluginManager customPluginManager;
        MetaClass metaClass;
        DefaultPlugins defaultPlugins;
        this.defaultPlugins = defaultPlugins = DefaultPlugins.INSTANCE;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.pluginManager = customPluginManager = pluginManager;
    }

    public PluginUpdater(CustomPluginManager pluginManager, Path pluginsRoot, URL repo) {
        super((PluginManager)pluginManager, PluginUpdater.wrap(repo));
        CustomPluginManager customPluginManager;
        Path path;
        MetaClass metaClass;
        DefaultPlugins defaultPlugins;
        this.defaultPlugins = defaultPlugins = DefaultPlugins.INSTANCE;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.pluginsStore = path = pluginsRoot;
        this.pluginManager = customPluginManager = pluginManager;
    }

    private static List<UpdateRepository> wrap(URL repo) {
        ArrayList<UpdateRepository> result = new ArrayList<UpdateRepository>(1);
        DefaultGroovyMethods.leftShift(result, (Object)new DefaultUpdateRepository("nextflow.io", repo));
        return result;
    }

    public void prepareAndStart(String pluginId, String version) {
        PluginWrapper current = this.pluginManager.getPlugin(pluginId);
        if (!DefaultTypeTransformation.booleanUnbox((Object)current)) {
            String string = version;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "latest"}, new String[]{"Installing plugin ", " version: ", ""})));
            this.installPlugin(pluginId, version);
        } else if (this.shouldUpdate(pluginId, version, current)) {
            String string = version;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "latest", current.getDescriptor().getVersion()}, new String[]{"Updating plugin ", " version: ", " [current version: ", "]"})));
            this.updatePlugin(pluginId, version);
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
                String string;
                version = string = current.getDescriptor().getVersion();
            }
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, version}, new String[]{"Starting plugin ", " version: ", ""})));
            this.pluginManager.startPlugin(pluginId);
        }
    }

    public void pullPlugins(List<String> plugins) {
        boolean bl;
        this.pullOnly = bl = true;
        try {
            public final class _pullPlugins_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _pullPlugins_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PluginSpec doCall(Object it) {
                    return PluginSpec.parse(ShortTypeHandling.castToString((Object)it));
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _pullPlugins_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List specs = DefaultGroovyMethods.collect(plugins, (Closure)new _pullPlugins_closure1((Object)this, (Object)this));
            List list = specs;
            PluginSpec spec = null;
            Iterator iterator = list != null ? list.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    spec = (PluginSpec)ScriptBytecodeAdapter.castToType(iterator.next(), PluginSpec.class);
                    this.pullPlugin0(spec.getId(), spec.getVersion());
                }
            }
        }
        finally {
            boolean bl2;
            this.pullOnly = bl2 = false;
        }
    }

    public void pullPlugin0(String pluginId, String version) {
        PluginWrapper current = this.pluginManager.getPlugin(pluginId);
        if (!DefaultTypeTransformation.booleanUnbox((Object)current)) {
            String string = version;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "latest"}, new String[]{"Installing plugin ", " version: ", ""})));
            this.installPlugin(pluginId, version);
        } else if (this.shouldUpdate(pluginId, version, current)) {
            String string = version;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId, DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "latest", current.getDescriptor().getVersion()}, new String[]{"Updating plugin ", " version: ", " [current version: ", "]"})));
            this.updatePlugin(pluginId, version);
        }
    }

    public boolean installPlugin(String id, String version) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.pluginsStore)) {
            throw (Throwable)new IllegalStateException("Missing pluginStore attribute");
        }
        return this.load0(id, version);
    }

    private Path download0(String id, String version) {
        Path pluginPath = this.pluginsStore.resolve(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, version}, new String[]{"", "-", ""})));
        if (FilesEx.exists(pluginPath, new LinkOption[0])) {
            return pluginPath;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
            PluginInfo.PluginRelease pluginRelease = this.getLastPluginRelease(id);
            version = ShortTypeHandling.castToString((Object)pluginRelease);
        }
        log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, version}, new String[]{"Downloading plugin ", "@", ""})));
        Path downloaded = this.downloadPlugin(id, version);
        Path dir = FileUtils.expandIfZip((Path)downloaded);
        FileHelper.deletePath(downloaded);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = pluginPath;
            valueRecorder.record((Object)path, 8);
            Path path2 = path.getFileName();
            valueRecorder.record((Object)path2, 19);
            Path path3 = dir;
            valueRecorder.record((Object)path3, 36);
            Path path4 = path3.getFileName();
            valueRecorder.record((Object)path4, 40);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)path2, (Object)path4);
            valueRecorder.record((Object)bl, -1);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert pluginPath.getFileName() == dir.getFileName()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        try {
            this.safeMove(dir, pluginPath);
        }
        catch (IOException e) {
            throw (Throwable)new PluginRuntimeException((Throwable)e, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginPath}, new String[]{"Failed to write file '", "' to plugins folder"})), new Object[0]);
        }
        return pluginPath;
    }

    protected void safeMove(Path source, Path target) {
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Object[] objectArray = new Object[3];
            objectArray[0] = source;
            objectArray[1] = target;
            String string = e.getMessage();
            objectArray[2] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : e;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"Failed atomic move for plugin ", " -> ", " - Reason: ", " - Fallback on safe move"})));
            this.safeMove0(source, target);
        }
    }

    protected void safeMove0(Path source, Path target) {
        FileHelper.deletePath(target);
        FileHelper.copyPath(source, target, new CopyOption[0]);
        try {
            FileHelper.deletePath(source);
        }
        catch (IOException e) {
            log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{source}, new String[]{"Unable to delete plugin directory: ", ""})), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Path safeDownload(String id, String version) {
        void var2_2;
        Reference id2 = new Reference((Object)id);
        Reference version2 = new Reference((Object)var2_2);
        File sentinel = this.lockFile((String)id2.get(), (String)version2.get());
        FileMutex fileMutex = new FileMutex();
        File file = sentinel;
        fileMutex.setTarget(file);
        String string = "10 min";
        fileMutex.setTimeout(string);
        FileMutex mutex = fileMutex;
        try {
            public final class _safeDownload_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference id;
                private /* synthetic */ Reference version;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _safeDownload_closure2(Object _outerInstance, Object _thisObject, Reference id, Reference version) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.id = reference2 = id;
                    this.version = reference = version;
                }

                public Path doCall(Object it) {
                    return ((PluginUpdater)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PluginUpdater.class))).download0(ShortTypeHandling.castToString((Object)this.id.get()), ShortTypeHandling.castToString((Object)this.version.get()));
                }

                @Generated
                public String getId() {
                    return ShortTypeHandling.castToString((Object)this.id.get());
                }

                @Generated
                public String getVersion() {
                    return ShortTypeHandling.castToString((Object)this.version.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Path doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _safeDownload_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Path path = (Path)ScriptBytecodeAdapter.castToType(mutex.lock(new _safeDownload_closure2((Object)this, (Object)this, id2, version2)), Path.class);
            return path;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            sentinel.delete();
        }
    }

    private File lockFile(String id, String version) {
        String tmp = System.getProperty("java.io.tmpdir");
        return new File(tmp, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, version}, new String[]{"nextflow-plugin-", "-", ".lock"})));
    }

    private boolean load0(String id, String version) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)id)) {
            StringBuffer stringBuffer = new StringBuffer("id. Values: ");
            stringBuffer.append((Object)"id = ");
            stringBuffer.append(InvokerHelper.toString((Object)id));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Missing plugin Id");
        }
        if (version == null) {
            String string;
            PluginInfo.PluginRelease pluginRelease = this.getLastPluginRelease(id);
            version = string = pluginRelease == null ? null : pluginRelease.version;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id}, new String[]{"Cannot find latest version of ", " plugin"})));
        }
        Path pluginPath = this.pluginsStore.resolve(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, version}, new String[]{"", "-", ""})));
        if (!FilesEx.exists(pluginPath, new LinkOption[0])) {
            Path path;
            pluginPath = path = this.safeDownload(id, version);
        }
        if (!FilesEx.exists(pluginPath.resolve("classes/META-INF/MANIFEST.MF"), new LinkOption[0])) {
            log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginPath.getFileName(), pluginPath}, new String[]{"Plugin '", "' installation looks corrupted - Delete the following directory and run nextflow again: ", ""})));
        }
        PluginWrapper wrapper = this.pluginManager.loadPluginFromPath(pluginPath);
        List list = wrapper.getDescriptor().getDependencies();
        List deps = DefaultTypeTransformation.booleanUnbox((Object)list) ? list : Collections.emptyList();
        List list2 = deps;
        PluginDependency it = null;
        Iterator iterator = list2 != null ? list2.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                it = (PluginDependency)ScriptBytecodeAdapter.castToType(iterator.next(), PluginDependency.class);
                String installed = this.checkInstalled(it.getPluginId(), it.getPluginVersionSupport());
                if (DefaultTypeTransformation.booleanUnbox((Object)installed)) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, it.getPluginId(), it.getPluginVersionSupport(), installed}, new String[]{"Plugin ", " requires ", " supported version: ", " - found version: ", ""})));
                    continue;
                }
                PluginSpec pluginSpec = this.defaultPlugins.getPlugin(it.getPluginId());
                String depVersion = pluginSpec != null ? pluginSpec.getVersion() : null;
                if (!DefaultTypeTransformation.booleanUnbox((Object)depVersion)) {
                    String string;
                    PluginInfo.PluginRelease pluginRelease = this.findNewestMatchingRelease(it.getPluginId(), it.getPluginVersionSupport());
                    depVersion = string = pluginRelease == null ? null : pluginRelease.version;
                }
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, it.getPluginId(), it.getPluginVersionSupport(), depVersion}, new String[]{"Plugin ", " requires ", " supported version: ", " - available version: ", ""})));
                if (this.pullOnly) {
                    this.pullPlugin0(it.getPluginId(), depVersion);
                    continue;
                }
                this.prepareAndStart(it.getPluginId(), depVersion);
            }
        }
        if (this.pullOnly) {
            return false;
        }
        this.pluginManager.resolvePlugins();
        PluginState state = this.pluginManager.startPlugin(id);
        return ScriptBytecodeAdapter.compareEqual((Object)PluginState.STARTED, (Object)state);
    }

    public boolean updatePlugin(String id, String version) {
        if (this.pluginManager.getPlugin(id) == null) {
            throw (Throwable)new PluginRuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id}, new String[]{"Plugin ", " cannot be updated since it is not installed"})));
        }
        PluginInfo pluginInfo = (PluginInfo)ScriptBytecodeAdapter.castToType(this.getPluginsMap().get(id), PluginInfo.class);
        if (pluginInfo == null) {
            throw (Throwable)new PluginRuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id}, new String[]{"Plugin ", " does not exist in any repository"})));
        }
        if (!this.pluginManager.deletePlugin(id)) {
            return false;
        }
        return this.load0(id, version);
    }

    protected boolean shouldUpdate(String pluginId, String version, PluginWrapper current) {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.pluginManager.getRuntimeMode(), (Object)RuntimeMode.DEVELOPMENT)) {
            log.debug("Update not supported during development mode");
            return false;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
            String string;
            PluginInfo.PluginRelease pluginRelease = this.getLastPluginRelease(pluginId);
            version = string = pluginRelease == null ? null : pluginRelease.version;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)version)) {
            log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId}, new String[]{"Cannot find latest version for plugin ", " [skip update]"})));
            return false;
        }
        return this.pluginManager.getVersionManager().compareVersions(current.getDescriptor().getVersion(), version) < 0;
    }

    protected String checkInstalled(String id, String verConstraint) {
        VersionManager versionManager = this.pluginManager.getVersionManager();
        PluginWrapper current = this.pluginManager.getPlugin(id);
        if (!DefaultTypeTransformation.booleanUnbox((Object)current)) {
            return ShortTypeHandling.castToString(null);
        }
        boolean found = versionManager.checkVersionConstraint(current.getDescriptor().getVersion(), verConstraint);
        return ShortTypeHandling.castToString(found ? current.getDescriptor().getVersion() : null);
    }

    protected PluginInfo.PluginRelease findNewestMatchingRelease(String id, String verConstraint) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = verConstraint;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert verConstraint", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        VersionManager versionManager = this.pluginManager.getVersionManager();
        PluginInfo pluginInfo = (PluginInfo)ScriptBytecodeAdapter.castToType(this.getPluginsMap().get(id), PluginInfo.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)pluginInfo)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id}, new String[]{"Unknown plugin id: ", ""})));
        }
        public final class _findNewestMatchingRelease_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findNewestMatchingRelease_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(Object a, Object b) {
                return Version.valueOf((String)((PluginInfo.PluginRelease)b).version) == Version.valueOf((String)((PluginInfo.PluginRelease)a).version) ? 0 : (Version.valueOf((String)((PluginInfo.PluginRelease)b).version) == null ? -1 : (Version.valueOf((String)((PluginInfo.PluginRelease)a).version) == null ? 1 : Version.valueOf((String)((PluginInfo.PluginRelease)b).version).compareTo(Version.valueOf((String)((PluginInfo.PluginRelease)a).version))));
            }

            @Generated
            public Integer call(Object a, Object b) {
                return this.doCall(a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findNewestMatchingRelease_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List releases = DefaultGroovyMethods.sort((Iterable)pluginInfo.releases, (boolean)false, (Closure)new _findNewestMatchingRelease_closure3((Object)this, (Object)this));
        List list = releases;
        Iterator iterator = list != null ? list.iterator() : null;
        PluginInfo.PluginRelease rel = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                rel = (PluginInfo.PluginRelease)ScriptBytecodeAdapter.castToType(iterator2.next(), PluginInfo.PluginRelease.class);
                if (!versionManager.checkVersionConstraint(rel.version, verConstraint) || !DefaultTypeTransformation.booleanUnbox((Object)rel.url) || !versionManager.checkVersionConstraint(Const.APP_VER, rel.requires)) continue;
                return rel;
            }
        }
        return (PluginInfo.PluginRelease)ScriptBytecodeAdapter.castToType(null, PluginInfo.PluginRelease.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PluginUpdater.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.plugin.PluginUpdater");
    }
}

