/*
 * Decompiled with CFR 0.152.
 */
package nextflow.file;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

public class FilePatternSplitter
implements GroovyObject {
    public static final FilePatternSplitter GLOB;
    public static final Pattern QUESTION_MARK_REGEX;
    public static final Pattern STAR_CHAR_REGEX;
    public static final Pattern GLOB_CURLY_BRACKETS;
    public static final Pattern GLOB_SQUARE_BRACKETS;
    private static final char BACK_SLASH;
    private static final String GLOB_CHARS = "*?[]{}";
    private static final String REGEX_CHARS = ".^$+{}[]|()";
    private boolean pattern;
    private final Syntax syntax;
    private String scheme;
    private String parent;
    private String fileName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public FilePatternSplitter(Syntax syntax) {
        Syntax syntax2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.syntax = syntax2 = syntax;
    }

    public boolean isPattern() {
        return this.pattern;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getParent() {
        return this.parent;
    }

    public String getScheme() {
        return this.scheme;
    }

    public static FilePatternSplitter glob() {
        return new FilePatternSplitter(Syntax.GLOB);
    }

    public static FilePatternSplitter regex() {
        return new FilePatternSplitter(Syntax.REGEX);
    }

    public static boolean isMatchingPattern(Object pattern) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)pattern)) {
            return false;
        }
        if (pattern instanceof Pattern) {
            return true;
        }
        String str = DefaultGroovyMethods.toString((Object)pattern);
        if (STAR_CHAR_REGEX.matcher(str).find()) {
            return true;
        }
        if (QUESTION_MARK_REGEX.matcher(str).find()) {
            return true;
        }
        if (GLOB_CURLY_BRACKETS.matcher(str).find()) {
            return true;
        }
        return GLOB_SQUARE_BRACKETS.matcher(str).find();
    }

    private String metaChars() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.syntax), (Object)((Object)Syntax.GLOB)) ? GLOB_CHARS : REGEX_CHARS;
    }

    private boolean containsMetaChars(String str) {
        String meta = this.metaChars();
        int i = 0;
        while (i < str.length()) {
            if (meta.contains(StringGroovyMethods.getAt((String)str, (int)i))) {
                return true;
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return false;
    }

    public FilePatternSplitter parse(String filePath) {
        int n;
        int p = filePath.indexOf("://");
        if (p != -1) {
            String string;
            String string2;
            this.scheme = string2 = filePath.substring(0, p);
            filePath = string = filePath.substring(p + 3);
        } else {
            Object var5_5 = null;
            this.scheme = ShortTypeHandling.castToString(var5_5);
        }
        int found = 0;
        String norm = this.replaceMetaChars(filePath);
        p = n = this.firstMetaIndex(norm);
        if (p == -1) {
            int n2;
            int n3;
            p = n3 = filePath.lastIndexOf("/");
            found = n2 = 0;
        } else {
            int n4;
            int n5;
            found = n5 = 1;
            int i = p;
            p = n4 = -1;
            while (--i >= 0) {
                int n6;
                if (!ScriptBytecodeAdapter.compareEqual((Object)StringGroovyMethods.getAt((String)filePath, (int)i), (Object)Character.valueOf('/'))) continue;
                p = n6 = i;
                break;
            }
        }
        if (p == -1) {
            boolean bl;
            String string;
            String string3;
            this.parent = string3 = "./";
            this.fileName = string = filePath;
            this.pattern = bl = found != 0 && this.pairedBrackets(norm);
        } else {
            boolean bl;
            String string;
            String string4;
            this.parent = string4 = this.strip(filePath.substring(0, p + 1));
            this.fileName = string = filePath.substring(p + 1);
            this.pattern = bl = found != 0 && this.pairedBrackets(norm);
        }
        return this;
    }

    private boolean pairedBrackets(String str) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.syntax), (Object)((Object)Syntax.REGEX))) {
            return true;
        }
        if (str.contains("{") || str.contains("}")) {
            return GLOB_CURLY_BRACKETS.matcher(str).matches();
        }
        if (str.contains("[") || str.contains("]")) {
            return GLOB_SQUARE_BRACKETS.matcher(str).matches();
        }
        return true;
    }

    protected String replaceMetaChars(String str, char marker) {
        String meta = this.metaChars();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            int n = i;
            int cfr_ignored_0 = n + 1;
            char ch = str.charAt(n);
            if (ch == BACK_SLASH && i < str.length() && meta.contains(StringGroovyMethods.getAt((String)str, (int)i))) {
                result.append(ch).append(marker);
                int n2 = i;
                i = n2 + 1;
                continue;
            }
            result.append(ch);
        }
        return ShortTypeHandling.castToString((Object)result);
    }

    protected int firstMetaIndex(String str) {
        String meta = this.metaChars();
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < meta.length()) {
            int p = str.indexOf(StringGroovyMethods.getAt((String)meta, (int)i));
            if (p != -1 && p < min) {
                int n;
                min = n = p;
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return min != Integer.MAX_VALUE ? min : -1;
    }

    public String strip(String str) {
        int p = str.indexOf("\\");
        if (p == -1) {
            return str;
        }
        String meta = this.metaChars();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            int n = i;
            int cfr_ignored_0 = n + 1;
            char ch = str.charAt(n);
            if (!(ch != BACK_SLASH || i == str.length() || !meta.contains(StringGroovyMethods.getAt((String)str, (int)i)))) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public String escape(Path path) {
        return this.escape(path.toString());
    }

    public String escape(String str) {
        String meta = this.metaChars();
        String result = str;
        int i = 0;
        while (i < meta.length()) {
            String string;
            result = string = result.replace(StringGroovyMethods.getAt((String)meta, (int)i), StringGroovyMethods.plus((String)"\\", (CharSequence)StringGroovyMethods.getAt((String)meta, (int)i)));
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return result;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FilePatternSplitter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(FilePatternSplitter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(FilePatternSplitter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(FilePatternSplitter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, FilePatternSplitter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(FilePatternSplitter.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    protected String replaceMetaChars(String str) {
        CallSite[] callSiteArray = FilePatternSplitter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.replaceMetaChars(str, (char)0);
        }
        return this.replaceMetaChars(str, (char)0);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        char c;
        Pattern pattern;
        Pattern pattern2;
        FilePatternSplitter filePatternSplitter;
        GLOB = filePatternSplitter = FilePatternSplitter.glob();
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"(?<!\\\\)\\?");
        QUESTION_MARK_REGEX = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        Object object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"(?<!\\\\)\\*");
        STAR_CHAR_REGEX = (Pattern)ScriptBytecodeAdapter.castToType((Object)object2, Pattern.class);
        GLOB_CURLY_BRACKETS = pattern2 = Pattern.compile("(.*)(?<!\\\\)(\\{.*,.*\\})(.*)");
        GLOB_SQUARE_BRACKETS = pattern = Pattern.compile("(.*)(?<!\\\\)(\\[.+\\])(.*)");
        BACK_SLASH = c = DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"\\", Character.TYPE));
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(FilePatternSplitter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FilePatternSplitter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static final class Syntax
    extends Enum<Syntax>
    implements GroovyObject {
        public static final /* enum */ Syntax GLOB;
        public static final /* enum */ Syntax REGEX;
        public static final Syntax MIN_VALUE;
        public static final Syntax MAX_VALUE;
        private static final /* synthetic */ Syntax[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        private Syntax(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum nextflow.file.FilePatternSplitter$Syntax was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        private Syntax() {
            this(new LinkedHashMap());
        }

        @Generated
        public static final Syntax[] values() {
            return (Syntax[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), Syntax[].class);
        }

        @Generated
        public Syntax next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (Syntax)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Syntax.class);
        }

        @Generated
        public Syntax previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (Syntax)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), Syntax.class);
        }

        @Generated
        public static Syntax valueOf(String name) {
            return (Syntax)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(Syntax.class, name)), Syntax.class);
        }

        @Generated
        public static final /* synthetic */ Syntax $INIT(Object ... para) {
            Syntax syntax;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Syntax.class)) {
                case -1348271900: {
                    Syntax syntax2;
                    syntax = syntax2;
                    Object[] objectArray2 = objectArray;
                    syntax2 = new Syntax();
                    break;
                }
                case -242181752: {
                    Syntax syntax2;
                    syntax = syntax2;
                    Object[] objectArray2 = objectArray;
                    syntax2 = new Syntax((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return syntax;
        }

        static {
            Syntax syntax;
            Syntax syntax2;
            Syntax syntax3;
            Syntax syntax4;
            GLOB = syntax4 = Syntax.$INIT("GLOB", 0);
            REGEX = syntax3 = Syntax.$INIT("REGEX", 1);
            MIN_VALUE = syntax2 = GLOB;
            MAX_VALUE = syntax = REGEX;
            Syntax[] syntaxArray = new Syntax[]{GLOB, REGEX};
            $VALUES = syntaxArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Syntax.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

