/*
 * Decompiled with CFR 0.152.
 */
package nextflow.plugin;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextflow.SysEnv;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.plugin.CustomPluginManager;
import nextflow.plugin.DefaultPlugins;
import nextflow.plugin.DevPluginManager;
import nextflow.plugin.DevPluginUpdater;
import nextflow.plugin.LocalPluginManager;
import nextflow.plugin.PluginSpec;
import nextflow.plugin.PluginUpdater;
import nextflow.plugin.Plugins;
import nextflow.plugin.Priority;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginStateListener;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsFacade
implements PluginStateListener,
GroovyObject {
    private static final String DEV_MODE = "dev";
    private static final String PROD_MODE = "prod";
    private Map<String, String> env;
    private String mode;
    private Path root;
    private PluginUpdater updater;
    private CustomPluginManager manager;
    private DefaultPlugins defaultPlugins;
    private String indexUrl;
    private boolean embedded;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private final Closure memoizedMethodClosure$defaultManager;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public PluginsFacade() {
        Path path;
        String string;
        Closure closure;
        MetaClass metaClass;
        String string2;
        DefaultPlugins defaultPlugins;
        Map<String, String> map = SysEnv.get();
        this.env = map;
        this.defaultPlugins = defaultPlugins = DefaultPlugins.INSTANCE;
        this.indexUrl = string2 = Plugins.DEFAULT_PLUGINS_REPO;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.memoizedMethodClosure$defaultManager = closure = new _closure1(this, this).memoize();
        this.mode = string = this.getPluginsMode();
        this.root = path = this.getPluginsDir();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.mode, (Object)DEV_MODE) && ScriptBytecodeAdapter.compareEqual((Object)this.root.toString(), (Object)"plugins") && !DefaultTypeTransformation.booleanUnbox((Object)this.isRunningFromDistArchive())) {
            Path path2;
            this.root = path2 = this.detectPluginsDevRoot();
        }
        System.setProperty("pf4j.mode", this.mode);
    }

    public PluginsFacade(Path root, String mode) {
        Path path;
        String string;
        Closure closure;
        MetaClass metaClass;
        String string2;
        DefaultPlugins defaultPlugins;
        Map<String, String> map = SysEnv.get();
        this.env = map;
        this.defaultPlugins = defaultPlugins = DefaultPlugins.INSTANCE;
        this.indexUrl = string2 = Plugins.DEFAULT_PLUGINS_REPO;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.memoizedMethodClosure$defaultManager = closure = new _closure1(this, this).memoize();
        this.mode = string = mode;
        this.root = path = root;
        System.setProperty("pf4j.mode", mode);
    }

    @Generated
    public PluginsFacade(Path root) {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        this(root, PROD_MODE);
    }

    protected String isRunningFromDistArchive() {
        String className = this.getClass().getName().replace(".", "/");
        String classJar = this.getClass().getResource(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)className), (CharSequence)".class")).toString();
        return ShortTypeHandling.castToString((Object)classJar.startsWith("jar:"));
    }

    protected Path getPluginsDir() {
        String dir = ShortTypeHandling.castToString((Object)this.env.get("NXF_PLUGINS_DIR"));
        if (DefaultTypeTransformation.booleanUnbox((Object)dir)) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir}, new String[]{"Detected NXF_PLUGINS_DIR=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return Paths.get(dir, new String[0]);
        }
        if (this.env.containsKey("NXF_HOME")) {
            Object v1;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.env.get("NXF_HOME")}, new String[]{"Detected NXF_HOME - Using ", "/plugins"})));
                v1 = null;
            } else {
                v1 = null;
            }
            return Paths.get(ShortTypeHandling.castToString((Object)this.env.get("NXF_HOME")), "plugins");
        }
        log.trace("Using local plugins directory");
        return Paths.get("plugins", new String[0]);
    }

    private boolean isNextflowDevRoot(File file) {
        return ScriptBytecodeAdapter.compareEqual((Object)file.getName(), (Object)"nextflow") && file.isDirectory() && new File(file, "settings.gradle").isFile();
    }

    /*
     * Unable to fully structure code
     */
    private Path pluginsDevRoot(File path) {
        if (this.isNextflowDevRoot(path)) {
            return path.toPath().resolve("plugins");
        }
        if (!new File(path, "settings.gradle").exists()) ** GOTO lbl-1000
        path = var2_2 = new File(path, "../nextflow");
        if (this.isNextflowDevRoot(var2_2)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (v0) {
            return path.toPath().resolve("plugins");
        }
        return (Path)ScriptBytecodeAdapter.castToType(null, Path.class);
    }

    protected Path detectPluginsDevRoot() {
        File file = new File(".").getAbsoluteFile();
        do {
            File file2;
            Path root = this.pluginsDevRoot(file);
            if (DefaultTypeTransformation.booleanUnbox((Object)root)) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{root}, new String[]{"Detected dev plugins root: ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                return root;
            }
            file = file2 = file.getParentFile();
        } while (file != null);
        throw (Throwable)new IllegalStateException("Unable to detect local plugins root");
    }

    protected String getPluginsMode() {
        String mode = ShortTypeHandling.castToString((Object)this.env.get("NXF_PLUGINS_MODE"));
        if (DefaultTypeTransformation.booleanUnbox((Object)mode)) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mode}, new String[]{"Detected NXF_PLUGINS_MODE=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return mode;
        }
        if (this.env.containsKey("NXF_HOME")) {
            log.trace("Detected NXF_HOME - Using plugins mode=prod");
            return PROD_MODE;
        }
        log.debug("Using dev plugins mode");
        return DEV_MODE;
    }

    protected boolean getPluginsDefault() {
        if (this.env.containsKey("NXF_PLUGINS_DEFAULT")) {
            Object v0;
            if (log.isTraceEnabled()) {
                log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.env.get("NXF_PLUGINS_DEFAULT")}, new String[]{"Detected NXF_PLUGINS_DEFAULT=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return ScriptBytecodeAdapter.compareNotEqual((Object)this.env.get("NXF_PLUGINS_DEFAULT"), (Object)"false");
        }
        if (this.env.containsKey("NXF_HOME")) {
            log.trace("Detected NXF_HOME - Using plugins defaults");
            return true;
        }
        log.trace("Disabling plugins defaults");
        return false;
    }

    protected CustomPluginManager createManager(Path root) {
        CustomPluginManager result = ScriptBytecodeAdapter.compareNotEqual((Object)this.mode, (Object)DEV_MODE) ? new LocalPluginManager(root) : new DevPluginManager(root);
        ((CustomPluginManager)result).addPluginStateListener(this);
        return result;
    }

    protected PluginUpdater createUpdater(Path root, CustomPluginManager manager) {
        return ScriptBytecodeAdapter.compareNotEqual((Object)this.mode, (Object)DEV_MODE) ? new PluginUpdater(manager, root, new URL(this.indexUrl)) : new DevPluginUpdater(manager);
    }

    public void pluginStateChanged(PluginStateEvent ev) {
        Throwable err = ev.getPlugin().getFailedException();
        PluginDescriptor dsc = ev.getPlugin().getDescriptor();
        if (DefaultTypeTransformation.booleanUnbox((Object)err)) {
            String string;
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dsc.getPluginId(), dsc.getVersion(), DefaultTypeTransformation.booleanUnbox((Object)(string = err.getMessage())) ? string : err}, new String[]{"Unable to start plugin id=", " version=", " -- cause: ", ""})), err);
        }
    }

    public PluginManager getManager() {
        return this.manager;
    }

    public void init(boolean embedded) {
        PluginUpdater pluginUpdater;
        CustomPluginManager customPluginManager;
        Object v0;
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            throw (Throwable)new IllegalArgumentException("Plugin system was already setup");
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.mode, embedded, this.root, this.defaultPlugins.toSortedString()}, new String[]{"Setting up plugin manager > mode=", "; embedded=", "; plugins-dir=", "; core-plugins: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.mode, (Object)DEV_MODE) && !FilesEx.mkdirs(this.root, new FileAttribute[0])) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.root}, new String[]{"Unable to create plugins dir: ", ""})));
        }
        this.manager = customPluginManager = this.createManager(this.root);
        this.updater = pluginUpdater = this.createUpdater(this.root, this.manager);
        this.manager.loadPlugins();
        if (embedded) {
            boolean bl;
            this.manager.startPlugins();
            this.embedded = bl = embedded;
        }
    }

    public void init(Path root, String mode, CustomPluginManager pluginManager) {
        PluginUpdater pluginUpdater;
        CustomPluginManager customPluginManager;
        String string;
        Path path;
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            throw (Throwable)new IllegalArgumentException("Plugin system was already setup");
        }
        this.root = path = root;
        this.mode = string = mode;
        this.manager = customPluginManager = pluginManager;
        this.manager.addPluginStateListener(this);
        this.updater = pluginUpdater = this.createUpdater(root, this.manager);
        this.manager.loadPlugins();
        if (this.embedded) {
            boolean bl;
            this.manager.startPlugins();
            this.embedded = bl = this.embedded;
        }
    }

    public synchronized void setup(Map config) {
        this.init();
        this.load(config);
    }

    public void load(Map config) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            throw (Throwable)new IllegalArgumentException("Plugin system has not been initialised yet");
        }
        this.start(this.pluginsRequirement(config));
    }

    public synchronized void stop() {
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            this.manager.stopPlugins();
            Object var1_1 = null;
            this.manager = (CustomPluginManager)((Object)ScriptBytecodeAdapter.castToType(var1_1, CustomPluginManager.class));
        }
    }

    public <T> List<T> getExtensions(Class<T> type) {
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            return this.manager.getExtensions(type);
        }
        log.debug("Using Default plugins manager");
        return this.defaultManager().getExtensions(type);
    }

    public <T> List<T> getExtensions(Class<T> type, String pluginId) {
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)this.manager))) {
            return this.manager.getExtensions(type, pluginId);
        }
        return List.of();
    }

    public <T> List<T> getPriorityExtensions(Class<T> type, String group) {
        Reference group2 = new Reference((Object)group);
        List result = this.getExtensions(type);
        if (DefaultTypeTransformation.booleanUnbox((Object)((String)group2.get()))) {
            List list;
            public final class _getPriorityExtensions_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference group;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getPriorityExtensions_closure2(Object _outerInstance, Object _thisObject, Reference group) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.group = reference = group;
                }

                public Boolean doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"group0", (Object)new Object[]{it}), (Object)this.group.get());
                }

                @Generated
                public String getGroup() {
                    return ShortTypeHandling.castToString((Object)this.group.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getPriorityExtensions_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            result = list = DefaultGroovyMethods.findAll(result, (Closure)new _getPriorityExtensions_closure2(this, this, group2));
        }
        public final class _getPriorityExtensions_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getPriorityExtensions_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Integer doCall(Object it) {
                return (Integer)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"priority0", (Object)new Object[]{it}), Integer.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPriorityExtensions_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.sort(result, (Closure)new _getPriorityExtensions_closure3(this, this));
    }

    protected int priority0(Object it) {
        Priority annot = (Priority)ScriptBytecodeAdapter.castToType((Object)it.getClass().getAnnotation(Priority.class), Priority.class);
        return DefaultTypeTransformation.booleanUnbox((Object)annot) ? annot.value() : 0;
    }

    protected String group0(Object it) {
        Priority annot = (Priority)ScriptBytecodeAdapter.castToType((Object)it.getClass().getAnnotation(Priority.class), Priority.class);
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)annot) && DefaultTypeTransformation.booleanUnbox((Object)annot.group()) ? annot.group() : null));
    }

    private PluginManager defaultManager() {
        return (PluginManager)ScriptBytecodeAdapter.castToType((Object)this.memoizedMethodClosure$defaultManager.call(), PluginManager.class);
    }

    public void start(String pluginId) {
        if (this.isSelfContained() && this.defaultPlugins.hasPlugin(pluginId)) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pluginId}, new String[]{"Plugin 'start' is not required in self-contained mode -- ignoring it for plugin: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        this.start(PluginSpec.parse(pluginId, this.defaultPlugins));
    }

    public void start(PluginSpec plugin) {
        if (this.isSelfContained() && this.defaultPlugins.hasPlugin(plugin.getId())) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{plugin.getId()}, new String[]{"Plugin 'start' is not required in self-contained mode -- ignoring it for plugin: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return;
        }
        this.updater.prepareAndStart(plugin.getId(), plugin.getVersion());
    }

    public void start(List<PluginSpec> specs) {
        List<PluginSpec> list = specs;
        Iterator<PluginSpec> iterator = list != null ? list.iterator() : null;
        PluginSpec it = null;
        Iterator<PluginSpec> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                it = (PluginSpec)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), PluginSpec.class);
                this.start(it);
            }
        }
    }

    public boolean isStarted(String pluginId) {
        PluginWrapper pluginWrapper = this.manager.getPlugin(pluginId);
        return ScriptBytecodeAdapter.compareEqual((Object)(pluginWrapper != null ? pluginWrapper.getPluginState() : null), (Object)PluginState.STARTED);
    }

    protected boolean isSelfContained() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.env.get("NXF_PACK"), (Object)"all") || this.embedded;
    }

    protected List<PluginSpec> pluginsRequirement(Map config) {
        Object v3;
        List<PluginSpec> specs = this.parseConf(config);
        if (this.isSelfContained() && DefaultTypeTransformation.booleanUnbox(specs)) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join(specs, (String)",")}, new String[]{"Nextflow self-contained distribution only allows core plugins -- User config plugins will be ignored: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            return Collections.emptyList();
        }
        if (DefaultTypeTransformation.booleanUnbox(specs)) {
            Object v1;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{specs}, new String[]{"Plugins declared=", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
        }
        if (this.getPluginsDefault()) {
            Object v2;
            List<PluginSpec> defSpecs = this.defaultPluginsConf(config);
            List<PluginSpec> list = this.mergePluginSpecs(specs, defSpecs);
            specs = list;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{defSpecs}, new String[]{"Plugins default=", ""})));
                v2 = null;
            } else {
                v2 = null;
            }
        }
        public final class _pluginsRequirement_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _pluginsRequirement_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((PluginSpec)it).getId(), (Object)"nf-tower");
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _pluginsRequirement_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if ((DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate(config, "tower.enabled")) || DefaultTypeTransformation.booleanUnbox((Object)this.env.get("TOWER_ACCESS_TOKEN"))) && !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find(specs, (Closure)new _pluginsRequirement_closure4(this, this)))) {
            DefaultGroovyMethods.leftShift(specs, (Object)this.defaultPlugins.getPlugin("nf-tower"));
        }
        public final class _pluginsRequirement_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _pluginsRequirement_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((PluginSpec)it).getId(), (Object)"nf-wave");
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _pluginsRequirement_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if ((DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate(config, "wave.enabled")) || DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate(config, "fusion.enabled"))) && !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find(specs, (Closure)new _pluginsRequirement_closure5(this, this)))) {
            DefaultGroovyMethods.leftShift(specs, (Object)this.defaultPlugins.getPlugin("nf-wave"));
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{specs}, new String[]{"Plugins resolved requirement=", ""})));
            v3 = null;
        } else {
            v3 = null;
        }
        return specs;
    }

    protected List<PluginSpec> defaultPluginsConf(Map config) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String commaSepList = ShortTypeHandling.castToString((Object)this.env.get("NXF_PLUGINS_DEFAULT"));
        if (DefaultTypeTransformation.booleanUnbox((Object)commaSepList) && ScriptBytecodeAdapter.isNotCase((Object)commaSepList, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"true", "false"}))) {
            public final class _defaultPluginsConf_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _defaultPluginsConf_closure6(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public PluginSpec doCall(Object it) {
                    return ((PluginsFacade)this.getThisObject()).defaultPlugins.hasPlugin(ShortTypeHandling.castToString((Object)it)) ? ((PluginsFacade)this.getThisObject()).defaultPlugins.getPlugin(ShortTypeHandling.castToString((Object)it)) : PluginSpec.parse(ShortTypeHandling.castToString((Object)it));
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _defaultPluginsConf_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return DefaultGroovyMethods.collect((Iterable)StringGroovyMethods.tokenize((CharSequence)commaSepList, (CharSequence)","), (Closure)new _defaultPluginsConf_closure6(this, this));
        }
        ArrayList<PluginSpec> plugins = new ArrayList<PluginSpec>();
        String workDir = (String)ScriptBytecodeAdapter.asType(config.get("workDir"), String.class);
        String bucketDir = (String)ScriptBytecodeAdapter.asType(config.get("bucketDir"), String.class);
        Object executor = Bolts.navigate(config, "process.executor");
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"awsbatch") || DefaultTypeTransformation.booleanUnbox((string6 = workDir) != null ? Boolean.valueOf(string6.startsWith("s3://")) : null) || DefaultTypeTransformation.booleanUnbox((string5 = bucketDir) != null ? Boolean.valueOf(string5.startsWith("s3://")) : null)) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-amazon"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"google-lifesciences") || ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"google-batch") || DefaultTypeTransformation.booleanUnbox((string4 = workDir) != null ? Boolean.valueOf(string4.startsWith("gs://")) : null) || DefaultTypeTransformation.booleanUnbox((string3 = bucketDir) != null ? Boolean.valueOf(string3.startsWith("gs://")) : null)) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-google"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)executor, (Object)"azurebatch") || DefaultTypeTransformation.booleanUnbox((string2 = workDir) != null ? Boolean.valueOf(string2.startsWith("az://")) : null) || DefaultTypeTransformation.booleanUnbox((string = bucketDir) != null ? Boolean.valueOf(string.startsWith("az://")) : null)) {
            DefaultGroovyMethods.leftShift(plugins, (Object)this.defaultPlugins.getPlugin("nf-azure"));
        }
        return plugins;
    }

    protected List<PluginSpec> parseConf(Map config) {
        List pluginsConf = (List)ScriptBytecodeAdapter.asType(config.get("plugins"), List.class);
        List list = pluginsConf;
        Integer n = list != null ? Integer.valueOf(list.size()) : null;
        ArrayList<PluginSpec> result = new ArrayList<PluginSpec>(DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0));
        if (DefaultTypeTransformation.booleanUnbox((Object)pluginsConf)) {
            List list2 = pluginsConf;
            Iterator iterator = list2 != null ? list2.iterator() : null;
            String it = null;
            Iterator iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    it = ShortTypeHandling.castToString(iterator2.next());
                    result.add(PluginSpec.parse(it, this.defaultPlugins));
                }
            }
        }
        return result;
    }

    public synchronized void pullPlugins(List<String> ids) {
        this.updater.pullPlugins(ids);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startIfMissing(String pluginId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.env.get("NXF_PLUGINS_DEFAULT"), (Object)"false")) {
            return false;
        }
        if (this.isSelfContained() && this.defaultPlugins.hasPlugin(pluginId)) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (this.isStarted(pluginId)) {
            return false;
        }
        PluginsFacade pluginsFacade = this;
        synchronized (pluginsFacade) {
            if (this.isStarted(pluginId)) {
                return false;
            }
            {
                this.start(pluginId);
                return true;
            }
        }
    }

    protected List<PluginSpec> mergePluginSpecs(List<PluginSpec> configPlugins, List<PluginSpec> defaultPlugins) {
        List<PluginSpec> list;
        LinkedHashMap<String, PluginSpec> map = new LinkedHashMap<String, PluginSpec>(10);
        List<PluginSpec> list2 = configPlugins;
        Iterator<PluginSpec> iterator = list2 != null ? list2.iterator() : null;
        PluginSpec plugin = null;
        Iterator<PluginSpec> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                plugin = (PluginSpec)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), PluginSpec.class);
                map.put(plugin.getId(), plugin);
            }
        }
        Iterator<PluginSpec> iterator3 = (list = defaultPlugins) != null ? list.iterator() : null;
        PluginSpec plugin2 = null;
        Iterator<PluginSpec> iterator4 = iterator3;
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                plugin2 = (PluginSpec)ScriptBytecodeAdapter.castToType((Object)iterator4.next(), PluginSpec.class);
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(map, (Object)plugin2.getId())) || !DefaultTypeTransformation.booleanUnbox((Object)((PluginSpec)DefaultGroovyMethods.getAt(map, (Object)plugin2.getId())).getVersion()))) continue;
                map.put(plugin2.getId(), plugin2);
            }
        }
        return new ArrayList<PluginSpec>(map.values());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PluginsFacade.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    protected PluginManager memoizedMethodPriv$defaultManager() {
        return new DefaultPluginManager();
    }

    @Generated
    public void init() {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.init(false);
        } else {
            this.init(false);
        }
    }

    @Generated
    public synchronized void setup() {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        this.setup((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Collections.class), Map.class));
    }

    @Generated
    public <T> List<T> getPriorityExtensions(Class<T> type) {
        CallSite[] callSiteArray = PluginsFacade.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getPriorityExtensions(type, null);
        }
        return this.getPriorityExtensions(type, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.plugin.PluginsFacade");
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[1];
        stringArray[0] = "emptyMap";
        return new CallSiteArray(PluginsFacade.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PluginsFacade.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public PluginManager doCall(Object it) {
            return (PluginManager)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((PluginsFacade)this.getThisObject()), (String)"memoizedMethodPriv$defaultManager", (Object)new Object[0]), PluginManager.class);
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public PluginManager doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

