/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMultiply;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;

@EqualsAndHashCode(includeFields=true, includes={"size"})
public class MemoryUnit
implements Comparable<MemoryUnit>,
Serializable,
Cloneable,
GroovyObject {
    public static final MemoryUnit ZERO;
    private static final Pattern FORMAT;
    public static final List UNITS;
    private long size;
    private static final DecimalFormatSymbols formatSymbols;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private MemoryUnit() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        int n = 0;
        this.size = n;
    }

    public MemoryUnit(long value) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!(value >= (long)0)) {
            StringBuffer stringBuffer = new StringBuffer("(value >= 0). Values: ");
            stringBuffer.append((Object)"value = ");
            stringBuffer.append(InvokerHelper.toString((Object)value));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"Memory unit cannot be a negative number");
        }
        long l = value;
        this.size = l;
    }

    public MemoryUnit(String str) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Matcher matcher = FORMAT.matcher(str);
        if (!matcher.matches()) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid FileSize value: '", "'"})));
        }
        String value = matcher.group(1);
        String string = matcher.group(2);
        String unit = string != null ? string.toUpperCase() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)unit) || ScriptBytecodeAdapter.compareEqual((Object)unit, (Object)Character.valueOf('B'))) {
            long l = Long.parseLong(value);
            this.size = l;
        } else {
            int p = UNITS.indexOf(unit);
            if (p == -1) {
                int n;
                p = n = UNITS.indexOf(StringGroovyMethods.plus((String)unit, (CharSequence)"B"));
                if (p == -1) {
                    throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid file size unit: ", ""})));
                }
            }
            long l = Math.round(Double.parseDouble(value) * Math.pow(1024, p));
            this.size = l;
        }
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols;
        List list;
        MemoryUnit memoryUnit;
        ZERO = memoryUnit = new MemoryUnit(0);
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"([0-9\\.]+)\\s*(\\S)?B?");
        FORMAT = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
        UNITS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB"});
        formatSymbols = decimalFormatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)".", Character.TYPE)));
    }

    public long toBytes() {
        return this.size;
    }

    public long getBytes() {
        return this.size;
    }

    public long toKilo() {
        return this.size >> 10;
    }

    public long getKilo() {
        return this.size >> 10;
    }

    public long toMega() {
        return this.size >> 20;
    }

    public long getMega() {
        return this.size >> 20;
    }

    public long toGiga() {
        return this.size >> 30;
    }

    public long getGiga() {
        return this.size >> 30;
    }

    public MemoryUnit plus(MemoryUnit value) {
        return value != null ? new MemoryUnit(this.size + value.size) : this;
    }

    public MemoryUnit minus(MemoryUnit value) {
        return value != null ? new MemoryUnit(this.size - value.size) : this;
    }

    public MemoryUnit multiply(Number value) {
        return new MemoryUnit(DefaultTypeTransformation.longUnbox((Object)NumberNumberMultiply.multiply((Number)this.size, (Number)value)));
    }

    public MemoryUnit div(Number value) {
        return new MemoryUnit(Math.round(DefaultTypeTransformation.doubleUnbox((Object)NumberNumberDiv.div((Number)this.size, (Number)value))));
    }

    public String toString() {
        if (this.size <= (long)0) {
            return "0";
        }
        int digitGroups = (int)(Math.log10(this.size) / Math.log10(1024));
        DecimalFormat formatter = new DecimalFormat("0.#", formatSymbols);
        formatter.setGroupingUsed(false);
        return StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)formatter.format((double)this.size / Math.pow(1024, digitGroups)), (CharSequence)" "), (Object)DefaultGroovyMethods.getAt((List)UNITS, (int)digitGroups));
    }

    @Override
    public int compareTo(MemoryUnit that) {
        return ScriptBytecodeAdapter.compareTo((Object)this.size, (Object)that.size);
    }

    public static int compareTo(MemoryUnit left, Object right) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            MemoryUnit memoryUnit = left;
            valueRecorder.record((Object)memoryUnit, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)memoryUnit)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert left", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (right == null) {
            throw (Throwable)new IllegalArgumentException("Not a valid memory value: null");
        }
        if (right instanceof MemoryUnit) {
            return left == (MemoryUnit)ScriptBytecodeAdapter.castToType((Object)right, MemoryUnit.class) ? 0 : (left == null ? -1 : ((MemoryUnit)ScriptBytecodeAdapter.castToType((Object)right, MemoryUnit.class) == null ? 1 : left.compareTo((MemoryUnit)ScriptBytecodeAdapter.castToType((Object)right, MemoryUnit.class))));
        }
        if (right instanceof Number) {
            return ScriptBytecodeAdapter.compareTo((Object)left.size, (Object)DefaultGroovyMethods.toLong((Number)((Number)ScriptBytecodeAdapter.castToType((Object)right, Number.class))));
        }
        if (right instanceof CharSequence) {
            return left == MemoryUnit.of(((CharSequence)right).toString()) ? 0 : (left == null ? -1 : (MemoryUnit.of(((CharSequence)right).toString()) == null ? 1 : left.compareTo(MemoryUnit.of(((CharSequence)right).toString()))));
        }
        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{right}, new String[]{"Not a valid memory value: ", ""})));
    }

    public static MemoryUnit of(String value) {
        return new MemoryUnit(value);
    }

    public static MemoryUnit of(long value) {
        return new MemoryUnit(value);
    }

    public boolean asBoolean() {
        return this.size != (long)0;
    }

    public long toUnit(String unit) {
        int p = UNITS.indexOf(unit);
        if (p == -1) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{unit}, new String[]{"Not a valid memory unit: ", ""})));
        }
        return DefaultTypeTransformation.longUnbox((Object)DefaultGroovyMethods.intdiv((Number)this.size, (Number)Math.round(Math.pow(1024, p))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MemoryUnit.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.size, (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (long)this.size);
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof MemoryUnit;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemoryUnit)) {
            return false;
        }
        MemoryUnit otherTyped = (MemoryUnit)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!(this.size == otherTyped.size)) {
            return false;
        }
        if (!(Long.valueOf(this.size) == Long.valueOf(otherTyped.size))) {
            if (Long.valueOf(this.size) == this && !(Long.valueOf(otherTyped.size) == otherTyped) || !(Long.valueOf(this.size) == this) && Long.valueOf(otherTyped.size) == otherTyped) {
                return false;
            }
            if (!(Long.valueOf(this.size) == this && Long.valueOf(otherTyped.size) == otherTyped) && !(this.size == otherTyped.size)) {
                return false;
            }
        }
        return true;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

