/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Scheduling;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import nextflow.Const;
import nextflow.exception.AbortOperationException;
import nextflow.extension.FilesEx;
import nextflow.file.FileHelper;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class GceApiHelper
implements GroovyObject {
    private static final String PROJECT_PREFIX = "https://www.googleapis.com/compute/v1/projects/";
    public static final String GAC_ENV = "GOOGLE_APPLICATION_CREDENTIALS";
    private final String project;
    private final String zone;
    private final Compute compute;
    private Random random;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GceApiHelper(String project, String zone, Compute compute) {
        Compute compute2;
        String string;
        String string2;
        MetaClass metaClass;
        Random random;
        this.random = random = new Random();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = string2 = project;
        this.zone = string = zone;
        this.compute = compute2 = compute;
    }

    public GceApiHelper(String project, String zone) throws IOException, GeneralSecurityException {
        Compute compute;
        String string;
        String string2;
        MetaClass metaClass;
        Random random;
        this.random = random = new Random();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string3 = project;
        this.project = string2 = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : this.readProject();
        String string4 = zone;
        this.zone = string = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : this.readZone();
        this.compute = compute = GceApiHelper.createComputeService(GoogleCredential.getApplicationDefault());
    }

    public static Compute createComputeService(GoogleCredential credential) throws IOException, GeneralSecurityException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        if (credential.createScopedRequired()) {
            GoogleCredential googleCredential;
            credential = googleCredential = credential.createScoped(Arrays.asList("https://www.googleapis.com/auth/cloud-platform"));
        }
        return new Compute.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Const.APP_VER}, new String[]{"nextflow/", ""}))).build();
    }

    public String projectZonePrefix() {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{PROJECT_PREFIX, this.project, this.zone}, new String[]{"", "", "/zones/", "/"}));
    }

    public String instanceType(String shortName) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.projectZonePrefix(), shortName}, new String[]{"", "machineTypes/", ""}));
    }

    public static String imageName(String imagePath) {
        return StringGroovyMethods.plus((String)PROJECT_PREFIX, (CharSequence)imagePath);
    }

    public AttachedDisk createBootDisk(String name, String imagePath) {
        AttachedDisk disk = new AttachedDisk();
        disk.setBoot(Boolean.valueOf(true));
        disk.setAutoDelete(Boolean.valueOf(true));
        disk.setType("PERSISTENT");
        AttachedDiskInitializeParams params = new AttachedDiskInitializeParams();
        if (name != null) {
            params.setDiskName(name);
        }
        params.setSourceImage(GceApiHelper.imageName(imagePath));
        params.setDiskType(StringGroovyMethods.plus((String)this.projectZonePrefix(), (CharSequence)"diskTypes/pd-standard"));
        disk.setInitializeParams(params);
        return disk;
    }

    public NetworkInterface createNetworkInterface() {
        NetworkInterface ifc = new NetworkInterface();
        ifc.setNetwork(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{PROJECT_PREFIX, this.project}, new String[]{"", "", "/global/networks/default"})));
        List configs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        AccessConfig config = new AccessConfig();
        config.setType("ONE_TO_ONE_NAT");
        config.setName("External NAT");
        configs.add(config);
        ifc.setAccessConfigs(configs);
        return ifc;
    }

    public String randomName(String baseName) {
        return StringGroovyMethods.plus((String)baseName, (CharSequence)this.randomName());
    }

    public String randomName() {
        byte[] bytes = new byte[5];
        this.random.nextBytes(bytes);
        return new BigInteger(bytes).abs().toString(16);
    }

    public List<Instance> getInstanceList(String filter) {
        Compute.Instances.List listRequest = this.compute.instances().list(this.project, this.zone);
        listRequest.setFilter(filter);
        return ((InstanceList)listRequest.execute()).getItems();
    }

    public Operation.Error blockUntilComplete(Iterable<Operation> ops, long timeoutMs, long pollingIntervalMs) {
        long start = System.currentTimeMillis();
        Operation op = null;
        Iterator<Operation> iterator = ops.iterator();
        while (iterator.hasNext()) {
            op = (Operation)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Operation.class);
            Operation.Error result = this.blockUntilComplete(op, timeoutMs - (System.currentTimeMillis() - start), pollingIntervalMs);
            if (!(result != null)) continue;
            return result;
        }
        return (Operation.Error)ScriptBytecodeAdapter.castToType(null, Operation.Error.class);
    }

    public Operation.Error blockUntilComplete(Operation operation, long timeoutMs, long pollingIntervalMs) {
        long start = System.currentTimeMillis();
        String opZone = operation.getZone();
        if (opZone != null) {
            Object object = DefaultGroovyMethods.last((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)opZone.split("/"), Object[].class)));
            opZone = ShortTypeHandling.castToString((Object)object);
        }
        String status = operation.getStatus();
        String opId = operation.getName();
        while (operation != null && ScriptBytecodeAdapter.compareNotEqual((Object)status, (Object)"DONE")) {
            String string;
            Thread.sleep(pollingIntervalMs);
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed >= timeoutMs) {
                throw (Throwable)new TimeoutException("Timed out waiting for operation to complete");
            }
            if (opZone != null) {
                Compute.ZoneOperations.Get get = this.compute.zoneOperations().get(this.project, opZone, opId);
                Object object = get.execute();
                operation = (Operation)ScriptBytecodeAdapter.castToType((Object)object, Operation.class);
            } else {
                Compute.GlobalOperations.Get get = this.compute.globalOperations().get(this.project, opId);
                Object object = get.execute();
                operation = (Operation)ScriptBytecodeAdapter.castToType((Object)object, Operation.class);
            }
            Operation operation2 = operation;
            status = string = operation2 != null ? operation2.getStatus() : null;
        }
        Operation operation3 = operation;
        return operation3 != null ? operation3.getError() : null;
    }

    public Image lookupImage(String imageId) {
        Reference imageId2 = new Reference((Object)imageId);
        String img = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])((String)imageId2.get()).split("/"), (int)0));
        ImageList list = (ImageList)ScriptBytecodeAdapter.castToType((Object)this.compute.images().list(img).execute(), ImageList.class);
        public final class _lookupImage_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference imageId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _lookupImage_closure1(Object _outerInstance, Object _thisObject, Reference imageId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.imageId = reference = imageId;
            }

            public Object doCall(Object it) {
                return ((Image)it).getSelfLink().endsWith(ShortTypeHandling.castToString((Object)this.imageId.get()));
            }

            public String getImageId() {
                return ShortTypeHandling.castToString((Object)this.imageId.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _lookupImage_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Image)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)list.getItems(), (Closure)new _lookupImage_closure1(this, this, imageId2)), Image.class);
    }

    public MachineType lookupMachineType(String machineType) {
        MachineType machineType2 = (MachineType)ScriptBytecodeAdapter.castToType((Object)this.compute.machineTypes().get(this.project, this.zone, machineType).execute(), MachineType.class);
        try {
            return machineType2;
        }
        catch (GoogleJsonResponseException re) {
            block7: {
                if (!(re.getDetails().getCode() == 404)) break block7;
                MachineType machineType3 = (MachineType)ScriptBytecodeAdapter.castToType(null, MachineType.class);
                return machineType3;
            }
            throw (Throwable)re;
        }
    }

    public String instanceIdToPrivateDNS(String instanceId) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{instanceId, this.project}, new String[]{"", ".c.", ".internal"}));
    }

    public String publicIpToDns(String ip) {
        if (ip == null) {
            return ShortTypeHandling.castToString(null);
        }
        String[] parts = ip.split("\\.");
        if (parts.length != 4) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Expected IPv4 Public IP address instead of '", (CharSequence)ip), (CharSequence)"'"));
        }
        return StringGroovyMethods.plus((String)DefaultGroovyMethods.join((Object[])DefaultGroovyMethods.reverse((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)parts, Object[].class))), (String)"."), (CharSequence)".bc.googleusercontent.com");
    }

    public String validateLabelValue(String value) {
        if (value == null) {
            return ShortTypeHandling.castToString(null);
        }
        if (!value.matches("[a-z0-9-_]*")) {
            return "Value must consist of lowercase letters, numbers, underscores and dashes only";
        }
        if (value.length() > 63) {
            return "Value exceeds maximum length of 63";
        }
        return ShortTypeHandling.castToString(null);
    }

    public Object setStartupScript(Instance instance, String script) {
        return this.addMetadataItem(instance, "startup-script", script);
    }

    public Object setShutdownScript(Instance instance, String script) {
        return this.addMetadataItem(instance, "shutdown-script", script);
    }

    public Object addMetadataItem(Instance instance, String key, String value) {
        Metadata metadata = instance.getMetadata();
        Metadata metadata2 = DefaultTypeTransformation.booleanUnbox((Object)metadata) ? metadata : new Metadata();
        List list = metadata2.getItems();
        List items = DefaultTypeTransformation.booleanUnbox((Object)list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Metadata.Items item = new Metadata.Items();
        item.setKey(key);
        item.setValue(value);
        items.add(item);
        metadata2.setItems(items);
        return instance.setMetadata(metadata2);
    }

    public String readGoogleMetadata(String meta) {
        String payload;
        block6: {
            String string;
            payload = ResourceGroovyMethods.getText((URL)ResourceGroovyMethods.toURL((CharSequence)new GStringImpl(new Object[]{meta}, new String[]{"http://metadata/computeMetadata/v1/", ""})), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"requestProperties", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Metadata-Flavor", "Google"})}));
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)payload) || DefaultTypeTransformation.booleanUnbox((string = payload) != null ? Boolean.valueOf(string.isEmpty()) : null))) break block6;
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{meta}, new String[]{"Could not find google metadata: ", ""})));
        }
        String string = payload;
        try {
            return string;
        }
        catch (Exception e) {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{meta, e.getClass(), e.getMessage()}, new String[]{"Cannot read Google metadata ", ": ", "(", ")"})), (Throwable)e);
        }
    }

    public String readProject() {
        if (this.isCredentialLocationDefined()) {
            Object cred = new JsonSlurper().parseText(this.getCredentialsFile());
            Object project = DefaultGroovyMethods.getAt((Object)cred, (String)"project_id");
            if (!DefaultTypeTransformation.booleanUnbox((Object)project)) {
                throw (Throwable)new AbortOperationException("Could not read project from Credential file");
            }
            return ShortTypeHandling.castToString((Object)project);
        }
        return this.readGoogleMetadata("project/project-id");
    }

    public String readZone() {
        return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.last((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)this.readGoogleMetadata("instance/zone").split("/"), Object[].class))));
    }

    public String readInstanceId() {
        return this.readGoogleMetadata("instance/name");
    }

    public Scheduling createScheduling(boolean preemptible) {
        return new Scheduling().setPreemptible(Boolean.valueOf(preemptible));
    }

    public String getCredentialsFile() {
        String credFileLocation = this.credentialFileLocation();
        if (!DefaultTypeTransformation.booleanUnbox((Object)credFileLocation)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{GAC_ENV}, new String[]{"", " is not defined in your environment"})));
        }
        Path credFile = FileHelper.asPath((String)credFileLocation);
        if (DefaultTypeTransformation.booleanUnbox((Object)credFile) && FilesEx.exists((Path)credFile, (LinkOption[])new LinkOption[0])) {
            return ResourceGroovyMethods.getText((File)credFile.toFile());
        }
        throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{credFileLocation}, new String[]{"Could not find Google credentials file '", "'"})));
    }

    public boolean isCredentialLocationDefined() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.credentialFileLocation());
    }

    public String credentialFileLocation() {
        return System.getenv(GAC_ENV);
    }

    @Generated
    public Operation.Error blockUntilComplete(Iterable<Operation> ops, long timeoutMs) {
        return this.blockUntilComplete(ops, timeoutMs, (long)5000);
    }

    @Generated
    public Operation.Error blockUntilComplete(Iterable<Operation> ops) {
        return this.blockUntilComplete(ops, (long)20000, (long)5000);
    }

    @Generated
    public Operation.Error blockUntilComplete(Operation operation, long timeoutMs) {
        return this.blockUntilComplete(operation, timeoutMs, (long)5000);
    }

    @Generated
    public Operation.Error blockUntilComplete(Operation operation) {
        return this.blockUntilComplete(operation, (long)10000, (long)5000);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GceApiHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public final String getProject() {
        return this.project;
    }

    @Generated
    public final String getZone() {
        return this.zone;
    }

    @Generated
    public final Compute getCompute() {
        return this.compute;
    }

    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public void setRandom(Random random) {
        this.random = random;
    }
}

