/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstancesSetLabelsRequest;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.NetworkInterface;
import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.ClosureSignatureConflictResolver;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextflow.Global;
import nextflow.cloud.CloudConst;
import nextflow.cloud.CloudDriver;
import nextflow.cloud.CloudScripts;
import nextflow.cloud.LaunchConfig;
import nextflow.cloud.aws.CloudBootTemplateBinding;
import nextflow.cloud.google.GceApiHelper;
import nextflow.cloud.types.CloudInstance;
import nextflow.cloud.types.CloudInstanceStatus;
import nextflow.cloud.types.CloudInstanceType;
import nextflow.exception.AbortOperationException;
import nextflow.extension.Bolts;
import nextflow.file.FileHelper;
import nextflow.processor.TaskTemplateEngine;
import nextflow.util.MemoryUnit;
import nextflow.util.ServiceName;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value="google")
public class GoogleCloudDriver
implements CloudDriver,
GroovyObject {
    private static final String TERMINATION_FILENAME = "/tmp/shutdown.begin";
    private static final String GCE_CREDENTIAL_FILE = "$HOME/.nextflow/gce_credentials.json";
    private static long OPS_WAIT_TIMEOUT_MS;
    private static long POLL_WAIT;
    private GceApiHelper helper;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GoogleCloudDriver(GceApiHelper helper) {
        GceApiHelper gceApiHelper;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CloudDriver.Trait.Helper.$init$((CloudDriver)this);
        this.helper = gceApiHelper = helper;
    }

    public GoogleCloudDriver() {
        this(Collections.emptyMap());
    }

    @Deprecated
    public GoogleCloudDriver(Map config) {
        MetaClass metaClass;
        CallSite[] callSiteArray = GoogleCloudDriver.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CloudDriver.Trait.Helper.$init$((CloudDriver)this);
        Object object = callSiteArray[0].callGetProperty((Object)config);
        String zone = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[1].callSafe(callSiteArray[2].callGetProperty(Global.class), (Object)"google.zone")));
        Object object2 = callSiteArray[3].callGetProperty((Object)config);
        String project = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(Global.class), (Object)"google.project")));
        Object object3 = callSiteArray[6].callConstructor(GceApiHelper.class, (Object)project, (Object)zone);
        this.helper = (GceApiHelper)ScriptBytecodeAdapter.castToType((Object)object3, GceApiHelper.class);
        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)log)) ? callSiteArray[8].call((Object)log, (Object)"Starting GoogleCloudDriver in project {} and zone {}", callSiteArray[9].callGroovyObjectGetProperty((Object)this.helper), callSiteArray[10].callGroovyObjectGetProperty((Object)this.helper)) : null;
    }

    public synchronized Compute getClient() {
        return this.helper.getCompute();
    }

    public void validate(LaunchConfig config) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)config.getImageId())) {
            throw (Throwable)new AbortOperationException("Missing mandatory cloud `imageId` setting");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)config.getInstanceType())) {
            throw (Throwable)new AbortOperationException("Missing mandatory cloud `instanceType` setting");
        }
        try {
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.helper.lookupImage(config.getImageId()))) {
                throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{config.getImageId()}, new String[]{"Unknown GCE image ID: ", ""})));
            }
        }
        catch (Exception e) {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{config.getImageId()}, new String[]{"Invalid GCE image ID: ", ""})), (Throwable)e);
        }
        try {
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.helper.lookupMachineType(config.getInstanceType()))) {
                throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{config.getInstanceType()}, new String[]{"Unknown GCE machine type: ", ""})));
            }
        }
        catch (Exception e) {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{config.getInstanceType()}, new String[]{"Invalid GCE machine type: ", ""})), (Throwable)e);
        }
        String validationError = this.helper.validateLabelValue(config.getClusterName());
        if (validationError != null) {
            throw (Throwable)new AbortOperationException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Invalid cluster name '", (CharSequence)config.getClusterName()), (CharSequence)"': "), (CharSequence)validationError));
        }
        this.checkUnsupportedSettings(config);
    }

    protected void checkUnsupportedSettings(LaunchConfig config) {
        List UNSUPPORTED = ScriptBytecodeAdapter.createList((Object[])new Object[]{"bootStorageSize", "instanceRole", "instanceStorageMount", "instanceStorageDevice", "securityGroup", "sharedStorageId", "sharedStorageMount", "subnetId", "spotPrice"});
        Set invalid = DefaultGroovyMethods.intersect((Set)config.getAttributeNames(), (Iterable)UNSUPPORTED);
        if (DefaultTypeTransformation.booleanUnbox((Object)invalid)) {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)invalid, (String)", ")}, new String[]{"The following cloud settings are not supported by GCE driver: ", ""})));
        }
    }

    public List<String> launchInstances(int instanceCount, LaunchConfig config) {
        Reference config2 = new Reference((Object)config);
        Reference result = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference ops = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _launchInstances_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference config;
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference ops;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _launchInstances_closure1(Object _outerInstance, Object _thisObject, Reference config, Reference result, Reference ops) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.config = reference3 = config;
                this.result = reference2 = result;
                this.ops = reference = ops;
            }

            public Object doCall(Object it) {
                Instance inst = new Instance();
                inst.setName(((GoogleCloudDriver)this.getThisObject()).helper.randomName(StringGroovyMethods.plus((String)((LaunchConfig)this.config.get()).getClusterName(), (CharSequence)"-")));
                inst.setMachineType(((GoogleCloudDriver)this.getThisObject()).helper.instanceType(((LaunchConfig)this.config.get()).getInstanceType()));
                if (((LaunchConfig)this.config.get()).getPreemptible()) {
                    inst.setScheduling(((GoogleCloudDriver)this.getThisObject()).helper.createScheduling(((LaunchConfig)this.config.get()).getPreemptible()));
                    ((GoogleCloudDriver)this.getThisObject()).helper.setShutdownScript(inst, ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethodSafe((Object)((GoogleCloudDriver)this.getThisObject()), (String)"gceShutdownScript", (Object)new Object[0])));
                }
                inst.setDisks(ScriptBytecodeAdapter.createList((Object[])new Object[]{((GoogleCloudDriver)this.getThisObject()).helper.createBootDisk(inst.getName(), ((LaunchConfig)this.config.get()).getImageId())}));
                inst.setNetworkInterfaces(ScriptBytecodeAdapter.createList((Object[])new Object[]{((GoogleCloudDriver)this.getThisObject()).helper.createNetworkInterface()}));
                ((GoogleCloudDriver)this.getThisObject()).helper.setStartupScript(inst, ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethodSafe((Object)((GoogleCloudDriver)this.getThisObject()), (String)"gceStartupScript", (Object)new Object[]{this.config.get()})));
                Compute.Instances.Insert insert = ((GoogleCloudDriver)this.getThisObject()).helper.getCompute().instances().insert(((GoogleCloudDriver)this.getThisObject()).helper.getProject(), ((GoogleCloudDriver)this.getThisObject()).helper.getZone(), inst);
                DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)inst.getName());
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.ops.get(), List.class)), (Object)insert.execute());
            }

            public LaunchConfig getConfig() {
                return (LaunchConfig)ScriptBytecodeAdapter.castToType((Object)this.config.get(), LaunchConfig.class);
            }

            public List getResult() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class);
            }

            public List getOps() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.ops.get(), List.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _launchInstances_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.times((Number)instanceCount, (Closure)new _launchInstances_closure1(this, this, config2, result, ops));
        this.helper.blockUntilComplete((List)ops.get(), OPS_WAIT_TIMEOUT_MS);
        return (List)result.get();
    }

    public void waitInstanceStatus(Collection<String> instanceIds, CloudInstanceStatus status) {
        List instanceStatusList = null;
        CloudInstanceStatus cloudInstanceStatus = status;
        if (ScriptBytecodeAdapter.isCase((Object)cloudInstanceStatus, (Object)CloudInstanceStatus.STARTED)) {
            List list;
            instanceStatusList = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"RUNNING"});
            this.waitStatus(instanceIds, instanceStatusList);
        } else if (ScriptBytecodeAdapter.isCase((Object)cloudInstanceStatus, (Object)CloudInstanceStatus.READY)) {
            List list;
            instanceStatusList = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"RUNNING"});
            this.waitStatus(instanceIds, instanceStatusList);
        } else if (ScriptBytecodeAdapter.isCase((Object)cloudInstanceStatus, (Object)CloudInstanceStatus.TERMINATED)) {
            List list;
            instanceStatusList = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"TERMINATED"});
            this.waitStatus(instanceIds, instanceStatusList);
        } else {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{status}, new String[]{"Unknown instance status: ", ""})));
        }
    }

    void waitStatus(Collection<String> instanceIds, List<String> instanceStatusList) {
        HashSet<String> remaining = new HashSet<String>(instanceIds);
        while (!remaining.isEmpty()) {
            String filter = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(instanceIds, (Closure)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"instanceIdToFilterExpression")), (String)" OR ");
            List<Instance> instances = this.helper.getInstanceList(filter);
            if (DefaultTypeTransformation.booleanUnbox(instances)) {
                Instance instance = null;
                Iterator<Instance> iterator = instances.iterator();
                while (iterator.hasNext()) {
                    instance = (Instance)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Instance.class);
                    if (!instanceStatusList.contains(instance.get("status"))) continue;
                    remaining.remove(instance.getName());
                }
            } else if (instanceStatusList.contains("TERMINATED") && (instances == null || instances.isEmpty())) break;
            if (!(!remaining.isEmpty())) continue;
            Thread.sleep(POLL_WAIT);
        }
    }

    public void tagInstances(Collection<String> instanceIds, Map<String, String> tags) {
        Reference labels = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _tagInstances_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference labels;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _tagInstances_closure2(Object _outerInstance, Object _thisObject, Reference labels) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.labels = reference = labels;
            }

            public Object doCall(Object k, Object v) {
                Object object = v;
                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.labels.get(), Map.class)), (Object)((String)k).toLowerCase(), (Object)object);
                return object;
            }

            public Object call(Object k, Object v) {
                return this.doCall(k, v);
            }

            public Map getLabels() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.labels.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _tagInstances_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(tags, (Closure)new _tagInstances_closure2(this, this, labels));
        List ops = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String instanceId = null;
        Iterator<String> iterator = instanceIds.iterator();
        while (iterator.hasNext()) {
            instanceId = ShortTypeHandling.castToString((Object)iterator.next());
            Instance instance = (Instance)ScriptBytecodeAdapter.castToType((Object)this.helper.getCompute().instances().get(this.helper.getProject(), this.helper.getZone(), instanceId).execute(), Instance.class);
            if (instance.getLabels() != null) {
                Map map = DefaultGroovyMethods.plus((Map)((Map)labels.get()), (Map)instance.getLabels());
                labels.set((Object)map);
            }
            InstancesSetLabelsRequest request = new InstancesSetLabelsRequest();
            request.setLabelFingerprint(instance.getLabelFingerprint());
            request.setLabels((Map)labels.get());
            DefaultGroovyMethods.leftShift((List)ops, (Object)this.helper.getCompute().instances().setLabels(this.helper.getProject(), this.helper.getZone(), instanceId, request).execute());
        }
        this.helper.blockUntilComplete(ops, OPS_WAIT_TIMEOUT_MS);
    }

    public void eachSpotPrice(List<String> instanceTypes, @ClosureParams(value=SimpleType.class, options={"nextflow.cloud.types.CloudSpotPrice"}) Closure callback) {
        throw (Throwable)new UnsupportedOperationException("Spot prices feature is not supported by the GCE driver");
    }

    public void eachInstanceWithTags(Map tags, @ClosureParams(value=SimpleType.class, options={"nextflow.cloud.types.CloudInstance"}) Closure callback) {
        String filter = null;
        if (tags != null && !tags.isEmpty()) {
            String string;
            filter = string = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Map)tags, (Closure)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"tagToFilterExpression")), (String)" ");
        }
        this.eachInstanceWithFilter(filter, callback);
    }

    public void eachInstanceWithIds(List<String> instanceIds, @ClosureParams(value=SimpleType.class, options={"nextflow.cloud.types.CloudInstance"}) Closure callback) {
        if (instanceIds.size() > 0) {
            this.eachInstanceWithFilter(DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect(instanceIds, (Closure)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"instanceIdToFilterExpression")), (String)" OR "), callback);
        }
    }

    public void eachInstance(@ClosureParams(value=SimpleType.class, options={"nextflow.cloud.types.CloudInstance"}) Closure callback) {
        this.eachInstanceWithFilter((String)ScriptBytecodeAdapter.asType(null, String.class), callback);
    }

    public void eachInstanceWithFilter(String filter, @ClosureParams(value=SimpleType.class, options={"nextflow.cloud.types.CloudInstance"}) Closure callback) {
        Reference callback2 = new Reference((Object)callback);
        List<Instance> list = this.helper.getInstanceList(filter);
        public final class _eachInstanceWithFilter_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference callback;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _eachInstanceWithFilter_closure3(Object _outerInstance, Object _thisObject, Reference callback) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.callback = reference = callback;
            }

            public Object doCall(Object inst) {
                return ((Closure)this.callback.get()).call(((GoogleCloudDriver)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GoogleCloudDriver.class)).toNextflow((Instance)ScriptBytecodeAdapter.castToType((Object)inst, Instance.class)));
            }

            public Closure getCallback() {
                return (Closure)ScriptBytecodeAdapter.castToType((Object)this.callback.get(), Closure.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _eachInstanceWithFilter_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each(list, (Closure)new _eachInstanceWithFilter_closure3(this, this, callback2)) : null;
    }

    public List<String> listPrivateIPs(String clusterName) {
        Reference result = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _listPrivateIPs_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listPrivateIPs_closure4(Object _outerInstance, Object _thisObject, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.result = reference = result;
            }

            public Object doCall(CloudInstance it) {
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.result.get(), List.class)), (Object)it.getPrivateIpAddress());
            }

            public Object call(CloudInstance it) {
                return this.doCall(it);
            }

            public Object getResult() {
                return this.result.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listPrivateIPs_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.eachInstanceWithTags(ScriptBytecodeAdapter.createMap((Object[])new Object[]{CloudConst.TAG_CLUSTER_NAME, clusterName}), new _listPrivateIPs_closure4(this, this, result));
        return (List)result.get();
    }

    public void terminateInstances(Collection<String> instanceIds) {
        String idInstance = null;
        Iterator<String> iterator = instanceIds.iterator();
        while (iterator.hasNext()) {
            idInstance = ShortTypeHandling.castToString((Object)iterator.next());
            Compute.Instances.Delete delete = this.helper.getCompute().instances().delete(this.helper.getProject(), this.helper.getZone(), idInstance);
            delete.execute();
        }
    }

    public String getLocalInstanceId() {
        return this.helper.readInstanceId();
    }

    public String getLocalTerminationNotice() {
        Path shutdownFile = FileHelper.asPath((String)TERMINATION_FILENAME);
        if (Files.exists(shutdownFile, new LinkOption[0])) {
            return ResourceGroovyMethods.getText((File)shutdownFile.toFile());
        }
        return ShortTypeHandling.castToString(null);
    }

    public CloudInstanceType describeInstanceType(String instanceType) {
        MachineType type = this.helper.lookupMachineType(instanceType);
        if (!DefaultTypeTransformation.booleanUnbox((Object)type)) {
            return (CloudInstanceType)ScriptBytecodeAdapter.castToType(null, CloudInstanceType.class);
        }
        return new CloudInstanceType(type.getName(), type.getGuestCpus().intValue(), new MemoryUnit(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{type.getMemoryMb()}, new String[]{"", " MB"}))), new MemoryUnit(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{type.getImageSpaceGb()}, new String[]{"", " GB"}))), type.getMaximumPersistentDisks().intValue());
    }

    public static String tagToFilterExpression(String k, Object v) {
        Object object;
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"(labels.", (CharSequence)k.toLowerCase()), (CharSequence)" = \""), (Object)(DefaultTypeTransformation.booleanUnbox((Object)(object = v)) ? object : "*")), (CharSequence)"\")");
    }

    public static String instanceIdToFilterExpression(String instanceId) {
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"(name = \"", (CharSequence)instanceId), (CharSequence)"\")");
    }

    public Object toNextflow(Instance instance) {
        AccessConfig accessConfig;
        NetworkInterface networkInterface = null;
        AccessConfig accessConfig2 = null;
        Map map = instance.getLabels();
        public final class _toNextflow_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toNextflow_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toNextflow_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Object labels = DefaultTypeTransformation.booleanUnbox((Object)map) ? map : new _toNextflow_closure5(this, this);
        if (instance.getNetworkInterfaces() != null && !instance.getNetworkInterfaces().isEmpty()) {
            List list;
            Object object = DefaultGroovyMethods.getAt((List)instance.getNetworkInterfaces(), (int)0);
            networkInterface = (NetworkInterface)ScriptBytecodeAdapter.castToType((Object)object, NetworkInterface.class);
            if (networkInterface.getAccessConfigs() != null && !DefaultTypeTransformation.booleanUnbox((list = networkInterface.getAccessConfigs()) != null ? Boolean.valueOf(list.isEmpty()) : null)) {
                Object object2 = DefaultGroovyMethods.getAt((List)networkInterface.getAccessConfigs(), (int)0);
                accessConfig2 = (AccessConfig)ScriptBytecodeAdapter.castToType((Object)object2, AccessConfig.class);
            }
        }
        Object[] objectArray = new Object[16];
        objectArray[0] = "id";
        objectArray[1] = instance.getName();
        objectArray[2] = "privateIpAddress";
        NetworkInterface networkInterface2 = networkInterface;
        objectArray[3] = networkInterface2 != null ? networkInterface2.getNetworkIP() : null;
        objectArray[4] = "privateDnsName";
        objectArray[5] = this.helper.instanceIdToPrivateDNS(instance.getName());
        objectArray[6] = "publicIpAddress";
        AccessConfig accessConfig3 = accessConfig2;
        objectArray[7] = accessConfig3 != null ? accessConfig3.getNatIP() : null;
        objectArray[8] = "publicDnsName";
        AccessConfig accessConfig4 = accessConfig2;
        String string = accessConfig4 != null ? accessConfig4.getPublicPtrDomainName() : null;
        objectArray[9] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.helper.publicIpToDns((accessConfig = accessConfig2) != null ? accessConfig.getNatIP() : null);
        objectArray[10] = "state";
        objectArray[11] = instance.getStatus();
        objectArray[12] = "role";
        objectArray[13] = DefaultGroovyMethods.getAt((Object)labels, (String)CloudConst.TAG_CLUSTER_ROLE.toLowerCase());
        objectArray[14] = "clusterName";
        objectArray[15] = DefaultGroovyMethods.getAt((Object)labels, (String)CloudConst.TAG_CLUSTER_NAME.toLowerCase());
        return new CloudInstance(ScriptBytecodeAdapter.createMap((Object[])objectArray));
    }

    String gceShutdownScript() {
        return Bolts.leftTrim((String)StringGroovyMethods.stripIndent((CharSequence)new GStringImpl(new Object[]{TERMINATION_FILENAME}, new String[]{"\n            #!/bin/bash            \n            date >> ", "                                               \n        "})));
    }

    String gceStartupScript(LaunchConfig cfg) {
        List builder = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (cfg.getCreateUser()) {
            DefaultGroovyMethods.leftShift((List)builder, (Object)CloudScripts.scriptCreateUser((String)cfg.getUserName(), (String)cfg.getKeyHash()));
        }
        DefaultGroovyMethods.leftShift((List)builder, (Object)this.cloudInitScript(cfg));
        if (DefaultTypeTransformation.booleanUnbox((Object)builder)) {
            builder.add(0, "#!/bin/bash");
        }
        return DefaultGroovyMethods.join((Iterable)builder, (String)"\n");
    }

    String cloudInitScript(LaunchConfig cfg) {
        CallSite[] callSiteArray = GoogleCloudDriver.$getCallSiteArray();
        Object template = callSiteArray[11].call(callSiteArray[12].callGroovyObjectGetProperty((Object)this), (Object)"cloud-boot.txt");
        if (!DefaultTypeTransformation.booleanUnbox((Object)template)) {
            throw (Throwable)callSiteArray[13].callConstructor(IllegalStateException.class, (Object)"Missing `cloud-boot.txt` template resource");
        }
        Object binding = callSiteArray[14].callConstructor(CloudBootTemplateBinding.class, (Object)cfg);
        Object object = callSiteArray[15].call((Object)cfg);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)binding, (String)"nextflowConfig");
        Object object2 = callSiteArray[16].callCurrent((GroovyObject)this, (Object)cfg);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)binding, (String)"bashProfile");
        String string = GCE_CREDENTIAL_FILE;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)binding, (String)"gceCredentialsFile");
        Object object3 = callSiteArray[17].call((Object)this.helper);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)binding, (String)"gceCredentials");
        return ShortTypeHandling.castToString((Object)callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].callConstructor(TaskTemplateEngine.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"!", Character.TYPE))), Character.TYPE)), (Object)false), callSiteArray[24].callConstructor(InputStreamReader.class, template)), binding)));
    }

    public String scriptBashEnv(LaunchConfig cfg) {
        String string;
        String profile = StringGroovyMethods.stripIndent((CharSequence)new GStringImpl(new Object[]{cfg.getNextflow().getVersion(), cfg.getClusterName()}, new String[]{"        export NXF_VER='", "'\n        export NXF_MODE='google'\n        export NXF_EXECUTOR='ignite'\n        export NXF_CLUSTER_JOIN='cloud:google:", "'\n        "}));
        if (DefaultTypeTransformation.booleanUnbox((Object)cfg.getNextflow().getTrace())) {
            String string2;
            profile = string2 = StringGroovyMethods.plus((String)profile, (CharSequence)new GStringImpl(new Object[]{cfg.getNextflow().getTrace()}, new String[]{"export NXF_TRACE='", "'\n"}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)cfg.getNextflow().getOptions())) {
            String string3;
            profile = string3 = StringGroovyMethods.plus((String)profile, (CharSequence)new GStringImpl(new Object[]{cfg.getNextflow().getOptions()}, new String[]{"export NXF_OPTS='", "'\n"}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)cfg.getSharedStorageId()) && DefaultTypeTransformation.booleanUnbox((Object)cfg.getSharedStorageMount())) {
            String string4;
            String string5;
            profile = string5 = StringGroovyMethods.plus((String)profile, (CharSequence)new GStringImpl(new Object[]{cfg.getSharedStorageMount(), cfg.getUserName()}, new String[]{"export NXF_WORK='", "/", "/work'\n"}));
            profile = string4 = StringGroovyMethods.plus((String)profile, (CharSequence)new GStringImpl(new Object[]{cfg.getSharedStorageMount(), cfg.getUserName()}, new String[]{"export NXF_ASSETS='", "/", "/projects'\n"}));
        }
        profile = string = StringGroovyMethods.plus((String)profile, (CharSequence)new GStringImpl(new Object[]{GCE_CREDENTIAL_FILE}, new String[]{"export GOOGLE_APPLICATION_CREDENTIALS=", "\n"}));
        if (DefaultTypeTransformation.booleanUnbox((Object)System.getenv("NEXTFLOW_DOWNLOAD_URL"))) {
            String string6;
            profile = string6 = StringGroovyMethods.plus((String)profile, (CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"export NEXTFLOW_DOWNLOAD_URL=", (CharSequence)System.getenv("NEXTFLOW_DOWNLOAD_URL")), (CharSequence)"\n"));
        }
        return profile;
    }

    @Traits.TraitBridge(traitClass=CloudDriver.class, desc="(Lgroovy/lang/Closure;)V")
    public void eachSpotPrice(@ClosureParams(value=SimpleType.class, conflictResolutionStrategy=ClosureSignatureConflictResolver.class, options={"nextflow.cloud.types.CloudSpotPrice"}) Closure param1) {
        CloudDriver.Trait.Helper.eachSpotPrice((CloudDriver)this, (Closure)param1);
    }

    public /* synthetic */ void nextflow_cloud_CloudDrivertrait$super$eachSpotPrice(Closure<Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"eachSpotPrice", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"eachSpotPrice", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=CloudDriver.class, desc="(Ljava/util/Collection;Lnextflow/cloud/LaunchConfig;)V")
    public void tagInstances(Collection<String> param1, LaunchConfig param2) {
        CloudDriver.Trait.Helper.tagInstances((CloudDriver)this, param1, (LaunchConfig)param2);
    }

    public /* synthetic */ void nextflow_cloud_CloudDrivertrait$super$tagInstances(Collection<String> param0, LaunchConfig param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"tagInstances", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"tagInstances", (Object[])new Object[]{param0, param1});
        }
    }

    static {
        Logger logger;
        int n = 1000;
        POLL_WAIT = n;
        int n2 = 300000;
        OPS_WAIT_TIMEOUT_MS = n2;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.GoogleCloudDriver");
        CloudDriver.Trait.Helper.$static$init$(GoogleCloudDriver.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleCloudDriver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public static String getTERMINATION_FILENAME() {
        return TERMINATION_FILENAME;
    }

    @Generated
    public static String getGCE_CREDENTIAL_FILE() {
        return GCE_CREDENTIAL_FILE;
    }

    @Generated
    public static long getOPS_WAIT_TIMEOUT_MS() {
        return OPS_WAIT_TIMEOUT_MS;
    }

    @Generated
    public static void setOPS_WAIT_TIMEOUT_MS(long l) {
        OPS_WAIT_TIMEOUT_MS = l;
    }

    @Generated
    public static long getPOLL_WAIT() {
        return POLL_WAIT;
    }

    @Generated
    public static void setPOLL_WAIT(long l) {
        POLL_WAIT = l;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "zone";
        stringArray[1] = "navigate";
        stringArray[2] = "config";
        stringArray[3] = "project";
        stringArray[4] = "navigate";
        stringArray[5] = "config";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "isDebugEnabled";
        stringArray[8] = "debug";
        stringArray[9] = "project";
        stringArray[10] = "zone";
        stringArray[11] = "getResourceAsStream";
        stringArray[12] = "class";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "renderCloudConfigObject";
        stringArray[16] = "scriptBashEnv";
        stringArray[17] = "getCredentialsFile";
        stringArray[18] = "toString";
        stringArray[19] = "make";
        stringArray[20] = "createTemplate";
        stringArray[21] = "setEnableShortNotation";
        stringArray[22] = "setPlaceholder";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[25];
        GoogleCloudDriver.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GoogleCloudDriver.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GoogleCloudDriver.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

