/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.lifesciences;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nextflow.Session;
import nextflow.exception.AbortOperationException;
import nextflow.extension.Bolts;
import nextflow.util.MemoryUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ToString(includeNames=true, includePackage=false)
public class GoogleLifeSciencesConfig
implements GroovyObject {
    public static final String DEFAULT_COPY_IMAGE = "google/cloud-sdk:alpine";
    public static final String DEFAULT_SSH_IMAGE = "gcr.io/cloud-genomics-pipelines/tools";
    public static final String DEFAULT_ENTRY_POINT = "/bin/bash";
    private String project;
    private List<String> zones;
    private List<String> regions;
    private boolean preemptible;
    private Path remoteBinDir;
    private String location;
    private boolean disableBinDir;
    private MemoryUnit bootDiskSize;
    private boolean sshDaemon;
    private String sshImage;
    private Integer debugMode;
    private String copyImage;
    private boolean usePrivateAddress;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Deprecated
    public GoogleLifeSciencesConfig(String project, List<String> zone, List<String> region, Path remoteBinDir, boolean preemptible) {
        boolean bl;
        Path path;
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = string = project;
        List<String> list = zone;
        this.zones = list;
        List<String> list2 = region;
        this.regions = list2;
        this.remoteBinDir = path = remoteBinDir;
        this.preemptible = bl = preemptible;
        String string2 = DefaultTypeTransformation.booleanUnbox(region) ? region.get(0) : null;
        this.location = ShortTypeHandling.castToString((Object)string2);
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.location)) {
            throw (Throwable)new IllegalArgumentException("Missing Google cloud location");
        }
    }

    public GoogleLifeSciencesConfig() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Generated
    public GoogleLifeSciencesConfig(String project, List<String> zone, List<String> region, Path remoteBinDir) {
        this(project, zone, region, remoteBinDir, false);
    }

    @Generated
    public GoogleLifeSciencesConfig(String project, List<String> zone, List<String> region) {
        this(project, zone, region, null, false);
    }

    public static GoogleLifeSciencesConfig fromSession(Session session) {
        GoogleLifeSciencesConfig googleLifeSciencesConfig = GoogleLifeSciencesConfig.fromSession0(session.getConfig());
        try {
            return googleLifeSciencesConfig;
        }
        catch (Exception e) {
            session.abort();
            throw (Throwable)e;
        }
    }

    protected static GoogleLifeSciencesConfig fromSession0(Map config) {
        String project = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.project"), String.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)config, (String)"google.zone")) && !DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)config, (String)"google.region"))) {
            throw (Throwable)new AbortOperationException("Missing configuration value 'google.zone' or 'google.region'");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)config, (String)"google.zone")) && DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)config, (String)"google.region"))) {
            throw (Throwable)new AbortOperationException("You can't specify both 'google.zone' and 'google.region' configuration parameters -- Please remove one of them from your configuration");
        }
        Object path = Bolts.navigate((Map)config, (String)"env.PATH");
        if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
            log.warn("Environment PATH defined in config file is ignored by Google Pipeline executor");
        }
        boolean disableBinDir = DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.disableRemoteBinDir", (Object)false));
        boolean preemptible = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.preemptible", (Object)false), Boolean.TYPE));
        MemoryUnit bootDiskSize = (MemoryUnit)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.bootDiskSize"), MemoryUnit.class);
        boolean sshDaemon = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.sshDaemon", (Object)false), Boolean.TYPE));
        String sshImage = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.sshImage", (Object)DEFAULT_SSH_IMAGE), String.class);
        String copyImage = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.copyImage", (Object)DEFAULT_COPY_IMAGE), String.class);
        Object debugMode = Bolts.navigate((Map)config, (String)"google.lifeSciences.debug", (Object)System.getenv("NXF_DEBUG"));
        boolean privateAddr = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.lifeSciences.usePrivateAddress"), Boolean.TYPE));
        String string = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.zone"), String.class);
        String[] stringArray = string != null ? string.split(",") : null;
        List<String> list = stringArray != null ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)stringArray, Object[].class))) : null;
        List<String> zones = DefaultTypeTransformation.booleanUnbox(list) ? list : Collections.emptyList();
        String string2 = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.region"), String.class);
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        List<String> list2 = stringArray2 != null ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)stringArray2, Object[].class))) : null;
        List<String> regions = DefaultTypeTransformation.booleanUnbox(list2) ? list2 : Collections.emptyList();
        String string3 = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)config, (String)"google.location"), String.class);
        String location = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : GoogleLifeSciencesConfig.fallbackToRegionOrZone(regions, zones);
        GoogleLifeSciencesConfig googleLifeSciencesConfig = new GoogleLifeSciencesConfig();
        String string4 = project;
        googleLifeSciencesConfig.setProject(string4);
        List<String> list3 = regions;
        googleLifeSciencesConfig.setRegions(list3);
        List<String> list4 = zones;
        googleLifeSciencesConfig.setZones(list4);
        String string5 = location;
        googleLifeSciencesConfig.setLocation(string5);
        boolean bl = preemptible;
        googleLifeSciencesConfig.setPreemptible(bl);
        boolean bl2 = disableBinDir;
        googleLifeSciencesConfig.setDisableBinDir(bl2);
        MemoryUnit memoryUnit = bootDiskSize;
        googleLifeSciencesConfig.setBootDiskSize(memoryUnit);
        Integer n = GoogleLifeSciencesConfig.debugMode0(debugMode);
        googleLifeSciencesConfig.setDebugMode(n);
        String string6 = copyImage;
        googleLifeSciencesConfig.setCopyImage(string6);
        boolean bl3 = sshDaemon;
        googleLifeSciencesConfig.setSshDaemon(bl3);
        String string7 = sshImage;
        googleLifeSciencesConfig.setSshImage(string7);
        boolean bl4 = privateAddr;
        googleLifeSciencesConfig.setUsePrivateAddress(bl4);
        return googleLifeSciencesConfig;
    }

    private static Integer debugMode0(Object value) {
        if (value instanceof Boolean) {
            return DefaultTypeTransformation.booleanUnbox((Object)value) ? 1 : 0;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return StringGroovyMethods.toInteger((CharSequence)DefaultGroovyMethods.toString((Object)value));
        }
        return (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
    }

    public static String fallbackToRegionOrZone(List<String> regions, List<String> zones) {
        Reference zones2 = new Reference(zones);
        if (DefaultTypeTransformation.booleanUnbox(regions)) {
            return GoogleLifeSciencesConfig.bestLocationForRegion(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(regions, (int)0)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)((List)zones2.get()))) {
            public final class _fallbackToRegionOrZone_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference zones;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _fallbackToRegionOrZone_closure1(Object _outerInstance, Object _thisObject, Reference zones) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.zones = reference = zones;
                }

                public Object doCall(Object it) {
                    int p = ((String)DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType((Object)this.zones.get(), List.class)), (int)0)).lastIndexOf("-");
                    return ScriptBytecodeAdapter.compareNotEqual((Object)p, (Object)-1) ? ((String)it).substring(0, p) : ShortTypeHandling.castToString((Object)it);
                }

                public List getZones() {
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.zones.get(), List.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _fallbackToRegionOrZone_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List norm = DefaultGroovyMethods.unique((List)DefaultGroovyMethods.collect((Iterable)((List)zones2.get()), (Closure)new _fallbackToRegionOrZone_closure1(GoogleLifeSciencesConfig.class, GoogleLifeSciencesConfig.class, zones2)));
            return GoogleLifeSciencesConfig.bestLocationForRegion(ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)norm, (int)0)));
        }
        throw (Throwable)new AbortOperationException("Missing Google region or zone information");
    }

    public static String bestLocationForRegion(String region) {
        return region.startsWith("europe-") ? "europe-west2" : "us-central1";
    }

    public static String getProjectIdFromCreds(String credsFilePath) {
        block7: {
            if (!DefaultTypeTransformation.booleanUnbox((Object)credsFilePath)) {
                throw (Throwable)new AbortOperationException("Missing Google credentials -- make sure your environment defines the GOOGLE_APPLICATION_CREDENTIALS environment variable");
            }
            File file = new File(credsFilePath);
            Map creds = (Map)ScriptBytecodeAdapter.castToType((Object)new JsonSlurper().parse(file), Map.class);
            if (!DefaultTypeTransformation.booleanUnbox(creds.get("project_id"))) break block7;
            String string = ShortTypeHandling.castToString(creds.get("project_id"));
            return string;
        }
        try {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{credsFilePath}, new String[]{"Missing `project_id` in Google credentials file: ", ""})));
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{credsFilePath}, new String[]{"Missing Google credentials file: ", ""})));
        }
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("GoogleLifeSciencesConfig(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("project:");
        _result.append(InvokerHelper.toString((Object)this.getProject()));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("zones:");
        _result.append(InvokerHelper.toString(this.getZones()));
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("regions:");
        _result.append(InvokerHelper.toString(this.getRegions()));
        Boolean bl7 = $toStringFirst;
        if (bl7 == null ? false : bl7) {
            Boolean bl8;
            $toStringFirst = bl8 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("preemptible:");
        _result.append(InvokerHelper.toString((Object)this.isPreemptible()));
        Boolean bl9 = $toStringFirst;
        if (bl9 == null ? false : bl9) {
            Boolean bl10;
            $toStringFirst = bl10 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("remoteBinDir:");
        _result.append(InvokerHelper.toString((Object)this.getRemoteBinDir()));
        Boolean bl11 = $toStringFirst;
        if (bl11 == null ? false : bl11) {
            Boolean bl12;
            $toStringFirst = bl12 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("location:");
        _result.append(InvokerHelper.toString((Object)this.getLocation()));
        Boolean bl13 = $toStringFirst;
        if (bl13 == null ? false : bl13) {
            Boolean bl14;
            $toStringFirst = bl14 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("disableBinDir:");
        _result.append(InvokerHelper.toString((Object)this.isDisableBinDir()));
        Boolean bl15 = $toStringFirst;
        if (bl15 == null ? false : bl15) {
            Boolean bl16;
            $toStringFirst = bl16 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("bootDiskSize:");
        _result.append(InvokerHelper.toString((Object)this.getBootDiskSize()));
        Boolean bl17 = $toStringFirst;
        if (bl17 == null ? false : bl17) {
            Boolean bl18;
            $toStringFirst = bl18 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("sshDaemon:");
        _result.append(InvokerHelper.toString((Object)this.isSshDaemon()));
        Boolean bl19 = $toStringFirst;
        if (bl19 == null ? false : bl19) {
            Boolean bl20;
            $toStringFirst = bl20 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("sshImage:");
        _result.append(InvokerHelper.toString((Object)this.getSshImage()));
        Boolean bl21 = $toStringFirst;
        if (bl21 == null ? false : bl21) {
            Boolean bl22;
            $toStringFirst = bl22 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("debugMode:");
        _result.append(InvokerHelper.toString((Object)this.getDebugMode()));
        Boolean bl23 = $toStringFirst;
        if (bl23 == null ? false : bl23) {
            Boolean bl24;
            $toStringFirst = bl24 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("copyImage:");
        _result.append(InvokerHelper.toString((Object)this.getCopyImage()));
        Boolean bl25 = $toStringFirst;
        if (bl25 == null ? false : bl25) {
            Boolean bl26;
            $toStringFirst = bl26 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append("usePrivateAddress:");
        _result.append(InvokerHelper.toString((Object)this.isUsePrivateAddress()));
        _result.append(")");
        return _result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleLifeSciencesConfig.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.lifesciences.GoogleLifeSciencesConfig");
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public void setProject(String string) {
        this.project = string;
    }

    @Generated
    public List<String> getZones() {
        return this.zones;
    }

    @Generated
    public void setZones(List<String> list) {
        this.zones = list;
    }

    @Generated
    public List<String> getRegions() {
        return this.regions;
    }

    @Generated
    public void setRegions(List<String> list) {
        this.regions = list;
    }

    @Generated
    public boolean getPreemptible() {
        return this.preemptible;
    }

    @Generated
    public boolean isPreemptible() {
        return this.preemptible;
    }

    @Generated
    public void setPreemptible(boolean bl) {
        this.preemptible = bl;
    }

    @Generated
    public Path getRemoteBinDir() {
        return this.remoteBinDir;
    }

    @Generated
    public void setRemoteBinDir(Path path) {
        this.remoteBinDir = path;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public void setLocation(String string) {
        this.location = string;
    }

    @Generated
    public boolean getDisableBinDir() {
        return this.disableBinDir;
    }

    @Generated
    public boolean isDisableBinDir() {
        return this.disableBinDir;
    }

    @Generated
    public void setDisableBinDir(boolean bl) {
        this.disableBinDir = bl;
    }

    @Generated
    public MemoryUnit getBootDiskSize() {
        return this.bootDiskSize;
    }

    @Generated
    public void setBootDiskSize(MemoryUnit memoryUnit) {
        this.bootDiskSize = memoryUnit;
    }

    @Generated
    public boolean getSshDaemon() {
        return this.sshDaemon;
    }

    @Generated
    public boolean isSshDaemon() {
        return this.sshDaemon;
    }

    @Generated
    public void setSshDaemon(boolean bl) {
        this.sshDaemon = bl;
    }

    @Generated
    public String getSshImage() {
        return this.sshImage;
    }

    @Generated
    public void setSshImage(String string) {
        this.sshImage = string;
    }

    @Generated
    public Integer getDebugMode() {
        return this.debugMode;
    }

    @Generated
    public void setDebugMode(Integer n) {
        this.debugMode = n;
    }

    @Generated
    public String getCopyImage() {
        return this.copyImage;
    }

    @Generated
    public void setCopyImage(String string) {
        this.copyImage = string;
    }

    @Generated
    public boolean getUsePrivateAddress() {
        return this.usePrivateAddress;
    }

    @Generated
    public boolean isUsePrivateAddress() {
        return this.usePrivateAddress;
    }

    @Generated
    public void setUsePrivateAddress(boolean bl) {
        this.usePrivateAddress = bl;
    }
}

