/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.lifesciences;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import nextflow.Session;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesConfig;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesHelper;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesTaskHandler;
import nextflow.exception.AbortOperationException;
import nextflow.executor.Executor;
import nextflow.executor.SupportedScriptTypes;
import nextflow.extension.FilesEx;
import nextflow.processor.TaskHandler;
import nextflow.processor.TaskMonitor;
import nextflow.processor.TaskPollingMonitor;
import nextflow.processor.TaskRun;
import nextflow.script.ScriptType;
import nextflow.util.Duration;
import nextflow.util.ServiceName;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value="google-lifesciences")
@SupportedScriptTypes(value={ScriptType.SCRIPTLET})
public class GoogleLifeSciencesExecutor
extends Executor {
    private GoogleLifeSciencesConfig config;
    private GoogleLifeSciencesHelper helper;
    private Map<String, String> env;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public GoogleLifeSciencesExecutor() {
        HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
        this.env = hashMap;
    }

    public final boolean isContainerNative() {
        return true;
    }

    public final Path getWorkDir() {
        Path path = this.getSession().getBucketDir();
        return DefaultTypeTransformation.booleanUnbox((Object)path) ? path : this.getSession().getWorkDir();
    }

    protected void register() {
        GoogleLifeSciencesHelper googleLifeSciencesHelper;
        GoogleLifeSciencesConfig googleLifeSciencesConfig;
        super.register();
        Path path = this.getWorkDir();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)(path != null ? FilesEx.getScheme((Path)path) : null), (Object)"gs")) {
            this.getSession().abort();
            throw (Throwable)new AbortOperationException("Executor `google-lifesciences` requires a Google Storage bucket to be specified as a working directory -- Add the option `-w gs://<your-bucket/path>` to your run command line or specify a workDir in your config file");
        }
        String credsFile = ShortTypeHandling.castToString((Object)this.env.get("GOOGLE_APPLICATION_CREDENTIALS"));
        String projectId = GoogleLifeSciencesConfig.getProjectIdFromCreds(credsFile);
        this.config = googleLifeSciencesConfig = GoogleLifeSciencesConfig.fromSession(this.getSession());
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.config.getProject())) {
            String string = projectId;
            this.config.setProject(string);
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)this.config.getProject(), (Object)projectId)) {
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.config.getProject(), credsFile}, new String[]{"Project Id `", "` declared in the nextflow config file does not match the one expected by credentials file: ", ""})));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getSession().getBinDir()) && !this.config.getDisableBinDir()) {
            Path cloudPath = this.getTempDir();
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{FilesEx.toUriString((Path)cloudPath)}, new String[]{"Uploading local `bin` scripts folder to ", "/bin"})));
            Path path2 = FilesEx.copyTo((Path)this.getSession().getBinDir(), (Path)cloudPath);
            this.config.setRemoteBinDir(path2);
        }
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.config}, new String[]{"Google Life Science config=", ""})));
        this.helper = googleLifeSciencesHelper = this.initClient();
        this.helper.checkValidLocation();
    }

    protected GoogleLifeSciencesHelper initClient() {
        return new GoogleLifeSciencesHelper(this.config).init();
    }

    protected TaskMonitor createTaskMonitor() {
        return TaskPollingMonitor.create((Session)this.getSession(), (String)this.getName(), (int)1000, (Duration)Duration.of((String)"10 sec"));
    }

    public TaskHandler createTaskHandler(TaskRun task) {
        return new GoogleLifeSciencesTaskHandler(task, this);
    }

    protected GoogleLifeSciencesHelper getHelper() {
        return this.helper;
    }

    protected GoogleLifeSciencesConfig getConfig() {
        return this.config;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GoogleLifeSciencesExecutor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.lifesciences.GoogleLifeSciencesExecutor");
    }
}

