/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.lifesciences;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesConfig;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesHelper;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesTaskHandler;
import nextflow.executor.SimpleFileCopyStrategy;
import nextflow.extension.FilesEx;
import nextflow.processor.TaskBean;
import nextflow.processor.TaskRun;
import nextflow.util.Escape;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleLifeSciencesFileCopyStrategy
extends SimpleFileCopyStrategy {
    private GoogleLifeSciencesConfig config;
    private GoogleLifeSciencesTaskHandler handler;
    private TaskBean task;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public GoogleLifeSciencesFileCopyStrategy(TaskBean bean, GoogleLifeSciencesTaskHandler handler) {
        super(bean);
        TaskBean taskBean;
        GoogleLifeSciencesConfig googleLifeSciencesConfig;
        GoogleLifeSciencesTaskHandler googleLifeSciencesTaskHandler;
        this.handler = googleLifeSciencesTaskHandler = handler;
        this.config = googleLifeSciencesConfig = handler.getExecutor().getConfig();
        this.task = taskBean = bean;
    }

    public String getStageInputFilesScript(Map<String, Path> inputFiles) {
        String localTaskDir = GoogleLifeSciencesHelper.getLocalTaskDir(this.getWorkDir());
        String remoteTaskDir = GoogleLifeSciencesHelper.getRemoteTaskDir(this.getWorkDir());
        List createDirectories = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        List stagingCommands = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String stageName = null;
        Iterator<String> iterator = inputFiles.keySet().iterator();
        while (iterator.hasNext()) {
            stageName = ShortTypeHandling.castToString((Object)iterator.next());
            Path storePath = (Path)ScriptBytecodeAdapter.castToType((Object)inputFiles.get(stageName), Path.class);
            boolean storePathIsDir = FilesEx.isDirectory((Path)storePath, (LinkOption[])new LinkOption[0]);
            Path stagePath = Paths.get(stageName, new String[0]);
            Path parent = stagePath.getParent();
            String escapedStoreUri = Escape.uriPath((Path)storePath);
            String escapedStageName = Escape.path((String)stageName);
            if (DefaultTypeTransformation.booleanUnbox((Object)parent)) {
                DefaultGroovyMethods.leftShift((List)createDirectories, (Object)new GStringImpl(new Object[]{localTaskDir, Escape.path((Path)parent)}, new String[]{"mkdir -p ", "/", ""}).toString());
            }
            if (storePathIsDir) {
                DefaultGroovyMethods.leftShift((List)stagingCommands, (Object)new GStringImpl(new Object[]{escapedStoreUri, localTaskDir}, new String[]{"gsutil -m -q cp -R ", "/ ", ""}).toString());
                if (!(DefaultTypeTransformation.booleanUnbox((Object)parent) || !storePath.toString().endsWith(stageName))) continue;
                DefaultGroovyMethods.leftShift((List)stagingCommands, (Object)new GStringImpl(new Object[]{localTaskDir, Escape.path((String)FilesEx.getName((Path)storePath)), localTaskDir, escapedStageName}, new String[]{"mv ", "/", " ", "/", ""}).toString());
                continue;
            }
            DefaultGroovyMethods.leftShift((List)stagingCommands, (Object)new GStringImpl(new Object[]{escapedStoreUri, localTaskDir, escapedStageName}, new String[]{"gsutil -m -q cp ", " ", "/", ""}).toString());
        }
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)new GStringImpl(new Object[]{remoteTaskDir, TaskRun.CMD_START}, new String[]{"echo start | gsutil -q cp  -c - ", "/", ""})).append("\n");
        if (DefaultTypeTransformation.booleanUnbox((Object)createDirectories)) {
            result.append(DefaultGroovyMethods.join((Iterable)createDirectories, (String)"\n")).append("\n");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)stagingCommands)) {
            result.append(DefaultGroovyMethods.join((Iterable)stagingCommands, (String)"\n")).append("\n");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getRemoteBinDir())) {
            result.append((CharSequence)new GStringImpl(new Object[]{localTaskDir}, new String[]{"mkdir -p ", "/nextflow-bin"})).append("\n").append((CharSequence)new GStringImpl(new Object[]{Escape.uriPath((Path)this.config.getRemoteBinDir()), localTaskDir}, new String[]{"gsutil -m -q cp -P -r ", "/* ", "/nextflow-bin"})).append("\n");
        }
        return result.toString();
    }

    public String getUnstageOutputFilesScript(List<String> outputFiles, Path targetDir) {
        StringBuilder result = new StringBuilder();
        String it = null;
        Iterator<String> iterator = outputFiles.iterator();
        while (iterator.hasNext()) {
            it = ShortTypeHandling.castToString((Object)iterator.next());
            result.append(this.copyMany(it, targetDir)).append("\n");
        }
        return result.toString();
    }

    public String copyFile(String local, Path target) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Escape.path((String)local), Escape.uriPath((Path)target)}, new String[]{"gsutil -m -q cp -R ", " ", ""}));
    }

    public String copyMany(String local, Path target) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Escape.path((String)local), Escape.uriPath((Path)target)}, new String[]{"IFS=$'\\n'; for name in $(eval \"ls -1d ", "\" 2>/dev/null);do gsutil -m -q cp -R $name ", "/$name; done; unset IFS"}));
    }

    public String getEnvScript(Map environment, boolean container) {
        if (container) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Object)((Object)this)).getClass().getSimpleName()}, new String[]{"Parameter `container` not supported by ", ""})));
        }
        String localTaskDir = GoogleLifeSciencesHelper.getLocalTaskDir(this.getWorkDir());
        StringBuilder result = new StringBuilder();
        HashMap copy = DefaultTypeTransformation.booleanUnbox((Object)environment) ? new HashMap(environment) : Collections.emptyMap();
        if (copy.containsKey("PATH")) {
            copy.remove("PATH");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getRemoteBinDir())) {
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)new GStringImpl(new Object[]{localTaskDir}, new String[]{"chmod +x ", "/nextflow-bin/*\n"}));
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)new GStringImpl(new Object[]{localTaskDir}, new String[]{"export PATH=", "/nextflow-bin:$PATH\n"}));
        }
        String envSnippet = super.getEnvScript(copy, false);
        if (DefaultTypeTransformation.booleanUnbox((Object)envSnippet)) {
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)envSnippet);
        }
        return result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GoogleLifeSciencesFileCopyStrategy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.lifesciences.GoogleLifeSciencesFileCopyStrategy");
    }

    @Generated
    public GoogleLifeSciencesConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(GoogleLifeSciencesConfig googleLifeSciencesConfig) {
        this.config = googleLifeSciencesConfig;
    }

    @Generated
    public GoogleLifeSciencesTaskHandler getHandler() {
        return this.handler;
    }

    @Generated
    public void setHandler(GoogleLifeSciencesTaskHandler googleLifeSciencesTaskHandler) {
        this.handler = googleLifeSciencesTaskHandler;
    }

    @Generated
    public TaskBean getTask() {
        return this.task;
    }

    @Generated
    public void setTask(TaskBean taskBean) {
        this.task = taskBean;
    }
}

