/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.lifesciences;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.lifesciences.v2beta.CloudLifeSciences;
import com.google.api.services.lifesciences.v2beta.model.Accelerator;
import com.google.api.services.lifesciences.v2beta.model.Action;
import com.google.api.services.lifesciences.v2beta.model.CancelOperationRequest;
import com.google.api.services.lifesciences.v2beta.model.Disk;
import com.google.api.services.lifesciences.v2beta.model.ListLocationsResponse;
import com.google.api.services.lifesciences.v2beta.model.Location;
import com.google.api.services.lifesciences.v2beta.model.Mount;
import com.google.api.services.lifesciences.v2beta.model.Network;
import com.google.api.services.lifesciences.v2beta.model.Operation;
import com.google.api.services.lifesciences.v2beta.model.Pipeline;
import com.google.api.services.lifesciences.v2beta.model.Resources;
import com.google.api.services.lifesciences.v2beta.model.RunPipelineRequest;
import com.google.api.services.lifesciences.v2beta.model.ServiceAccount;
import com.google.api.services.lifesciences.v2beta.model.VirtualMachine;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesConfig;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesSubmitRequest;
import nextflow.extension.Bolts;
import nextflow.processor.TaskRun;
import nextflow.util.Escape;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleLifeSciencesHelper
implements GroovyObject {
    public static final List<String> DEFAULT_LOCATIONS;
    public static final String SSH_DAEMON_NAME = "ssh-daemon";
    public static final String DEFAULT_APP_NAME = "Nextflow/GLS";
    public static final String SCOPE_CLOUD_PLATFORM = "https://www.googleapis.com/auth/cloud-platform";
    private CloudLifeSciences client;
    private GoogleCredentials credentials;
    private final String applicationName;
    private GoogleLifeSciencesConfig config;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    protected GoogleLifeSciencesHelper(GoogleCredentials credential, String name) {
        String string;
        GoogleCredentials googleCredentials;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.credentials = googleCredentials = credential;
        this.applicationName = string = name;
    }

    public GoogleLifeSciencesHelper(GoogleLifeSciencesConfig config) {
        String string;
        GoogleLifeSciencesConfig googleLifeSciencesConfig;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.config = googleLifeSciencesConfig = config;
        this.applicationName = string = DEFAULT_APP_NAME;
    }

    @Generated
    protected GoogleLifeSciencesHelper(GoogleCredentials credential) {
        this(credential, DEFAULT_APP_NAME);
    }

    @Generated
    protected GoogleLifeSciencesHelper() {
        this(null, DEFAULT_APP_NAME);
    }

    public static String sanitizeName(String name) {
        return StringGroovyMethods.take((String)name.replaceAll("[^a-zA-Z0-9\\-_]+", "-"), (int)63);
    }

    public GoogleLifeSciencesHelper init() {
        CloudLifeSciences cloudLifeSciences;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.credentials)) {
            GoogleCredentials googleCredentials;
            this.credentials = googleCredentials = GoogleCredentials.getApplicationDefault();
        }
        if (this.credentials.createScopedRequired()) {
            GoogleCredentials googleCredentials;
            this.credentials = googleCredentials = this.credentials.createScoped((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{SCOPE_CLOUD_PLATFORM}));
        }
        HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)this.credentials);
        this.client = cloudLifeSciences = new CloudLifeSciences.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)requestInitializer).setApplicationName(this.applicationName).build();
        return this;
    }

    public Map<String, String> getEnvironment() {
        HashMap<String, String> result = new HashMap<String, String>(1);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getDebugMode())) {
            result.put("NXF_DEBUG", this.config.getDebugMode().toString());
        }
        return result;
    }

    public Action createAction(String name, String imageUri, List<String> commands, List<Mount> mounts, List<ActionFlags> flags, String entrypoint) {
        Action action = new Action().setContainerName(name).setImageUri(imageUri).setCommands(commands).setMounts(mounts).setEntrypoint(entrypoint).setEnvironment(this.getEnvironment());
        this.setFlags(action, flags);
        return action;
    }

    protected Action setFlags(Action action, List<ActionFlags> flags) {
        if (DefaultTypeTransformation.booleanUnbox((Object)(flags == null ? Boolean.valueOf(ActionFlags.IGNORE_EXIT_STATUS == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(flags, (Object)((Object)ActionFlags.IGNORE_EXIT_STATUS)))))) {
            action.setIgnoreExitStatus(Boolean.valueOf(true));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(flags == null ? Boolean.valueOf(ActionFlags.RUN_IN_BACKGROUND == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(flags, (Object)((Object)ActionFlags.RUN_IN_BACKGROUND)))))) {
            action.setRunInBackground(Boolean.valueOf(true));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(flags == null ? Boolean.valueOf(ActionFlags.ALWAYS_RUN == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(flags, (Object)((Object)ActionFlags.ALWAYS_RUN)))))) {
            action.setAlwaysRun(Boolean.valueOf(true));
        }
        if (ActionFlags.ENABLE_FUSE != null) {
            action.setEnableFuse(Boolean.valueOf(true));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(flags == null ? Boolean.valueOf(ActionFlags.PUBLISH_EXPOSED_PORTS == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(flags, (Object)((Object)ActionFlags.PUBLISH_EXPOSED_PORTS)))))) {
            action.setPublishExposedPorts(Boolean.valueOf(true));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(flags == null ? Boolean.valueOf(ActionFlags.DISABLE_IMAGE_PREFETCH == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(flags, (Object)((Object)ActionFlags.DISABLE_IMAGE_PREFETCH)))))) {
            action.setDisableImagePrefetch(Boolean.valueOf(true));
        }
        if (ActionFlags.DISABLE_STANDARD_ERROR_CAPTURE != null) {
            action.setDisableStandardErrorCapture(Boolean.valueOf(true));
        }
        return action;
    }

    public Pipeline createPipeline(List<Action> actions, Resources resources) {
        return new Pipeline().setActions(actions).setResources(resources);
    }

    public Operation submitPipeline(GoogleLifeSciencesSubmitRequest req) {
        ArrayList<Action> actions = new ArrayList<Action>(5);
        if (this.config.getSshDaemon()) {
            actions.add(this.createSshDaemonAction(req));
        }
        actions.add(this.createStagingAction(req));
        actions.add(this.createMainAction(req));
        actions.add(this.createUnstagingAction(req));
        Pipeline pipeline = this.createPipeline(actions, this.createResources(req));
        return this.runPipeline(req.getProject(), req.getLocation(), pipeline, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"taskName", req.getTaskName()}));
    }

    protected Resources createResources(GoogleLifeSciencesSubmitRequest req) {
        Object v0;
        Disk disk = new Disk();
        disk.setName(req.getDiskName());
        disk.setSizeGb(req.getDiskSizeGb());
        ServiceAccount serviceAccount = new ServiceAccount().setScopes(ScriptBytecodeAdapter.createList((Object[])new Object[]{SCOPE_CLOUD_PLATFORM}));
        VirtualMachine vm = new VirtualMachine().setMachineType(req.getMachineType()).setDisks(ScriptBytecodeAdapter.createList((Object[])new Object[]{disk})).setServiceAccount(serviceAccount).setPreemptible(Boolean.valueOf(req.isPreemptible()));
        if (req.isUsePrivateAddress()) {
            vm.setNetwork(new Network().setUsePrivateAddress(Boolean.valueOf(true)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)req.getBootDiskSizeGb())) {
            vm.setBootDiskSizeGb(req.getBootDiskSizeGb());
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)req.getAccelerator())) {
            Accelerator acc = new Accelerator().setType(req.getAccelerator().getType()).setCount((Long)ScriptBytecodeAdapter.castToType((Object)req.getAccelerator().getRequest(), Long.class));
            ArrayList<Accelerator> list = new ArrayList<Accelerator>(1);
            list.add(acc);
            vm.setAccelerators(list);
        }
        Resources result = new Resources().setZones(req.getZone()).setRegions(req.getRegion()).setVirtualMachine(vm);
        if (log.isTraceEnabled()) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{req.getTaskName(), result}, new String[]{"[GLS] task=", "; VM resources=", ""}));
            v0 = null;
        } else {
            v0 = null;
        }
        return result;
    }

    protected Action createMainAction(GoogleLifeSciencesSubmitRequest req) {
        List cmd = ScriptBytecodeAdapter.createList((Object[])new Object[]{"-o", "pipefail", "-c", this.getMainScript(req.getWorkDir())});
        if (!DefaultTypeTransformation.booleanUnbox((Object)req.getEntryPoint())) {
            cmd.add(0, "bash");
        }
        return this.createAction(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getTaskName()}, new String[]{"", "-main"})), req.getContainerImage(), cmd, ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()}), Collections.emptyList(), req.getEntryPoint());
    }

    protected Action createStagingAction(GoogleLifeSciencesSubmitRequest req) {
        return this.createAction(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getTaskName()}, new String[]{"", "-stage"})), this.config.getCopyImage(), ScriptBytecodeAdapter.createList((Object[])new Object[]{"bash", "-c", this.getStagingScript(req.getWorkDir())}), ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()}));
    }

    protected Action createUnstagingAction(GoogleLifeSciencesSubmitRequest req) {
        return this.createAction(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getTaskName()}, new String[]{"", "-unstage"})), this.config.getCopyImage(), ScriptBytecodeAdapter.createList((Object[])new Object[]{"bash", "-c", this.getUnstagingScript(req.getWorkDir())}), ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{ActionFlags.ALWAYS_RUN, ActionFlags.IGNORE_EXIT_STATUS}));
    }

    protected Action createSshDaemonAction(GoogleLifeSciencesSubmitRequest req) {
        return new Action().setContainerName(SSH_DAEMON_NAME).setImageUri(this.config.getSshImage()).setEntrypoint("ssh-server").setMounts(ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()})).setPortMappings(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"22", 22})).setAlwaysRun(Boolean.valueOf(true)).setRunInBackground(Boolean.valueOf(true)).setIgnoreExitStatus(Boolean.valueOf(true));
    }

    public Operation checkOperationStatus(Operation operation) {
        Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType((Object)this.client.projects().locations().operations().get(operation.getName()).execute(), Operation.class);
        try {
            return operation2;
        }
        catch (IOException e) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operation.getName()}, new String[]{"Invalid server response fetching operation status: ", ""})), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            Operation operation3 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation3;
        }
    }

    public void cancelOperation(Operation operation) {
        block5: {
            try {
                this.client.projects().locations().operations().cancel(operation.getName(), new CancelOperationRequest()).execute();
            }
            catch (IOException e) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operation.getName(), e.getMessage()}, new String[]{"Invalid server response cancelling operation: ", " | ", ""})));
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
    }

    public Operation runPipeline(String project, String location, Pipeline pipeline, Map<String, String> labels) {
        GStringImpl parent = new GStringImpl(new Object[]{project, location}, new String[]{"projects/", "/locations/", ""});
        Operation operation = (Operation)ScriptBytecodeAdapter.castToType((Object)this.client.projects().locations().pipelines().run(ShortTypeHandling.castToString((Object)parent), new RunPipelineRequest().setPipeline(pipeline).setLabels(labels)).execute(), Operation.class);
        try {
            return operation;
        }
        catch (IOException e) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pipeline}, new String[]{"Invalid server response running pipeline: ", ""})), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation2;
        }
    }

    public static String getLocalTaskDir(Path workDir) {
        return Escape.path((Path)workDir);
    }

    public static String getRemoteTaskDir(Path workDir) {
        return Escape.uriPath((Path)workDir);
    }

    public String getStagingScript(Path workDir) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String localTaskDir = GoogleLifeSciencesHelper.getLocalTaskDir(workDir);
        String remoteTaskDir = GoogleLifeSciencesHelper.getRemoteTaskDir(workDir);
        String result = "set -x; ";
        result = string6 = StringGroovyMethods.plus((String)result, (CharSequence)"{ ");
        result = string5 = StringGroovyMethods.plus((String)result, (CharSequence)new GStringImpl(new Object[]{localTaskDir}, new String[]{"cd ", "; "}));
        result = string4 = StringGroovyMethods.plus((String)result, (CharSequence)new GStringImpl(new Object[]{remoteTaskDir, TaskRun.CMD_RUN}, new String[]{"gsutil -m -q cp ", "/", " .; "}));
        result = string3 = StringGroovyMethods.plus((String)result, (CharSequence)new GStringImpl(new Object[]{TaskRun.CMD_RUN}, new String[]{"bash ", " nxf_stage; "}));
        result = string2 = StringGroovyMethods.plus((String)result, (CharSequence)"[[ $NXF_DEBUG -gt 0 ]] && ls -lah $PWD || true; ");
        result = string = StringGroovyMethods.plus((String)result, (CharSequence)new GStringImpl(new Object[]{localTaskDir, TaskRun.CMD_LOG}, new String[]{"} &> ", "/", ""}));
        return result;
    }

    public String getMainScript(Path workDir) {
        String localTaskDir = GoogleLifeSciencesHelper.getLocalTaskDir(workDir);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{localTaskDir, TaskRun.CMD_RUN, localTaskDir, TaskRun.CMD_LOG}, new String[]{"{ cd ", "; bash ", "; } >> ", "/", " 2>&1"}));
    }

    public String getUnstagingScript(Path workDir) {
        String string;
        String string2;
        String localTaskDir = GoogleLifeSciencesHelper.getLocalTaskDir(workDir);
        String remoteTaskDir = GoogleLifeSciencesHelper.getRemoteTaskDir(workDir);
        String result = "set -x; ";
        result = string2 = StringGroovyMethods.plus((String)result, (CharSequence)new GStringImpl(new Object[]{localTaskDir, TaskRun.CMD_LOG, remoteTaskDir, TaskRun.CMD_LOG, localTaskDir, remoteTaskDir, localTaskDir}, new String[]{"trap 'err=$?; exec 1>&2; gsutil -m -q cp -R ", "/", " ", "/", " || true; [[ $err -gt 0 || $GOOGLE_LAST_EXIT_STATUS -gt 0 || $NXF_DEBUG -gt 0 ]] && { ls -lah ", " || true; gsutil -m -q cp -R /google/ ", "; } || rm -rf ", "; exit $err' EXIT; "}));
        result = string = StringGroovyMethods.plus((String)result, (CharSequence)new GStringImpl(new Object[]{localTaskDir, TaskRun.CMD_RUN, localTaskDir, TaskRun.CMD_LOG}, new String[]{"{ cd ", "; bash ", " nxf_unstage; } >> ", "/", " 2>&1"}));
        return result;
    }

    public void checkValidLocation() {
        Object v0;
        if (DefaultTypeTransformation.booleanUnbox((Object)(DEFAULT_LOCATIONS == null ? Boolean.valueOf(this.config.getLocation() == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(DEFAULT_LOCATIONS, (Object)this.config.getLocation()))))) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ((ListLocationsResponse)this.client.projects().locations().list(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.config.getProject()}, new String[]{"projects/", ""}))).execute()).getLocations();
        if (list != null) {
            Object for$it$12 = null;
            for (Object for$it$12 : list) {
                Object var5_5 = for$it$12;
                arrayList.add(var5_5 != null ? ((Location)var5_5).getLocationId() : null);
            }
        }
        ArrayList<String> availLocations = arrayList;
        if (DefaultTypeTransformation.booleanUnbox((Object)(availLocations == null ? Boolean.valueOf(this.config.getLocation() == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(availLocations, (Object)this.config.getLocation()))))) {
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.config.getLocation(), DefaultGroovyMethods.join(availLocations, (String)",")}, new String[]{"The specified Google Life Sciences location is not available: \"", "\" -- Please choose open of the following ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleLifeSciencesHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GoogleLifeSciencesHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GoogleLifeSciencesHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public Action createAction(String name, String imageUri, List<String> commands, List<Mount> mounts, List<ActionFlags> flags) {
        return this.createAction(name, imageUri, commands, mounts, flags, null);
    }

    @Generated
    public Action createAction(String name, String imageUri, List<String> commands, List<Mount> mounts) {
        return this.createAction(name, imageUri, commands, mounts, ScriptBytecodeAdapter.createList((Object[])new Object[0]), null);
    }

    @Generated
    public Operation runPipeline(String project, String location, Pipeline pipeline) {
        return this.runPipeline(project, location, pipeline, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleLifeSciencesHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        List list;
        DEFAULT_LOCATIONS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"us-central1", "europe-west2"});
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.lifesciences.GoogleLifeSciencesHelper");
    }

    @Generated
    public CloudLifeSciences getClient() {
        return this.client;
    }

    @Generated
    public void setClient(CloudLifeSciences cloudLifeSciences) {
        this.client = cloudLifeSciences;
    }

    @Generated
    public GoogleCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public void setCredentials(GoogleCredentials googleCredentials) {
        this.credentials = googleCredentials;
    }

    @Generated
    public final String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public GoogleLifeSciencesConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(GoogleLifeSciencesConfig googleLifeSciencesConfig) {
        this.config = googleLifeSciencesConfig;
    }

    public static final class ActionFlags
    extends Enum<ActionFlags>
    implements GroovyObject {
        public static final /* enum */ ActionFlags FLAG_UNSPECIFIED;
        public static final /* enum */ ActionFlags IGNORE_EXIT_STATUS;
        public static final /* enum */ ActionFlags RUN_IN_BACKGROUND;
        public static final /* enum */ ActionFlags ALWAYS_RUN;
        public static final /* enum */ ActionFlags ENABLE_FUSE;
        public static final /* enum */ ActionFlags PUBLISH_EXPOSED_PORTS;
        public static final /* enum */ ActionFlags DISABLE_IMAGE_PREFETCH;
        public static final /* enum */ ActionFlags DISABLE_STANDARD_ERROR_CAPTURE;
        public static final ActionFlags MIN_VALUE;
        public static final ActionFlags MAX_VALUE;
        private static final /* synthetic */ ActionFlags[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public ActionFlags(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum nextflow.cloud.google.lifesciences.GoogleLifeSciencesHelper$ActionFlags was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public ActionFlags() {
            this(new LinkedHashMap());
        }

        public static final ActionFlags[] values() {
            return (ActionFlags[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), ActionFlags[].class);
        }

        public /* synthetic */ ActionFlags next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (ActionFlags)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), ActionFlags.class);
        }

        public /* synthetic */ ActionFlags previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (ActionFlags)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), ActionFlags.class);
        }

        public static ActionFlags valueOf(String name) {
            return (ActionFlags)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(ActionFlags.class, name)), ActionFlags.class);
        }

        public static final /* synthetic */ ActionFlags $INIT(Object ... para) {
            ActionFlags actionFlags;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, ActionFlags.class)) {
                case -1348271900: {
                    ActionFlags actionFlags2;
                    actionFlags = actionFlags2;
                    Object[] objectArray2 = objectArray;
                    actionFlags2 = new ActionFlags();
                    break;
                }
                case -242181752: {
                    ActionFlags actionFlags2;
                    actionFlags = actionFlags2;
                    Object[] objectArray2 = objectArray;
                    actionFlags2 = new ActionFlags((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return actionFlags;
        }

        static {
            ActionFlags actionFlags;
            ActionFlags actionFlags2;
            ActionFlags actionFlags3;
            ActionFlags actionFlags4;
            ActionFlags actionFlags5;
            ActionFlags actionFlags6;
            ActionFlags actionFlags7;
            ActionFlags actionFlags8;
            ActionFlags actionFlags9;
            ActionFlags actionFlags10;
            FLAG_UNSPECIFIED = actionFlags10 = ActionFlags.$INIT("FLAG_UNSPECIFIED", 0);
            IGNORE_EXIT_STATUS = actionFlags9 = ActionFlags.$INIT("IGNORE_EXIT_STATUS", 1);
            RUN_IN_BACKGROUND = actionFlags8 = ActionFlags.$INIT("RUN_IN_BACKGROUND", 2);
            ALWAYS_RUN = actionFlags7 = ActionFlags.$INIT("ALWAYS_RUN", 3);
            ENABLE_FUSE = actionFlags6 = ActionFlags.$INIT("ENABLE_FUSE", 4);
            PUBLISH_EXPOSED_PORTS = actionFlags5 = ActionFlags.$INIT("PUBLISH_EXPOSED_PORTS", 5);
            DISABLE_IMAGE_PREFETCH = actionFlags4 = ActionFlags.$INIT("DISABLE_IMAGE_PREFETCH", 6);
            DISABLE_STANDARD_ERROR_CAPTURE = actionFlags3 = ActionFlags.$INIT("DISABLE_STANDARD_ERROR_CAPTURE", 7);
            MIN_VALUE = actionFlags2 = FLAG_UNSPECIFIED;
            MAX_VALUE = actionFlags = DISABLE_STANDARD_ERROR_CAPTURE;
            ActionFlags[] actionFlagsArray = new ActionFlags[]{FLAG_UNSPECIFIED, IGNORE_EXIT_STATUS, RUN_IN_BACKGROUND, ALWAYS_RUN, ENABLE_FUSE, PUBLISH_EXPOSED_PORTS, DISABLE_IMAGE_PREFETCH, DISABLE_STANDARD_ERROR_CAPTURE};
            $VALUES = actionFlagsArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ActionFlags.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

