/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.lifesciences;

import com.google.api.services.lifesciences.v2beta.model.Event;
import com.google.api.services.lifesciences.v2beta.model.Metadata;
import com.google.api.services.lifesciences.v2beta.model.Mount;
import com.google.api.services.lifesciences.v2beta.model.Operation;
import com.google.api.services.lifesciences.v2beta.model.Status;
import groovy.json.JsonOutput;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesConfig;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesExecutor;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesHelper;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesScriptLauncher;
import nextflow.cloud.google.lifesciences.GoogleLifeSciencesSubmitRequest;
import nextflow.cloud.types.CloudMachineInfo;
import nextflow.cloud.types.PriceModel;
import nextflow.exception.ProcessSubmitException;
import nextflow.exception.ProcessUnrecoverableException;
import nextflow.executor.res.AcceleratorResource;
import nextflow.extension.Bolts;
import nextflow.processor.TaskBean;
import nextflow.processor.TaskHandler;
import nextflow.processor.TaskRun;
import nextflow.processor.TaskStatus;
import nextflow.trace.TraceRecord;
import nextflow.util.MemoryUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.NioGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleLifeSciencesTaskHandler
extends TaskHandler {
    public static final String DEFAULT_DISK_NAME = "nf-pipeline-work";
    private GoogleLifeSciencesExecutor executor;
    private TaskBean taskBean;
    private Path exitFile;
    private Path outputFile;
    private Path errorFile;
    private Operation operation;
    private Metadata metadata;
    private String pipelineId;
    private GoogleLifeSciencesHelper helper;
    private volatile String assignedZone;
    private volatile String assignedInstance;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public GoogleLifeSciencesTaskHandler(TaskRun task, GoogleLifeSciencesExecutor executor) {
        super(task);
        Path path;
        Path path2;
        Path path3;
        GoogleLifeSciencesHelper googleLifeSciencesHelper;
        TaskBean taskBean;
        GoogleLifeSciencesExecutor googleLifeSciencesExecutor;
        this.executor = googleLifeSciencesExecutor = executor;
        this.taskBean = taskBean = new TaskBean(task);
        this.helper = googleLifeSciencesHelper = executor.getHelper();
        this.outputFile = path3 = task.getWorkDir().resolve(TaskRun.CMD_OUTFILE);
        this.errorFile = path2 = task.getWorkDir().resolve(TaskRun.CMD_ERRFILE);
        this.exitFile = path = task.getWorkDir().resolve(TaskRun.CMD_EXIT);
        this.validateConfiguration();
    }

    protected GoogleLifeSciencesTaskHandler() {
    }

    public void validateConfiguration() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.getTask().getContainer())) {
            throw (Throwable)new ProcessUnrecoverableException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTask().getName()}, new String[]{"No container image specified for process ", " -- Either specify the container to use in the process definition or with 'process.container' value in your config"})));
        }
    }

    protected String getMachineType() {
        String machineType = this.getMachineType0(this.getTask().getConfig().getMachineType(), this.getTask().getConfig().getCpus(), this.getTask().getConfig().getMemory());
        Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask().getName(), machineType}, new String[]{"[GLS] Task: ", " - Instance Type: ", ""}));
        return machineType;
    }

    protected String getMachineType0(String taskMachineType, int cpus, MemoryUnit memory) {
        String machineType = taskMachineType;
        if (machineType == null) {
            String string;
            long megabytes = memory != null ? memory.getMega() : (long)(cpus * 1024);
            machineType = string = StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"custom-", (Object)cpus), (CharSequence)"-"), (Object)megabytes);
        }
        return machineType;
    }

    protected void logEvents(Operation operation) {
        List<Event> events = this.getEventsFromOp(operation);
        if (!DefaultTypeTransformation.booleanUnbox(events)) {
            return;
        }
        HashSet warns = new HashSet();
        Event ev = null;
        Iterator<Event> iterator = events.iterator();
        while (iterator.hasNext()) {
            String string;
            ev = (Event)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Event.class);
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask().getName(), ev}, new String[]{"[GLS] task ", " > event=", ""}));
            String d = ev.getDescription();
            String string2 = d;
            Boolean bl = string2 != null ? Boolean.valueOf(string2.contains("resource_exhausted")) : null;
            if (bl == null ? false : bl) {
                DefaultGroovyMethods.leftShift(warns, (Object)d);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.assignedZone) && DefaultTypeTransformation.booleanUnbox((Object)ev.getWorkerAssigned())) {
                String string3;
                this.assignedZone = string3 = ev.getWorkerAssigned().getZone();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.assignedInstance) && DefaultTypeTransformation.booleanUnbox((Object)ev.getWorkerAssigned())) {
                String string4;
                this.assignedInstance = string4 = ev.getWorkerAssigned().getInstance();
            }
            if (!(DefaultTypeTransformation.booleanUnbox((Object)ev.getContainerStarted()) && DefaultTypeTransformation.booleanUnbox((string = d) != null ? Boolean.valueOf(string.contains(GoogleLifeSciencesHelper.SSH_DAEMON_NAME)) : null))) continue;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{ev.getContainerStarted().getIpAddress(), this.executor.getConfig().getProject(), this.assignedZone, this.assignedInstance}, new String[]{"[GLS] SSH daemon IP ", "; connect command: `gcloud compute --project ", " ssh --zone ", " ", "`"})));
        }
        if (DefaultTypeTransformation.booleanUnbox(warns)) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTask().getName(), this.pipelineId, GoogleLifeSciencesTaskHandler.prettyPrint(events)}, new String[]{"[GLS] New event > ", " - Pipeline Id: ", "\n", ""})));
            String w = null;
            Iterator iterator2 = warns.iterator();
            while (iterator2.hasNext()) {
                w = ShortTypeHandling.castToString(iterator2.next());
                Bolts.warn1((Logger)log, (Object)new GStringImpl(new Object[]{w}, new String[]{"Google Pipelines > ", ""}));
            }
        } else if (log.isTraceEnabled()) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask().getName(), this.pipelineId, GoogleLifeSciencesTaskHandler.prettyPrint(events)}, new String[]{"[GLS] New event > ", " - Pipeline Id: ", "\n", ""}));
        }
    }

    public boolean checkIfRunning() {
        if (this.operation == null || !this.isSubmitted()) {
            return false;
        }
        Operation result = this.helper.checkOperationStatus(this.operation);
        if (result == null) {
            return false;
        }
        this.logEvents(result);
        if (result != null) {
            Operation operation;
            TaskStatus taskStatus = TaskStatus.RUNNING;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskStatus, GoogleLifeSciencesTaskHandler.class, (GroovyObject)this, (String)"status");
            this.operation = operation = result;
            return true;
        }
        return false;
    }

    public boolean checkIfCompleted() {
        Operation operation;
        if (!this.isRunning()) {
            return false;
        }
        Operation resultOp = this.helper.checkOperationStatus(this.operation);
        if (!DefaultTypeTransformation.booleanUnbox((Object)resultOp)) {
            return false;
        }
        this.operation = operation = resultOp;
        this.logEvents(this.operation);
        Boolean bl = this.operation.getDone();
        if (bl == null ? false : bl) {
            Status status;
            Status status2;
            Object[] objectArray = new Object[3];
            objectArray[0] = this.getTask().getName();
            Metadata metadata = this.metadata;
            objectArray[1] = metadata != null ? metadata.getStartTime() : null;
            Metadata metadata2 = this.metadata;
            objectArray[2] = metadata2 != null ? metadata2.getEndTime() : null;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"[GLS] Task complete > ", " - Start Time: ", " - End Time: ", ""})));
            Integer xs = this.readExitFile();
            Path path = this.outputFile;
            this.getTask().setStdout((Object)path);
            Integer n = xs != null ? xs : ((status2 = this.operation.getError()) != null ? status2.getCode() : null);
            this.getTask().setExitStatus(n);
            Path path2 = xs != null ? this.errorFile : ((status = this.operation.getError()) != null ? status.getMessage() : null);
            this.getTask().setStderr((Object)path2);
            TaskStatus taskStatus = TaskStatus.COMPLETED;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskStatus, GoogleLifeSciencesTaskHandler.class, (GroovyObject)this, (String)"status");
            return true;
        }
        return false;
    }

    List<Event> getEventsFromOp(Operation operation) {
        Metadata metadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)operation.getMetadata(), Metadata.class);
        Metadata metadata2 = metadata;
        if (!DefaultTypeTransformation.booleanUnbox((Object)(metadata2 != null ? metadata2.getEvents() : null))) {
            return Collections.emptyList();
        }
        List result = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.metadata)) {
            List list;
            Metadata metadata3;
            this.metadata = metadata3 = metadata;
            result = list = metadata.getEvents();
        } else {
            Metadata metadata4;
            int delta = metadata.getEvents().size() - this.metadata.getEvents().size();
            this.metadata = metadata4 = metadata;
            List list = delta > 0 ? DefaultGroovyMethods.take((List)metadata.getEvents(), (int)delta) : null;
            result = (List)ScriptBytecodeAdapter.castToType((Object)list, List.class);
        }
        return result != null ? DefaultGroovyMethods.reverse((List)result) : Collections.emptyList();
    }

    Integer readExitFile() {
        Integer n = (Integer)ScriptBytecodeAdapter.asType((Object)NioGroovyMethods.getText((Path)this.exitFile), Integer.class);
        try {
            return n;
        }
        catch (Exception e) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTask().getName(), e.getMessage()}, new String[]{"[GLS] Cannot read exitstatus for task: `", "` | ", ""})));
            Integer n2 = (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
            return n2;
        }
    }

    public void kill() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.operation)) {
            return;
        }
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTask().getName(), this.pipelineId}, new String[]{"[GLS] Killing task > ", " - Pipeline Id: ", ""})));
        this.helper.cancelOperation(this.operation);
    }

    public void submit() {
        String string;
        Operation operation;
        this.createTaskWrapper();
        GoogleLifeSciencesSubmitRequest req = this.createPipelineRequest();
        Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask().getName(), req}, new String[]{"[GLS] Task created > ", " - Request: ", ""}));
        this.operation = operation = this.submitPipeline(req);
        if (this.operation == null) {
            throw (Throwable)new ProcessSubmitException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTask().getName()}, new String[]{"Failed to submit task with name: ", ""})));
        }
        this.pipelineId = string = this.getPipelineIdFromOp(this.operation);
        TaskStatus taskStatus = TaskStatus.SUBMITTED;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskStatus, GoogleLifeSciencesTaskHandler.class, (GroovyObject)this, (String)"status");
        if (log.isTraceEnabled()) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask().getName(), this.pipelineId, GoogleLifeSciencesTaskHandler.prettyPrint(this.operation)}, new String[]{"[GLS] Task submitted > ", " - Pipeline Id: ", "; Operation:\n", ""}));
        } else {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getTask().getName(), this.pipelineId}, new String[]{"[GLS] Task submitted > ", " - Pipeline Id: ", ""})));
        }
    }

    String getPipelineIdFromOp(Operation operation) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string;
            Operation operation2 = operation;
            valueRecorder.record((Object)operation2, 8);
            Operation operation3 = operation2;
            if (operation2 != null) {
                String string2 = operation3.getName();
                string = string2;
                valueRecorder.record((Object)string2, 19);
            } else {
                string = null;
            }
            valueRecorder.record((Object)string, 19);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert operation?.getName()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)operation.getName(), (CharSequence)"/"), (int)-1));
    }

    void createTaskWrapper() {
        new GoogleLifeSciencesScriptLauncher(this.taskBean, this).build();
    }

    Operation submitPipeline(GoogleLifeSciencesSubmitRequest request) {
        return this.helper.submitPipeline(request);
    }

    GoogleLifeSciencesSubmitRequest createPipelineRequest() {
        GoogleLifeSciencesSubmitRequest req = new GoogleLifeSciencesSubmitRequest();
        String string = this.getMachineType();
        req.setMachineType(string);
        String string2 = this.executor.getConfig().getProject();
        req.setProject(string2);
        List<String> list = this.executor.getConfig().getZones();
        req.setZone(list);
        List<String> list2 = this.executor.getConfig().getRegions();
        req.setRegion(list2);
        String string3 = DEFAULT_DISK_NAME;
        req.setDiskName(string3);
        MemoryUnit memoryUnit = this.getTask().getConfig().getDisk();
        Integer n = (Integer)ScriptBytecodeAdapter.asType((Object)(memoryUnit != null ? Long.valueOf(memoryUnit.getGiga()) : null), Integer.class);
        req.setDiskSizeGb(n);
        boolean bl = this.executor.getConfig().getPreemptible();
        req.setPreemptible(bl);
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.getTask().getHash()}, new String[]{"nf-", ""});
        req.setTaskName(ShortTypeHandling.castToString((Object)gStringImpl));
        String string4 = this.getTask().getContainer();
        req.setContainerImage(string4);
        Path path = this.getTask().getWorkDir();
        req.setWorkDir(path);
        Mount mount = this.configureMount(DEFAULT_DISK_NAME, this.getTask().getWorkDir().toString());
        req.setSharedMount(mount);
        AcceleratorResource acceleratorResource = this.getTask().getConfig().getAccelerator();
        req.setAccelerator(acceleratorResource);
        String string5 = this.executor.getConfig().getLocation();
        req.setLocation(string5);
        MemoryUnit memoryUnit2 = this.executor.getConfig().getBootDiskSize();
        Integer n2 = (Integer)ScriptBytecodeAdapter.asType((Object)(memoryUnit2 != null ? Long.valueOf(memoryUnit2.toGiga()) : null), Integer.class);
        req.setBootDiskSizeGb(n2);
        String string6 = this.getTask().getConfig().getContainerOptionsMap().getOrDefault("entrypoint", GoogleLifeSciencesConfig.DEFAULT_ENTRY_POINT);
        req.setEntryPoint(ShortTypeHandling.castToString((Object)string6));
        boolean bl2 = this.executor.getConfig().getUsePrivateAddress();
        req.setUsePrivateAddress(bl2);
        return req;
    }

    protected Mount configureMount(String diskName, String mountPath, boolean readOnly) {
        return new Mount().setDisk(diskName).setPath(mountPath).setReadOnly(Boolean.valueOf(readOnly));
    }

    public TraceRecord getTraceRecord() {
        TraceRecord result = super.getTraceRecord();
        result.put("native_id", (Object)this.pipelineId);
        CloudMachineInfo cloudMachineInfo = this.getMachineInfo();
        result.setMachineInfo(cloudMachineInfo);
        return result;
    }

    private CloudMachineInfo getMachineInfo() {
        PriceModel price = this.executor.getConfig().getPreemptible() ? PriceModel.spot : PriceModel.standard;
        CloudMachineInfo result = new CloudMachineInfo(this.getMachineType(), this.assignedZone, price);
        Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask().getName(), result}, new String[]{"[GLS] Task: ", " > cloud-info=", ""}));
        return result;
    }

    public static String prettyPrint(Operation op) {
        return JsonOutput.prettyPrint((String)JsonOutput.toJson((Map)op));
    }

    public static String prettyPrint(List<Event> events) {
        return JsonOutput.prettyPrint((String)JsonOutput.toJson(events));
    }

    @Generated
    protected Mount configureMount(String diskName, String mountPath) {
        return this.configureMount(diskName, mountPath, false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GoogleLifeSciencesTaskHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.lifesciences.GoogleLifeSciencesTaskHandler");
    }

    @Generated
    public GoogleLifeSciencesExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public void setExecutor(GoogleLifeSciencesExecutor googleLifeSciencesExecutor) {
        this.executor = googleLifeSciencesExecutor;
    }
}

