/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.pipelines;

import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nextflow.Session;
import nextflow.cloud.google.pipelines.GooglePipelinesConfiguration;
import nextflow.cloud.google.pipelines.GooglePipelinesHelper;
import nextflow.cloud.google.pipelines.GooglePipelinesTaskHandler;
import nextflow.exception.AbortOperationException;
import nextflow.executor.Executor;
import nextflow.executor.SupportedScriptTypes;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.processor.TaskHandler;
import nextflow.processor.TaskMonitor;
import nextflow.processor.TaskPollingMonitor;
import nextflow.processor.TaskRun;
import nextflow.script.ScriptType;
import nextflow.util.Duration;
import nextflow.util.ServiceName;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ServiceName(value="google-pipelines")
@SupportedScriptTypes(value={ScriptType.SCRIPTLET})
public class GooglePipelinesExecutor
extends Executor {
    private GooglePipelinesConfiguration pipelineConfig;
    private GooglePipelinesHelper helper;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public GooglePipelinesExecutor() {
        GooglePipelinesHelper googlePipelinesHelper;
        this.helper = googlePipelinesHelper = new GooglePipelinesHelper();
    }

    public final boolean isContainerNative() {
        return true;
    }

    public final Path getWorkDir() {
        Path path = this.getSession().getBucketDir();
        return DefaultTypeTransformation.booleanUnbox((Object)path) ? path : this.getSession().getWorkDir();
    }

    protected void register() {
        GooglePipelinesConfiguration googlePipelinesConfiguration;
        super.register();
        this.pipelineConfig = googlePipelinesConfiguration = this.validateConfiguration();
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.pipelineConfig}, new String[]{"[GPAPI] Pipelines Configuration: '", "'"})));
    }

    protected TaskMonitor createTaskMonitor() {
        return TaskPollingMonitor.create((Session)this.getSession(), (String)this.getName(), (int)1000, (Duration)Duration.of((String)"10 sec"));
    }

    public TaskHandler createTaskHandler(TaskRun task) {
        return new GooglePipelinesTaskHandler(task, this, this.pipelineConfig);
    }

    public GooglePipelinesConfiguration validateConfiguration() {
        String string;
        if (!(this.getWorkDir() instanceof CloudStoragePath)) {
            this.getSession().abort();
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getName()}, new String[]{"When using `", "` executor a GCE bucket must be provided as a working directory -- Add the option `-w gs://<your-bucket/path>` to your run command line or specify a workDir in your config file"})));
        }
        List requiredConfigs = ScriptBytecodeAdapter.createList((Object[])new Object[]{"google.project"});
        String it = null;
        Iterator iterator = requiredConfigs.iterator();
        while (iterator.hasNext()) {
            it = ShortTypeHandling.castToString(iterator.next());
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)it)))) continue;
            this.getSession().abort();
            throw (Throwable)new AbortOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{it, this.getName()}, new String[]{"Required config value '", "' for executor ", " is not defined -- Please add it to your process or nextflow configuration file"})));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.zone")) && !DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.region"))) {
            this.getSession().abort();
            throw (Throwable)new AbortOperationException("Missing configuration value 'google.zone' or 'google.region'");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.zone")) && DefaultTypeTransformation.booleanUnbox((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.region"))) {
            this.getSession().abort();
            throw (Throwable)new AbortOperationException("You can't specify both 'google.zone' and 'google.region' configuration parameters -- Please remove one of them from your configuration");
        }
        Object path = Bolts.navigate((Map)this.getSession().getConfig(), (String)"env.PATH");
        if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
            log.warn("Environment PATH defined in config file is ignored by Google Pipeline executor");
        }
        log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getName()}, new String[]{"Executor `", "` is deprecated -- Use `google-lifesciences` instead"})));
        Object disableBinDir = this.getSession().getExecConfigProp(this.getName(), "disableRemoteBinDir", (Object)false);
        Path remoteBinDir = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getSession().getBinDir()) && !DefaultTypeTransformation.booleanUnbox((Object)disableBinDir)) {
            Path path2;
            Path cloudPath = this.getTempDir();
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{FilesEx.toUriString((Path)cloudPath)}, new String[]{"Uploading local `bin` scripts folder to ", "/bin"})));
            remoteBinDir = path2 = FilesEx.copyTo((Path)this.getSession().getBinDir(), (Path)cloudPath);
        }
        String[] stringArray = (string = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.zone"), String.class)) != null ? string.split(",") : null;
        List zones = stringArray != null ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)stringArray, Object[].class))) : null;
        String string2 = (String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.region"), String.class);
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        List regions = stringArray2 != null ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)stringArray2, Object[].class))) : null;
        return new GooglePipelinesConfiguration((String)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"google.project"), String.class), zones, regions, remoteBinDir, DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)Bolts.navigate((Map)this.getSession().getConfig(), (String)"cloud.preemptible"), Boolean.TYPE)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GooglePipelinesExecutor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.pipelines.GooglePipelinesExecutor");
    }

    @Generated
    public GooglePipelinesHelper getHelper() {
        return this.helper;
    }

    @Generated
    public void setHelper(GooglePipelinesHelper googlePipelinesHelper) {
        this.helper = googlePipelinesHelper;
    }
}

