/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.pipelines;

import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextflow.cloud.google.pipelines.GooglePipelinesTaskHandler;
import nextflow.executor.SimpleFileCopyStrategy;
import nextflow.extension.FilesEx;
import nextflow.processor.TaskBean;
import nextflow.util.Escape;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePipelinesFileCopyStrategy
extends SimpleFileCopyStrategy {
    private GooglePipelinesTaskHandler handler;
    private TaskBean task;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public GooglePipelinesFileCopyStrategy(TaskBean bean, GooglePipelinesTaskHandler handler) {
        super(bean);
        TaskBean taskBean;
        GooglePipelinesTaskHandler googlePipelinesTaskHandler;
        this.handler = googlePipelinesTaskHandler = handler;
        this.task = taskBean = bean;
    }

    public String getStageInputFilesScript(Map<String, Path> inputFiles) {
        Reference createDirectories = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference stagingCommands = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getStageInputFilesScript_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference createDirectories;
            private /* synthetic */ Reference stagingCommands;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getStageInputFilesScript_closure1(Object _outerInstance, Object _thisObject, Reference createDirectories, Reference stagingCommands) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.createDirectories = reference2 = createDirectories;
                this.stagingCommands = reference = stagingCommands;
            }

            public Object doCall(Object stageName, Object storePath) {
                Path absStorePath = ((Path)storePath).toAbsolutePath();
                boolean storePathIsDir = FilesEx.isDirectory((Path)absStorePath, (LinkOption[])new LinkOption[0]);
                Path stagePath = Paths.get(ShortTypeHandling.castToString((Object)stageName), new String[0]);
                Path parent = stagePath.getParent();
                GStringImpl escapedStoreUri = new GStringImpl(new Object[]{absStorePath.getFileSystem(), Escape.path((Path)absStorePath)}, new String[]{"", "", ""});
                String escapedStageName = Escape.path((String)ShortTypeHandling.castToString((Object)stageName));
                if (DefaultTypeTransformation.booleanUnbox((Object)parent)) {
                    DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.createDirectories.get(), List.class)), (Object)new GStringImpl(new Object[]{((GooglePipelinesFileCopyStrategy)((SimpleFileCopyStrategy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SimpleFileCopyStrategy.class))).getWorkDir(), parent}, new String[]{"mkdir -p ", "/", ""}).toString());
                }
                if (storePathIsDir) {
                    DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.stagingCommands.get(), List.class)), (Object)new GStringImpl(new Object[]{escapedStoreUri, ((GooglePipelinesFileCopyStrategy)((SimpleFileCopyStrategy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SimpleFileCopyStrategy.class))).getWorkDir()}, new String[]{"gsutil -m -q cp -R ", "/ ", ""}).toString());
                    if (DefaultTypeTransformation.booleanUnbox((Object)parent) || !absStorePath.toString().endsWith(ShortTypeHandling.castToString((Object)stageName))) {
                        GStringImpl newLocation = new GStringImpl(new Object[]{((GooglePipelinesFileCopyStrategy)((SimpleFileCopyStrategy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SimpleFileCopyStrategy.class))).getWorkDir(), escapedStageName}, new String[]{"", "/", ""});
                        return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.stagingCommands.get(), List.class)), (Object)new GStringImpl(new Object[]{((GooglePipelinesFileCopyStrategy)((SimpleFileCopyStrategy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SimpleFileCopyStrategy.class))).getWorkDir(), Escape.path((String)FilesEx.getName((Path)absStorePath)), newLocation}, new String[]{"mv ", "/", " ", ""}).toString());
                    }
                    return null;
                }
                return DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.stagingCommands.get(), List.class)), (Object)new GStringImpl(new Object[]{escapedStoreUri, ((GooglePipelinesFileCopyStrategy)((SimpleFileCopyStrategy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SimpleFileCopyStrategy.class))).getWorkDir(), escapedStageName}, new String[]{"gsutil -m -q cp ", " ", "/", ""}).toString());
            }

            public Object call(Object stageName, Object storePath) {
                return this.doCall(stageName, storePath);
            }

            public Object getCreateDirectories() {
                return this.createDirectories.get();
            }

            public Object getStagingCommands() {
                return this.stagingCommands.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getStageInputFilesScript_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(inputFiles, (Closure)new _getStageInputFilesScript_closure1((Object)this, (Object)this, createDirectories, stagingCommands));
        this.handler.stagingCommands.addAll((List)createDirectories.get());
        this.handler.stagingCommands.addAll((List)stagingCommands.get());
        if (DefaultTypeTransformation.booleanUnbox((Object)this.handler.pipelineConfiguration.getRemoteBinDir())) {
            String createRemoteBinDir = new GStringImpl(new Object[]{this.getWorkDir()}, new String[]{"mkdir -p ", "/nextflow-bin"}).toString();
            String remoteBinCopy = new GStringImpl(new Object[]{FilesEx.toUriString((Path)this.handler.pipelineConfiguration.getRemoteBinDir()), this.getWorkDir()}, new String[]{"gsutil -m -q cp -P -r ", "/* ", "/nextflow-bin"}).toString();
            DefaultGroovyMethods.leftShift((List)DefaultGroovyMethods.leftShift(this.handler.stagingCommands, (Object)createRemoteBinDir), (Object)remoteBinCopy);
        }
        return "# Google pipeline staging is done in a pipeline action step that is run prior to the main pipeline action";
    }

    public String getUnstageOutputFilesScript(List<String> outputFiles, Path targetDir) {
        public final class _getUnstageOutputFilesScript_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getUnstageOutputFilesScript_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                String escaped = Escape.path((String)ShortTypeHandling.castToString((Object)it));
                return new GStringImpl(new Object[]{escaped, FilesEx.toUriString((Path)((GooglePipelinesFileCopyStrategy)((SimpleFileCopyStrategy)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SimpleFileCopyStrategy.class))).getWorkDir())}, new String[]{"gsutil -m -q cp -R ", " ", " || true"}).toString();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getUnstageOutputFilesScript_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List unstagingCommands = DefaultGroovyMethods.collect(outputFiles, (Closure)new _getUnstageOutputFilesScript_closure2((Object)this, (Object)this));
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{unstagingCommands}, new String[]{"[GPAPI] Constructed the following file copy staging commands: ", ""})));
        this.handler.unstagingCommands.addAll(unstagingCommands);
        return ": # Google pipeline unstaging is done in a pipeline action step that is run after the main pipeline action";
    }

    public String touchFile(Path file) {
        if (DefaultTypeTransformation.booleanUnbox((Object)(CloudStoragePath.class == null ? Boolean.valueOf(file == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(CloudStoragePath.class, (Object)file))))) {
            DefaultGroovyMethods.leftShift(this.handler.stagingCommands, (Object)new GStringImpl(new Object[]{FilesEx.toUriString((Path)file)}, new String[]{"echo start | gsutil -q cp  -c - ", " || true"}).toString());
            return "# Google pipeline touchFile is done in a pipeline action step that is run prior to the main pipeline action";
        }
        return super.touchFile(file);
    }

    public String getEnvScript(Map environment, boolean container) {
        if (container) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Object)((Object)this)).getClass().getSimpleName()}, new String[]{"Parameter `wrapHandler` not supported by ", ""})));
        }
        StringBuilder result = new StringBuilder();
        HashMap copy = DefaultTypeTransformation.booleanUnbox((Object)environment) ? new HashMap(environment) : Collections.emptyMap();
        if (copy.containsKey("PATH")) {
            copy.remove("PATH");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.handler.pipelineConfiguration.getRemoteBinDir())) {
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)new GStringImpl(new Object[]{this.getWorkDir()}, new String[]{"chmod +x ", "/nextflow-bin/*\n"}));
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)new GStringImpl(new Object[]{this.getWorkDir()}, new String[]{"export PATH=", "/nextflow-bin:$PATH\n"}));
        }
        String envSnippet = super.getEnvScript(copy, false);
        if (DefaultTypeTransformation.booleanUnbox((Object)envSnippet)) {
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)envSnippet);
        }
        return result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GooglePipelinesFileCopyStrategy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.pipelines.GooglePipelinesFileCopyStrategy");
    }

    @Generated
    public GooglePipelinesTaskHandler getHandler() {
        return this.handler;
    }

    @Generated
    public void setHandler(GooglePipelinesTaskHandler googlePipelinesTaskHandler) {
        this.handler = googlePipelinesTaskHandler;
    }

    @Generated
    public TaskBean getTask() {
        return this.task;
    }

    @Generated
    public void setTask(TaskBean taskBean) {
        this.task = taskBean;
    }
}

