/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.pipelines;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.genomics.v2alpha1.Genomics;
import com.google.api.services.genomics.v2alpha1.model.Accelerator;
import com.google.api.services.genomics.v2alpha1.model.Action;
import com.google.api.services.genomics.v2alpha1.model.CancelOperationRequest;
import com.google.api.services.genomics.v2alpha1.model.Disk;
import com.google.api.services.genomics.v2alpha1.model.Mount;
import com.google.api.services.genomics.v2alpha1.model.Operation;
import com.google.api.services.genomics.v2alpha1.model.Pipeline;
import com.google.api.services.genomics.v2alpha1.model.Resources;
import com.google.api.services.genomics.v2alpha1.model.RunPipelineRequest;
import com.google.api.services.genomics.v2alpha1.model.ServiceAccount;
import com.google.api.services.genomics.v2alpha1.model.VirtualMachine;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextflow.cloud.google.pipelines.GooglePipelinesSubmitRequest;
import nextflow.executor.res.AcceleratorResource;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePipelinesHelper
implements GroovyObject {
    private static final String SCOPE_CLOUD_PLATFORM = "https://www.googleapis.com/auth/cloud-platform";
    private static final List<String> ENV_VAR_TO_INCLUDE;
    private Genomics genomicsClient;
    private GoogleCredential credential;
    private final String applicationName;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GooglePipelinesHelper(GoogleCredential credential, String name) {
        String string;
        GoogleCredential googleCredential;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.credential = googleCredential = credential;
        this.applicationName = string = name;
    }

    @Generated
    public GooglePipelinesHelper(GoogleCredential credential) {
        this(credential, "Nextflow GooglePipelinesExecutor");
    }

    @Generated
    public GooglePipelinesHelper() {
        this(null, "Nextflow GooglePipelinesExecutor");
    }

    public static String sanitizeName(String name) {
        return StringGroovyMethods.take((String)name.replaceAll("[^a-zA-Z0-9\\-_]+", "-"), (int)63);
    }

    public void init() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.genomicsClient)) {
            Genomics genomics;
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.credential)) {
                GoogleCredential googleCredential;
                this.credential = googleCredential = GoogleCredential.getApplicationDefault();
            }
            if (this.credential.createScopedRequired()) {
                GoogleCredential googleCredential;
                this.credential = googleCredential = this.credential.createScoped((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{SCOPE_CLOUD_PLATFORM}));
            }
            this.genomicsClient = genomics = new Genomics.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.credential).setApplicationName(this.applicationName).build();
        }
    }

    public Map<String, String> getEnvironment() {
        public final class _getEnvironment_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getEnvironment_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return GooglePipelinesHelper.getENV_VAR_TO_INCLUDE().contains(((Map.Entry)it).getKey());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getEnvironment_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.findAll(System.getenv(), (Closure)new _getEnvironment_closure1(this, this));
    }

    public Action createAction(String name, String imageUri, List<String> commands, List<Mount> mounts, List<ActionFlags> flags, String entrypoint) {
        public final class _createAction_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createAction_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object flag) {
                return ((ActionFlags)((Object)flag)).toString();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createAction_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return new Action().setName(name).setImageUri(imageUri).setCommands(commands).setMounts(mounts).setFlags(DefaultGroovyMethods.collect(flags, (Closure)new _createAction_closure2(this, this))).setEntrypoint(entrypoint).setEnvironment(this.getEnvironment());
    }

    public Pipeline createPipeline(List<Action> actions, Resources resources) {
        return new Pipeline().setActions(actions).setResources(resources);
    }

    public Operation submitPipeline(GooglePipelinesSubmitRequest req) {
        List actions = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.createStagingAction(req), this.createMainAction(req), this.createUnstagingAction(req)});
        Pipeline pipeline = this.createPipeline(actions, this.createResources(req));
        return this.runPipeline(pipeline, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"taskName", req.getTaskName()}));
    }

    protected Resources createResources(GooglePipelinesSubmitRequest req) {
        return this.configureResources(req.getMachineType(), req.getProject(), req.getZone(), req.getRegion(), req.getDiskName(), req.getDiskSizeGb(), ScriptBytecodeAdapter.createList((Object[])new Object[]{GooglePipelinesHelper.getSCOPE_CLOUD_PLATFORM()}), req.isPreemptible(), req.getAccelerator());
    }

    protected Action createMainAction(GooglePipelinesSubmitRequest req) {
        return this.createAction(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getTaskName()}, new String[]{"", "-main"})), req.getContainerImage(), ScriptBytecodeAdapter.createList((Object[])new Object[]{"bash", "-c", req.getMainScript()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{ActionFlags.IGNORE_EXIT_STATUS}));
    }

    protected Action createStagingAction(GooglePipelinesSubmitRequest req) {
        return this.createAction(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getTaskName()}, new String[]{"", "-stage"})), req.getFileCopyImage(), ScriptBytecodeAdapter.createList((Object[])new Object[]{"bash", "-c", req.getStagingScript()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{ActionFlags.ALWAYS_RUN, ActionFlags.IGNORE_EXIT_STATUS}));
    }

    protected Action createUnstagingAction(GooglePipelinesSubmitRequest req) {
        return this.createAction(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{req.getTaskName()}, new String[]{"", "-unstage"})), req.getFileCopyImage(), ScriptBytecodeAdapter.createList((Object[])new Object[]{"bash", "-c", req.getUnstagingScript()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{req.getSharedMount()}), ScriptBytecodeAdapter.createList((Object[])new Object[]{ActionFlags.ALWAYS_RUN, ActionFlags.IGNORE_EXIT_STATUS}));
    }

    public Resources configureResources(String machineType, String projectId, List<String> zone, List<String> region, String diskName, Integer diskSizeGb, List<String> scopes, boolean preemptible, AcceleratorResource accelerator) {
        Disk disk = new Disk();
        disk.setName(diskName);
        disk.setSizeGb(diskSizeGb);
        ServiceAccount serviceAccount = new ServiceAccount();
        if (DefaultTypeTransformation.booleanUnbox(scopes)) {
            serviceAccount.setScopes(scopes);
        }
        VirtualMachine vm = new VirtualMachine().setMachineType(machineType).setDisks(ScriptBytecodeAdapter.createList((Object[])new Object[]{disk})).setServiceAccount(serviceAccount).setPreemptible(Boolean.valueOf(preemptible));
        if (DefaultTypeTransformation.booleanUnbox((Object)accelerator)) {
            Accelerator acc = new Accelerator().setType(accelerator.getType()).setCount((Long)ScriptBytecodeAdapter.castToType((Object)accelerator.getRequest(), Long.class));
            ArrayList<Accelerator> list = new ArrayList<Accelerator>(1);
            list.add(acc);
            vm.setAccelerators(list);
        }
        return new Resources().setProjectId(projectId).setZones(zone).setRegions(region).setVirtualMachine(vm);
    }

    public Mount configureMount(String diskName, String mountPath, boolean readOnly) {
        return new Mount().setDisk(diskName).setPath(mountPath).setReadOnly(Boolean.valueOf(readOnly));
    }

    public Operation checkOperationStatus(Operation operation) {
        this.init();
        Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType((Object)this.genomicsClient.projects().operations().get(operation.getName()).execute(), Operation.class);
        try {
            return operation2;
        }
        catch (IOException e) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operation.getName()}, new String[]{"Invalid server response fetching operation status: ", ""})), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            Operation operation3 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation3;
        }
    }

    public void cancelOperation(Operation operation) {
        block5: {
            this.init();
            try {
                this.genomicsClient.projects().operations().cancel(operation.getName(), new CancelOperationRequest()).execute();
            }
            catch (IOException e) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{operation.getName(), e.getMessage()}, new String[]{"Invalid server response cancelling operation: ", " | ", ""})));
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
    }

    public Operation runPipeline(Pipeline pipeline, Map<String, String> labels) {
        this.init();
        Operation operation = (Operation)ScriptBytecodeAdapter.castToType((Object)this.genomicsClient.pipelines().run(new RunPipelineRequest().setPipeline(pipeline).setLabels(labels)).execute(), Operation.class);
        try {
            return operation;
        }
        catch (IOException e) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pipeline}, new String[]{"Invalid server response running pipeline: ", ""})), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation2;
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GooglePipelinesHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GooglePipelinesHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GooglePipelinesHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ List<String> pfaccess$0(GooglePipelinesHelper $that) {
        return ENV_VAR_TO_INCLUDE;
    }

    @Generated
    public Action createAction(String name, String imageUri, List<String> commands, List<Mount> mounts, List<ActionFlags> flags) {
        return this.createAction(name, imageUri, commands, mounts, flags, null);
    }

    @Generated
    public Action createAction(String name, String imageUri, List<String> commands, List<Mount> mounts) {
        return this.createAction(name, imageUri, commands, mounts, ScriptBytecodeAdapter.createList((Object[])new Object[0]), null);
    }

    @Generated
    public Mount configureMount(String diskName, String mountPath) {
        return this.configureMount(diskName, mountPath, false);
    }

    @Generated
    public Operation runPipeline(Pipeline pipeline) {
        return this.runPipeline(pipeline, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GooglePipelinesHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        List list;
        ENV_VAR_TO_INCLUDE = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"NXF_DEBUG"});
        log = logger = LoggerFactory.getLogger((String)"nextflow.cloud.google.pipelines.GooglePipelinesHelper");
    }

    @Generated
    public static String getSCOPE_CLOUD_PLATFORM() {
        return SCOPE_CLOUD_PLATFORM;
    }

    @Generated
    public static List<String> getENV_VAR_TO_INCLUDE() {
        return ENV_VAR_TO_INCLUDE;
    }

    @Generated
    public Genomics getGenomicsClient() {
        return this.genomicsClient;
    }

    @Generated
    public void setGenomicsClient(Genomics genomics) {
        this.genomicsClient = genomics;
    }

    @Generated
    public GoogleCredential getCredential() {
        return this.credential;
    }

    @Generated
    public void setCredential(GoogleCredential googleCredential) {
        this.credential = googleCredential;
    }

    @Generated
    public final String getApplicationName() {
        return this.applicationName;
    }

    public static final class ActionFlags
    extends Enum<ActionFlags>
    implements GroovyObject {
        public static final /* enum */ ActionFlags FLAG_UNSPECIFIED;
        public static final /* enum */ ActionFlags IGNORE_EXIT_STATUS;
        public static final /* enum */ ActionFlags RUN_IN_BACKGROUND;
        public static final /* enum */ ActionFlags ALWAYS_RUN;
        public static final /* enum */ ActionFlags ENABLE_FUSE;
        public static final /* enum */ ActionFlags PUBLISH_EXPOSED_PORTS;
        public static final /* enum */ ActionFlags DISABLE_IMAGE_PREFETCH;
        public static final /* enum */ ActionFlags DISABLE_STANDARD_ERROR_CAPTURE;
        public static final ActionFlags MIN_VALUE;
        public static final ActionFlags MAX_VALUE;
        private static final /* synthetic */ ActionFlags[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public ActionFlags(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum nextflow.cloud.google.pipelines.GooglePipelinesHelper$ActionFlags was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        public ActionFlags() {
            this(new LinkedHashMap());
        }

        public static final ActionFlags[] values() {
            return (ActionFlags[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), ActionFlags[].class);
        }

        public /* synthetic */ ActionFlags next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (ActionFlags)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), ActionFlags.class);
        }

        public /* synthetic */ ActionFlags previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (ActionFlags)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), ActionFlags.class);
        }

        public static ActionFlags valueOf(String name) {
            return (ActionFlags)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(ActionFlags.class, name)), ActionFlags.class);
        }

        public static final /* synthetic */ ActionFlags $INIT(Object ... para) {
            ActionFlags actionFlags;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, ActionFlags.class)) {
                case -1348271900: {
                    ActionFlags actionFlags2;
                    actionFlags = actionFlags2;
                    Object[] objectArray2 = objectArray;
                    actionFlags2 = new ActionFlags();
                    break;
                }
                case -242181752: {
                    ActionFlags actionFlags2;
                    actionFlags = actionFlags2;
                    Object[] objectArray2 = objectArray;
                    actionFlags2 = new ActionFlags((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return actionFlags;
        }

        static {
            ActionFlags actionFlags;
            ActionFlags actionFlags2;
            ActionFlags actionFlags3;
            ActionFlags actionFlags4;
            ActionFlags actionFlags5;
            ActionFlags actionFlags6;
            ActionFlags actionFlags7;
            ActionFlags actionFlags8;
            ActionFlags actionFlags9;
            ActionFlags actionFlags10;
            FLAG_UNSPECIFIED = actionFlags10 = ActionFlags.$INIT("FLAG_UNSPECIFIED", 0);
            IGNORE_EXIT_STATUS = actionFlags9 = ActionFlags.$INIT("IGNORE_EXIT_STATUS", 1);
            RUN_IN_BACKGROUND = actionFlags8 = ActionFlags.$INIT("RUN_IN_BACKGROUND", 2);
            ALWAYS_RUN = actionFlags7 = ActionFlags.$INIT("ALWAYS_RUN", 3);
            ENABLE_FUSE = actionFlags6 = ActionFlags.$INIT("ENABLE_FUSE", 4);
            PUBLISH_EXPOSED_PORTS = actionFlags5 = ActionFlags.$INIT("PUBLISH_EXPOSED_PORTS", 5);
            DISABLE_IMAGE_PREFETCH = actionFlags4 = ActionFlags.$INIT("DISABLE_IMAGE_PREFETCH", 6);
            DISABLE_STANDARD_ERROR_CAPTURE = actionFlags3 = ActionFlags.$INIT("DISABLE_STANDARD_ERROR_CAPTURE", 7);
            MIN_VALUE = actionFlags2 = FLAG_UNSPECIFIED;
            MAX_VALUE = actionFlags = DISABLE_STANDARD_ERROR_CAPTURE;
            ActionFlags[] actionFlagsArray = new ActionFlags[]{FLAG_UNSPECIFIED, IGNORE_EXIT_STATUS, RUN_IN_BACKGROUND, ALWAYS_RUN, ENABLE_FUSE, PUBLISH_EXPOSED_PORTS, DISABLE_IMAGE_PREFETCH, DISABLE_STANDARD_ERROR_CAPTURE};
            $VALUES = actionFlagsArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ActionFlags.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

