/*
 * Decompiled with CFR 0.152.
 */
package nextflow.cloud.google.pipelines;

import com.google.api.services.genomics.v2alpha1.model.Event;
import com.google.api.services.genomics.v2alpha1.model.Metadata;
import com.google.api.services.genomics.v2alpha1.model.Mount;
import com.google.api.services.genomics.v2alpha1.model.Operation;
import groovy.json.JsonOutput;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import nextflow.cloud.google.pipelines.GooglePipelinesConfiguration;
import nextflow.cloud.google.pipelines.GooglePipelinesExecutor;
import nextflow.cloud.google.pipelines.GooglePipelinesScriptLauncher;
import nextflow.cloud.google.pipelines.GooglePipelinesSubmitRequest;
import nextflow.cloud.types.CloudMachineInfo;
import nextflow.cloud.types.PriceModel;
import nextflow.exception.ProcessSubmitException;
import nextflow.exception.ProcessUnrecoverableException;
import nextflow.processor.TaskBean;
import nextflow.processor.TaskHandler;
import nextflow.processor.TaskRun;
import nextflow.processor.TaskStatus;
import nextflow.trace.TraceRecord;
import nextflow.util.Escape;
import nextflow.util.MemoryUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePipelinesTaskHandler
extends TaskHandler {
    private static List<String> UNSTAGE_CONTROL_FILES;
    private GooglePipelinesExecutor executor;
    GooglePipelinesConfiguration pipelineConfiguration;
    private TaskBean taskBean;
    private Path exitFile;
    private Path outputFile;
    private Path errorFile;
    private String machineType;
    private String mountPath;
    private static final String diskName = "nf-pipeline-work";
    private static final String fileCopyImage = "google/cloud-sdk:alpine";
    private Mount sharedMount;
    private Operation operation;
    private Metadata metadata;
    private String pipelineId;
    List<String> stagingCommands;
    List<String> unstagingCommands;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public GooglePipelinesTaskHandler(TaskRun task, GooglePipelinesExecutor executor, GooglePipelinesConfiguration pipelineConfiguration) {
        List list;
        List list2;
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        super(task);
        this.stagingCommands = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.unstagingCommands = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        GooglePipelinesExecutor googlePipelinesExecutor = executor;
        this.executor = (GooglePipelinesExecutor)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)googlePipelinesExecutor), GooglePipelinesExecutor.class));
        Object object = callSiteArray[0].callConstructor(TaskBean.class, (Object)task);
        this.taskBean = (TaskBean)ScriptBytecodeAdapter.castToType((Object)object, TaskBean.class);
        GooglePipelinesConfiguration googlePipelinesConfiguration = pipelineConfiguration;
        this.pipelineConfiguration = (GooglePipelinesConfiguration)ScriptBytecodeAdapter.castToType((Object)googlePipelinesConfiguration, GooglePipelinesConfiguration.class);
        Object object2 = callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)task), callSiteArray[3].callGetProperty(TaskRun.class));
        this.outputFile = (Path)ScriptBytecodeAdapter.castToType((Object)object2, Path.class);
        Object object3 = callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)task), callSiteArray[6].callGetProperty(TaskRun.class));
        this.errorFile = (Path)ScriptBytecodeAdapter.castToType((Object)object3, Path.class);
        Object object4 = callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)task), callSiteArray[9].callGetProperty(TaskRun.class));
        this.exitFile = (Path)ScriptBytecodeAdapter.castToType((Object)object4, Path.class);
        Object object5 = callSiteArray[10].call(callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty(callSiteArray[13].callGroovyObjectGetProperty((Object)task))));
        this.mountPath = ShortTypeHandling.castToString((Object)object5);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object6 = callSiteArray[14].callCurrent((GroovyObject)this);
            this.machineType = ShortTypeHandling.castToString((Object)object6);
        } else {
            String string = this.getProcessMachineType();
            this.machineType = ShortTypeHandling.castToString((Object)string);
        }
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[15].callCurrent((GroovyObject)this);
        } else {
            this.validateConfiguration();
        }
    }

    protected GooglePipelinesTaskHandler() {
        List list;
        List list2;
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        this.stagingCommands = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.unstagingCommands = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    public void validateConfiguration() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGroovyObjectGetProperty(callSiteArray[17].callGroovyObjectGetProperty((Object)this)))) {
            throw (Throwable)callSiteArray[18].callConstructor(ProcessUnrecoverableException.class, (Object)new GStringImpl(new Object[]{callSiteArray[19].callGroovyObjectGetProperty(callSiteArray[20].callGroovyObjectGetProperty((Object)this))}, new String[]{"No container image specified for process ", " -- Either specify the container to use in the process definition or with 'process.container' value in your config"}));
        }
    }

    public String getProcessMachineType() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        String machineType = ShortTypeHandling.castToString((Object)callSiteArray[21].callCurrent((GroovyObject)this, callSiteArray[22].call(callSiteArray[23].callGetProperty(callSiteArray[24].call((Object)this.executor)), (Object)"cloud.instanceType"), callSiteArray[25].callGetProperty(callSiteArray[26].callGroovyObjectGetProperty(callSiteArray[27].callGroovyObjectGetProperty((Object)this))), callSiteArray[28].callGetProperty(callSiteArray[29].callGroovyObjectGetProperty(callSiteArray[30].callGroovyObjectGetProperty((Object)this))), callSiteArray[31].callGetProperty(callSiteArray[32].callGroovyObjectGetProperty(callSiteArray[33].callGroovyObjectGetProperty((Object)this)))));
        callSiteArray[34].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[35].callGroovyObjectGetProperty(callSiteArray[36].callGroovyObjectGetProperty((Object)this)), machineType}, new String[]{"[GPAPI] Task: ", " - Instance Type: ", ""}));
        return machineType;
    }

    public String getProcessMachineType(String cloudInstanceType, String taskMachineType, int cpus, MemoryUnit memory) {
        String string;
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)cloudInstanceType, null)) {
            callSiteArray[37].call((Object)log, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"firstOnly", true, "cacheKey", GooglePipelinesTaskHandler.class}), (Object)"Configuration setting [cloud.instanceType] is deprecated.  Please use either the process cpus/memory directives or process.machineType instead.");
        }
        String machineType = DefaultTypeTransformation.booleanUnbox((Object)(string = taskMachineType)) ? string : cloudInstanceType;
        if (ScriptBytecodeAdapter.compareEqual((Object)machineType, null)) {
            long megabytes = 0L;
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = ScriptBytecodeAdapter.compareNotEqual((Object)memory, null) ? callSiteArray[38].callGroovyObjectGetProperty((Object)memory) : callSiteArray[39].call((Object)cpus, (Object)1024);
                megabytes = DefaultTypeTransformation.longUnbox((Object)object);
            } else {
                Object object = ScriptBytecodeAdapter.compareNotEqual((Object)memory, null) ? callSiteArray[40].callGroovyObjectGetProperty((Object)memory) : Integer.valueOf(cpus * 1024);
                megabytes = DefaultTypeTransformation.longUnbox((Object)object);
            }
            Object object = callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call((Object)"custom-", (Object)cpus), (Object)"-"), (Object)megabytes);
            machineType = ShortTypeHandling.castToString((Object)object);
        }
        return machineType;
    }

    protected void logEvents(Operation operation) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        Object events = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            events = object = callSiteArray[44].callCurrent((GroovyObject)this, (Object)operation);
        } else {
            List<Event> list = this.getEventsFromOp(operation);
            events = list;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)events)) {
            return;
        }
        Object warns = callSiteArray[45].callConstructor(HashSet.class);
        Event e = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call(events), Iterator.class);
        while (iterator.hasNext()) {
            e = (Event)ScriptBytecodeAdapter.castToType(iterator.next(), Event.class);
            Object d = callSiteArray[47].call((Object)e);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callSafe(d, (Object)"resource_exhausted"))) continue;
            callSiteArray[49].call(warns, d);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)warns)) {
            callSiteArray[50].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[51].callGroovyObjectGetProperty(callSiteArray[52].callGroovyObjectGetProperty((Object)this)), this.pipelineId, callSiteArray[53].callCurrent((GroovyObject)this, events)}, new String[]{"[GPAPI] New event > ", " - Pipeline Id: ", "\n", ""}));
            String w = null;
            Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call(warns), Iterator.class);
            while (iterator2.hasNext()) {
                w = ShortTypeHandling.castToString(iterator2.next());
                callSiteArray[55].call((Object)log, (Object)new GStringImpl(new Object[]{w}, new String[]{"Google Pipelines > ", ""}));
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call((Object)log))) {
            callSiteArray[57].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[58].callGroovyObjectGetProperty(callSiteArray[59].callGroovyObjectGetProperty((Object)this)), this.pipelineId, callSiteArray[60].callCurrent((GroovyObject)this, events)}, new String[]{"[GPAPI] New event > ", " - Pipeline Id: ", "\n", ""}));
        }
    }

    public boolean checkIfRunning() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)this.operation, null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].callCurrent((GroovyObject)this)) : ScriptBytecodeAdapter.compareEqual((Object)this.operation, null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].callCurrent((GroovyObject)this))) {
            return false;
        }
        Object result = callSiteArray[63].call(callSiteArray[64].callGroovyObjectGetProperty((Object)this.executor), (Object)this.operation);
        if (ScriptBytecodeAdapter.compareEqual((Object)result, null)) {
            return false;
        }
        callSiteArray[65].callCurrent((GroovyObject)this, result);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)result, null)) {
            Object object = callSiteArray[66].callGetProperty(TaskStatus.class);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((TaskStatus)ShortTypeHandling.castToEnum((Object)object, TaskStatus.class)), GooglePipelinesTaskHandler.class, (GroovyObject)this, (String)"status");
            Object object2 = result;
            this.operation = (Operation)ScriptBytecodeAdapter.castToType((Object)object2, Operation.class);
            return true;
        }
        return false;
    }

    public boolean checkIfCompleted() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].callCurrent((GroovyObject)this))) {
            return false;
        }
        Object resultOp = callSiteArray[68].call(callSiteArray[69].callGroovyObjectGetProperty((Object)this.executor), (Object)this.operation);
        if (!DefaultTypeTransformation.booleanUnbox((Object)resultOp)) {
            return false;
        }
        Object object = resultOp;
        this.operation = (Operation)ScriptBytecodeAdapter.castToType((Object)object, Operation.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[70].callCurrent((GroovyObject)this, (Object)this.operation);
        } else {
            this.logEvents(this.operation);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call((Object)this.operation))) {
            callSiteArray[72].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[73].callGroovyObjectGetProperty(callSiteArray[74].callGroovyObjectGetProperty((Object)this)), callSiteArray[75].callSafe((Object)this.metadata), callSiteArray[76].callSafe((Object)this.metadata)}, new String[]{"[GPAPI] Task complete > ", " - Start Time: ", " - End Time: ", ""}));
            Integer xs = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object2 = callSiteArray[77].callCurrent((GroovyObject)this);
                xs = (Integer)ScriptBytecodeAdapter.castToType((Object)object2, Integer.class);
            } else {
                Integer n;
                xs = n = this.readExitFile();
            }
            Path path = this.outputFile;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)path, GooglePipelinesTaskHandler.class, (GroovyObject)callSiteArray[78].callGroovyObjectGetProperty((Object)this), (String)"stdout");
            Integer n = ScriptBytecodeAdapter.compareNotEqual((Object)xs, null) ? xs : callSiteArray[79].callSafe(callSiteArray[80].call((Object)this.operation));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, GooglePipelinesTaskHandler.class, (GroovyObject)callSiteArray[81].callGroovyObjectGetProperty((Object)this), (String)"exitStatus");
            Path path2 = ScriptBytecodeAdapter.compareNotEqual((Object)xs, null) ? this.errorFile : callSiteArray[82].callSafe(callSiteArray[83].call((Object)this.operation));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)path2, GooglePipelinesTaskHandler.class, (GroovyObject)callSiteArray[84].callGroovyObjectGetProperty((Object)this), (String)"stderr");
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)xs) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[85].callGroovyObjectGetProperty(callSiteArray[86].callGroovyObjectGetProperty((Object)this)), (Object)10) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[87].callGroovyObjectGetProperty(callSiteArray[88].callGroovyObjectGetProperty((Object)this)), (Object)14))) {
                    callSiteArray[89].call(callSiteArray[90].callGroovyObjectGetProperty(callSiteArray[91].callGroovyObjectGetProperty((Object)this)), (Object)"maxRetries", callSiteArray[92].call(callSiteArray[93].callGroovyObjectGetProperty(callSiteArray[94].callGroovyObjectGetProperty((Object)this)), (Object)1));
                    callSiteArray[95].call(callSiteArray[96].callGroovyObjectGetProperty(callSiteArray[97].callGroovyObjectGetProperty((Object)this)), (Object)"errorStrategy", (Object)"retry");
                }
            } else if (!DefaultTypeTransformation.booleanUnbox((Object)xs) && (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[98].callGroovyObjectGetProperty(callSiteArray[99].callGroovyObjectGetProperty((Object)this)), (Object)10) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[100].callGroovyObjectGetProperty(callSiteArray[101].callGroovyObjectGetProperty((Object)this)), (Object)14))) {
                callSiteArray[102].call(callSiteArray[103].callGroovyObjectGetProperty(callSiteArray[104].callGroovyObjectGetProperty((Object)this)), (Object)"maxRetries", callSiteArray[105].call(callSiteArray[106].callGroovyObjectGetProperty(callSiteArray[107].callGroovyObjectGetProperty((Object)this)), (Object)1));
                callSiteArray[108].call(callSiteArray[109].callGroovyObjectGetProperty(callSiteArray[110].callGroovyObjectGetProperty((Object)this)), (Object)"errorStrategy", (Object)"retry");
            }
            Object object3 = callSiteArray[111].callGetProperty(TaskStatus.class);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((TaskStatus)ShortTypeHandling.castToEnum((Object)object3, TaskStatus.class)), GooglePipelinesTaskHandler.class, (GroovyObject)this, (String)"status");
            return true;
        }
        return false;
    }

    List<Event> getEventsFromOp(Operation operation) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        Metadata metadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].call((Object)operation), Metadata.class);
        List result = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.metadata)) {
            Metadata metadata2 = metadata;
            this.metadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)metadata2, Metadata.class);
            Object object = ScriptBytecodeAdapter.compareNotEqual((Object)metadata, null) ? callSiteArray[113].call((Object)metadata) : callSiteArray[114].call(Collections.class);
            result = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        } else {
            Object delta = callSiteArray[115].call(callSiteArray[116].call(callSiteArray[117].call((Object)metadata)), callSiteArray[118].call(callSiteArray[119].call((Object)this.metadata)));
            Metadata metadata3 = metadata;
            this.metadata = (Metadata)ScriptBytecodeAdapter.castToType((Object)metadata3, Metadata.class);
            Object object = ScriptBytecodeAdapter.compareGreaterThan((Object)delta, (Object)0) ? callSiteArray[120].call(callSiteArray[121].call((Object)metadata), delta) : callSiteArray[122].call(Collections.class);
            result = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].call((Object)result), List.class);
    }

    Integer readExitFile() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        Integer n = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[124].callGetProperty((Object)this.exitFile), Integer.class);
        try {
            return n;
        }
        catch (Exception e) {
            callSiteArray[125].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[126].callGroovyObjectGetProperty(callSiteArray[127].callGroovyObjectGetProperty((Object)this)), callSiteArray[128].callGetProperty((Object)e)}, new String[]{"[GPAPI] Cannot read exitstatus for task: `", "` | ", ""}));
            Integer n2 = (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
            return n2;
        }
    }

    public void kill() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.operation)) {
            return;
        }
        callSiteArray[129].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[130].callGroovyObjectGetProperty(callSiteArray[131].callGroovyObjectGetProperty((Object)this)), this.pipelineId}, new String[]{"[GPAPI] Killing task > ", " - Pipeline Id: ", ""}));
        callSiteArray[132].call(callSiteArray[133].callGroovyObjectGetProperty((Object)this.executor), (Object)this.operation);
    }

    public void submit() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[134].callCurrent((GroovyObject)this);
        } else {
            this.createTaskWrapper();
        }
        Object req = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            req = object = callSiteArray[135].callCurrent((GroovyObject)this);
        } else {
            GooglePipelinesSubmitRequest googlePipelinesSubmitRequest = this.createPipelineRequest();
            req = googlePipelinesSubmitRequest;
        }
        callSiteArray[136].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[137].callGroovyObjectGetProperty(callSiteArray[138].callGroovyObjectGetProperty((Object)this)), req}, new String[]{"[GPAPI] Task created > ", " - Request: ", ""}));
        Object object = callSiteArray[139].callCurrent((GroovyObject)this, req);
        this.operation = (Operation)ScriptBytecodeAdapter.castToType((Object)object, Operation.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)this.operation, null)) {
            throw (Throwable)callSiteArray[140].callConstructor(ProcessSubmitException.class, (Object)new GStringImpl(new Object[]{callSiteArray[141].callGroovyObjectGetProperty(callSiteArray[142].callGroovyObjectGetProperty((Object)this))}, new String[]{"Failed to submit task with name: ", ""}));
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[143].callCurrent((GroovyObject)this, (Object)this.operation);
            this.pipelineId = ShortTypeHandling.castToString((Object)object2);
        } else {
            String string;
            this.pipelineId = string = this.getPipelineIdFromOp(this.operation);
        }
        Object object3 = callSiteArray[144].callGetProperty(TaskStatus.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((TaskStatus)ShortTypeHandling.castToEnum((Object)object3, TaskStatus.class)), GooglePipelinesTaskHandler.class, (GroovyObject)this, (String)"status");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[145].call((Object)log))) {
                callSiteArray[146].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[147].callGroovyObjectGetProperty(callSiteArray[148].callGroovyObjectGetProperty((Object)this)), this.pipelineId, callSiteArray[149].callCurrent((GroovyObject)this, (Object)this.operation)}, new String[]{"[GPAPI] Task submitted > ", " - Pipeline Id: ", "; Operation:\n", ""}));
            } else {
                callSiteArray[150].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[151].callGroovyObjectGetProperty(callSiteArray[152].callGroovyObjectGetProperty((Object)this)), this.pipelineId}, new String[]{"[GPAPI] Task submitted > ", " - Pipeline Id: ", ""}));
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[153].call((Object)log))) {
            callSiteArray[154].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[155].callGroovyObjectGetProperty(callSiteArray[156].callGroovyObjectGetProperty((Object)this)), this.pipelineId, this.prettyPrint(this.operation)}, new String[]{"[GPAPI] Task submitted > ", " - Pipeline Id: ", "; Operation:\n", ""}));
        } else {
            callSiteArray[157].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[158].callGroovyObjectGetProperty(callSiteArray[159].callGroovyObjectGetProperty((Object)this)), this.pipelineId}, new String[]{"[GPAPI] Task submitted > ", " - Pipeline Id: ", ""}));
        }
    }

    String getPipelineIdFromOp(Operation operation) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[160];
            Operation operation2 = operation;
            valueRecorder.record((Object)operation2, 8);
            Object object = callSite.callSafe((Object)operation2);
            valueRecorder.record(object, 19);
            if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert operation?.getName()", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call((Object)operation), (Object)"/"), (Object)-1));
    }

    void createTaskWrapper() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        callSiteArray[164].call(callSiteArray[165].callConstructor(GooglePipelinesScriptLauncher.class, (Object)this.taskBean, (Object)this));
    }

    Operation submitPipeline(GooglePipelinesSubmitRequest request) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        return (Operation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].call(callSiteArray[167].callGroovyObjectGetProperty((Object)this.executor), (Object)request), Operation.class);
    }

    GooglePipelinesSubmitRequest createPipelineRequest() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        String stagingScript = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[168].call(callSiteArray[169].callGroovyObjectGetProperty(callSiteArray[170].callGroovyObjectGetProperty((Object)this)))}, new String[]{"mkdir -p ", ""}));
        if (DefaultTypeTransformation.booleanUnbox(this.stagingCommands)) {
            stagingScript = ShortTypeHandling.castToString((Object)callSiteArray[171].call((Object)stagingScript, (Object)new GStringImpl(new Object[]{callSiteArray[172].call(this.stagingCommands, (Object)"; "), callSiteArray[173].callGroovyObjectGetProperty(callSiteArray[174].callGroovyObjectGetProperty((Object)this)), callSiteArray[175].callGetProperty(TaskRun.class)}, new String[]{"; (", ") 2>&1 > ", "/", ""})));
        }
        String mainScript = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[176].callGroovyObjectGetProperty(callSiteArray[177].callGroovyObjectGetProperty((Object)this)), callSiteArray[178].callGetProperty(TaskRun.class), callSiteArray[179].callGetProperty(TaskRun.class)}, new String[]{"cd ", "; bash ", " 2>&1 | tee -a ", ""}));
        List unstaging = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        callSiteArray[180].call((Object)unstaging, (Object)new GStringImpl(new Object[]{callSiteArray[181].callGroovyObjectGetProperty(callSiteArray[182].callGroovyObjectGetProperty((Object)this))}, new String[]{"cd ", ""}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[183].call((Object)unstaging, callSiteArray[184].call((Object)"[[ $GOOGLE_PIPELINE_FAILED == 1 || $NXF_DEBUG ]] && ", callSiteArray[185].callCurrent((GroovyObject)this, (Object)"/google/")));
        } else {
            callSiteArray[186].call((Object)unstaging, callSiteArray[187].call((Object)"[[ $GOOGLE_PIPELINE_FAILED == 1 || $NXF_DEBUG ]] && ", (Object)this.unstage("/google/")));
        }
        callSiteArray[188].call((Object)unstaging, this.unstagingCommands);
        callSiteArray[189].call((Object)unstaging, (Object)new GStringImpl(new Object[]{callSiteArray[190].callGetProperty(TaskRun.class), callSiteArray[191].callCurrent((GroovyObject)this, callSiteArray[192].callGetProperty(TaskRun.class))}, new String[]{"[[ -f ", " ]] && ", ""}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            String it = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].call(UNSTAGE_CONTROL_FILES), Iterator.class);
            while (iterator.hasNext()) {
                it = ShortTypeHandling.castToString(iterator.next());
                callSiteArray[194].call((Object)unstaging, callSiteArray[195].callCurrent((GroovyObject)this, (Object)it));
            }
        } else {
            String it = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[196].call(UNSTAGE_CONTROL_FILES), Iterator.class);
            while (iterator.hasNext()) {
                it = ShortTypeHandling.castToString(iterator.next());
                callSiteArray[197].call((Object)unstaging, (Object)this.unstage(it));
            }
        }
        Object object = callSiteArray[198].call(callSiteArray[199].callGroovyObjectGetProperty((Object)this.executor), (Object)diskName, (Object)this.mountPath);
        this.sharedMount = (Mount)ScriptBytecodeAdapter.castToType((Object)object, Mount.class);
        Object req = callSiteArray[200].callConstructor(GooglePipelinesSubmitRequest.class);
        String string = this.machineType;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)req, (String)"machineType");
        Object object2 = callSiteArray[201].callGroovyObjectGetProperty((Object)this.pipelineConfiguration);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)req, (String)"project");
        Object object3 = callSiteArray[202].callGroovyObjectGetProperty((Object)this.pipelineConfiguration);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)req, (String)"zone");
        Object object4 = callSiteArray[203].callGroovyObjectGetProperty((Object)this.pipelineConfiguration);
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)req, (String)"region");
        String string2 = diskName;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)req, (String)"diskName");
        Object object5 = callSiteArray[204].callGetPropertySafe(callSiteArray[205].callGetProperty(callSiteArray[206].callGroovyObjectGetProperty(callSiteArray[207].callGroovyObjectGetProperty((Object)this))));
        ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)req, (String)"diskSizeGb");
        Object object6 = callSiteArray[208].callGroovyObjectGetProperty((Object)this.pipelineConfiguration);
        ScriptBytecodeAdapter.setProperty((Object)object6, null, (Object)req, (String)"preemptible");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[209].callGroovyObjectGetProperty(callSiteArray[210].callGroovyObjectGetProperty((Object)this))}, new String[]{"nf-", ""});
        ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)req, (String)"taskName");
        Object object7 = callSiteArray[211].callGroovyObjectGetProperty(callSiteArray[212].callGroovyObjectGetProperty((Object)this));
        ScriptBytecodeAdapter.setProperty((Object)object7, null, (Object)req, (String)"containerImage");
        String string3 = fileCopyImage;
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)req, (String)"fileCopyImage");
        String string4 = stagingScript;
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)req, (String)"stagingScript");
        String string5 = mainScript;
        ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)req, (String)"mainScript");
        Object object8 = callSiteArray[213].call(callSiteArray[214].call((Object)unstaging, (Object)"; "));
        ScriptBytecodeAdapter.setProperty((Object)object8, null, (Object)req, (String)"unstagingScript");
        Mount mount = this.sharedMount;
        ScriptBytecodeAdapter.setProperty((Object)mount, null, (Object)req, (String)"sharedMount");
        Object object9 = callSiteArray[215].call(callSiteArray[216].callGroovyObjectGetProperty(callSiteArray[217].callGroovyObjectGetProperty((Object)this)));
        ScriptBytecodeAdapter.setProperty((Object)object9, null, (Object)req, (String)"accelerator");
        return (GooglePipelinesSubmitRequest)ScriptBytecodeAdapter.castToType((Object)req, GooglePipelinesSubmitRequest.class);
    }

    String unstage(String local) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[218].call(Escape.class, (Object)local), callSiteArray[219].call(callSiteArray[220].callGroovyObjectGetProperty(callSiteArray[221].callGroovyObjectGetProperty((Object)this)))}, new String[]{"gsutil -m -q cp -R ", " ", " || true"}));
    }

    public TraceRecord getTraceRecord() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        Object result = ScriptBytecodeAdapter.invokeMethodOnSuper0(TaskHandler.class, (GroovyObject)this, (String)"getTraceRecord");
        callSiteArray[222].call(result, (Object)"native_id", (Object)this.pipelineId);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[223].callCurrent((GroovyObject)this);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)result, (String)"machineInfo");
        } else {
            CloudMachineInfo cloudMachineInfo = this.getMachineInfo();
            ScriptBytecodeAdapter.setProperty((Object)cloudMachineInfo, null, (Object)result, (String)"machineInfo");
        }
        return (TraceRecord)ScriptBytecodeAdapter.castToType((Object)result, TraceRecord.class);
    }

    private CloudMachineInfo getMachineInfo() {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        Object zone = callSiteArray[224].callSafe(callSiteArray[225].callGroovyObjectGetProperty((Object)this.pipelineConfiguration), (Object)0);
        Object price = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[226].callGroovyObjectGetProperty((Object)this.pipelineConfiguration)) ? callSiteArray[227].callGetProperty(PriceModel.class) : callSiteArray[228].callGetProperty(PriceModel.class);
        return (CloudMachineInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[229].callConstructor(CloudMachineInfo.class, (Object)this.machineType, zone, price), CloudMachineInfo.class);
    }

    public String prettyPrint(Operation op) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[230].call(JsonOutput.class, callSiteArray[231].call(JsonOutput.class, (Object)op)));
    }

    public static String prettyPrint(List<Event> events) {
        CallSite[] callSiteArray = GooglePipelinesTaskHandler.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[232].call(JsonOutput.class, callSiteArray[233].call(JsonOutput.class, events)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GooglePipelinesTaskHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        List list;
        UNSTAGE_CONTROL_FILES = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{GooglePipelinesTaskHandler.$getCallSiteArray()[234].callGetProperty(TaskRun.class), GooglePipelinesTaskHandler.$getCallSiteArray()[235].callGetProperty(TaskRun.class), GooglePipelinesTaskHandler.$getCallSiteArray()[236].callGetProperty(TaskRun.class), GooglePipelinesTaskHandler.$getCallSiteArray()[237].callGetProperty(TaskRun.class)});
        Object object = GooglePipelinesTaskHandler.$getCallSiteArray()[238].call(LoggerFactory.class, (Object)"nextflow.cloud.google.pipelines.GooglePipelinesTaskHandler");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public GooglePipelinesExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public void setExecutor(GooglePipelinesExecutor googlePipelinesExecutor) {
        this.executor = googlePipelinesExecutor;
    }

    @Generated
    public static String getDiskName() {
        return diskName;
    }

    @Generated
    public static String getFileCopyImage() {
        return fileCopyImage;
    }

    public /* synthetic */ TraceRecord super$2$getTraceRecord() {
        return super.getTraceRecord();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "resolve";
        stringArray[2] = "workDir";
        stringArray[3] = "CMD_OUTFILE";
        stringArray[4] = "resolve";
        stringArray[5] = "workDir";
        stringArray[6] = "CMD_ERRFILE";
        stringArray[7] = "resolve";
        stringArray[8] = "workDir";
        stringArray[9] = "CMD_EXIT";
        stringArray[10] = "toString";
        stringArray[11] = "parent";
        stringArray[12] = "parent";
        stringArray[13] = "workDir";
        stringArray[14] = "getProcessMachineType";
        stringArray[15] = "validateConfiguration";
        stringArray[16] = "container";
        stringArray[17] = "task";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "name";
        stringArray[20] = "task";
        stringArray[21] = "getProcessMachineType";
        stringArray[22] = "navigate";
        stringArray[23] = "config";
        stringArray[24] = "getSession";
        stringArray[25] = "machineType";
        stringArray[26] = "config";
        stringArray[27] = "task";
        stringArray[28] = "cpus";
        stringArray[29] = "config";
        stringArray[30] = "task";
        stringArray[31] = "memory";
        stringArray[32] = "config";
        stringArray[33] = "task";
        stringArray[34] = "trace";
        stringArray[35] = "name";
        stringArray[36] = "task";
        stringArray[37] = "warn1";
        stringArray[38] = "mega";
        stringArray[39] = "multiply";
        stringArray[40] = "mega";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "getEventsFromOp";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "iterator";
        stringArray[47] = "getDescription";
        stringArray[48] = "contains";
        stringArray[49] = "leftShift";
        stringArray[50] = "debug";
        stringArray[51] = "name";
        stringArray[52] = "task";
        stringArray[53] = "prettyPrint";
        stringArray[54] = "iterator";
        stringArray[55] = "warn1";
        stringArray[56] = "isTraceEnabled";
        stringArray[57] = "trace";
        stringArray[58] = "name";
        stringArray[59] = "task";
        stringArray[60] = "prettyPrint";
        stringArray[61] = "isSubmitted";
        stringArray[62] = "isSubmitted";
        stringArray[63] = "checkOperationStatus";
        stringArray[64] = "helper";
        stringArray[65] = "logEvents";
        stringArray[66] = "RUNNING";
        stringArray[67] = "isRunning";
        stringArray[68] = "checkOperationStatus";
        stringArray[69] = "helper";
        stringArray[70] = "logEvents";
        stringArray[71] = "getDone";
        stringArray[72] = "debug";
        stringArray[73] = "name";
        stringArray[74] = "task";
        stringArray[75] = "getStartTime";
        stringArray[76] = "getEndTime";
        stringArray[77] = "readExitFile";
        stringArray[78] = "task";
        stringArray[79] = "getCode";
        stringArray[80] = "getError";
        stringArray[81] = "task";
        stringArray[82] = "getMessage";
        stringArray[83] = "getError";
        stringArray[84] = "task";
        stringArray[85] = "exitStatus";
        stringArray[86] = "task";
        stringArray[87] = "exitStatus";
        stringArray[88] = "task";
        stringArray[89] = "setProperty";
        stringArray[90] = "config";
        stringArray[91] = "task";
        stringArray[92] = "plus";
        stringArray[93] = "failCount";
        stringArray[94] = "task";
        stringArray[95] = "setProperty";
        stringArray[96] = "config";
        stringArray[97] = "task";
        stringArray[98] = "exitStatus";
        stringArray[99] = "task";
        stringArray[100] = "exitStatus";
        stringArray[101] = "task";
        stringArray[102] = "setProperty";
        stringArray[103] = "config";
        stringArray[104] = "task";
        stringArray[105] = "plus";
        stringArray[106] = "failCount";
        stringArray[107] = "task";
        stringArray[108] = "setProperty";
        stringArray[109] = "config";
        stringArray[110] = "task";
        stringArray[111] = "COMPLETED";
        stringArray[112] = "getMetadata";
        stringArray[113] = "getEvents";
        stringArray[114] = "emptyList";
        stringArray[115] = "minus";
        stringArray[116] = "size";
        stringArray[117] = "getEvents";
        stringArray[118] = "size";
        stringArray[119] = "getEvents";
        stringArray[120] = "take";
        stringArray[121] = "getEvents";
        stringArray[122] = "emptyList";
        stringArray[123] = "reverse";
        stringArray[124] = "text";
        stringArray[125] = "debug";
        stringArray[126] = "name";
        stringArray[127] = "task";
        stringArray[128] = "message";
        stringArray[129] = "debug";
        stringArray[130] = "name";
        stringArray[131] = "task";
        stringArray[132] = "cancelOperation";
        stringArray[133] = "helper";
        stringArray[134] = "createTaskWrapper";
        stringArray[135] = "createPipelineRequest";
        stringArray[136] = "trace";
        stringArray[137] = "name";
        stringArray[138] = "task";
        stringArray[139] = "submitPipeline";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "name";
        stringArray[142] = "task";
        stringArray[143] = "getPipelineIdFromOp";
        stringArray[144] = "SUBMITTED";
        stringArray[145] = "isTraceEnabled";
        stringArray[146] = "trace";
        stringArray[147] = "name";
        stringArray[148] = "task";
        stringArray[149] = "prettyPrint";
        stringArray[150] = "debug";
        stringArray[151] = "name";
        stringArray[152] = "task";
        stringArray[153] = "isTraceEnabled";
        stringArray[154] = "trace";
        stringArray[155] = "name";
        stringArray[156] = "task";
        stringArray[157] = "debug";
        stringArray[158] = "name";
        stringArray[159] = "task";
        stringArray[160] = "getName";
        stringArray[161] = "getAt";
        stringArray[162] = "tokenize";
        stringArray[163] = "getName";
        stringArray[164] = "build";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "submitPipeline";
        stringArray[167] = "helper";
        stringArray[168] = "toString";
        stringArray[169] = "workDir";
        stringArray[170] = "task";
        stringArray[171] = "plus";
        stringArray[172] = "join";
        stringArray[173] = "workDir";
        stringArray[174] = "task";
        stringArray[175] = "CMD_LOG";
        stringArray[176] = "workDir";
        stringArray[177] = "task";
        stringArray[178] = "CMD_RUN";
        stringArray[179] = "CMD_LOG";
        stringArray[180] = "leftShift";
        stringArray[181] = "workDir";
        stringArray[182] = "task";
        stringArray[183] = "leftShift";
        stringArray[184] = "plus";
        stringArray[185] = "unstage";
        stringArray[186] = "leftShift";
        stringArray[187] = "plus";
        stringArray[188] = "addAll";
        stringArray[189] = "leftShift";
        stringArray[190] = "CMD_TRACE";
        stringArray[191] = "unstage";
        stringArray[192] = "CMD_TRACE";
        stringArray[193] = "iterator";
        stringArray[194] = "leftShift";
        stringArray[195] = "unstage";
        stringArray[196] = "iterator";
        stringArray[197] = "leftShift";
        stringArray[198] = "configureMount";
        stringArray[199] = "helper";
        stringArray[200] = "<$constructor$>";
        stringArray[201] = "project";
        stringArray[202] = "zone";
        stringArray[203] = "region";
        stringArray[204] = "giga";
        stringArray[205] = "disk";
        stringArray[206] = "config";
        stringArray[207] = "task";
        stringArray[208] = "preemptible";
        stringArray[209] = "hash";
        stringArray[210] = "task";
        stringArray[211] = "container";
        stringArray[212] = "task";
        stringArray[213] = "trim";
        stringArray[214] = "join";
        stringArray[215] = "getAccelerator";
        stringArray[216] = "config";
        stringArray[217] = "task";
        stringArray[218] = "path";
        stringArray[219] = "toUriString";
        stringArray[220] = "workDir";
        stringArray[221] = "task";
        stringArray[222] = "put";
        stringArray[223] = "getMachineInfo";
        stringArray[224] = "get";
        stringArray[225] = "zone";
        stringArray[226] = "preemptible";
        stringArray[227] = "spot";
        stringArray[228] = "standard";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "prettyPrint";
        stringArray[231] = "toJson";
        stringArray[232] = "prettyPrint";
        stringArray[233] = "toJson";
        stringArray[234] = "CMD_ERRFILE";
        stringArray[235] = "CMD_OUTFILE";
        stringArray[236] = "CMD_LOG";
        stringArray[237] = "CMD_EXIT";
        stringArray[238] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[239];
        GooglePipelinesTaskHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GooglePipelinesTaskHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GooglePipelinesTaskHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

