/*
 * Decompiled with CFR 0.152.
 */
package nextflow.file.http;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import nextflow.SysEnv;
import nextflow.extension.Bolts;
import nextflow.file.http.XAuthRegistry;
import nextflow.file.http.XFileAttributes;
import nextflow.file.http.XFileSystem;
import nextflow.file.http.XPath;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.ftp.FtpURLConnection;

abstract class XFileSystemProvider
extends FileSystemProvider
implements GroovyObject {
    private Map<URI, FileSystem> fileSystemMap;
    public static final Set<String> ALL_SCHEMES;
    public static final String DEFAULT_RETRY_CODES = "404,410";
    public static final int MAX_REDIRECT_HOPS = 5;
    public static final int DEFAULT_BACK_OFF_BASE = 3;
    public static final int DEFAULT_BACK_OFF_DELAY = 250;
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private int maxAttempts;
    private int backOffBase;
    private int backOffDelay;
    private List<Integer> retryCodes;
    private Map<String, String> env;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public XFileSystemProvider() {
        MetaClass metaClass;
        Map map;
        int n;
        int n2;
        int n3;
        LinkedHashMap<URI, FileSystem> linkedHashMap = new LinkedHashMap<URI, FileSystem>(20);
        this.fileSystemMap = linkedHashMap;
        this.maxAttempts = n3 = DEFAULT_MAX_ATTEMPTS;
        this.backOffBase = n2 = DEFAULT_BACK_OFF_BASE;
        this.backOffDelay = n = DEFAULT_BACK_OFF_DELAY;
        this.env = map = SysEnv.get();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Integer n4 = (Integer)ScriptBytecodeAdapter.asType((Object)this.config("NXF_HTTPFS_MAX_ATTEMPTS", DEFAULT_MAX_ATTEMPTS), Integer.class);
        this.maxAttempts = n4;
        Integer n5 = (Integer)ScriptBytecodeAdapter.asType((Object)this.config("NXF_HTTPFS_BACKOFF_BASE", DEFAULT_BACK_OFF_BASE), Integer.class);
        this.backOffBase = n5;
        Integer n6 = (Integer)ScriptBytecodeAdapter.asType((Object)this.config("NXF_HTTPFS_DELAY", DEFAULT_BACK_OFF_DELAY), Integer.class);
        this.backOffDelay = n6;
        Object object = this.config("NXF_HTTPFS_RETRY_CODES", DEFAULT_RETRY_CODES);
        String string = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
        List list = string != null ? StringGroovyMethods.tokenize((CharSequence)string, (CharSequence)",") : null;
        List list2 = list != null ? DefaultGroovyMethods.collect((Iterable)list, (Closure)new _closure1(this, this)) : null;
        this.retryCodes = list2;
    }

    protected int maxAttempts() {
        return this.maxAttempts;
    }

    protected int backOffBase() {
        return this.backOffBase;
    }

    protected int backOffDelay() {
        return this.backOffDelay;
    }

    protected List<Integer> retryCodes() {
        return this.retryCodes;
    }

    protected Object config(String name, Object defValue) {
        return this.env.containsKey(name) ? this.env.get(name) : defValue;
    }

    private static URI key(String s, String a) {
        return new URI(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{s, a}, new String[]{"", "://", ""})));
    }

    private static URI key(URI uri) {
        String base = uri.getAuthority();
        int p = base.indexOf("@");
        if (p == -1) {
            return XFileSystemProvider.key(uri.getScheme().toLowerCase(), base.toLowerCase());
        }
        String user = base.substring(0, p);
        String host = base.substring(p);
        return XFileSystemProvider.key(uri.getScheme().toLowerCase(), StringGroovyMethods.plus((String)user, (CharSequence)host.toLowerCase()));
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        String scheme = uri.getScheme().toLowerCase();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)scheme, (Object)this.getScheme())) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase(), scheme}, new String[]{"Not a valid ", " scheme: ", ""})));
        }
        URI base = XFileSystemProvider.key(uri);
        if (this.fileSystemMap.containsKey(base)) {
            throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{base}, new String[]{"File system `", "` already exists"})));
        }
        return new XFileSystem(this, base);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.getFileSystem(uri, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileSystem getFileSystem(URI uri, boolean canCreate) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Map<URI, FileSystem> map = this.fileSystemMap;
            valueRecorder.record(map, 8);
            valueRecorder.record(map, 8);
            if (map != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert fileSystemMap != null", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        String scheme = uri.getScheme().toLowerCase();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)scheme, (Object)this.getScheme())) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase(), scheme}, new String[]{"Not a valid ", " scheme: ", ""})));
        }
        URI key = XFileSystemProvider.key(uri);
        if (!canCreate) {
            FileSystem result = (FileSystem)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.fileSystemMap, (Object)key), FileSystem.class);
            if (!(result == null)) return result;
            throw (Throwable)new FileSystemNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"File system not found: ", ""})));
        }
        Map<URI, FileSystem> map = this.fileSystemMap;
        synchronized (map) {
            FileSystem fileSystem2;
            FileSystem result = (FileSystem)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.fileSystemMap, (Object)key), FileSystem.class);
            if (!(result == null)) return result;
            result = fileSystem2 = this.newFileSystem(uri, Collections.emptyMap());
            FileSystem fileSystem3 = result;
            ScriptBytecodeAdapter.invokeMethodN(XFileSystemProvider.class, this.fileSystemMap, (String)"putAt", (Object[])new Object[]{key, fileSystem3});
            return result;
        }
    }

    @Override
    public Path getPath(URI uri) {
        String path = uri.getPath();
        if (!path.contains("?") && DefaultTypeTransformation.booleanUnbox((Object)uri.getQuery())) {
            String string;
            path = string = StringGroovyMethods.plus((String)path, (CharSequence)StringGroovyMethods.plus((String)"?", (CharSequence)uri.getQuery()));
        }
        return this.getFileSystem(uri, true).getPath(path, new String[0]);
    }

    protected String auth(String userInfo) {
        String BEARER = "x-oauth-bearer:";
        int p = userInfo.indexOf(BEARER);
        if (p != -1) {
            String token = userInfo.substring(BEARER.length());
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{token}, new String[]{"Bearer ", ""}));
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{EncodingGroovyMethods.encodeBase64((byte[])userInfo.getBytes())}, new String[]{"Basic ", ""}));
    }

    protected URLConnection toConnection(Path path) {
        Object v0;
        URL url = path.toUri().toURL();
        if (log.isTraceEnabled()) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{url}, new String[]{"File remote URL: ", ""}));
            v0 = null;
        } else {
            v0 = null;
        }
        return this.toConnection0(url, 0);
    }

    /*
     * Unable to fully structure code
     */
    protected URLConnection toConnection0(URL url, int attempt) {
        conn = url.openConnection();
        conn.setRequestProperty("User-Agent", "Nextflow/httpfs");
        if (DefaultTypeTransformation.booleanUnbox((Object)url.getUserInfo())) {
            conn.setRequestProperty("Authorization", this.auth(url.getUserInfo()));
        } else {
            XAuthRegistry.getInstance().authorize(conn);
        }
        if (!(conn instanceof HttpURLConnection)) ** GOTO lbl-1000
        if (ScriptBytecodeAdapter.createList((Object[])new Object[]{307, 308}) == null) {
            ((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode();
            v0 = false;
        } else {
            v0 = DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{307, 308}), (Object)((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode());
        }
        if (v0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1 != false && attempt < XFileSystemProvider.MAX_REDIRECT_HOPS != false) {
            header = conn.getHeaderFields();
            var5_5 = header.get("Location");
            location = ShortTypeHandling.castToString(var5_5 != null ? var5_5.get(0) : null);
            newPath = new URI(location).toURL();
            if (XFileSystemProvider.log.isDebugEnabled()) {
                XFileSystemProvider.log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{newPath}, new String[]{"Remote redirect URL: ", ""})));
                v2 = null;
            } else {
                v2 = null;
            }
            return this.toConnection0(newPath, attempt + 1);
        }
        if (!(conn instanceof HttpURLConnection)) ** GOTO lbl-1000
        if (this.retryCodes == null) {
            ((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode();
            v3 = false;
        } else {
            v3 = DefaultGroovyMethods.isCase(this.retryCodes, (Object)((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode());
        }
        if (v3) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        if (v4 != false && attempt < this.maxAttempts != false) {
            delay = (long)Math.pow(this.backOffBase, attempt) * (long)this.backOffDelay;
            if (XFileSystemProvider.log.isDebugEnabled()) {
                XFileSystemProvider.log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode(), delay, attempt + 1}, new String[]{"Got HTTP error=", " waiting for ", "ms (attempt=", ")"})));
                v5 = null;
            } else {
                v5 = null;
            }
            Thread.sleep(delay);
            return this.toConnection0(url, attempt + 1);
        }
        return conn;
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (ScriptBytecodeAdapter.compareNotEqual(path.getClass(), XPath.class)) {
            throw (Throwable)new ProviderMismatchException();
        }
        if (options.size() > 0) {
            Set<? extends OpenOption> set = options;
            Iterator<? extends OpenOption> iterator = set != null ? set.iterator() : null;
            OpenOption opt = null;
            Iterator<? extends OpenOption> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    opt = (OpenOption)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), OpenOption.class);
                    if (!(ScriptBytecodeAdapter.compareEqual((Object)opt, (Object)StandardOpenOption.APPEND) || ScriptBytecodeAdapter.compareEqual((Object)opt, (Object)StandardOpenOption.WRITE))) continue;
                    throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{opt}, new String[]{"'", "' not allowed"})));
                }
            }
        }
        URLConnection conn = this.toConnection(path);
        Reference stream = new Reference((Object)new BufferedInputStream(conn.getInputStream()));
        return new SeekableByteChannel(this, stream){
            public /* synthetic */ Reference stream;
            private long _position;
            final /* synthetic */ XFileSystemProvider this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                XFileSystemProvider xFileSystemProvider;
                this.this$0 = xFileSystemProvider = p0;
                this.stream = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public int read(ByteBuffer buffer) throws IOException {
                data = 0;
                len = 0;
                while (true) {
                    if (!(len < buffer.capacity())) ** GOTO lbl-1000
                    data = var4_4 = ((BufferedInputStream)this.stream.get()).read();
                    if (var4_4 != -1) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) break;
                    buffer.put((byte)data);
                    var5_5 = len;
                    var5_5 + 1;
                }
                this._position = this._position + (long)len;
                var6_6 = len;
                return var6_6 != 0 != false ? var6_6 : -1;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw (Throwable)new UnsupportedOperationException("Write operation not supported");
            }

            @Override
            public long position() throws IOException {
                return this._position;
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                throw (Throwable)new UnsupportedOperationException("Position operation not supported");
            }

            @Override
            public long size() throws IOException {
                return 8192;
            }

            @Override
            public SeekableByteChannel truncate(long unused) throws IOException {
                throw (Throwable)new UnsupportedOperationException("Truncate operation not supported");
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
                ((BufferedInputStream)this.stream.get()).close();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                this.this$0.this$dist$set$2(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, XFileSystemProvider.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        if (ScriptBytecodeAdapter.compareNotEqual(path.getClass(), XPath.class)) {
            throw (Throwable)new ProviderMismatchException();
        }
        if (options.length > 0) {
            OpenOption opt2 = null;
            OpenOption[] openOptionArray = options;
            if (options != null) {
                for (OpenOption opt2 : openOptionArray) {
                    if (!(ScriptBytecodeAdapter.compareEqual((Object)opt2, (Object)StandardOpenOption.APPEND) || ScriptBytecodeAdapter.compareEqual((Object)opt2, (Object)StandardOpenOption.WRITE))) continue;
                    throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{opt2}, new String[]{"'", "' not allowed"})));
                }
            }
        }
        return this.toConnection(path).getInputStream();
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Write not supported by ", " file system provider"})));
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Direcotry listing unsupported by ", " file system provider"})));
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Create directory not supported by ", " file system provider"})));
    }

    @Override
    public void delete(Path path) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Delete not supported by ", " file system provider"})));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Copy not supported by ", " file system provider"})));
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Move not supported by ", " file system provider"})));
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return ScriptBytecodeAdapter.compareEqual((Object)path, (Object)path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return path.getFileName().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"File store not supported by ", " file system provider"})));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.readAttributes(path, XFileAttributes.class, new LinkOption[0]);
        AccessMode m2 = null;
        AccessMode[] accessModeArray = modes;
        if (modes != null) {
            for (AccessMode m2 : accessModeArray) {
                if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)m2), (Object)((Object)AccessMode.WRITE))) continue;
                throw (Throwable)new AccessDeniedException("Write mode not supported");
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return (V)((FileAttributeView)ScriptBytecodeAdapter.castToType(null, FileAttributeView.class));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (ScriptBytecodeAdapter.compareEqual(type, BasicFileAttributes.class) || ScriptBytecodeAdapter.compareEqual(type, XFileAttributes.class)) {
            XPath p = (XPath)ScriptBytecodeAdapter.castToType((Object)path, XPath.class);
            BasicFileAttributes attrs = this.readHttpAttributes(p);
            if (attrs == null) {
                throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{p.toString()}, new String[]{"Unable to access path: ", ""})));
            }
            return (A)attrs;
        }
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase(), type}, new String[]{"Not a valid ", " file attribute type: ", ""})));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Read file attributes not supported by ", " file system provider"})));
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getScheme().toUpperCase()}, new String[]{"Set file attributes not supported by ", " file system provider"})));
    }

    /*
     * Unable to fully structure code
     */
    protected XFileAttributes readHttpAttributes(XPath path) {
        conn = this.toConnection(path);
        if (conn instanceof FtpURLConnection) {
            return new XFileAttributes(null, -1);
        }
        if (!(conn instanceof HttpURLConnection)) ** GOTO lbl-1000
        if (ScriptBytecodeAdapter.createList((Object[])new Object[]{200, 301, 302, 307, 308}) == null) {
            ((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode();
            v0 = false;
        } else {
            v0 = DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{200, 301, 302, 307, 308}), (Object)((HttpURLConnection)ScriptBytecodeAdapter.castToType((Object)conn, HttpURLConnection.class)).getResponseCode());
        }
        if (v0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1) {
            header = conn.getHeaderFields();
            return this.readHttpAttributes(header);
        }
        return (XFileAttributes)ScriptBytecodeAdapter.castToType(null, XFileAttributes.class);
    }

    protected XFileAttributes readHttpAttributes(Map<String, List<String>> header) {
        List<String> list = header.get("Last-Modified");
        String lastMod = ShortTypeHandling.castToString(list != null ? list.get(0) : null);
        List<String> list2 = header.get("Content-Length");
        String string = list2 != null ? list2.get(0) : null;
        Long l = string != null ? StringGroovyMethods.toLong((CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)string, CharSequence.class))) : null;
        long contentLen = DefaultTypeTransformation.booleanUnbox(l) ? l : (Long)ScriptBytecodeAdapter.castToType((Object)-1, Long.class);
        SimpleDateFormat dateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        FileTime modTime = DefaultTypeTransformation.booleanUnbox((Object)lastMod) ? FileTime.from(dateFormat.parse(lastMod).getTime(), TimeUnit.MILLISECONDS) : null;
        return new XFileAttributes(modTime, contentLen);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(XFileSystemProvider.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != XFileSystemProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        Set set;
        ALL_SCHEMES = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"ftp", "http", "https"}), Set.class);
        log = logger = LoggerFactory.getLogger((String)"nextflow.file.http.XFileSystemProvider");
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Integer doCall(Object val) {
            return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)val, Integer.TYPE));
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

