/*
 * Decompiled with CFR 0.152.
 */
package nextflow.executor;

import groovy.lang.Closure;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Map;
import java.util.UUID;
import nextflow.Const;
import nextflow.Session;
import nextflow.cloud.CloudConfig;
import nextflow.daemon.IgGridFactory;
import nextflow.executor.IgBaseTask;
import nextflow.processor.TaskId;
import nextflow.processor.TaskPollingMonitor;
import nextflow.scheduler.Autoscaler;
import nextflow.scheduler.Protocol;
import nextflow.scheduler.Scheduler;
import nextflow.scheduler.SchedulerAgent;
import nextflow.util.ClusterConfig;
import nextflow.util.RemoteSession;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterGroup;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgConnector
implements GroovyObject {
    private final TaskPollingMonitor monitor;
    private final Session session;
    private Ignite grid;
    private IgniteCache<UUID, RemoteSession> allSessions;
    private volatile SchedulerAgent agent;
    @Delegate
    private Scheduler scheduler;
    private static final transient Logger log;
    private static final Closure memoizedMethodClosure$createTaskPollingMonitor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private IgConnector(TaskPollingMonitor monitor) {
        Session session;
        TaskPollingMonitor taskPollingMonitor;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        log.debug("Create Ignite master node");
        this.monitor = taskPollingMonitor = monitor;
        this.session = session = monitor.getSession();
        this.initialize();
    }

    public static IgConnector create(TaskPollingMonitor monitor) {
        return (IgConnector)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$createTaskPollingMonitor.call((Object)monitor), IgConnector.class);
    }

    private void initialize() {
        SchedulerAgent schedulerAgent;
        Scheduler scheduler;
        Object v0;
        IgniteCache igniteCache;
        Ignite ignite;
        Map map = this.session.getConfig();
        IgGridFactory factory = new IgGridFactory(Const.ROLE_MASTER, DefaultTypeTransformation.booleanUnbox((Object)map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        this.grid = ignite = factory.start();
        this.allSessions = igniteCache = this.grid.cache(IgGridFactory.SESSIONS_CACHE);
        this.allSessions.put((Object)this.session.getUniqueId(), (Object)new RemoteSession(this.session));
        ClusterConfig clusterConfig = new ClusterConfig((Map)ScriptBytecodeAdapter.asType(this.session.getConfig().get("cluster"), Map.class), Const.ROLE_MASTER, System.getenv());
        Reference shutdownCluster = new Reference((Object)DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)clusterConfig.getAttribute("shutdownOnComplete", (Object)false), Boolean.TYPE)));
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{(Boolean)shutdownCluster.get()}, new String[]{"Cluster shutdownOnComplete: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        public final class _initialize_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference shutdownCluster;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _initialize_closure1(Object _outerInstance, Object _thisObject, Reference shutdownCluster) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.shutdownCluster = reference = shutdownCluster;
            }

            public Object doCall(Object it) {
                ((IgConnector)this.getThisObject()).allSessions.remove((Object)((IgConnector)this.getThisObject()).session.getUniqueId());
                ((IgConnector)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), IgConnector.class)).shutdown(DefaultTypeTransformation.booleanUnbox((Object)this.shutdownCluster.get()));
                ((IgConnector)this.getThisObject()).grid.close();
                return null;
            }

            public Boolean getShutdownCluster() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.shutdownCluster.get(), Boolean.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initialize_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.monitor.getSession().onShutdown((Closure)new _initialize_closure1(this, this, shutdownCluster));
        UUID masterId = this.grid.cluster().localNode().id();
        this.scheduler = scheduler = new Scheduler().init(this.grid, this.monitor);
        this.agent = schedulerAgent = new SchedulerAgent(this.grid, clusterConfig, masterId).run();
        boolean cloudEnabled = clusterConfig.isCloudCluster();
        if (cloudEnabled) {
            CloudConfig cloudConfig = CloudConfig.create((Map)this.session.getConfig());
            Autoscaler autoscaler = new Autoscaler(this.grid, cloudConfig);
            this.registerAutoscaler(autoscaler);
        }
    }

    public ClusterGroup getCluster() {
        ClusterGroup result = this.grid.cluster().forNodes(this.grid.cluster().nodes());
        return result;
    }

    public void shutdown(boolean killRemoteAgents) {
        block6: {
            log.debug("Shutting down grid nodes");
            try {
                if (killRemoteAgents) {
                    this.shutdownRemoteAgents();
                }
                this.agent.close();
                this.shutdownScheduler();
            }
            catch (Exception e) {
                Object v0;
                if (log.isWarnEnabled()) {
                    String string = e.getMessage();
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)string) ? string : e.toString()}, new String[]{"Unexpected error shutting down Ignite scheduler -- ", ""})));
                    v0 = null;
                    break block6;
                }
                v0 = null;
            }
        }
    }

    @Generated
    private static IgConnector memoizedMethodPriv$createTaskPollingMonitor(TaskPollingMonitor monitor) {
        return new IgConnector(monitor);
    }

    @Generated
    public Scheduler init(Ignite ignite, TaskPollingMonitor monitor) {
        return this.scheduler.init(ignite, monitor);
    }

    @Generated
    public void registerAutoscaler(Autoscaler autoscaler) {
        this.scheduler.registerAutoscaler(autoscaler);
    }

    @Generated
    public void schedule(IgBaseTask ... tasks) {
        this.scheduler.schedule(tasks);
    }

    @Generated
    public boolean checkTaskStarted(TaskId taskId) {
        return this.scheduler.checkTaskStarted(taskId);
    }

    @Generated
    public boolean checkTaskCompleted(TaskId taskId) {
        return this.scheduler.checkTaskCompleted(taskId);
    }

    @Generated
    public boolean checkTaskFailed(TaskId taskId) {
        return this.scheduler.checkTaskFailed(taskId);
    }

    @Generated
    public void cancelTask(TaskId taskId) {
        this.scheduler.cancelTask(taskId);
    }

    @Generated
    public Protocol.TaskHolder removeTaskCompleted(TaskId taskId) {
        return this.scheduler.removeTaskCompleted(taskId);
    }

    @Generated
    public String dumpScheduledTasksStatus() {
        return this.scheduler.dumpScheduledTasksStatus();
    }

    @Generated
    public void shutdownRemoteAgents() {
        this.scheduler.shutdownRemoteAgents();
    }

    @Generated
    public void shutdownScheduler() {
        this.scheduler.shutdownScheduler();
    }

    @Generated
    public void shutdown() {
        this.shutdown(false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IgConnector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Closure closure;
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.executor.IgConnector");
        public final class __clinit__closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(TaskPollingMonitor monitor) {
                return IgConnector.memoizedMethodPriv$createTaskPollingMonitor(monitor);
            }

            public Object call(TaskPollingMonitor monitor) {
                return this.doCall(monitor);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        memoizedMethodClosure$createTaskPollingMonitor = closure = new __clinit__closure2(IgConnector.class, IgConnector.class).memoize();
    }
}

