/*
 * Decompiled with CFR 0.152.
 */
package nextflow.scheduler;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import nextflow.cloud.CloudConfig;
import nextflow.cloud.CloudDriver;
import nextflow.cloud.CloudDriverFactory;
import nextflow.cloud.types.CloudInstanceStatus;
import nextflow.executor.IgBaseTask;
import nextflow.processor.TaskId;
import nextflow.scheduler.Protocol;
import nextflow.util.Duration;
import org.apache.ignite.Ignite;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Autoscaler
implements Closeable,
GroovyObject {
    private String driverName;
    private CloudDriver driver;
    private Ignite ignite;
    private Map<UUID, Protocol.NodeData> workerNodes;
    private Map<TaskId, Protocol.TaskHolder> scheduledTasks;
    private ScheduledExecutorService watchdog;
    private CloudConfig.Autoscale scalerConfig;
    private volatile boolean enabled;
    private volatile Queue<String> pendingInstanceIds;
    private Map<List, Byte> canRunTaskCache;
    private long waitingTimestamp;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Autoscaler(Ignite ignite, CloudConfig config) {
        MetaClass metaClass;
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(HashMap.class);
        this.canRunTaskCache = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Ignite ignite2 = ignite;
        this.ignite = (Ignite)ScriptBytecodeAdapter.castToType((Object)ignite2, Ignite.class);
        Object object2 = callSiteArray[1].call((Object)config);
        this.scalerConfig = (CloudConfig.Autoscale)ScriptBytecodeAdapter.castToType((Object)object2, CloudConfig.Autoscale.class);
        Object object3 = callSiteArray[2].call((Object)config);
        this.driverName = ShortTypeHandling.castToString((Object)object3);
        Object object4 = callSiteArray[3].callGroovyObjectGetProperty((Object)this.scalerConfig);
        this.enabled = DefaultTypeTransformation.booleanUnbox((Object)object4);
        Object object5 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call((Object)log)) ? callSiteArray[5].call((Object)log, (Object)new GStringImpl(new Object[]{this.enabled}, new String[]{"### Auto-scaling enabled: ", ""})) : null;
    }

    protected Autoscaler() {
        MetaClass metaClass;
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object object = callSiteArray[6].callConstructor(HashMap.class);
        this.canRunTaskCache = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    void init(Map<UUID, Protocol.NodeData> nodes, Map<TaskId, Protocol.TaskHolder> tasks) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Map<UUID, Protocol.NodeData> map = nodes;
        this.workerNodes = (Map)ScriptBytecodeAdapter.castToType(map, Map.class);
        Map<TaskId, Protocol.TaskHolder> map2 = tasks;
        this.scheduledTasks = (Map)ScriptBytecodeAdapter.castToType(map2, Map.class);
        if (this.enabled) {
            String string = this.driverName;
            String driverName = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : callSiteArray[7].call(CloudDriverFactory.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)driverName)) {
                throw (Throwable)callSiteArray[8].callConstructor(IllegalStateException.class, (Object)"No cloud driver name has been specified");
            }
            Object object = callSiteArray[9].call(CloudDriverFactory.class, (Object)driverName);
            this.driver = (CloudDriver)ScriptBytecodeAdapter.castToType((Object)object, CloudDriver.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.driver)) {
                throw (Throwable)callSiteArray[10].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{driverName}, new String[]{"Cannot load cloud driver: `", "`"}));
            }
            callSiteArray[11].call((Object)this.driver, (Object)this.scalerConfig);
        }
        Object object = callSiteArray[12].call(Executors.class, (Object)1);
        this.watchdog = (ScheduledExecutorService)ScriptBytecodeAdapter.castToType((Object)object, ScheduledExecutorService.class);
        callSiteArray[13].call((Object)this.watchdog, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Runnable)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"clusterWatchdog"), Runnable.class)), Runnable.class), (Object)1, (Object)1, callSiteArray[14].callGetProperty(TimeUnit.class));
    }

    void onNodeStart(Protocol.NodeData data) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(this.pendingInstanceIds)) {
            return;
        }
        Object found = callSiteArray[15].call(this.pendingInstanceIds, callSiteArray[16].callGetProperty((Object)data));
        if (DefaultTypeTransformation.booleanUnbox((Object)found)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)log)) ? callSiteArray[18].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[19].callGetProperty((Object)data), callSiteArray[20].callGetProperty((Object)data), callSiteArray[21].call(this.pendingInstanceIds)}, new String[]{"### Autoscale node joined the cluster [", "] instance-id=", " -- Still missing ", " instances"})) : null;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call(this.pendingInstanceIds))) {
                boolean bl;
                this.enabled = bl = true;
            }
        }
    }

    void clusterWatchdog() {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            try {
                callSiteArray[23].callCurrent((GroovyObject)this);
                callSiteArray[24].callCurrent((GroovyObject)this);
                callSiteArray[25].callCurrent((GroovyObject)this);
                callSiteArray[26].callCurrent((GroovyObject)this);
            }
            catch (InterruptedException e) {
                callSiteArray[27].call((Object)log, (Object)"Shutdown in progress [InterruptedException]");
            }
            catch (Throwable e) {
                callSiteArray[28].call((Object)log, (Object)"### Oops.. Something went wrong", (Object)e);
            }
        } else {
            try {
                this.checkClusterSize();
                this.checkStarvingTasks();
                this.checkIdleNodes();
                this.checkPendingInstances();
            }
            catch (InterruptedException e) {
                callSiteArray[29].call((Object)log, (Object)"Shutdown in progress [InterruptedException]");
            }
            catch (Throwable e) {
                callSiteArray[30].call((Object)log, (Object)"### Oops.. Something went wrong", (Object)e);
            }
        }
    }

    int getClusterSize() {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[31].call(this.workerNodes));
    }

    void checkClusterSize() {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        if (!this.enabled) {
            return;
        }
        Object currentSize = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            currentSize = object = callSiteArray[32].callCurrent((GroovyObject)this);
        } else {
            int n = this.getClusterSize();
            currentSize = n;
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)currentSize, (Object)callSiteArray[33].callGroovyObjectGetProperty((Object)this.scalerConfig))) {
            Object missingInstances = callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this.scalerConfig), currentSize);
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call((Object)log)) ? callSiteArray[37].call((Object)log, (Object)new GStringImpl(new Object[]{missingInstances, currentSize, callSiteArray[38].callGroovyObjectGetProperty((Object)this.scalerConfig)}, new String[]{"### Adding ", " instance(s) to cloud cluster -- current-size: ", "; min-size: ", "; "})) : null;
            callSiteArray[39].callCurrent((GroovyObject)this, missingInstances);
        }
    }

    void checkStarvingTasks() {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object timeout = callSiteArray[40].callGroovyObjectGetProperty((Object)this.scalerConfig);
        Object type = callSiteArray[41].callGroovyObjectGetProperty((Object)this.scalerConfig);
        public final class _checkStarvingTasks_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkStarvingTasks_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _checkStarvingTasks_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _checkStarvingTasks_closure1.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _checkStarvingTasks_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkStarvingTasks_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "started";
                return new CallSiteArray(_checkStarvingTasks_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkStarvingTasks_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Collection waiting = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(callSiteArray[43].call(this.scheduledTasks), (Object)new _checkStarvingTasks_closure1(this, this)), Collection.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)waiting)) {
            callSiteArray[44].call((Object)log, (Object)"### No tasks waiting for execution");
            int n = 0;
            this.waitingTimestamp = n;
            return;
        }
        if (!(this.waitingTimestamp != 0L)) {
            Object object = callSiteArray[45].call(System.class);
            this.waitingTimestamp = DefaultTypeTransformation.longUnbox((Object)object);
        }
        Object delta = callSiteArray[46].call(callSiteArray[47].call(System.class), (Object)this.waitingTimestamp);
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)log)) ? callSiteArray[49].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[50].call((Object)waiting), callSiteArray[51].call(Duration.class, delta), timeout}, new String[]{"### Tasks waiting for execution: count=", "; delta=", "; timeout=", ""})) : null;
        if (ScriptBytecodeAdapter.compareLessThan((Object)delta, (Object)callSiteArray[52].callGetProperty(timeout))) {
            return;
        }
        List tasks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        int missingCpus = 0;
        Object itr = callSiteArray[53].call((Object)waiting);
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].call(itr))) {
            Object it = callSiteArray[55].call(itr);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call(it, timeout))) {
                callSiteArray[57].callCurrent((GroovyObject)this, callSiteArray[58].callGetProperty(it));
            }
            Boolean result = this.enabled && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callCurrent((GroovyObject)this, callSiteArray[60].callGetProperty(it), type));
            if (!DefaultTypeTransformation.booleanUnbox((Object)result)) continue;
            missingCpus = DefaultTypeTransformation.intUnbox((Object)callSiteArray[61].call((Object)missingCpus, callSiteArray[62].callGetProperty(callSiteArray[63].call(callSiteArray[64].callGetProperty(it)))));
            callSiteArray[65].call((Object)tasks, callSiteArray[66].callGetProperty(callSiteArray[67].callGetProperty(it)));
        }
        callSiteArray[68].call(this.canRunTaskCache);
        if (DefaultTypeTransformation.booleanUnbox((Object)missingCpus) && this.enabled) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[69].call((Object)log)) ? callSiteArray[70].call((Object)log, (Object)new GStringImpl(new Object[]{timeout, missingCpus, callSiteArray[71].call((Object)tasks, (Object)",")}, new String[]{"### The following tasks have been waiting for more than ", " -- required cpus=", "; taskIds=", ""})) : null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[72].callCurrent((GroovyObject)this, (Object)missingCpus);
            } else {
                this.requestNewCpus(missingCpus);
            }
        }
    }

    void requestNewCpus(int cpus) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object type = callSiteArray[73].call((Object)this.driver, callSiteArray[74].callGroovyObjectGetProperty((Object)this.scalerConfig));
        if (!DefaultTypeTransformation.booleanUnbox((Object)type)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].call((Object)log)) ? callSiteArray[76].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[77].callGroovyObjectGetProperty((Object)this.scalerConfig)}, new String[]{"### Can't find a instance type description: ", ""})) : null;
            return;
        }
        Integer nodeNeeded = DefaultTypeTransformation.intUnbox((Object)callSiteArray[78].call(Math.class, callSiteArray[79].call((Object)cpus, callSiteArray[80].callGetProperty(type))));
        Object currentSize = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            currentSize = object = callSiteArray[81].callCurrent((GroovyObject)this);
        } else {
            int n = this.getClusterSize();
            currentSize = n;
        }
        Object maxSize = callSiteArray[82].call((Object)this.scalerConfig);
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)currentSize, (Object)maxSize)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[83].call((Object)log)) ? callSiteArray[84].call((Object)log, (Object)new GStringImpl(new Object[]{cpus, nodeNeeded, currentSize, maxSize}, new String[]{"### Can't grow the cluster more, current size reached the cluster limit -- missing-cpus: ", "; node-needed: ", "; current-size: ", "; max-size: ", ""})) : null;
            return;
        }
        Object num = callSiteArray[85].call(Math.class, (Object)nodeNeeded, callSiteArray[86].call(maxSize, currentSize));
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)log)) ? callSiteArray[88].call((Object)log, (Object)new GStringImpl(new Object[]{num, type, cpus, nodeNeeded, currentSize, maxSize}, new String[]{"### Requesting ", " instance(s) of type: ", " -- missing-cpus: ", "; node-needed: ", "; current-size: ", "; max-size: ", ""})) : null;
        callSiteArray[89].callCurrent((GroovyObject)this, num);
    }

    void requestNewInstances(int num) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object ids = callSiteArray[90].call((Object)this.driver, (Object)num, (Object)this.scalerConfig);
        boolean bl = false;
        this.enabled = DefaultTypeTransformation.booleanUnbox((Object)bl);
        Object object = callSiteArray[91].callConstructor(ConcurrentLinkedQueue.class, ids);
        this.pendingInstanceIds = (Queue)ScriptBytecodeAdapter.castToType((Object)object, Queue.class);
        callSiteArray[92].call((Object)this.driver, ids, callSiteArray[93].callGetProperty(CloudInstanceStatus.class));
        callSiteArray[94].call((Object)this.driver, ids, (Object)this.scalerConfig);
    }

    boolean canRunOnNewInstance(IgBaseTask task, String instanceType) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object taskId = callSiteArray[95].call((Object)task);
        Object req = callSiteArray[96].call((Object)task);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[97].callGetProperty(req), (Object)1) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[98].callGetProperty(req)) : ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[99].callGetProperty(req), (Object)1) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[100].callGetProperty(req))) {
            return true;
        }
        Object total = callSiteArray[101].call((Object)this.driver, (Object)instanceType);
        if (!DefaultTypeTransformation.booleanUnbox((Object)total)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[102].call((Object)log)) ? callSiteArray[103].call((Object)log, (Object)new GStringImpl(new Object[]{instanceType}, new String[]{"### Unknown instance type: ", ""})) : null;
            return false;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[104].callGetProperty(req), (Object)callSiteArray[105].callGetProperty(total))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[106].call((Object)log)) ? callSiteArray[107].call((Object)log, (Object)new GStringImpl(new Object[]{taskId, instanceType, callSiteArray[108].callGetProperty(req), callSiteArray[109].callGetProperty(total)}, new String[]{"### Task (id=", ") exceed the number of CPUs provided by autoscaling instance type: ", " -- req: ", "; provided: ", ""})) : null;
            return false;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[110].callGetProperty(req)) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[111].callGetProperty(req), (Object)callSiteArray[112].callGetProperty(total))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].call((Object)log)) ? callSiteArray[114].call((Object)log, (Object)new GStringImpl(new Object[]{taskId, instanceType, callSiteArray[115].callGetProperty(req), callSiteArray[116].callGetProperty(total)}, new String[]{"### Task (id=", ") exceed the amount of memory provided by autoscaling instance type: ", " -- req: ", "; provided: ", ""})) : null;
            return false;
        }
        return true;
    }

    byte canRunOnExistingNodes(IgBaseTask task) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object taskId = callSiteArray[117].call((Object)task);
        Object req = callSiteArray[118].call((Object)task);
        List key = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[119].callGetProperty(req), callSiteArray[120].callGetProperty(req)});
        Object found = callSiteArray[121].call(this.canRunTaskCache, (Object)key);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)found, null)) {
            return DefaultTypeTransformation.byteUnbox((Object)found);
        }
        Boolean overflow = true;
        Boolean fulfil = false;
        try {
            Object itr = callSiteArray[122].call(callSiteArray[123].call(this.workerNodes));
            while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[124].call(itr))) {
                Object node = callSiteArray[125].call(itr);
                Object total = callSiteArray[126].callGetProperty(node);
                if (ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[127].callGetProperty(req), (Object)callSiteArray[128].callGetProperty(total)) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].callGetProperty(req)) || ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[130].callGetProperty(req), (Object)callSiteArray[131].callGetProperty(total)))) {
                    boolean bl = false;
                    overflow = bl;
                }
                Object free = callSiteArray[132].callGetProperty(node);
                if (!(DefaultTypeTransformation.booleanUnbox((Object)free) && ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[133].callGetProperty(req), (Object)callSiteArray[134].callGetProperty(free)) && (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[135].callGetProperty(req)) || ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[136].callGetProperty(req), (Object)callSiteArray[137].callGetProperty(free))))) continue;
                boolean bl = true;
                fulfil = bl;
            }
        }
        catch (Exception e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[138].call((Object)log)) ? callSiteArray[139].call((Object)log, (Object)new GStringImpl(new Object[]{taskId}, new String[]{"### Oops.. Cannot establish resources availability: taskId=", ""}), (Object)e) : null;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)overflow)) {
            Object object;
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[140].call((Object)log)) ? callSiteArray[141].call((Object)log, (Object)new GStringImpl(new Object[]{taskId, callSiteArray[142].callGetProperty(req), DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[143].callGetProperty(req))) ? object : "-"}, new String[]{"### Task (id=", ") requests an amount of resources not available in any node in the current cluster topology -- CPUs: ", "; memory: ", ""})) : null;
        }
        byte result = DefaultTypeTransformation.byteUnbox((Object)(DefaultTypeTransformation.booleanUnbox((Object)fulfil) ? Integer.valueOf(1) : Integer.valueOf(DefaultTypeTransformation.booleanUnbox((Object)overflow) ? 2 : 0)));
        callSiteArray[144].call(this.canRunTaskCache, (Object)key, (Object)result);
        return result;
    }

    Object getLocalNodeId() {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        return callSiteArray[145].call(callSiteArray[146].call(callSiteArray[147].call((Object)this.ignite)));
    }

    void checkIdleNodes() {
        Object object;
        Object object2;
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !this.enabled || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[148].callGroovyObjectGetProperty((Object)this.scalerConfig)) : !this.enabled || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[149].callGroovyObjectGetProperty((Object)this.scalerConfig))) {
            return;
        }
        Object timeout = callSiteArray[150].call((Object)this.scalerConfig);
        List idleNodeIds = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object itr = callSiteArray[151].call(callSiteArray[152].call(this.workerNodes));
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[153].call(itr))) {
            Object node = callSiteArray[154].call(itr);
            try {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[155].call(node, timeout))) continue;
                Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].call((Object)log)) ? callSiteArray[157].call((Object)log, (Object)new GStringImpl(new Object[]{node}, new String[]{"### Idle node detected: ", ""})) : null;
                callSiteArray[158].call((Object)idleNodeIds, callSiteArray[159].callGetProperty(node));
            }
            catch (Exception e) {
                Object object4;
                Object object5 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[160].call((Object)log)) ? callSiteArray[161].call((Object)log, (Object)new GStringImpl(new Object[]{node, DefaultTypeTransformation.booleanUnbox((Object)(object4 = callSiteArray[162].callGetProperty((Object)e))) ? object4 : e}, new String[]{"### Oops.. Failed to check idle node info: ", " -- Cause: ", ""})) : null;
            }
        }
        Object local = null;
        local = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[163].callCurrent((GroovyObject)this)) : (object = this.getLocalNodeId());
        callSiteArray[164].call((Object)idleNodeIds, local);
        if (!DefaultTypeTransformation.booleanUnbox((Object)idleNodeIds)) {
            return;
        }
        Object killList = callSiteArray[165].callCurrent((GroovyObject)this, (Object)idleNodeIds);
        if (DefaultTypeTransformation.booleanUnbox((Object)killList)) {
            callSiteArray[166].callCurrent((GroovyObject)this, killList);
        }
    }

    List<String> applyTerminationPolicy(Collection<UUID> idleNodeIds) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object killList = callSiteArray[167].callConstructor(ArrayList.class, callSiteArray[168].call(idleNodeIds));
        Object itr = callSiteArray[169].call(idleNodeIds);
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[170].call(itr))) {
            Object nodeId = callSiteArray[171].call(itr);
            Object data = callSiteArray[172].call(this.workerNodes, nodeId);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[173].callGetProperty(data))) {
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[174].call((Object)log)) ? callSiteArray[175].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[176].callGetProperty(data), nodeId}, new String[]{"### Oops.. Missing cloud instance id for node: [", "] ", " -- Ignore termination request"})) : null;
                continue;
            }
            callSiteArray[177].call(killList, callSiteArray[178].callGetProperty(data));
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)killList, List.class);
    }

    void killNodes(List<String> killList) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        Object instanceIds = callSiteArray[179].callCurrent((GroovyObject)this, killList);
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[180].call((Object)log)) ? callSiteArray[181].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[182].call(instanceIds, (Object)", ")}, new String[]{"### Killing instances: ids=", ""})) : null;
        callSiteArray[183].callCurrent((GroovyObject)this, instanceIds);
    }

    void requestTerminateInstances(List<String> instanceIds) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        callSiteArray[184].call((Object)this.driver, instanceIds);
        callSiteArray[185].call((Object)this.driver, instanceIds, callSiteArray[186].callGetProperty(CloudInstanceStatus.class));
    }

    List<String> ensureMinSize(List<String> killList) {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[187].call(killList), (Object)callSiteArray[188].callGroovyObjectGetProperty((Object)this))) {
            throw (Throwable)callSiteArray[189].callConstructor(IllegalStateException.class, (Object)"Can't kill all cluster nodes");
        }
        int newSize = DefaultTypeTransformation.intUnbox((Object)callSiteArray[190].call(callSiteArray[191].callGroovyObjectGetProperty((Object)this), callSiteArray[192].call(killList)));
        Object delta = callSiteArray[193].call((Object)newSize, callSiteArray[194].callGroovyObjectGetProperty((Object)this.scalerConfig));
        if (ScriptBytecodeAdapter.compareLessThan((Object)delta, (Object)0)) {
            int last = DefaultTypeTransformation.intUnbox((Object)callSiteArray[195].call(delta, (Object)1));
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[196].call(killList, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)last, (boolean)true)), List.class);
        }
        return killList;
    }

    void checkPendingInstances() {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
    }

    @Override
    public void close() throws IOException {
        CallSite[] callSiteArray = Autoscaler.$getCallSiteArray();
        callSiteArray[197].call((Object)this.watchdog);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Autoscaler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = Autoscaler.$getCallSiteArray()[198].call(LoggerFactory.class, (Object)"nextflow.scheduler.Autoscaler");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "getAutoscale";
        stringArray[2] = "getDriverName";
        stringArray[3] = "enabled";
        stringArray[4] = "isDebugEnabled";
        stringArray[5] = "debug";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "getDefaultDriverName";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "getDriver";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "validate";
        stringArray[12] = "newScheduledThreadPool";
        stringArray[13] = "scheduleWithFixedDelay";
        stringArray[14] = "MINUTES";
        stringArray[15] = "remove";
        stringArray[16] = "instanceId";
        stringArray[17] = "isDebugEnabled";
        stringArray[18] = "debug";
        stringArray[19] = "hostName";
        stringArray[20] = "instanceId";
        stringArray[21] = "size";
        stringArray[22] = "isEmpty";
        stringArray[23] = "checkClusterSize";
        stringArray[24] = "checkStarvingTasks";
        stringArray[25] = "checkIdleNodes";
        stringArray[26] = "checkPendingInstances";
        stringArray[27] = "debug";
        stringArray[28] = "debug";
        stringArray[29] = "debug";
        stringArray[30] = "debug";
        stringArray[31] = "size";
        stringArray[32] = "getClusterSize";
        stringArray[33] = "minInstances";
        stringArray[34] = "minus";
        stringArray[35] = "minInstances";
        stringArray[36] = "isDebugEnabled";
        stringArray[37] = "debug";
        stringArray[38] = "minInstances";
        stringArray[39] = "requestNewInstances";
        stringArray[40] = "starvingTimeout";
        stringArray[41] = "instanceType";
        stringArray[42] = "findAll";
        stringArray[43] = "values";
        stringArray[44] = "trace";
        stringArray[45] = "currentTimeMillis";
        stringArray[46] = "minus";
        stringArray[47] = "currentTimeMillis";
        stringArray[48] = "isTraceEnabled";
        stringArray[49] = "trace";
        stringArray[50] = "size";
        stringArray[51] = "of";
        stringArray[52] = "millis";
        stringArray[53] = "iterator";
        stringArray[54] = "hasNext";
        stringArray[55] = "next";
        stringArray[56] = "isWaitingMoreThan";
        stringArray[57] = "canRunOnExistingNodes";
        stringArray[58] = "task";
        stringArray[59] = "canRunOnNewInstance";
        stringArray[60] = "task";
        stringArray[61] = "plus";
        stringArray[62] = "cpus";
        stringArray[63] = "getResources";
        stringArray[64] = "task";
        stringArray[65] = "leftShift";
        stringArray[66] = "taskId";
        stringArray[67] = "task";
        stringArray[68] = "clear";
        stringArray[69] = "isDebugEnabled";
        stringArray[70] = "debug";
        stringArray[71] = "join";
        stringArray[72] = "requestNewCpus";
        stringArray[73] = "describeInstanceType";
        stringArray[74] = "instanceType";
        stringArray[75] = "isWarnEnabled";
        stringArray[76] = "warn";
        stringArray[77] = "instanceType";
        stringArray[78] = "ceil";
        stringArray[79] = "div";
        stringArray[80] = "cpus";
        stringArray[81] = "getClusterSize";
        stringArray[82] = "getMaxInstances";
        stringArray[83] = "isDebugEnabled";
        stringArray[84] = "debug";
        stringArray[85] = "min";
        stringArray[86] = "minus";
        stringArray[87] = "isDebugEnabled";
        stringArray[88] = "debug";
        stringArray[89] = "requestNewInstances";
        stringArray[90] = "launchInstances";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "waitInstanceStatus";
        stringArray[93] = "STARTED";
        stringArray[94] = "tagInstances";
        stringArray[95] = "getTaskId";
        stringArray[96] = "getResources";
        stringArray[97] = "cpus";
        stringArray[98] = "memory";
        stringArray[99] = "cpus";
        stringArray[100] = "memory";
        stringArray[101] = "describeInstanceType";
        stringArray[102] = "isWarnEnabled";
        stringArray[103] = "warn";
        stringArray[104] = "cpus";
        stringArray[105] = "cpus";
        stringArray[106] = "isWarnEnabled";
        stringArray[107] = "warn";
        stringArray[108] = "cpus";
        stringArray[109] = "cpus";
        stringArray[110] = "memory";
        stringArray[111] = "memory";
        stringArray[112] = "memory";
        stringArray[113] = "isWarnEnabled";
        stringArray[114] = "warn";
        stringArray[115] = "memory";
        stringArray[116] = "memory";
        stringArray[117] = "getTaskId";
        stringArray[118] = "getResources";
        stringArray[119] = "cpus";
        stringArray[120] = "memory";
        stringArray[121] = "get";
        stringArray[122] = "iterator";
        stringArray[123] = "values";
        stringArray[124] = "hasNext";
        stringArray[125] = "next";
        stringArray[126] = "resources";
        stringArray[127] = "cpus";
        stringArray[128] = "cpus";
        stringArray[129] = "memory";
        stringArray[130] = "memory";
        stringArray[131] = "memory";
        stringArray[132] = "free";
        stringArray[133] = "cpus";
        stringArray[134] = "cpus";
        stringArray[135] = "memory";
        stringArray[136] = "memory";
        stringArray[137] = "memory";
        stringArray[138] = "isDebugEnabled";
        stringArray[139] = "debug";
        stringArray[140] = "isWarnEnabled";
        stringArray[141] = "warn";
        stringArray[142] = "cpus";
        stringArray[143] = "memory";
        stringArray[144] = "put";
        stringArray[145] = "id";
        stringArray[146] = "localNode";
        stringArray[147] = "cluster";
        stringArray[148] = "terminateWhenIdle";
        stringArray[149] = "terminateWhenIdle";
        stringArray[150] = "getIdleTimeout";
        stringArray[151] = "iterator";
        stringArray[152] = "values";
        stringArray[153] = "hasNext";
        stringArray[154] = "next";
        stringArray[155] = "isIdle";
        stringArray[156] = "isDebugEnabled";
        stringArray[157] = "debug";
        stringArray[158] = "leftShift";
        stringArray[159] = "nodeId";
        stringArray[160] = "isDebugEnabled";
        stringArray[161] = "debug";
        stringArray[162] = "message";
        stringArray[163] = "getLocalNodeId";
        stringArray[164] = "remove";
        stringArray[165] = "applyTerminationPolicy";
        stringArray[166] = "killNodes";
        stringArray[167] = "<$constructor$>";
        stringArray[168] = "size";
        stringArray[169] = "iterator";
        stringArray[170] = "hasNext";
        stringArray[171] = "next";
        stringArray[172] = "get";
        stringArray[173] = "instanceId";
        stringArray[174] = "isDebugEnabled";
        stringArray[175] = "debug";
        stringArray[176] = "hostName";
        stringArray[177] = "leftShift";
        stringArray[178] = "instanceId";
        stringArray[179] = "ensureMinSize";
        stringArray[180] = "isDebugEnabled";
        stringArray[181] = "debug";
        stringArray[182] = "join";
        stringArray[183] = "requestTerminateInstances";
        stringArray[184] = "terminateInstances";
        stringArray[185] = "waitInstanceStatus";
        stringArray[186] = "TERMINATED";
        stringArray[187] = "size";
        stringArray[188] = "clusterSize";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "minus";
        stringArray[191] = "clusterSize";
        stringArray[192] = "size";
        stringArray[193] = "minus";
        stringArray[194] = "minInstances";
        stringArray[195] = "minus";
        stringArray[196] = "getAt";
        stringArray[197] = "shutdownNow";
        stringArray[198] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[199];
        Autoscaler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Autoscaler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Autoscaler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

