/*
 * Decompiled with CFR 0.152.
 */
package nextflow.scheduler;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.cache.CacheException;
import nextflow.cloud.CloudSpotTerminationException;
import nextflow.daemon.IgGridFactory;
import nextflow.executor.IgBaseTask;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.processor.TaskId;
import nextflow.processor.TaskPollingMonitor;
import nextflow.scheduler.Autoscaler;
import nextflow.scheduler.Protocol;
import nextflow.util.ClusterConfig;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements GroovyObject {
    private static final Logger log;
    private Map<TaskId, Protocol.TaskHolder> scheduledTasks;
    private Map<TaskId, Protocol.TaskHolder> completedTasks;
    private IgniteCache<TaskId, IgBaseTask> pendingTasks;
    private Map<UUID, Protocol.NodeData> workerNodes;
    private Ignite ignite;
    private TaskPollingMonitor monitor;
    private BlockingQueue<Closure> messageQueue;
    private Thread messageProcessor;
    private Autoscaler autoscaler;
    private boolean cloudEnabled;
    private long bootTimestamp;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public Scheduler() {
        MetaClass metaClass;
        LinkedBlockingQueue<Closure> linkedBlockingQueue = new LinkedBlockingQueue<Closure>();
        this.messageQueue = linkedBlockingQueue;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Scheduler init(Ignite ignite, TaskPollingMonitor monitor) {
        IgniteCache igniteCache;
        TaskPollingMonitor taskPollingMonitor;
        Ignite ignite2;
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Ignite ignite3 = ignite;
            valueRecorder.record((Object)ignite3, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)ignite3)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert ignite", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            TaskPollingMonitor taskPollingMonitor2 = monitor;
            valueRecorder2.record((Object)taskPollingMonitor2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)taskPollingMonitor2)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert monitor", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        this.ignite = ignite2 = ignite;
        this.monitor = taskPollingMonitor = monitor;
        long l = System.currentTimeMillis();
        this.bootTimestamp = l;
        ConcurrentHashMap<UUID, Protocol.NodeData> concurrentHashMap = new ConcurrentHashMap<UUID, Protocol.NodeData>();
        this.workerNodes = concurrentHashMap;
        ConcurrentHashMap<TaskId, Protocol.TaskHolder> concurrentHashMap2 = new ConcurrentHashMap<TaskId, Protocol.TaskHolder>();
        this.scheduledTasks = concurrentHashMap2;
        ConcurrentHashMap<TaskId, Protocol.TaskHolder> concurrentHashMap3 = new ConcurrentHashMap<TaskId, Protocol.TaskHolder>();
        this.completedTasks = concurrentHashMap3;
        this.pendingTasks = igniteCache = ignite.cache(Protocol.PENDING_TASKS_CACHE);
        this.discoverWorkers();
        this.createEventProcessor();
        this.registerEvents();
        return this;
    }

    public void registerAutoscaler(Autoscaler autoscaler) {
        boolean bl;
        Autoscaler autoscaler2;
        this.autoscaler = autoscaler2 = autoscaler;
        this.autoscaler.init(this.workerNodes, this.scheduledTasks);
        this.cloudEnabled = bl = true;
    }

    private void discoverWorkers() {
        Collection nodes = this.ignite.compute().broadcast((IgniteCallable)new ClusterDiscovery());
        Reference buffer = new Reference((Object)new StringBuilder("+++ Initial cluster topology:\n"));
        public final class _discoverWorkers_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference buffer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _discoverWorkers_closure1(Object _outerInstance, Object _thisObject, Reference buffer) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.buffer = reference = buffer;
            }

            public Object doCall(Object node) {
                Object object = node;
                DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.getProperty("workerNodes"), Map.class)), (Object)((Protocol.NodeData)node).getNodeId(), (Object)object);
                return StringGroovyMethods.leftShift((StringBuilder)StringGroovyMethods.leftShift((StringBuilder)StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.buffer.get(), StringBuilder.class)), (Object)"- "), (Object)((Protocol.NodeData)node).toString()), (Object)"\n");
            }

            public Object getBuffer() {
                return this.buffer.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _discoverWorkers_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Collection)nodes, (Closure)new _discoverWorkers_closure1(this, this, buffer));
        log.debug(((StringBuilder)buffer.get()).toString());
    }

    boolean isRunning() {
        return this.messageProcessor.isAlive();
    }

    private void createEventProcessor() {
        Thread thread;
        public final class _createEventProcessor_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEventProcessor_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object doCall(Object it) {
                while (true) {
                    try {
                        ((Scheduler)this.getThisObject()).messageQueue.take().call();
                        continue;
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    catch (Throwable e) {
                        log.debug("+++ Can't process received message", e);
                        continue;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    break;
                }
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEventProcessor_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.messageProcessor = thread = DefaultGroovyStaticMethods.start(null, (String)"scheduler-thread", (Closure)new _createEventProcessor_closure2(this, this));
    }

    private IgniteBiPredicate<UUID, Object> createMessageDispatcher() {
        public final class _createMessageDispatcher_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createMessageDispatcher_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            /*
             * WARNING - void declaration
             */
            public Object doCall(UUID sender, Object message) {
                void var2_2;
                Reference sender2 = new Reference((Object)sender);
                Reference message2 = new Reference((Object)var2_2);
                public final class _closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference message;
                    private /* synthetic */ Reference sender;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure10(Object _outerInstance, Object _thisObject, Reference message, Reference sender) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.message = reference2 = message;
                        this.sender = reference = sender;
                    }

                    public Object doCall(Object it) {
                        if (this.message.get() instanceof Protocol.TaskStart) {
                            ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onTaskStart((UUID)ScriptBytecodeAdapter.castToType((Object)this.sender.get(), UUID.class), (Protocol.TaskStart)ScriptBytecodeAdapter.castToType((Object)this.message.get(), Protocol.TaskStart.class));
                            return null;
                        }
                        if (this.message.get() instanceof Protocol.TaskComplete) {
                            ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onTaskComplete((UUID)ScriptBytecodeAdapter.castToType((Object)this.sender.get(), UUID.class), (Protocol.TaskComplete)ScriptBytecodeAdapter.castToType((Object)this.message.get(), Protocol.TaskComplete.class));
                            return null;
                        }
                        if (this.message.get() instanceof Protocol.NodeData) {
                            ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onNodeStart((UUID)ScriptBytecodeAdapter.castToType((Object)this.sender.get(), UUID.class), (Protocol.NodeData)ScriptBytecodeAdapter.castToType((Object)this.message.get(), Protocol.NodeData.class));
                            return null;
                        }
                        if (this.message.get() instanceof Protocol.NodeIdle) {
                            ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onNodeIdle((UUID)ScriptBytecodeAdapter.castToType((Object)this.sender.get(), UUID.class), (Protocol.NodeIdle)ScriptBytecodeAdapter.castToType((Object)this.message.get(), Protocol.NodeIdle.class));
                            return null;
                        }
                        if (this.message.get() instanceof Protocol.NodeRetired) {
                            ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onNodeRetired((UUID)ScriptBytecodeAdapter.castToType((Object)this.sender.get(), UUID.class), (Protocol.NodeRetired)ScriptBytecodeAdapter.castToType((Object)this.message.get(), Protocol.NodeRetired.class));
                            return null;
                        }
                        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.message.get()}, new String[]{"Unknown worker message: ", ""})));
                    }

                    public Object getMessage() {
                        return this.message.get();
                    }

                    public UUID getSender() {
                        return (UUID)ScriptBytecodeAdapter.castToType((Object)this.sender.get(), UUID.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.leftShift(((Scheduler)this.getThisObject()).messageQueue, (Object)((Object)new _closure10((Object)this, this.getThisObject(), message2, sender2)));
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public Object call(UUID sender, Object message) {
                void var2_2;
                Reference sender2 = new Reference((Object)sender);
                Reference message2 = new Reference((Object)var2_2);
                return this.doCall((UUID)sender2.get(), message2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createMessageDispatcher_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (IgniteBiPredicate)ScriptBytecodeAdapter.asType((Object)((Object)new _createMessageDispatcher_closure3(this, this)), IgniteBiPredicate.class);
    }

    private IgnitePredicate<Event> createEventDispatcher() {
        public final class _createEventDispatcher_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEventDispatcher_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Event event) {
                Reference event2 = new Reference((Object)event);
                public final class _closure11
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference event;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure11(Object _outerInstance, Object _thisObject, Reference event) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.event = reference = event;
                    }

                    public Object doCall(Object it) {
                        if (this.event.get() instanceof DiscoveryEvent) {
                            if (((Event)this.event.get()).type() == EventType.EVT_NODE_LEFT) {
                                ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onNodeLeft(((DiscoveryEvent)ScriptBytecodeAdapter.castToType((Object)((Event)this.event.get()), DiscoveryEvent.class)).eventNode().id());
                                return null;
                            }
                            if (((Event)this.event.get()).type() == EventType.EVT_NODE_FAILED) {
                                ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).onNodeFailed(((DiscoveryEvent)ScriptBytecodeAdapter.castToType((Object)((Event)this.event.get()), DiscoveryEvent.class)).eventNode().id());
                                return null;
                            }
                        }
                        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.event.get()}, new String[]{"Unknown event: ", ""})));
                    }

                    public Event getEvent() {
                        return (Event)ScriptBytecodeAdapter.castToType((Object)this.event.get(), Event.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.leftShift(((Scheduler)this.getThisObject()).messageQueue, (Object)((Object)new _closure11((Object)this, this.getThisObject(), event2)));
                return true;
            }

            public Object call(Event event) {
                Reference event2 = new Reference((Object)event);
                return this.doCall((Event)event2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEventDispatcher_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (IgnitePredicate)ScriptBytecodeAdapter.asType((Object)((Object)new _createEventDispatcher_closure4(this, this)), IgnitePredicate.class);
    }

    private Object registerEvents() {
        this.ignite.message().localListen((Object)Protocol.TOPIC_SCHEDULER_EVENTS, this.createMessageDispatcher());
        this.ignite.events().localListen(this.createEventDispatcher(), new int[]{EventType.EVT_NODE_LEFT});
        this.ignite.events().localListen(this.createEventDispatcher(), new int[]{EventType.EVT_NODE_FAILED});
        return null;
    }

    public void schedule(IgBaseTask ... tasks) {
        Reference tasks2 = new Reference((Object)tasks);
        public final class _schedule_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tasks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _schedule_closure5(Object _outerInstance, Object _thisObject, Reference tasks) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.tasks = reference = tasks;
            }

            public Object doCall(Object it) {
                ((Scheduler)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), Scheduler.class)).schedule0((IgBaseTask[])ScriptBytecodeAdapter.castToType((Object)this.tasks.get(), IgBaseTask[].class));
                return null;
            }

            public IgBaseTask[] getTasks() {
                return (IgBaseTask[])ScriptBytecodeAdapter.castToType((Object)this.tasks.get(), IgBaseTask[].class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _schedule_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.leftShift(this.messageQueue, (Object)((Object)new _schedule_closure5(this, this, tasks2)));
    }

    private void schedule0(IgBaseTask ... tasks) {
        public final class _schedule0_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _schedule0_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(IgBaseTask t) {
                return t.getTaskId();
            }

            public Object call(IgBaseTask t) {
                return this.doCall(t);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _schedule0_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)tasks, Object[].class)), (Closure)new _schedule0_closure6(this, this)), (String)",")}, new String[]{"+++ Scheduling tasks: taskId=", ""}));
        int i = 0;
        while (i < DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)tasks, Object[].class)))) {
            IgBaseTask task = (IgBaseTask)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])tasks, (int)0), IgBaseTask.class);
            this.scheduledTasks.put(task.getTaskId(), new Protocol.TaskHolder(task));
            this.pendingTasks.put((Object)task.getTaskId(), (Object)task);
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        this.notifyTaskAvail();
    }

    private void notifyTaskAvail() {
        this.ignite.message().send((Object)Protocol.TOPIC_AGENT_EVENTS, (Object)Protocol.TaskAvail.INSTANCE);
    }

    private String hostName(UUID nodeId) {
        Protocol.NodeData node = (Protocol.NodeData)ScriptBytecodeAdapter.castToType((Object)this.workerNodes.get(nodeId), Protocol.NodeData.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)node)) {
            return ShortTypeHandling.castToString(null);
        }
        return this.cloudEnabled ? node.getInstanceId() : node.getHostName();
    }

    private void onNodeStart(UUID sender, Protocol.NodeData message) {
        Object v5;
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            UUID uUID = sender;
            valueRecorder.record((Object)uUID, 8);
            Protocol.NodeData nodeData = message;
            valueRecorder.record((Object)nodeData, 18);
            UUID uUID2 = nodeData.getNodeId();
            valueRecorder.record((Object)uUID2, -1);
            valueRecorder.record((Object)uUID2, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)uUID, (Object)uUID2);
            valueRecorder.record((Object)bl, -1);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sender == message.nodeId", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Protocol.NodeData nodeData = message;
        DefaultGroovyMethods.putAt(this.workerNodes, (Object)sender, (Object)nodeData);
        Autoscaler autoscaler = this.autoscaler;
        if (autoscaler != null) {
            autoscaler.onNodeStart(message);
            v5 = null;
        } else {
            v5 = null;
        }
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName(sender), sender}, new String[]{"+++ Node joined the cluster: [", "] ", ""})));
    }

    private void onNodeIdle(UUID sender, Protocol.NodeIdle message) {
        Protocol.NodeData node = (Protocol.NodeData)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.workerNodes, (Object)sender), Protocol.NodeData.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)node)) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{sender}, new String[]{"+++ Unknown idle node: nodeId=", ""})));
            return;
        }
        if (message.getIdleTimestamp() < this.bootTimestamp) {
            return;
        }
        long l = message.getIdleTimestamp();
        node.setIdleTimestamp(l);
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName(sender), node.idle()}, new String[]{"+++ Node idle: [", "] not working for ", ""})));
    }

    private void onTaskStart(UUID sender, Protocol.TaskStart message) {
        Protocol.TaskHolder holder = (Protocol.TaskHolder)ScriptBytecodeAdapter.castToType((Object)this.scheduledTasks.get(message.getTaskId()), Protocol.TaskHolder.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)holder)) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{message, this.hostName(sender), sender}, new String[]{"+++ Task started: ", " [", "] ", ""}));
            holder.withStart(sender);
            Protocol.NodeData node = (Protocol.NodeData)ScriptBytecodeAdapter.castToType((Object)this.workerNodes.get(sender), Protocol.NodeData.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)node)) {
                int n = 0;
                node.setIdleTimestamp(n);
            } else {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{sender}, new String[]{"+++ Oops.. Can't find node data with id=", ""})));
            }
        } else {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName(sender), message}, new String[]{"+++ Oops.. Started task is unknown -- [", "] ", ""})));
        }
    }

    private void onTaskComplete(UUID sender, Protocol.TaskComplete message) {
        Protocol.TaskHolder holder = (Protocol.TaskHolder)ScriptBytecodeAdapter.castToType((Object)this.scheduledTasks.get(message.getTaskId()), Protocol.TaskHolder.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)holder)) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{message, this.hostName(sender), sender}, new String[]{"+++ Task complete: ", " [", "] ", ""}));
            this.completedTasks.put(message.getTaskId(), holder.withComplete(message));
            this.scheduledTasks.remove(message.getTaskId());
            this.monitor.signal();
        } else {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{message, this.hostName(sender)}, new String[]{"+++ Got task complete message but cannot find it -- ", " [", "]"})));
        }
    }

    private void onNodeFailed(UUID nodeId) {
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName(nodeId), nodeId}, new String[]{"+++ Node failed: [", "] ", ""})));
        this.removeRunningTaskOnNode(nodeId, "failed");
        this.workerNodes.remove(nodeId);
    }

    private void onNodeLeft(UUID nodeId) {
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName(nodeId), nodeId}, new String[]{"+++ Node left: [", "] ", ""})));
        this.removeRunningTaskOnNode(nodeId, "leaving");
        this.workerNodes.remove(nodeId);
    }

    private void onNodeRetired(UUID nodeId, Protocol.NodeRetired message) {
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName(nodeId), nodeId, message}, new String[]{"+++ Node retired: [", "] ", " -- ", ""})));
        this.removeRunningTaskOnNode(nodeId, "retired");
        this.workerNodes.remove(nodeId);
    }

    private void removeRunningTaskOnNode(UUID nodeId, String reason) {
        String string;
        Reference nodeId2 = new Reference((Object)nodeId);
        public final class _removeRunningTaskOnNode_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference nodeId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeRunningTaskOnNode_closure7(Object _outerInstance, Object _thisObject, Reference nodeId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.nodeId = reference = nodeId;
            }

            public Object doCall(Protocol.TaskHolder it) {
                return ScriptBytecodeAdapter.compareEqual((Object)it.getWorker(), (Object)this.nodeId.get()) ? it.getTask() : null;
            }

            public Object call(Protocol.TaskHolder it) {
                return this.doCall(it);
            }

            public UUID getNodeId() {
                return (UUID)ScriptBytecodeAdapter.castToType((Object)this.nodeId.get(), UUID.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeRunningTaskOnNode_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List tasks = (List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.findResults(this.scheduledTasks.values(), (Closure)new _removeRunningTaskOnNode_closure7(this, this, nodeId2)), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)tasks)) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{reason, this.hostName((UUID)nodeId2.get())}, new String[]{"+++ No pending task on ", " node: [", "]"}));
            return;
        }
        public final class _removeRunningTaskOnNode_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeRunningTaskOnNode_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((IgBaseTask)it).getTaskId();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeRunningTaskOnNode_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{reason, this.hostName((UUID)nodeId2.get()), DefaultTypeTransformation.booleanUnbox((Object)(string = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)tasks, (Closure)new _removeRunningTaskOnNode_closure8(this, this)), (String)", "))) ? string : "n/a"}, new String[]{"+++ Dropping tasks on ", " node: [", "] taskId=", ""}));
        Iterator itr = tasks.iterator();
        while (itr.hasNext()) {
            IgBaseTask task = (IgBaseTask)ScriptBytecodeAdapter.castToType(itr.next(), IgBaseTask.class);
            Object cause = ScriptBytecodeAdapter.compareEqual((Object)reason, (Object)"retired") ? new CloudSpotTerminationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName((UUID)nodeId2.get())}, new String[]{"Computing node was retired: [", "]"}))) : new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.hostName((UUID)nodeId2.get())}, new String[]{"Task aborted due to failure on node: [", "]"})));
            Protocol.TaskComplete failure = Protocol.TaskComplete.error(task, (Throwable)cause);
            this.onTaskComplete((UUID)nodeId2.get(), failure);
        }
    }

    public boolean checkTaskStarted(TaskId taskId) {
        Protocol.TaskHolder taskHolder = this.scheduledTasks.get(taskId);
        return DefaultTypeTransformation.booleanUnbox(taskHolder != null ? Boolean.valueOf(taskHolder.getStarted()) : null) || this.completedTasks.containsKey(taskId);
    }

    public boolean checkTaskCompleted(TaskId taskId) {
        return this.completedTasks.containsKey(taskId);
    }

    public boolean checkTaskFailed(TaskId taskId) {
        Protocol.TaskHolder taskHolder = this.completedTasks.get(taskId);
        return (taskHolder != null ? taskHolder.getError() : null) != null;
    }

    public void cancelTask(TaskId taskId) {
        Reference taskId2 = new Reference((Object)taskId);
        public final class _cancelTask_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference taskId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cancelTask_closure9(Object _outerInstance, Object _thisObject, Reference taskId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.taskId = reference = taskId;
            }

            public Object doCall(Object it) {
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.taskId.get()}, new String[]{"+++ Cancelling task: taskId=", ""}));
                boolean removed = false;
                try {
                    boolean bl;
                    removed = bl = ((Scheduler)this.getThisObject()).pendingTasks.remove(this.taskId.get());
                }
                catch (CacheException e) {
                    if (!(e.getCause() instanceof IgniteInterruptedException)) {
                        throw (Throwable)e;
                    }
                }
                Protocol.TaskHolder holder = (Protocol.TaskHolder)ScriptBytecodeAdapter.castToType((Object)((Scheduler)this.getThisObject()).scheduledTasks.get(this.taskId.get()), Protocol.TaskHolder.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)holder)) {
                    if (holder.getWorker() != null) {
                        ClusterGroup worker = ((Scheduler)this.getThisObject()).ignite.cluster().forNodeId(holder.getWorker(), new UUID[0]);
                        ((Scheduler)this.getThisObject()).ignite.message(worker).send((Object)Protocol.TOPIC_AGENT_EVENTS, (Object)new Protocol.TaskCancel((TaskId)ScriptBytecodeAdapter.castToType((Object)this.taskId.get(), TaskId.class)));
                    }
                    ((Scheduler)this.getThisObject()).scheduledTasks.remove(this.taskId.get());
                }
                if (!removed && !DefaultTypeTransformation.booleanUnbox((Object)holder)) {
                    Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.taskId.get()}, new String[]{"+++ Oops.. Unable to cancel task: taskId=", ""}));
                    return null;
                }
                return null;
            }

            public TaskId getTaskId() {
                return (TaskId)ScriptBytecodeAdapter.castToType((Object)this.taskId.get(), TaskId.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cancelTask_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.leftShift(this.messageQueue, (Object)((Object)new _cancelTask_closure9(this, this, taskId2)));
    }

    public Protocol.TaskHolder removeTaskCompleted(TaskId taskId) {
        Protocol.TaskHolder result = (Protocol.TaskHolder)ScriptBytecodeAdapter.castToType((Object)this.completedTasks.get(taskId), Protocol.TaskHolder.class);
        this.completedTasks.remove(taskId);
        return result;
    }

    public String dumpScheduledTasksStatus() {
        StringBuilder result = new StringBuilder();
        Iterator<Protocol.TaskHolder> itr = this.scheduledTasks.values().iterator();
        while (itr.hasNext()) {
            StringGroovyMethods.leftShift((StringBuilder)result, (Object)itr.next().toString());
        }
        return result.toString();
    }

    public void shutdownRemoteAgents() {
        ClusterGroup group = this.ignite.cluster().forRemotes();
        if (DefaultTypeTransformation.booleanUnbox((Object)group.node())) {
            try {
                this.ignite.message(group).send((Object)Protocol.TOPIC_AGENT_EVENTS, (Object)Protocol.NodeShutdown.INSTANCE);
            }
            catch (Exception e) {
                log.warn("+++ Unexpected error notifying remote nodes shutdown", (Throwable)e);
            }
        }
    }

    public void shutdownScheduler() {
        Object v1;
        Object v0;
        Thread thread = this.messageProcessor;
        if (thread != null) {
            thread.interrupt();
            v0 = null;
        } else {
            v0 = null;
        }
        Autoscaler autoscaler = this.autoscaler;
        if (autoscaler != null) {
            FilesEx.closeQuietly((Closeable)autoscaler);
            v1 = null;
        } else {
            v1 = null;
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Scheduler.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Scheduler.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Scheduler.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Map<UUID, Protocol.NodeData> pfaccess$3(Scheduler $that) {
        return $that.workerNodes;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Scheduler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger(Scheduler.class);
    }

    static class ClusterDiscovery
    implements IgniteCallable<Protocol.NodeData>,
    GroovyObject {
        @IgniteInstanceResource
        private Ignite ignite;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public ClusterDiscovery() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Protocol.NodeData call() throws Exception {
            ClusterConfig clusterConfig = IgGridFactory.instance().getClusterConfig();
            return Protocol.NodeData.create(clusterConfig, this.ignite);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ClusterDiscovery.class, Scheduler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ClusterDiscovery.class, Scheduler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Scheduler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Scheduler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ClusterDiscovery.class, Scheduler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ClusterDiscovery.class, Scheduler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ClusterDiscovery.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

