/*
 * Decompiled with CFR 0.152.
 */
package nextflow.daemon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import nextflow.Const;
import nextflow.Global;
import nextflow.cloud.CloudDriverFactory;
import nextflow.exception.AbortOperationException;
import nextflow.extension.FilesEx;
import nextflow.file.FileHelper;
import nextflow.scheduler.Protocol;
import nextflow.util.ClusterConfig;
import nextflow.util.Duration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.logger.slf4j.Slf4jLogger;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.s3.TcpDiscoveryS3IpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.sharedfs.TcpDiscoverySharedFsIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgGridFactory
implements GroovyObject {
    public static final String SESSIONS_CACHE = "allSessions";
    public static final String GRID_NAME = "nextflow";
    public static final String NODE_ROLE = "ROLE";
    private final String role;
    private final ClusterConfig clusterConfig;
    private final Map config;
    private static IgGridFactory singleton;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public IgGridFactory(String role, Map config) {
        ClusterConfig clusterConfig;
        String string;
        Object v0;
        IgGridFactory igGridFactory;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{Const.ROLE_MASTER, Const.ROLE_WORKER}) == null ? Boolean.valueOf(role == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{Const.ROLE_MASTER, Const.ROLE_WORKER}), (Object)role))))) {
            ScriptBytecodeAdapter.assertFailed((Object)"(([nextflow.Const.ROLE_MASTER, nextflow.Const.ROLE_WORKER] == null)) ? (role == null) : [nextflow.Const.ROLE_MASTER, nextflow.Const.ROLE_WORKER].isCase(role)", (Object)new GStringImpl(new Object[]{Const.ROLE_MASTER, Const.ROLE_WORKER}, new String[]{"Parameter 'role' can be either `", "` or `", "`"}));
        }
        singleton = igGridFactory = this;
        Map map = (Map)ScriptBytecodeAdapter.castToType(config.get("cluster"), Map.class);
        Map configMap = DefaultTypeTransformation.booleanUnbox((Object)map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{role, configMap}, new String[]{"Configuration properties for role: '", "' -- ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        this.role = string = role;
        this.clusterConfig = clusterConfig = new ClusterConfig(configMap, role, System.getenv());
    }

    public static Ignite ignite() {
        return Ignition.ignite((String)GRID_NAME);
    }

    public static IgGridFactory instance() {
        return singleton;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public Ignite start() {
        return Ignition.start((IgniteConfiguration)this.config());
    }

    public IgniteConfiguration config() {
        Object v1;
        Duration duration;
        Object v0;
        java.util.logging.Logger.getLogger("").setLevel(Level.OFF);
        System.setProperty("IGNITE_UPDATE_NOTIFIER", "false");
        System.setProperty("IGNITE_NO_ASCII", "true");
        System.setProperty("IGNITE_NO_SHUTDOWN_HOOK", "true");
        System.setProperty("IGNITE_QUIET", "false");
        IgniteConfiguration cfg = new IgniteConfiguration();
        this.discoveryConfig(cfg);
        this.cacheConfig(cfg);
        String groupName = (String)ScriptBytecodeAdapter.asType((Object)this.clusterConfig.getAttribute("group", (Object)GRID_NAME), String.class);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{groupName}, new String[]{"Apache Ignite config > group name: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        cfg.setIgniteInstanceName(groupName);
        cfg.setUserAttributes(ScriptBytecodeAdapter.createMap((Object[])new Object[]{NODE_ROLE, this.role}));
        cfg.setGridLogger((IgniteLogger)new Slf4jLogger());
        Duration freq = (Duration)ScriptBytecodeAdapter.asType((Object)this.clusterConfig.getAttribute("metricsLogFrequency", (Object)Duration.of((String)"5 min")), Duration.class);
        cfg.setMetricsLogFrequency(freq.toMillis());
        cfg.setWorkDirectory(FileHelper.getLocalTempPath().resolve("ignite").toString());
        Duration timeout = (Duration)ScriptBytecodeAdapter.asType((Object)this.clusterConfig.getAttribute("failureDetectionTimeout"), Duration.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)timeout)) {
            cfg.setFailureDetectionTimeout(timeout.getMillis());
        }
        timeout = duration = (Duration)ScriptBytecodeAdapter.asType((Object)this.clusterConfig.getAttribute("clientFailureDetectionTimeout"), Duration.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)timeout)) {
            cfg.setClientFailureDetectionTimeout(timeout.getMillis());
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.clusterConfig}, new String[]{"Apache Ignite config > ", ""})));
            v1 = null;
        } else {
            v1 = null;
        }
        return cfg;
    }

    protected void cacheConfig(IgniteConfiguration cfg) {
        List configs = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        DefaultGroovyMethods.leftShift((List)configs, (Object)new CacheConfiguration().setName(SESSIONS_CACHE));
        DefaultGroovyMethods.leftShift((List)configs, (Object)new CacheConfiguration().setName(Protocol.PENDING_TASKS_CACHE).setCacheMode(CacheMode.REPLICATED));
        cfg.setCacheConfiguration((CacheConfiguration[])ScriptBytecodeAdapter.asType((Object)configs, CacheConfiguration[].class));
    }

    private Object discoveryConfig(IgniteConfiguration cfg) {
        Reference discoverCfg = new Reference((Object)new TcpDiscoverySpi());
        List addresses = this.clusterConfig.getNetworkInterfaceAddresses();
        if (DefaultTypeTransformation.booleanUnbox((Object)addresses)) {
            String addr = ShortTypeHandling.castToString(addresses.get(0));
            int indx = addr.indexOf(":");
            if (ScriptBytecodeAdapter.compareEqual((Object)indx, (Object)-1)) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{addr}, new String[]{"Apache Ignite config > interface: ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                ((TcpDiscoverySpi)discoverCfg.get()).setLocalAddress(addr);
            } else {
                Object v1;
                String host = addr.substring(0, indx);
                Integer port = (Integer)ScriptBytecodeAdapter.asType((Object)addr.substring(indx + 1), Integer.class);
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{host, port}, new String[]{"Ignite config > interface: ", ":", ""})));
                    v1 = null;
                } else {
                    v1 = null;
                }
                ((TcpDiscoverySpi)discoverCfg.get()).setLocalAddress(host);
                ((TcpDiscoverySpi)discoverCfg.get()).setLocalPort(port.intValue());
            }
        }
        String join = this.clusterConfig.getClusterJoin();
        if (DefaultTypeTransformation.booleanUnbox((Object)join)) {
            Object v10;
            if (ScriptBytecodeAdapter.compareEqual((Object)join, (Object)"multicast")) {
                log.debug("Ignite config > default discovery multicast");
                ((TcpDiscoverySpi)discoverCfg.get()).setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryMulticastIpFinder());
            } else if (join.startsWith("multicast:")) {
                TcpDiscoveryMulticastIpFinder finder = new TcpDiscoveryMulticastIpFinder();
                String address = join.replace("multicast:", "");
                Object[] parts = address.split(":");
                if (DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)parts, Object[].class))) != 0) {
                    Object v2;
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BytecodeInterface8.objectArrayGet((Object[])parts, (int)0)}, new String[]{"Ignite config > discovery multicast group: ", ""})));
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                    finder.setMulticastGroup(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)0)));
                }
                if (DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)parts, Object[].class))) == 2) {
                    Object v3;
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BytecodeInterface8.objectArrayGet((Object[])parts, (int)1)}, new String[]{"Ignite config > discovery multicast port: ", ""})));
                        v3 = null;
                    } else {
                        v3 = null;
                    }
                    finder.setMulticastPort(((Integer)ScriptBytecodeAdapter.asType((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)1), Integer.class)).intValue());
                }
                ((TcpDiscoverySpi)discoverCfg.get()).setIpFinder((TcpDiscoveryIpFinder)finder);
            } else if (join.startsWith("s3:")) {
                Object v4;
                List credentials = Global.getAwsCredentials(System.getenv(), (Map)this.config);
                if (!DefaultTypeTransformation.booleanUnbox((Object)credentials)) {
                    throw (Throwable)new AbortOperationException("Missing AWS credentials -- Please add AWS access credentials to your environment by defining the variables AWS_ACCESS_KEY and AWS_SECRET_KEY or in your nextflow config file");
                }
                String accessKey = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)credentials, (int)0));
                String secretKey = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)credentials, (int)1));
                String bucket = join.substring(3).trim();
                if (bucket.startsWith("/")) {
                    String string;
                    bucket = string = bucket.substring(1);
                }
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{bucket, accessKey.substring(0, 6), secretKey.substring(0, 6)}, new String[]{"Ignite config > discovery AWS bucket: ", "; access: ", "..; ", ".."})));
                    v4 = null;
                } else {
                    v4 = null;
                }
                TcpDiscoveryS3IpFinder finder = new TcpDiscoveryS3IpFinder();
                finder.setAwsCredentials((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
                finder.setBucketName(bucket);
                ((TcpDiscoverySpi)discoverCfg.get()).setIpFinder((TcpDiscoveryIpFinder)finder);
            } else if (join.startsWith("path:")) {
                Path path = FileHelper.asPath((String)join.substring(5).trim());
                if (FilesEx.exists((Path)path, (LinkOption[])new LinkOption[0])) {
                    Object v5;
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"Ignite config > discovery path: ", ""})));
                        v5 = null;
                    } else {
                        v5 = null;
                    }
                } else {
                    Object v6;
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"Ignite config > CREATING discovery path: ", ""})));
                        v6 = null;
                    } else {
                        v6 = null;
                    }
                    FilesEx.mkdirs((Path)path, (FileAttribute[])new FileAttribute[0]);
                }
                TcpDiscoverySharedFsIpFinder finder = new TcpDiscoverySharedFsIpFinder();
                finder.setPath(path.toString());
                ((TcpDiscoverySpi)discoverCfg.get()).setIpFinder((TcpDiscoveryIpFinder)finder);
            } else if (join.startsWith("ip:")) {
                Object v7;
                List ips = (List)ScriptBytecodeAdapter.asType((Object)StringUtils.split((String)join.substring(3).trim().toString(), (String)", \n"), List.class);
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)ips, (String)", ")}, new String[]{"Apache Ignite config > discovery IPs: ", ""})));
                    v7 = null;
                } else {
                    v7 = null;
                }
                TcpDiscoveryVmIpFinder finder = new TcpDiscoveryVmIpFinder();
                finder.setAddresses((Collection)ips);
                ((TcpDiscoverySpi)discoverCfg.get()).setIpFinder((TcpDiscoveryIpFinder)finder);
            } else if (join.startsWith("cloud:")) {
                Object v9;
                Object v8;
                List parts = StringGroovyMethods.tokenize((CharSequence)join, (CharSequence)":");
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{join}, new String[]{"Apache Ignite config > cloud provider: ", ""})));
                    v8 = null;
                } else {
                    v8 = null;
                }
                String driverName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)parts, (int)1));
                String clusterName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)parts, (int)2));
                List<String> ips = this.findCloudIpAddresses(driverName, clusterName);
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join(ips, (String)", ")}, new String[]{"Apache Ignite config > joining IPs: ", ""})));
                    v9 = null;
                } else {
                    v9 = null;
                }
                TcpDiscoveryVmIpFinder finder = new TcpDiscoveryVmIpFinder();
                finder.setShared(true);
                finder.setAddresses(ips);
                ((TcpDiscoverySpi)discoverCfg.get()).setIpFinder((TcpDiscoveryIpFinder)finder);
            } else if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{join}, new String[]{"Ignite config > unknown discovery method: ", ""})));
                v10 = null;
            } else {
                v10 = null;
            }
        }
        public final class _discoveryConfig_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference discoverCfg;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _discoveryConfig_closure1(Object _outerInstance, Object _thisObject, Reference discoverCfg) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.discoverCfg = reference = discoverCfg;
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((IgGridFactory)this.getThisObject()), (String)"checkAndSet", (Object)new Object[]{this.discoverCfg.get(), StringGroovyMethods.plus((String)"tcp.", (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)it, CharSequence.class)))});
            }

            public Object getDiscoverCfg() {
                return this.discoverCfg.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _discoveryConfig_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)this.clusterConfig.getAttributeNames("tcp"), (Closure)new _discoveryConfig_closure1(this, this, discoverCfg));
        return cfg.setDiscoverySpi((DiscoverySpi)((TcpDiscoverySpi)discoverCfg.get()));
    }

    private String getLocalAddress() {
        String string = InetAddress.getLocalHost().getHostAddress();
        try {
            return string;
        }
        catch (IOException e) {
            log.debug("Oops.. Cannot find local address", (Throwable)e);
            String string2 = ShortTypeHandling.castToString(null);
            return string2;
        }
    }

    private List<String> findCloudIpAddresses(String driverName, String clusterName) {
        List result = null;
        String localAddress = this.getLocalAddress();
        long begin = System.currentTimeMillis();
        while (true) {
            List list;
            result = list = CloudDriverFactory.getDriver((String)driverName).listPrivateIPs(clusterName);
            boolean notFound = !DefaultTypeTransformation.booleanUnbox((Object)result) || result.size() == 1 && result.contains(localAddress);
            if (!(notFound && System.currentTimeMillis() - begin < (long)5000)) break;
            DefaultGroovyStaticMethods.sleep(null, (long)100);
        }
        List list = result;
        return DefaultTypeTransformation.booleanUnbox((Object)list) ? list : ScriptBytecodeAdapter.createList((Object[])new Object[]{localAddress});
    }

    protected void checkAndSet(Object discoverCfg, String name, Object defValue) {
        Object value = this.clusterConfig.getAttribute(name, defValue);
        if (value != null) {
            Object v0;
            String p = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])name.split("\\."), (int)-1));
            Object x = value instanceof Duration ? Long.valueOf(((Duration)value).toMillis()) : value;
            String n = StringGroovyMethods.plus((String)"set", (CharSequence)StringUtils.capitalize((String)p));
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, n, x, x.getClass().getName()}, new String[]{"Ignite config > ", " [", "]: ", " [", "]"})));
                v0 = null;
            } else {
                v0 = null;
            }
            MethodUtils.invokeMethod((Object)discoverCfg, (String)n, (Object)x);
        }
    }

    @Generated
    protected void checkAndSet(Object discoverCfg, String name) {
        this.checkAndSet(discoverCfg, name, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IgGridFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.daemon.IgGridFactory");
    }
}

