/*
 * Decompiled with CFR 0.152.
 */
package nextflow.scheduler;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Closeable;
import java.nio.channels.ClosedByInterruptException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import nextflow.Const;
import nextflow.cloud.CloudDriver;
import nextflow.cloud.CloudDriverFactory;
import nextflow.daemon.IgGridFactory;
import nextflow.executor.IgBaseTask;
import nextflow.extension.Bolts;
import nextflow.processor.TaskId;
import nextflow.scheduler.Protocol;
import nextflow.util.ClusterConfig;
import nextflow.util.Duration;
import nextflow.util.MemoryUnit;
import nextflow.util.SysHelper;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerAgent
implements Closeable,
GroovyObject {
    private ExecutorService taskExecutor;
    private IgniteCache<TaskId, IgBaseTask> pendingTasks;
    private Map<TaskId, RunHolder> runningTasks;
    private Ignite ignite;
    private ClusterConfig config;
    private AgentProcessor eventProcessor;
    private Protocol.Resources total;
    private volatile boolean closed;
    private volatile UUID masterId;
    private CloudDriver driver;
    private boolean simulateSpotTermination;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public SchedulerAgent(Ignite ignite, ClusterConfig config, UUID masterId) {
        UUID uUID;
        boolean bl;
        AgentProcessor agentProcessor;
        CloudDriver cloudDriver;
        Protocol.Resources resources;
        ExecutorService executorService;
        IgniteCache igniteCache;
        Ignite ignite2;
        ClusterConfig clusterConfig;
        MetaClass metaClass;
        ConcurrentHashMap<TaskId, RunHolder> concurrentHashMap = new ConcurrentHashMap<TaskId, RunHolder>();
        this.runningTasks = concurrentHashMap;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.config = clusterConfig = config;
        this.ignite = ignite2 = ignite;
        this.pendingTasks = igniteCache = ignite.cache(Protocol.PENDING_TASKS_CACHE);
        this.taskExecutor = executorService = Executors.newFixedThreadPool(SysHelper.getAvailCpus());
        this.total = resources = new Protocol.Resources(config);
        this.driver = cloudDriver = this.getCloudDriver(config);
        this.eventProcessor = agentProcessor = new AgentProcessor(this);
        this.simulateSpotTermination = bl = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)config.getAttribute("simulateSpotTermination"), Boolean.TYPE));
        this.registerEvents();
        UUID uUID2 = masterId;
        this.masterId = uUID = DefaultTypeTransformation.booleanUnbox((Object)uUID2) ? uUID2 : this.getMasterNodeId();
        if (this.masterId != null) {
            this.notifyNodeStart();
        }
    }

    @Generated
    public SchedulerAgent(Ignite ignite, ClusterConfig config) {
        this(ignite, config, null);
    }

    private CloudDriver getCloudDriver(ClusterConfig config) {
        String driverName = config.getCloudDriverName();
        CloudDriver cloudDriver = (CloudDriver)ScriptBytecodeAdapter.castToType((Object)(config.isCloudCluster() ? CloudDriverFactory.getDriver((String)driverName) : null), CloudDriver.class);
        try {
            return cloudDriver;
        }
        catch (Exception e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{driverName}, new String[]{"=== Can't load cloud driver: `", "`"})), (Throwable)e);
                v0 = null;
            } else {
                v0 = null;
            }
            CloudDriver cloudDriver2 = (CloudDriver)ScriptBytecodeAdapter.castToType(null, CloudDriver.class);
            return cloudDriver2;
        }
    }

    private IgniteBiPredicate<UUID, Object> createMessageDispatcher() {
        public final class _createMessageDispatcher_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createMessageDispatcher_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(UUID uuid, Object message) {
                if (message instanceof Protocol.TaskAvail) {
                    ((SchedulerAgent)this.getThisObject()).eventProcessor.newMessage();
                } else if (message instanceof Protocol.TaskCancel) {
                    InvokerHelper.invokeMethodSafe((Object)((SchedulerAgent)this.getThisObject()), (String)"onCancelTask", (Object)new Object[]{message});
                } else if (message instanceof Protocol.NodeShutdown) {
                    ((SchedulerAgent)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SchedulerAgent.class)).onNodeShutdown(uuid);
                } else {
                    Object[] objectArray = new Object[1];
                    Object object = message;
                    Class<?> clazz = object != null ? object.getClass() : null;
                    objectArray[0] = clazz != null ? clazz.getName() : null;
                    throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"Unknown agent event: ", ""})));
                }
                return true;
            }

            public Object call(UUID uuid, Object message) {
                return this.doCall(uuid, message);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createMessageDispatcher_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (IgniteBiPredicate)ScriptBytecodeAdapter.asType((Object)((Object)new _createMessageDispatcher_closure1(this, this)), IgniteBiPredicate.class);
    }

    private IgnitePredicate createEventDispatcher() {
        public final class _createEventDispatcher_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEventDispatcher_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Event event) {
                if (event instanceof DiscoveryEvent) {
                    if (event.type() == EventType.EVT_NODE_LEFT) {
                        ((SchedulerAgent)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SchedulerAgent.class)).onNodeLeft(((DiscoveryEvent)ScriptBytecodeAdapter.castToType((Object)event, DiscoveryEvent.class)).eventNode().id());
                    } else if (event.type() == EventType.EVT_NODE_FAILED) {
                        ((SchedulerAgent)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SchedulerAgent.class)).onNodeFailed(((DiscoveryEvent)ScriptBytecodeAdapter.castToType((Object)event, DiscoveryEvent.class)).eventNode().id());
                    } else if (event.type() == EventType.EVT_NODE_JOINED) {
                        ((SchedulerAgent)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SchedulerAgent.class)).onNodeJoined(((DiscoveryEvent)ScriptBytecodeAdapter.castToType((Object)event, DiscoveryEvent.class)).eventNode().id());
                    } else {
                        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{event}, new String[]{"Unknown event: ", ""})));
                    }
                }
                return true;
            }

            public Object call(Event event) {
                return this.doCall(event);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEventDispatcher_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (IgnitePredicate)ScriptBytecodeAdapter.asType((Object)((Object)new _createEventDispatcher_closure2(this, this)), IgnitePredicate.class);
    }

    private void onNodeJoined(UUID nodeId) {
        Object v1;
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.masterId) && DefaultTypeTransformation.booleanUnbox((Object)this.isMasterNode(nodeId))) {
            UUID uUID;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{nodeId}, new String[]{"=== Master node joined: nodeId=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            this.masterId = uUID = nodeId;
        } else if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{nodeId}, new String[]{"=== Cluster node joined: nodeId=", ""})));
            v1 = null;
        } else {
            v1 = null;
        }
    }

    private void onNodeFailed(UUID nodeId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)nodeId, (Object)this.masterId)) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{nodeId}, new String[]{"=== Master node failed: nodeId=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            Object var2_2 = null;
            this.masterId = (UUID)ScriptBytecodeAdapter.castToType(var2_2, UUID.class);
            this.eventProcessor.newMessage();
        }
    }

    private void onNodeLeft(UUID nodeId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)nodeId, (Object)this.masterId)) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{nodeId}, new String[]{"=== Master node left: nodeId=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            Object var2_2 = null;
            this.masterId = (UUID)ScriptBytecodeAdapter.castToType(var2_2, UUID.class);
            this.eventProcessor.newMessage();
        }
    }

    private void onNodeShutdown(UUID nodeId) {
        this.close(true);
    }

    private void registerEvents() {
        this.ignite.message().localListen((Object)Protocol.TOPIC_AGENT_EVENTS, this.createMessageDispatcher());
        IgnitePredicate dispatcher = this.createEventDispatcher();
        this.ignite.events().localListen(dispatcher, new int[]{EventType.EVT_NODE_FAILED});
        this.ignite.events().localListen(dispatcher, new int[]{EventType.EVT_NODE_LEFT});
        this.ignite.events().localListen(dispatcher, new int[]{EventType.EVT_NODE_JOINED});
    }

    public SchedulerAgent run() {
        this.eventProcessor.start();
        return this;
    }

    private Object isMasterNode(UUID nodeId) {
        return ScriptBytecodeAdapter.compareEqual((Object)this.ignite.cluster().node(nodeId).attribute(IgGridFactory.NODE_ROLE), (Object)Const.ROLE_MASTER);
    }

    private UUID getMasterNodeId() {
        ClusterGroup clusterGroup = this.ignite.cluster().forAttribute(IgGridFactory.NODE_ROLE, (Object)Const.ROLE_MASTER);
        ClusterNode clusterNode = clusterGroup != null ? clusterGroup.node() : null;
        return clusterNode != null ? clusterNode.id() : null;
    }

    private void sendMessageToMaster(String topic, Object message) {
        block11: {
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.masterId)) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{message.getClass().getSimpleName(), message}, new String[]{"=== Master node is unknown -- Cannot send message: [", "] ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                return;
            }
            if (this.closed) {
                Object v1;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{message.getClass().getSimpleName(), message}, new String[]{"=== Shutdown in progress -- Wont send message: [", "] ", ""})));
                    v1 = null;
                } else {
                    v1 = null;
                }
                return;
            }
            try {
                ClusterGroup master = this.ignite.cluster().forNodeId(this.masterId, new UUID[0]);
                this.ignite.message(master).sendOrdered((Object)topic, message, (long)0);
            }
            catch (ClusterGroupEmptyException e) {
                Object v2;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{message.getClass().getSimpleName(), message}, new String[]{"=== Master node is not available -- Cannot send message: [", "] ", ""})));
                    v2 = null;
                    break block11;
                }
                v2 = null;
            }
        }
    }

    void notifyTaskStart(IgBaseTask task) {
        this.sendMessageToMaster(Protocol.TOPIC_SCHEDULER_EVENTS, new Protocol.TaskStart(task));
    }

    void notifyNodeStart() {
        Protocol.NodeData data = Protocol.NodeData.create(this.config, this.ignite);
        this.sendMessageToMaster(Protocol.TOPIC_SCHEDULER_EVENTS, data);
    }

    void notifyNodeRetired(String termination) {
        this.sendMessageToMaster(Protocol.TOPIC_SCHEDULER_EVENTS, new Protocol.NodeRetired(termination));
    }

    void notifyComplete(IgBaseTask task, Object result) {
        block7: {
            try {
                Object v0;
                if (log.isTraceEnabled()) {
                    Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{task.getTaskId(), result}, new String[]{"=== Notify task complete: taskId=", "; result=", ""}));
                    v0 = null;
                } else {
                    v0 = null;
                }
                Protocol.TaskComplete payload = Protocol.TaskComplete.create(task, result);
                this.sendMessageToMaster(Protocol.TOPIC_SCHEDULER_EVENTS, payload);
            }
            catch (Exception e) {
                Object v1;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{task.getTaskId(), result}, new String[]{"=== Failed to notify task completion: taskId=", "; result=", ""})), (Throwable)e);
                    v1 = null;
                    break block7;
                }
                v1 = null;
            }
        }
    }

    void notifyError(IgBaseTask task, Throwable error) {
        block7: {
            try {
                Object v0;
                TaskId taskId = task.getTaskId();
                if (log.isTraceEnabled()) {
                    Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{taskId, error}, new String[]{"=== Notify task complete [error]: taskId=", "; error=", ""}));
                    v0 = null;
                } else {
                    v0 = null;
                }
                Protocol.TaskComplete payload = Protocol.TaskComplete.error(task, error);
                this.sendMessageToMaster(Protocol.TOPIC_SCHEDULER_EVENTS, payload);
            }
            catch (Exception e) {
                Object v1;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{task.getTaskId(), error}, new String[]{"=== Failed to notify task completion: taskId=", "; error=", ""})), (Throwable)e);
                    v1 = null;
                    break block7;
                }
                v1 = null;
            }
        }
    }

    void notifyNodeIdle(long last) {
        log.trace("=== Notify node idle");
        this.sendMessageToMaster(Protocol.TOPIC_SCHEDULER_EVENTS, new Protocol.NodeIdle(last));
    }

    void onCancelTask(Protocol.TaskCancel message) {
        Object v1;
        RunHolder holder = (RunHolder)ScriptBytecodeAdapter.castToType((Object)this.runningTasks.get(message.getTaskId()), RunHolder.class);
        if (holder != null) {
            Object v0;
            if (log.isTraceEnabled()) {
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{message.getTaskId()}, new String[]{"=== Cancelling task: taskId=", ""}));
                v0 = null;
            } else {
                v0 = null;
            }
            holder.getFuture().cancel(true);
        } else if (log.isTraceEnabled()) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{message.getTaskId()}, new String[]{"=== Unable to find task to cancel: taskId=", ""}));
            v1 = null;
        } else {
            v1 = null;
        }
    }

    public synchronized void close(boolean shutdownIgnite) {
        boolean bl;
        if (this.closed) {
            return;
        }
        log.debug("=== Scheduler agent shutting down");
        this.closed = bl = true;
        this.taskExecutor.shutdownNow();
        this.eventProcessor.shutdown();
        if (!shutdownIgnite) {
            return;
        }
        public final class _close_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _close_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                DefaultGroovyMethods.print((Object)this.getThisObject(), (Object)"Cleaning up.. ");
                DefaultGroovyStaticMethods.sleep(null, (long)3000);
                ((SchedulerAgent)this.getThisObject()).ignite.close();
                DefaultGroovyMethods.println((Object)this.getThisObject(), (Object)"Done.");
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _close_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyStaticMethods.start(null, (Closure)new _close_closure3(this, this));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SchedulerAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SchedulerAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(SchedulerAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    @Generated
    public synchronized void close() {
        this.close(false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SchedulerAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"nextflow.scheduler.SchedulerAgent");
    }

    public static class MatchingResources
    implements IgniteBiPredicate<TaskId, IgBaseTask>,
    GroovyObject {
        private int cpus;
        private MemoryUnit memory;
        private MemoryUnit disk;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public MatchingResources(Protocol.Resources avail) {
            MemoryUnit memoryUnit;
            MemoryUnit memoryUnit2;
            int n;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.cpus = n = avail.getCpus();
            this.memory = memoryUnit2 = avail.getMemory();
            this.disk = memoryUnit = avail.getDisk();
        }

        public boolean apply(TaskId taskId, IgBaseTask task) {
            if (task.getResources().getCpus() > this.cpus) {
                return false;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)task.getResources().getMemory()) && ScriptBytecodeAdapter.compareGreaterThan((Object)task.getResources().getMemory(), (Object)this.memory)) {
                return false;
            }
            return !(DefaultTypeTransformation.booleanUnbox((Object)task.getResources().getDisk()) && ScriptBytecodeAdapter.compareGreaterThan((Object)task.getResources().getDisk(), (Object)this.disk));
        }

        public String toString() {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.cpus, this.memory, this.disk}, new String[]{"cpus=", "; mem=", "; disk=", ""}));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(MatchingResources.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(MatchingResources.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(MatchingResources.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(MatchingResources.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MatchingResources.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public int getCpus() {
            return this.cpus;
        }

        @Generated
        public void setCpus(int n) {
            this.cpus = n;
        }

        @Generated
        public MemoryUnit getMemory() {
            return this.memory;
        }

        @Generated
        public void setMemory(MemoryUnit memoryUnit) {
            this.memory = memoryUnit;
        }

        @Generated
        public MemoryUnit getDisk() {
            return this.disk;
        }

        @Generated
        public void setDisk(MemoryUnit memoryUnit) {
            this.disk = memoryUnit;
        }
    }

    class AgentProcessor
    extends Thread
    implements GroovyObject {
        private Lock checkpoint;
        private Condition notEmpty;
        private Protocol.Resources current;
        private volatile boolean stopped;
        private BlockingQueue<Closure> eventsQueue;
        private long idleTimestamp;
        private long _1_min;
        private volatile int execErrCount;
        private int fetchErrCount;
        public /* synthetic */ SchedulerAgent this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public AgentProcessor(SchedulerAgent $p$) {
            MetaClass metaClass;
            Condition condition;
            SchedulerAgent schedulerAgent;
            this.this$0 = schedulerAgent = $p$;
            ReentrantLock reentrantLock = new ReentrantLock();
            this.checkpoint = reentrantLock;
            this.notEmpty = condition = this.checkpoint.newCondition();
            LinkedBlockingQueue<Closure> linkedBlockingQueue = new LinkedBlockingQueue<Closure>();
            this.eventsQueue = linkedBlockingQueue;
            long l = Duration.of((String)"1 min").toMillis();
            this._1_min = l;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = "scheduler-agent";
            this.setName(string);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this.current = var1_1 = new Protocol.Resources(SchedulerAgent.pfaccess$4(this.this$0));
            SchedulerAgent.pfaccess$9(null).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.current}, new String[]{"=== Scheduler agent resources: ", ""})));
            while (this.stopped == false) {
                block10: {
                    if (!(this.getProperty("masterId") != null)) ** GOTO lbl30
                    this.processEvents();
                    this.checkSpotTermination();
                    if (this.processPendingTasks(this.current) == 0) break block10;
                    continue;
                }
                if (!this.stopped) ** GOTO lbl25
                try {
                    break;
lbl25:
                    // 1 sources

                    this.checkIfIdle();
                    Bolts.withLock((Lock)this.checkpoint, (Closure)new _run_closure1(this, this));
                    continue;
lbl30:
                    // 1 sources

                    if (!(this.stopped == false)) continue;
                    this.resetState();
                    this.waitForMasterNodeToJoin();
                }
                catch (InterruptedException e) {
                    SchedulerAgent.pfaccess$9(null).trace("=== Message processor interrupted");
                    this.stopped = var3_3 = true;
                }
                catch (RejectedExecutionException e) {
                    v0 = new Object[1];
                    var5_5 = e.getMessage();
                    v0[0] = DefaultTypeTransformation.booleanUnbox((Object)var5_5) != false ? var5_5 : e;
                    Bolts.trace((Logger)SchedulerAgent.pfaccess$9(null), (Object)new GStringImpl(v0, new String[]{"=== Task execution rejected -- ", ""}));
                }
                catch (Exception e) {
                    var7_7 = e;
                    var8_8 = var7_7 != null ? var7_7.getMessage() : null;
                    this.stopped = var11_11 = DefaultTypeTransformation.booleanUnbox(var8_8 != null ? Boolean.valueOf(var8_8.contains("grid is stopping")) : null) != false || DefaultTypeTransformation.booleanUnbox((var10_10 = (var9_9 = e) != null ? var9_9.getMessage() : null) != null ? Boolean.valueOf(var10_10.contains("cache is stopped")) : null) != false;
                    SchedulerAgent.pfaccess$9(null).error("=== Unexpected scheduler agent error", (Throwable)e);
                }
            }
        }

        private void abortPendingTasks() {
            String string;
            if (!DefaultTypeTransformation.booleanUnbox(this.this$0.runningTasks)) {
                return;
            }
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)(string = DefaultGroovyMethods.join(this.this$0.runningTasks.keySet(), (String)","))) ? string : "-"}, new String[]{"=== aborting pending tasks: taskId=", ""})));
            Iterator<RunHolder> itr = this.this$0.runningTasks.values().iterator();
            while (itr.hasNext()) {
                RunHolder holder = (RunHolder)ScriptBytecodeAdapter.castToType((Object)itr.next(), RunHolder.class);
                holder.getFuture().cancel(true);
            }
        }

        private void checkSpotTermination() {
            CloudDriver cloudDriver = this.this$0.driver;
            String termination = cloudDriver != null ? cloudDriver.getLocalTerminationNotice() : null;
            if (DefaultTypeTransformation.booleanUnbox((Object)termination) || this.this$0.simulateSpotTermination && DefaultTypeTransformation.booleanUnbox(this.this$0.runningTasks)) {
                boolean bl;
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{termination}, new String[]{"=== Detected spot termination notice: ", " -- Starting shutdown"})));
                this.abortPendingTasks();
                String string = termination;
                this.this$0.notifyNodeRetired(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "fake-spot-termination");
                this.stopped = bl = true;
                this.this$0.close(true);
            }
        }

        private void resetState() {
            Protocol.Resources resources;
            if (DefaultTypeTransformation.booleanUnbox(this.this$0.runningTasks)) {
                String string;
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)(string = DefaultGroovyMethods.join(this.this$0.runningTasks.keySet(), (String)", "))) ? string : "-"}, new String[]{"=== Cancelling running tasks: taskId=", ""}));
                Iterator<RunHolder> itr = this.this$0.runningTasks.values().iterator();
                while (itr.hasNext()) {
                    RunHolder holder = (RunHolder)ScriptBytecodeAdapter.castToType((Object)itr.next(), RunHolder.class);
                    holder.getFuture().cancel(true);
                }
                this.this$0.runningTasks.clear();
            }
            this.this$0.pendingTasks.clear();
            this.current = resources = new Protocol.Resources(this.this$0.config);
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.current}, new String[]{"=== Agent resources after reset: ", ""}));
            this.eventsQueue.clear();
            int n = 0;
            this.idleTimestamp = n;
        }

        private void waitForMasterNodeToJoin() {
            int c = 0;
            while (!DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("masterId")) && !this.stopped) {
                int n = c;
                int cfr_ignored_0 = n + 1;
                if (n % 60 == 0) {
                    log.debug("=== Waiting for master node to join..");
                }
                try {
                    Thread.sleep(5000);
                }
                catch (InterruptedException e) {
                    boolean bl;
                    this.stopped = bl = true;
                }
            }
        }

        public void shutdown() {
            boolean bl;
            this.stopped = bl = true;
            this.newMessage();
        }

        public void newMessage() {
            public final class _newMessage_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _newMessage_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    ((AgentProcessor)this.getThisObject()).notEmpty.signal();
                    return null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _newMessage_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Bolts.withLock((Lock)this.checkpoint, (Closure)new _newMessage_closure2(this, this));
        }

        public void async(Closure closure) {
            DefaultGroovyMethods.leftShift(this.eventsQueue, (Object)closure);
            this.newMessage();
        }

        public void processEvents() {
            Closure msg = null;
            while (true) {
                Object e = this.eventsQueue.poll();
                msg = (Closure)ScriptBytecodeAdapter.castToType(e, Closure.class);
                if (!(DefaultTypeTransformation.booleanUnbox(e) && !this.stopped)) break;
                msg.call();
            }
        }

        public int processPendingTasks(Protocol.Resources avail) {
            int n;
            int count = Math.max(this.fetchErrCount, this.execErrCount);
            if (count != 0) {
                long penalty = Math.round(Math.pow(count, 1.8) * (double)1000);
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Duration.of((long)penalty), this.execErrCount, this.fetchErrCount}, new String[]{"=== Error burst prevention: sleep penalty=", "; execErrCount=", "; fetchErrCount=", ""})));
                Thread.sleep(penalty);
            }
            this.processPendingTasks0(avail);
            this.fetchErrCount = n = 0;
            int n2 = n;
            try {
                return n2;
            }
            catch (Throwable e) {
                int n3 = this.fetchErrCount;
                this.fetchErrCount = n3 + 1;
                throw e;
            }
        }

        public int processPendingTasks0(Protocol.Resources avail) {
            public final class _processPendingTasks0_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _processPendingTasks0_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Cache.Entry)it).getValue();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processPendingTasks0_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List tasks = DefaultGroovyMethods.collect((Iterable)this.this$0.pendingTasks.query((Query)new ScanQuery((IgniteBiPredicate)new MatchingResources(avail))).getAll(), (Closure)new _processPendingTasks0_closure3(this, this));
            int count = 0;
            Iterator itr = tasks.iterator();
            while (itr.hasNext() && DefaultTypeTransformation.booleanUnbox((Object)avail.getCpus()) && DefaultTypeTransformation.booleanUnbox((Object)avail.getMemory()) && !this.stopped) {
                MemoryUnit memoryUnit;
                MemoryUnit memoryUnit2;
                int n = count;
                int cfr_ignored_0 = n + 1;
                IgBaseTask it = (IgBaseTask)ScriptBytecodeAdapter.castToType(itr.next(), IgBaseTask.class);
                Protocol.TaskResources res = it.getResources();
                if (!this.canRun(it, avail) || !DefaultTypeTransformation.booleanUnbox((Object)this.this$0.pendingTasks.getAndRemove((Object)it.getTaskId()))) continue;
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{it.getTaskId()}, new String[]{"=== Picked task up: taskId=", ""}));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)(avail.getCpus() - res.getCpus()), AgentProcessor.class, (GroovyObject)avail, (String)"cpus");
                avail.getMemory().minus(res.getMemory());
                avail.setMemory(memoryUnit2);
                avail.getDisk().minus(res.getDisk());
                avail.setDisk(memoryUnit);
                try {
                    RunHolder runHolder = new RunHolder(this.this$0.taskExecutor.submit(this.runTask(it)));
                    DefaultGroovyMethods.putAt(this.this$0.runningTasks, (Object)it.getTaskId(), (Object)runHolder);
                }
                catch (RejectedExecutionException e) {
                    this.rollbackResources(it, true);
                    throw (Throwable)e;
                }
                int n2 = 0;
                this.idleTimestamp = n2;
            }
            return count;
        }

        public boolean canRun(IgBaseTask it, Protocol.Resources avail) {
            Protocol.TaskResources req = it.getResources();
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{it.getTaskId(), req, avail}, new String[]{"Check avail resources: taskId=", "; req=[", "]; avail=[", "]"}));
            if (DefaultTypeTransformation.booleanUnbox((Object)req.getCpus()) && req.getCpus() > avail.getCpus()) {
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{it.getTaskId(), req.getCpus(), avail.getCpus()}, new String[]{"=== Cannot execute task: taskId=", " -- CPUs request exceed available (req=", "; avail=", ")"}));
                return false;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)req.getMemory()) && ScriptBytecodeAdapter.compareGreaterThan((Object)req.getMemory(), (Object)avail.getMemory())) {
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{it.getTaskId(), req.getMemory(), avail.getMemory()}, new String[]{"=== Cannot execute task: taskId=", " -- Memory request exceed available (req=", "; avail=", ")"}));
                return false;
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)req.getDisk()) && ScriptBytecodeAdapter.compareGreaterThan((Object)req.getDisk(), (Object)avail.getDisk())) {
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{it.getTaskId(), req.getDisk(), avail.getDisk()}, new String[]{"=== Cannot execute task: taskId=", " -- Disk request exceed available (req=", "; avail=", ")"}));
                return false;
            }
            return true;
        }

        public Runnable runTask(IgBaseTask task) {
            Reference task2 = new Reference((Object)task);
            return new Runnable(this, task2){
                public /* synthetic */ Reference task;
                public /* synthetic */ AgentProcessor this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    AgentProcessor agentProcessor;
                    this.this$0 = agentProcessor = p0;
                    this.task = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                @Override
                public void run() {
                    this.this$0.runTask0((IgBaseTask)ScriptBytecodeAdapter.castToType((Object)this.task.get(), IgBaseTask.class));
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$2(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, AgentProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$2(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, AgentProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$2(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, AgentProcessor.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            };
        }

        public void runTask0(IgBaseTask task) {
            Reference task2 = new Reference((Object)task);
            this.this$0.notifyTaskStart((IgBaseTask)task2.get());
            Reference error = new Reference((Object)false);
            Boolean cfr_ignored_0 = (Boolean)error.get();
            try {
                try {
                    Object result = ((IgBaseTask)task2.get()).call();
                    this.this$0.notifyComplete((IgBaseTask)task2.get(), result);
                    boolean bl = result instanceof Integer && DefaultTypeTransformation.intUnbox(result) > 0;
                    error.set((Object)bl);
                }
                catch (InterruptedException e) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ((IgBaseTask)task2.get()).getTaskId();
                    String string = e.getMessage();
                    objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : e;
                    Bolts.trace((Logger)log, (Object)new GStringImpl(objectArray, new String[]{"=== Task execution was interrupted: taskId=", " -- Message: ", ""}));
                    boolean bl = true;
                    error.set((Object)bl);
                }
                catch (ClosedByInterruptException e) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ((IgBaseTask)task2.get()).getTaskId();
                    String string = e.getMessage();
                    objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : e;
                    Bolts.trace((Logger)log, (Object)new GStringImpl(objectArray, new String[]{"=== Task execution was interrupted: taskId=", " -- Message: ", ""}));
                    boolean bl = true;
                    error.set((Object)bl);
                }
                catch (Throwable e) {
                    this.this$0.notifyError((IgBaseTask)task2.get(), e);
                    boolean bl = true;
                    error.set((Object)bl);
                }
            }
            finally {
                public final class _runTask0_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference error;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _runTask0_closure4(Object _outerInstance, Object _thisObject, Reference task, Reference error) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.task = reference2 = task;
                        this.error = reference = error;
                    }

                    public Object doCall(Object it) {
                        ((AgentProcessor)this.getOwner()).rollbackResources((IgBaseTask)ScriptBytecodeAdapter.castToType((Object)this.task.get(), IgBaseTask.class), DefaultTypeTransformation.booleanUnbox((Object)this.error.get()));
                        return null;
                    }

                    public IgBaseTask getTask() {
                        return (IgBaseTask)ScriptBytecodeAdapter.castToType((Object)this.task.get(), IgBaseTask.class);
                    }

                    public Boolean getError() {
                        return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.error.get(), Boolean.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _runTask0_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                this.async(new _runTask0_closure4(this, this, task2, error));
            }
        }

        public void rollbackResources(IgBaseTask task, boolean errorFlag) {
            Protocol.TaskResources used = task.getResources();
            TaskId taskId = task.getTaskId();
            if (this.this$0.runningTasks.containsKey(taskId)) {
                this.this$0.runningTasks.remove(taskId);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)(this.current.getCpus() + used.getCpus()), AgentProcessor.class, (GroovyObject)this.current, (String)"cpus");
                MemoryUnit memoryUnit = this.current.getMemory().plus(used.getMemory());
                this.current.setMemory(memoryUnit);
                MemoryUnit memoryUnit2 = SysHelper.getAvailDisk();
                this.current.setDisk(memoryUnit2);
                Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{taskId, this.current}, new String[]{"=== Resources after task execution: taskId=", "; ", ""}));
                if (this.current.getCpus() == this.this$0.total.getCpus()) {
                    long l = System.currentTimeMillis();
                    this.idleTimestamp = l;
                }
            }
            if (errorFlag) {
                int n = this.execErrCount;
                this.execErrCount = n + 1;
            } else {
                int n;
                this.execErrCount = n = 0;
            }
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{errorFlag, this.execErrCount}, new String[]{"=== Errors: flag=", "; execErrCount=", ""}));
        }

        public void checkIfIdle() {
            long now = System.currentTimeMillis();
            if (DefaultTypeTransformation.booleanUnbox((Object)this.idleTimestamp) && now - this.idleTimestamp > this._1_min) {
                this.this$0.notifyNodeIdle(this.idleTimestamp);
                int n = 0;
                this.idleTimestamp = n;
            }
        }

        public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AgentProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$2(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AgentProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$2(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(AgentProcessor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(AgentProcessor.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(AgentProcessor.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != AgentProcessor.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    static class RunHolder
    implements GroovyObject {
        private Future future;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public RunHolder(Future future) {
            Future future2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.future = future2 = future;
        }

        @Generated
        public RunHolder() {
            this(null);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(RunHolder.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(RunHolder.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(RunHolder.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(RunHolder.class, SchedulerAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != RunHolder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Future getFuture() {
            return this.future;
        }

        @Generated
        public void setFuture(Future future) {
            this.future = future;
        }
    }
}

