/*
 * Decompiled with CFR 0.152.
 */
package nextflow.executor;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import nextflow.Session;
import nextflow.executor.IgBaseTask;
import nextflow.executor.IgClosureTask;
import nextflow.executor.IgExecutor;
import nextflow.executor.IgResultData;
import nextflow.executor.IgScriptTask;
import nextflow.extension.Bolts;
import nextflow.file.FileHelper;
import nextflow.processor.TaskContext;
import nextflow.processor.TaskHandler;
import nextflow.processor.TaskRun;
import nextflow.processor.TaskStatus;
import nextflow.scheduler.Protocol;
import nextflow.script.ScriptType;
import nextflow.util.Duration;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.NioGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgTaskHandler
extends TaskHandler {
    private static final Duration READ_TIMEOUT;
    private long timeout;
    private IgExecutor executor;
    private ScriptType type;
    private Path exitFile;
    private Path outputFile;
    private Path errorFile;
    private long begin;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    private IgTaskHandler(TaskRun task) {
        super(task);
    }

    public static IgTaskHandler createScriptHandler(TaskRun task, IgExecutor executor) {
        IgTaskHandler handler = new IgTaskHandler(task);
        IgExecutor igExecutor = executor;
        ScriptBytecodeAdapter.setProperty((Object)((Object)igExecutor), null, (Object)((Object)handler), (String)"executor");
        ScriptType scriptType = ScriptType.SCRIPTLET;
        ScriptBytecodeAdapter.setProperty((Object)scriptType, null, (Object)((Object)handler), (String)"type");
        Path path = task.getWorkDir().resolve(TaskRun.CMD_EXIT);
        ScriptBytecodeAdapter.setProperty((Object)path, null, (Object)((Object)handler), (String)"exitFile");
        Path path2 = task.getWorkDir().resolve(TaskRun.CMD_OUTFILE);
        ScriptBytecodeAdapter.setProperty((Object)path2, null, (Object)((Object)handler), (String)"outputFile");
        Path path3 = task.getWorkDir().resolve(TaskRun.CMD_ERRFILE);
        ScriptBytecodeAdapter.setProperty((Object)path3, null, (Object)((Object)handler), (String)"errorFile");
        Session session = executor.getSession();
        Duration duration = session != null ? session.getExitReadTimeout(executor.getName(), READ_TIMEOUT) : null;
        long l = (DefaultTypeTransformation.booleanUnbox(duration) ? duration : READ_TIMEOUT).toMillis();
        ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)((Object)handler), (String)"timeout");
        return handler;
    }

    public static IgTaskHandler createGroovyHandler(TaskRun task, IgExecutor executor) {
        IgTaskHandler handler = new IgTaskHandler(task);
        IgExecutor igExecutor = executor;
        ScriptBytecodeAdapter.setProperty((Object)((Object)igExecutor), null, (Object)((Object)handler), (String)"executor");
        ScriptType scriptType = ScriptType.GROOVY;
        ScriptBytecodeAdapter.setProperty((Object)scriptType, null, (Object)((Object)handler), (String)"type");
        return handler;
    }

    public void submit() {
        UUID sessionId = this.getTask().getProcessor().getSession().getUniqueId();
        IgBaseTask remoteTask = ScriptBytecodeAdapter.compareEqual((Object)this.type, (Object)ScriptType.SCRIPTLET) ? new IgScriptTask(this.getTask(), sessionId) : new IgClosureTask(this.getTask(), sessionId);
        this.executor.execute(remoteTask);
        TaskStatus taskStatus = TaskStatus.SUBMITTED;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskStatus, IgTaskHandler.class, (GroovyObject)this, (String)"status");
        Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask()}, new String[]{"Task SUBMITTED > ", ""}));
    }

    public boolean checkIfRunning() {
        if (this.isSubmitted() && this.isStarted()) {
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask()}, new String[]{"Task RUNNING > ", ""}));
            TaskStatus taskStatus = TaskStatus.RUNNING;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskStatus, IgTaskHandler.class, (GroovyObject)this, (String)"status");
            return true;
        }
        return false;
    }

    private boolean isStarted() {
        return this.executor.checkTaskStarted(this.getTask().getId());
    }

    public boolean checkIfCompleted() {
        if (this.isRunning() && this.executor.checkTaskCompleted(this.getTask().getId())) {
            if (!this.executor.checkTaskFailed(this.getTask().getId()) && DefaultTypeTransformation.booleanUnbox((Object)this.exitFile) && this.readExitStatus() == null) {
                return false;
            }
            Bolts.trace((Logger)log, (Object)new GStringImpl(new Object[]{this.getTask()}, new String[]{"Task DONE > ", ""}));
            TaskStatus taskStatus = TaskStatus.COMPLETED;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskStatus, IgTaskHandler.class, (GroovyObject)this, (String)"status");
            Protocol.TaskHolder holder = this.executor.removeTaskCompleted(this.getTask().getId());
            if (DefaultTypeTransformation.booleanUnbox((Object)holder.getError())) {
                Throwable throwable = holder.getError();
                this.getTask().setError(throwable);
                return true;
            }
            if (this.isScriptlet()) {
                Path path = this.outputFile;
                this.getTask().setStdout((Object)path);
                Path path2 = this.errorFile;
                this.getTask().setStderr((Object)path2);
                Integer n = (Integer)ScriptBytecodeAdapter.asType((Object)holder.getResult(), Integer.class);
                this.getTask().setExitStatus(n);
            } else {
                IgResultData data = (IgResultData)ScriptBytecodeAdapter.asType((Object)holder.getResult(), IgResultData.class);
                Object object = data.getValue();
                this.getTask().setStdout(object);
                TaskContext taskContext = new TaskContext(this.getTask().getProcessor(), data.getContext());
                this.getTask().setContext(taskContext);
            }
            return true;
        }
        return false;
    }

    protected Integer readExitStatus() {
        String workDirList = null;
        if (!(this.begin != 0L)) {
            long l = System.currentTimeMillis();
            this.begin = l;
        } else {
            String string;
            workDirList = string = FileHelper.listDirectory((Path)this.getTask().getWorkDir());
        }
        Integer exitStatus = this.safeReadExitStatus();
        if (exitStatus != null) {
            return exitStatus;
        }
        if (!FileHelper.getWorkDirIsNFS()) {
            return Integer.MAX_VALUE;
        }
        long delta = System.currentTimeMillis() - this.begin;
        if (delta > this.timeout) {
            List errMessage = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            DefaultGroovyMethods.leftShift((List)errMessage, (Object)new GStringImpl(new Object[]{this, Duration.of((long)this.timeout), Duration.of((long)delta)}, new String[]{"Failed to get exit status for process ", " -- exit-status-read-timeout=", "; delta=", ""}));
            DefaultGroovyMethods.leftShift((List)errMessage, (Object)"Current queue status:");
            String string = this.executor.dumpQueueStatus();
            DefaultGroovyMethods.leftShift((List)errMessage, string != null ? Bolts.indent((String)string, (String)"> ") : null);
            DefaultGroovyMethods.leftShift((List)errMessage, (Object)new GStringImpl(new Object[]{this.getTask().getWorkDir()}, new String[]{"Content of workDir: ", ""}));
            String string2 = workDirList;
            DefaultGroovyMethods.leftShift((List)errMessage, string2 != null ? Bolts.indent((String)string2, (String)"> ") : null);
            log.debug(DefaultGroovyMethods.join((Iterable)errMessage, (String)"\n"));
            return Integer.MAX_VALUE;
        }
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.exitFile, Duration.of((long)delta)}, new String[]{"Command exit file is empty: ", " after ", " -- Try to wait a while and .. pray."})));
        return (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
    }

    private Integer safeReadExitStatus() {
        block10: {
            String status = null;
            try {
                String string;
                status = string = NioGroovyMethods.getText((Path)this.exitFile);
            }
            catch (NoSuchFileException e) {
                Integer n = (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
                return n;
            }
            if (!(status != null)) break block10;
            Integer n = StringGroovyMethods.toInteger((CharSequence)status);
            try {
                return n;
            }
            catch (NumberFormatException e) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.exitFile, status}, new String[]{"Unable to parse process exit file: ", " -- bad value: '", "'"})));
            }
        }
        return (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
    }

    public void kill() {
        this.executor.cancelTask(this.getTask().getId());
    }

    public boolean isScriptlet() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.type, (Object)ScriptType.SCRIPTLET);
    }

    public boolean isGroovy() {
        return ScriptBytecodeAdapter.compareEqual((Object)this.type, (Object)ScriptType.GROOVY);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != IgTaskHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        Duration duration;
        READ_TIMEOUT = duration = Duration.of((String)"270sec");
        log = logger = LoggerFactory.getLogger((String)"nextflow.executor.IgTaskHandler");
    }
}

