/*
 * Decompiled with CFR 0.152.
 */
package nextflow.executor;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nextflow.daemon.IgGridFactory;
import nextflow.executor.IgBaseTask;
import nextflow.executor.IgFileStagingStrategy;
import nextflow.executor.IgResultData;
import nextflow.executor.StagingStrategy;
import nextflow.extension.Bolts;
import nextflow.processor.TaskBean;
import nextflow.processor.TaskContext;
import nextflow.processor.TaskRun;
import nextflow.util.InputStreamDeserializer;
import nextflow.util.RemoteSession;
import org.apache.commons.lang.SerializationUtils;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgClosureTask
extends IgBaseTask<IgResultData> {
    private static final long serialVersionUID = 5515528753549263068L;
    private static final Map<UUID, GroovyClassLoader> classLoaderCache;
    private final byte[] codeObj;
    private final byte[] delegateObj;
    private transient StagingStrategy stagingStrategy;
    private static final transient Logger log;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public IgClosureTask(TaskRun task, UUID sessionId) {
        super(task, sessionId);
        byte[] byArray = SerializationUtils.serialize((Serializable)task.getCode().dehydrate());
        this.codeObj = byArray;
        byte[] byArray2 = task.getContext().dehydrate();
        this.delegateObj = byArray2;
    }

    @Override
    public void beforeExecute() {
        IgFileStagingStrategy igFileStagingStrategy = new IgFileStagingStrategy();
        TaskBean taskBean = this.bean;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskBean, IgClosureTask.class, (GroovyObject)igFileStagingStrategy, (String)"task");
        UUID uUID = this.getSessionId();
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)uUID, IgClosureTask.class, (GroovyObject)igFileStagingStrategy, (String)"sessionId");
        IgFileStagingStrategy igFileStagingStrategy2 = igFileStagingStrategy;
        this.stagingStrategy = igFileStagingStrategy2;
        this.stagingStrategy.stage();
    }

    @Override
    public void afterExecute() {
        this.stagingStrategy.unstage();
    }

    @Override
    protected IgResultData execute0() throws IgniteException {
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.bean.getName()}, new String[]{"Running closure for task > ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        ClassLoader loader = IgClosureTask.getClassLoaderFor(this.getSessionId());
        TaskContext delegate = TaskContext.rehydrate((byte[])this.delegateObj, (ClassLoader)loader);
        Closure closure = (Closure)ScriptBytecodeAdapter.castToType((Object)InputStreamDeserializer.deserialize((byte[])this.codeObj, (ClassLoader)loader), Closure.class);
        Object result = closure.rehydrate((Object)delegate, (Object)delegate.getScript(), (Object)delegate.getScript()).call();
        IgResultData igResultData = new IgResultData();
        Object object = result;
        igResultData.setValue(object);
        TaskContext taskContext = delegate;
        Map map = taskContext != null ? taskContext.getHolder() : null;
        igResultData.setContext(map);
        return igResultData;
    }

    public void cancel() {
    }

    protected static ClassLoader getClassLoaderFor(UUID sessionId) {
        Reference sessionId2 = new Reference((Object)sessionId);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            UUID uUID = (UUID)sessionId2.get();
            valueRecorder.record((Object)uUID, 8);
            if (uUID != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sessionId", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        public final class _getClassLoaderFor_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sessionId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClassLoaderFor_closure1(Object _outerInstance, Object _thisObject, Reference sessionId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.sessionId = reference = sessionId;
            }

            public Object doCall(Object it) {
                IgniteCache allSessions = IgGridFactory.ignite().cache(IgGridFactory.SESSIONS_CACHE);
                if (!DefaultTypeTransformation.booleanUnbox((Object)allSessions)) {
                    throw (Throwable)new IllegalStateException("Missing session cache object");
                }
                RemoteSession session = (RemoteSession)ScriptBytecodeAdapter.castToType((Object)allSessions.get(this.sessionId.get()), RemoteSession.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)session)) {
                    throw (Throwable)new IllegalStateException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.sessionId.get()}, new String[]{"Missing session object for id: ", ""})));
                }
                Reference result = new Reference((Object)new GroovyClassLoader());
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference result;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference result) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.result = reference = result;
                    }

                    public Object doCall(Path file) {
                        Object v0;
                        if (log.isDebugEnabled()) {
                            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"Adding to classpath: ", ""})));
                            v0 = null;
                        } else {
                            v0 = null;
                        }
                        ((GroovyClassLoader)this.result.get()).addClasspath(file.toAbsolutePath().toString());
                        return null;
                    }

                    public Object call(Path file) {
                        return this.doCall(file);
                    }

                    @Generated
                    public Object getResult() {
                        return this.result.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((List)session.getClasspath(), (Closure)new _closure2((Object)this, this.getThisObject(), result));
                return (GroovyClassLoader)result.get();
            }

            @Generated
            public UUID getSessionId() {
                return (UUID)ScriptBytecodeAdapter.castToType((Object)this.sessionId.get(), UUID.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClassLoaderFor_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (ClassLoader)Bolts.getOrCreate(classLoaderCache, (Object)((UUID)sessionId2.get()), (Closure)new _getClassLoaderFor_closure1(IgClosureTask.class, IgClosureTask.class, sessionId2));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IgClosureTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 5515528753549263068L;
    }

    static {
        Logger logger;
        IgClosureTask.__$swapInit();
        HashMap<UUID, GroovyClassLoader> hashMap = new HashMap<UUID, GroovyClassLoader>();
        classLoaderCache = hashMap;
        log = logger = LoggerFactory.getLogger((String)"nextflow.executor.IgClosureTask");
    }

    @Generated
    public static Map<UUID, GroovyClassLoader> getClassLoaderCache() {
        return classLoaderCache;
    }

    @Generated
    public final byte[] getCodeObj() {
        return this.codeObj;
    }

    @Generated
    public final byte[] getDelegateObj() {
        return this.delegateObj;
    }
}

