/*
 * Decompiled with CFR 0.152.
 */
package nextflow.executor;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import nextflow.executor.StagingStrategy;
import nextflow.extension.FilesEx;
import nextflow.file.FileHelper;
import nextflow.processor.TaskBean;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.NioGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgFileStagingStrategy
implements StagingStrategy,
GroovyObject {
    protected TaskBean task;
    protected UUID sessionId;
    protected Path localWorkDir;
    private static final Path _localCacheDir;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public IgFileStagingStrategy() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Logger logger;
        Path path;
        _localCacheDir = path = FileHelper.createLocalDir();
        log = logger = LoggerFactory.getLogger((String)"nextflow.executor.IgFileStagingStrategy");
        public final class __clinit__closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return NioGroovyMethods.deleteDir((Path)_localCacheDir);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.addShutdownHook((Object)Runtime.getRuntime(), (Closure)new __clinit__closure1(IgFileStagingStrategy.class, IgFileStagingStrategy.class));
    }

    public Path getLocalCacheDir() {
        return _localCacheDir;
    }

    @Override
    public void stage() {
        Path path;
        this.localWorkDir = path = FileHelper.createLocalDir();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.task.getInputFiles())) {
            return;
        }
        Map.Entry entry = null;
        Iterator iterator = this.task.getInputFiles().entrySet().iterator();
        while (iterator.hasNext()) {
            Object v0;
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            String fileName = ShortTypeHandling.castToString(entry.getKey());
            Path source = (Path)ScriptBytecodeAdapter.castToType(entry.getValue(), Path.class);
            Path cached = FileHelper.getLocalCachePath((Path)source, (Path)this.getLocalCacheDir(), (UUID)this.sessionId);
            Path staged = this.localWorkDir.resolve(fileName);
            if (fileName.contains("/")) {
                Files.createDirectories(staged.getParent(), new FileAttribute[0]);
            }
            if (log.isDebugEnabled()) {
                Logger logger = log;
                if (logger != null) {
                    logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.task.getName(), source, staged}, new String[]{"Task ", " > staging path: '", "' to: '", "'"})));
                    v0 = null;
                } else {
                    v0 = null;
                }
            } else {
                v0 = null;
            }
            Files.createSymbolicLink(staged, cached, new FileAttribute[0]);
        }
    }

    @Override
    public void unstage() {
        Object v0;
        if (log.isDebugEnabled()) {
            Logger logger = log;
            if (logger != null) {
                logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.task.getOutputFiles()}, new String[]{"Unstaging file names: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        } else {
            v0 = null;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.task.getOutputFiles())) {
            return;
        }
        if (!Files.exists(this.task.getTargetDir(), new LinkOption[0])) {
            Files.createDirectories(this.task.getTargetDir(), new FileAttribute[0]);
        }
        String name = null;
        Iterator iterator = this.task.getOutputFiles().iterator();
        while (iterator.hasNext()) {
            name = ShortTypeHandling.castToString(iterator.next());
            try {
                this.copyToTargetDir(name, this.localWorkDir, this.task.getTargetDir());
            }
            catch (IOException e) {
                Object v1;
                if (log.isErrorEnabled()) {
                    Logger logger = log;
                    if (logger != null) {
                        logger.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"Unable to copy result file: ", " to target dir"})), (Throwable)e);
                        v1 = null;
                        continue;
                    }
                    v1 = null;
                    continue;
                }
                v1 = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void copyToTargetDir(String filePattern, Path from, Path to) {
        void var3_3;
        Reference from2 = new Reference((Object)from);
        Reference to2 = new Reference((Object)var3_3);
        String type = filePattern.contains("**") ? "file" : "any";
        public final class _copyToTargetDir_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference from;
            private /* synthetic */ Reference to;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copyToTargetDir_closure2(Object _outerInstance, Object _thisObject, Reference from, Reference to) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.from = reference2 = from;
                this.to = reference = to;
            }

            public Object doCall(Path it) {
                String rel = ((Path)this.from.get()).relativize(it).toString();
                return FilesEx.copyTo((Path)it, (Path)((Path)this.to.get()).resolve(rel));
            }

            public Object call(Path it) {
                return this.doCall(it);
            }

            @Generated
            public Path getFrom() {
                return (Path)ScriptBytecodeAdapter.castToType((Object)this.from.get(), Path.class);
            }

            @Generated
            public Path getTo() {
                return (Path)ScriptBytecodeAdapter.castToType((Object)this.to.get(), Path.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyToTargetDir_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        FileHelper.visitFiles((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", type}), (Path)((Path)from2.get()), (String)filePattern, (Closure)new _copyToTargetDir_closure2(this, this, from2, to2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IgFileStagingStrategy.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

