/*
 * Decompiled with CFR 0.152.
 */
package nextflow.executor;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import nextflow.executor.BashWrapperBuilder;
import nextflow.executor.IgBaseTask;
import nextflow.executor.IgScriptStagingStrategy;
import nextflow.executor.ScriptFileCopyStrategy;
import nextflow.file.FileHelper;
import nextflow.processor.TaskBean;
import nextflow.processor.TaskRun;
import org.apache.ignite.IgniteException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgScriptTask
extends IgBaseTask<Integer> {
    private static final long serialVersionUID = -5552939711667527410L;
    private transient Process process;
    private transient IgScriptStagingStrategy stageStrategy;
    private transient boolean isRemoteWorkDir;
    private transient Path localWorkDir;
    private static final transient Logger log;
    private static /* synthetic */ Long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public IgScriptTask(TaskRun task, UUID sessionId) {
        super(task, sessionId);
    }

    @Override
    protected void beforeExecute() {
        boolean bl;
        this.isRemoteWorkDir = bl = ScriptBytecodeAdapter.compareNotEqual((Object)this.bean.getWorkDir().getFileSystem(), (Object)FileSystems.getDefault());
        if (this.isRemoteWorkDir) {
            Path path;
            IgScriptStagingStrategy igScriptStagingStrategy;
            IgScriptStagingStrategy igScriptStagingStrategy2 = new IgScriptStagingStrategy();
            TaskBean taskBean = this.bean.clone();
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)taskBean, IgScriptTask.class, (GroovyObject)igScriptStagingStrategy2, (String)"task");
            UUID uUID = this.getSessionId();
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)uUID, IgScriptTask.class, (GroovyObject)igScriptStagingStrategy2, (String)"sessionId");
            this.stageStrategy = igScriptStagingStrategy = igScriptStagingStrategy2;
            this.stageStrategy.stage();
            this.localWorkDir = path = this.stageStrategy.localWorkDir;
        } else {
            Path path;
            this.localWorkDir = path = this.bean.getWorkDir();
        }
    }

    @Override
    protected void afterExecute() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.stageStrategy)) {
            this.stageStrategy.unstage();
            this.cleanupLocalWorkDir();
        }
    }

    protected void cleanupLocalWorkDir() {
        block7: {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.bean.getCleanup(), (Object)false)) {
                return;
            }
            try {
                Object v0;
                List cmd = ScriptBytecodeAdapter.createList((Object[])new Object[]{"bash", "-c", new GStringImpl(new Object[]{this.localWorkDir, this.localWorkDir}, new String[]{"(sudo -n true && sudo rm -rf '", "' || rm -rf '", "')&>/dev/null"})});
                int status = ProcessGroovyMethods.execute((List)cmd).waitFor();
                if (status == 0) break block7;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.localWorkDir}, new String[]{"Can't cleanup path: ", ""})));
                    v0 = null;
                    break block7;
                }
                v0 = null;
            }
            catch (Exception e) {
                Object v1;
                if (log.isDebugEnabled()) {
                    String string = e.getMessage();
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.localWorkDir, DefaultTypeTransformation.booleanUnbox((Object)string) ? string : e}, new String[]{"Error while cleaning-up path: ", " -- Cause: ", ""})));
                    v1 = null;
                    break block7;
                }
                v1 = null;
            }
        }
    }

    @Override
    protected Integer execute0() throws IgniteException {
        Object v1;
        Process process;
        Object v0;
        BashWrapperBuilder wrapper = new BashWrapperBuilder(this.bean);
        if (this.isRemoteWorkDir) {
            IgScriptStagingStrategy igScriptStagingStrategy = this.stageStrategy;
            wrapper.setCopyStrategy((ScriptFileCopyStrategy)igScriptStagingStrategy);
            Path path = this.localWorkDir;
            wrapper.setWorkDir(path);
            Object var4_4 = null;
            wrapper.setScratch(var4_4);
            Path path2 = this.stageStrategy.getLocalCacheDir();
            wrapper.setContainerMount(path2);
        } else {
            Object object = wrapper.getScratch();
            String scratch = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
            if (ScriptBytecodeAdapter.compareEqual((Object)scratch, (Object)"true") || ScriptBytecodeAdapter.compareEqual((Object)scratch, (Object)"auto")) {
                String string = FileHelper.getLocalTempPath().toString();
                wrapper.setScratch((Object)string);
            }
        }
        ArrayList<String> job = new ArrayList<String>(this.bean.getShell());
        job.add(wrapper.build().toString());
        List cmd = ScriptBytecodeAdapter.createList((Object[])new Object[]{"/bin/bash", "-c", StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.join(job, (String)" "), (CharSequence)" &>"), (CharSequence)TaskRun.CMD_LOG)});
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.bean.getName(), this.getTaskId(), this.localWorkDir, this.isRemoteWorkDir}, new String[]{"Running task > ", " -- taskId=", "; workdir=", "; remote=", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(this.localWorkDir.toFile()).command(cmd).redirectErrorStream(true);
        this.process = process = builder.start();
        int result = this.process.waitFor();
        this.process.destroy();
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.bean.getName(), this.getTaskId(), result}, new String[]{"Completed task > ", " -- taskId=", "; exitStatus=", ""})));
            v1 = null;
        } else {
            v1 = null;
        }
        return result;
    }

    public void cancel() {
        Object v1;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.process)) {
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.bean.getName(), this.getTaskId()}, new String[]{"Cancelling process for task > ", " -- taskId=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            this.process.destroy();
        } else if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.bean.getName(), this.getTaskId()}, new String[]{"No process to cancel for task > ", " -- taskId=", ""})));
            v1 = null;
        } else {
            v1 = null;
        }
    }

    @Override
    public String toString() {
        TaskBean taskBean;
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getClass().getSimpleName(), this.getTaskId(), (taskBean = this.bean) != null ? taskBean.getName() : null, this.localWorkDir}, new String[]{"", "[taskId: ", "; name: ", "; workDir: ", "]"}));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IgScriptTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        long l = -5552939711667527410L;
        $const$0 = l;
    }

    static {
        Logger logger;
        IgScriptTask.__$swapInit();
        log = logger = LoggerFactory.getLogger((String)"nextflow.executor.IgScriptTask");
    }
}

