/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.upplication.s3fs.S3OutputStream;
import com.upplication.s3fs.S3Path;
import com.upplication.s3fs.util.S3MultipartOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3Client {
    private static final Logger log = LoggerFactory.getLogger(AmazonS3Client.class);
    AmazonS3 client;

    public AmazonS3Client(AmazonS3 client) {
        this.client = client;
    }

    public List<Bucket> listBuckets() {
        return this.client.listBuckets();
    }

    public ObjectListing listObjects(ListObjectsRequest request) {
        return this.client.listObjects(request);
    }

    public S3Object getObject(String bucketName, String key) {
        return this.client.getObject(bucketName, key);
    }

    public PutObjectResult putObject(String bucket, String key, File file) {
        return this.client.putObject(bucket, key, file);
    }

    public PutObjectResult putObject(String bucket, String keyName, InputStream inputStream, ObjectMetadata metadata) {
        return this.client.putObject(bucket, keyName, inputStream, metadata);
    }

    public void deleteObject(String bucket, String key) {
        this.client.deleteObject(bucket, key);
    }

    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        return this.client.copyObject(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) {
        return this.client.copyObject(copyObjectRequest);
    }

    public AccessControlList getBucketAcl(String bucket) {
        return this.client.getBucketAcl(bucket);
    }

    public Owner getS3AccountOwner() {
        return this.client.getS3AccountOwner();
    }

    public void setEndpoint(String endpoint) {
        this.client.setEndpoint(endpoint);
    }

    public void setRegion(String regionName) {
        Region region = RegionUtils.getRegion((String)regionName);
        if (region == null) {
            throw new IllegalArgumentException("Not a valid S3 region name: " + regionName);
        }
        this.client.setRegion(region);
    }

    public AccessControlList getObjectAcl(String bucketName, String key) {
        return this.client.getObjectAcl(bucketName, key);
    }

    public ObjectMetadata getObjectMetadata(String bucketName, String key) {
        return this.client.getObjectMetadata(bucketName, key);
    }

    public ObjectListing listNextBatchOfObjects(ObjectListing objectListing) {
        return this.client.listNextBatchOfObjects(objectListing);
    }

    public void multipartCopyObject(S3Path s3Source, S3Path s3Target, Long objectSize, S3MultipartOptions opts) {
        String sourceBucketName = s3Source.getBucket();
        String sourceObjectKey = s3Source.getKey();
        String targetBucketName = s3Target.getBucket();
        String targetObjectKey = s3Target.getKey();
        InitiateMultipartUploadRequest initiateRequest = new InitiateMultipartUploadRequest(targetBucketName, targetObjectKey);
        InitiateMultipartUploadResult initResult = this.client.initiateMultipartUpload(initiateRequest);
        String uploadId = initResult.getUploadId();
        if (objectSize == null) {
            GetObjectMetadataRequest metadataRequest = new GetObjectMetadataRequest(sourceBucketName, sourceObjectKey);
            ObjectMetadata metadataResult = this.client.getObjectMetadata(metadataRequest);
            objectSize = metadataResult.getContentLength();
        }
        int partSize = opts.getChunkSize(objectSize);
        ExecutorService executor = S3OutputStream.getOrCreateExecutor(opts.getMaxThreads());
        ArrayList<Callable<CopyPartResult>> copyPartRequests = new ArrayList<Callable<CopyPartResult>>();
        long bytePosition = 0L;
        int i = 1;
        while (bytePosition < objectSize) {
            long lastPosition = bytePosition + (long)partSize - 1L >= objectSize ? objectSize - 1L : bytePosition + (long)partSize - 1L;
            CopyPartRequest copyRequest = new CopyPartRequest().withDestinationBucketName(targetBucketName).withDestinationKey(targetObjectKey).withSourceBucketName(sourceBucketName).withSourceKey(sourceObjectKey).withUploadId(uploadId).withFirstByte(Long.valueOf(bytePosition)).withLastByte(Long.valueOf(lastPosition)).withPartNumber(i);
            copyPartRequests.add(AmazonS3Client.copyPart(this.client, copyRequest, opts));
            bytePosition += (long)partSize;
            ++i;
        }
        log.trace("Starting multipart copy from: {} to {} -- uploadId={}; objectSize={}; chunkSize={}; numOfChunks={}", new Object[]{s3Source, s3Target, uploadId, objectSize, partSize, copyPartRequests.size()});
        ArrayList<PartETag> etags = new ArrayList<PartETag>();
        try {
            List responses = executor.invokeAll(copyPartRequests);
            for (Future response : responses) {
                CopyPartResult result = (CopyPartResult)response.get();
                etags.add(new PartETag(result.getPartNumber(), result.getETag()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Multipart copy reported an unexpected error -- uploadId=" + uploadId, e);
        }
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(targetBucketName, targetObjectKey, initResult.getUploadId(), etags);
        log.trace("Completing multipart copy uploadId={}", (Object)uploadId);
        this.client.completeMultipartUpload(completeRequest);
    }

    static Callable<CopyPartResult> copyPart(final AmazonS3 client, final CopyPartRequest request, final S3MultipartOptions opts) {
        return new Callable<CopyPartResult>(){

            @Override
            public CopyPartResult call() throws Exception {
                return AmazonS3Client.copyPart0(client, request, opts);
            }
        };
    }

    static CopyPartResult copyPart0(AmazonS3 client, CopyPartRequest request, S3MultipartOptions opts) throws IOException, InterruptedException {
        String objectId = request.getUploadId();
        int partNumber = request.getPartNumber();
        long len = request.getLastByte() - request.getFirstByte();
        int attempt = 0;
        CopyPartResult result = null;
        while (result == null) {
            ++attempt;
            try {
                log.trace("Copying multipart {} with length {} attempt {} for {} ", new Object[]{partNumber, len, attempt, objectId});
                result = client.copyPart(request);
            }
            catch (AmazonClientException e) {
                if (attempt >= opts.getMaxAttempts()) {
                    throw new IOException("Failed to upload multipart data to Amazon S3", e);
                }
                log.debug("Failed to upload part {} attempt {} for {} -- Caused by: {}", new Object[]{partNumber, attempt, objectId, e.getMessage()});
                Thread.sleep(opts.getRetrySleepWithAttempt(attempt));
            }
        }
        return result;
    }
}

