/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.Grant;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.upplication.s3fs.AmazonS3Client;
import com.upplication.s3fs.S3FileAttributes;
import com.upplication.s3fs.S3FileSystem;
import com.upplication.s3fs.S3Iterator;
import com.upplication.s3fs.S3OutputStream;
import com.upplication.s3fs.S3Path;
import com.upplication.s3fs.util.IOUtils;
import com.upplication.s3fs.util.S3MultipartOptions;
import com.upplication.s3fs.util.S3ObjectSummaryLookup;
import com.upplication.s3fs.util.S3UploadRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemProvider
extends FileSystemProvider {
    private static Logger log = LoggerFactory.getLogger(S3FileSystemProvider.class);
    public static final String ACCESS_KEY = "access_key";
    public static final String SECRET_KEY = "secret_key";
    public static final String SESSION_TOKEN = "session_token";
    final AtomicReference<S3FileSystem> fileSystem = new AtomicReference();
    private final S3ObjectSummaryLookup s3ObjectSummaryLookup = new S3ObjectSummaryLookup();
    private Properties props;

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkArgument((boolean)uri.getScheme().equals("s3"), (String)"uri scheme must be 's3': '%s'", (Object[])new Object[]{uri});
        this.props = this.loadAmazonProperties();
        String accessKey = this.props.getProperty(ACCESS_KEY);
        String secretKey = this.props.getProperty(SECRET_KEY);
        String sessionToken = this.props.getProperty(SESSION_TOKEN);
        if (env.get(ACCESS_KEY) != null) {
            accessKey = env.get(ACCESS_KEY);
        }
        if (env.get(SECRET_KEY) != null) {
            secretKey = env.get(SECRET_KEY);
        }
        if (env.get(SESSION_TOKEN) != null) {
            sessionToken = env.get(SESSION_TOKEN);
        }
        this.props.putAll(env);
        Preconditions.checkArgument((accessKey == null && secretKey == null || accessKey != null && secretKey != null ? 1 : 0) != 0, (String)"%s and %s (and optionally %s) should be provided or should be omitted", (Object[])new Object[]{ACCESS_KEY, SECRET_KEY, SESSION_TOKEN});
        S3FileSystem result = this.createFileSystem(uri, accessKey, secretKey, sessionToken);
        if (!this.fileSystem.compareAndSet(null, result)) {
            throw new FileSystemAlreadyExistsException("S3 filesystem already exists. Use getFileSystem() instead");
        }
        return result;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        FileSystem fileSystem = this.fileSystem.get();
        if (fileSystem == null) {
            throw new FileSystemNotFoundException(String.format("S3 filesystem not yet created. Use newFileSystem() instead", new Object[0]));
        }
        return fileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(this.getScheme()), (String)"URI scheme must be %s", (Object[])new Object[]{this.getScheme()});
        if (uri.getHost() != null && !uri.getHost().isEmpty() && !uri.getHost().equals(this.fileSystem.get().getEndpoint())) {
            throw new IllegalArgumentException(String.format("only empty URI host or URI host that matching the current fileSystem: %s", this.fileSystem.get().getEndpoint()));
        }
        return this.getFileSystem(uri).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Preconditions.checkArgument((boolean)(dir instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        final S3Path s3Path = (S3Path)dir;
        return new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public Iterator<Path> iterator() {
                return new S3Iterator(s3Path.getFileSystem(), s3Path.getBucket(), s3Path.getKey() + "/");
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        S3ObjectInputStream result;
        Preconditions.checkArgument((options.length == 0 ? 1 : 0) != 0, (String)"OpenOptions not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])options)});
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        Preconditions.checkArgument((!s3Path.getKey().equals("") ? 1 : 0) != 0, (String)"cannot create InputStream for root directory: %s", (Object[])new Object[]{s3Path});
        try {
            result = s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey()).getObjectContent();
            if (result == null) {
                throw new IOException(String.format("The specified path is a directory: %s", path));
            }
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                throw new NoSuchFileException(path.toString());
            }
            throw new IOException(String.format("Cannot access file: %s", path), e);
        }
        return result;
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        if (options.length > 0) {
            LinkedHashSet<OpenOption> opts = new LinkedHashSet<OpenOption>(Arrays.asList(options));
            if (opts.contains(StandardOpenOption.APPEND)) {
                return super.newOutputStream(path, options);
            }
            if (opts.contains(StandardOpenOption.READ)) {
                throw new IllegalArgumentException("READ not allowed");
            }
            boolean create = opts.remove(StandardOpenOption.CREATE);
            boolean createNew = opts.remove(StandardOpenOption.CREATE_NEW);
            boolean truncateExisting = opts.remove(StandardOpenOption.TRUNCATE_EXISTING);
            opts.remove(StandardOpenOption.WRITE);
            opts.remove(StandardOpenOption.SPARSE);
            if (!opts.isEmpty()) {
                throw new UnsupportedOperationException(opts.iterator().next() + " not supported");
            }
            if (!create || !truncateExisting) {
                if (this.exists(s3Path)) {
                    if (createNew || !truncateExisting) {
                        throw new FileAlreadyExistsException(path.toString());
                    }
                } else if (!createNew && !create) {
                    throw new NoSuchFileException(path.toString());
                }
            }
        }
        return this.createUploaderOutputStream(s3Path);
    }

    private S3OutputStream createUploaderOutputStream(S3Path fileToUpload) {
        AmazonS3 s3 = fileToUpload.getFileSystem().getClient().client;
        S3UploadRequest req = this.props != null ? new S3UploadRequest(this.props) : new S3UploadRequest();
        req.setObjectId(fileToUpload.toS3ObjectId());
        return new S3OutputStream(s3, req);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path tempFile;
        S3Path s3Path;
        block3: {
            Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
            s3Path = (S3Path)path;
            tempFile = this.createTempDir().resolve(path.getFileName().toString());
            try {
                S3ObjectInputStream is = s3Path.getFileSystem().getClient().getObject(s3Path.getBucket(), s3Path.getKey()).getObjectContent();
                if (is == null) {
                    throw new IOException(String.format("The specified path is a directory: %s", path));
                }
                Files.write(tempFile, IOUtils.toByteArray((InputStream)is), new OpenOption[0]);
            }
            catch (AmazonS3Exception e) {
                if (e.getStatusCode() == 404) break block3;
                throw new IOException(String.format("Cannot access file: %s", path), e);
            }
        }
        final SeekableByteChannel seekable = Files.newByteChannel(tempFile, options, new FileAttribute[0]);
        return new SeekableByteChannel(){

            @Override
            public boolean isOpen() {
                return seekable.isOpen();
            }

            @Override
            public void close() throws IOException {
                if (!seekable.isOpen()) {
                    return;
                }
                seekable.close();
                if (Files.exists(tempFile, new LinkOption[0])) {
                    ObjectMetadata metadata = new ObjectMetadata();
                    metadata.setContentLength(Files.size(tempFile));
                    metadata.setContentType(Files.probeContentType(tempFile));
                    try (InputStream stream = Files.newInputStream(tempFile, new OpenOption[0]);){
                        s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), s3Path.getKey(), stream, metadata);
                    }
                } else {
                    s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey());
                }
                Files.deleteIfExists(tempFile);
                Files.deleteIfExists(tempFile.getParent());
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return seekable.write(src);
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                return seekable.truncate(size);
            }

            @Override
            public long size() throws IOException {
                return seekable.size();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return seekable.read(dst);
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                return seekable.position(newPosition);
            }

            @Override
            public long position() throws IOException {
                return seekable.position();
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = (S3Path)dir;
        Preconditions.checkArgument((attrs.length == 0 ? 1 : 0) != 0, (String)"attrs not yet supported: %s", (Object[])new Object[]{ImmutableList.copyOf((Object[])attrs)});
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        String keyName = s3Path.getKey() + (s3Path.getKey().endsWith("/") ? "" : "/");
        s3Path.getFileSystem().getClient().putObject(s3Path.getBucket(), keyName, new ByteArrayInputStream(new byte[0]), metadata);
    }

    @Override
    public void delete(Path path) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException("the path: " + path + " not exists");
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                if (stream.iterator().hasNext()) {
                    throw new DirectoryNotEmptyException("the path: " + path + " is a directory and is not empty");
                }
            }
        }
        s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey());
        s3Path.getFileSystem().getClient().deleteObject(s3Path.getBucket(), s3Path.getKey() + "/");
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(source instanceof S3Path), (String)"source must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        Preconditions.checkArgument((boolean)(target instanceof S3Path), (String)"target must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        if (this.isSameFile(source, target)) {
            return;
        }
        S3Path s3Source = (S3Path)source;
        S3Path s3Target = (S3Path)target;
        ImmutableSet actualOptions = ImmutableSet.copyOf((Object[])options);
        this.verifySupportedOptions((Set)EnumSet.of(StandardCopyOption.REPLACE_EXISTING), (Set)actualOptions);
        if (!actualOptions.contains((Object)StandardCopyOption.REPLACE_EXISTING) && this.exists(s3Target)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", target));
        }
        AmazonS3Client client = s3Source.getFileSystem().getClient();
        ObjectMetadata sourceObjMetadata = s3Source.getFileSystem().getClient().getObjectMetadata(s3Source.getBucket(), s3Source.getKey());
        S3MultipartOptions opts = this.props != null ? new S3MultipartOptions(this.props) : new S3MultipartOptions();
        int chunkSize = opts.getChunkSize();
        long length = sourceObjMetadata.getContentLength();
        if (length <= (long)chunkSize) {
            CopyObjectRequest copyObjRequest = new CopyObjectRequest(s3Source.getBucket(), s3Source.getKey(), s3Target.getBucket(), s3Target.getKey());
            if (sourceObjMetadata.getSSEAlgorithm() != null) {
                ObjectMetadata targetObjectMetadata = new ObjectMetadata();
                targetObjectMetadata.setSSEAlgorithm(sourceObjMetadata.getSSEAlgorithm());
                copyObjRequest.setNewObjectMetadata(targetObjectMetadata);
            }
            client.copyObject(copyObjRequest);
        } else {
            client.multipartCopyObject(s3Source, s3Target, length, opts);
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        return path1.isAbsolute() && path2.isAbsolute() && path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        S3Path s3Path = (S3Path)path;
        Preconditions.checkArgument((boolean)s3Path.isAbsolute(), (String)"path must be absolute: %s", (Object[])new Object[]{s3Path});
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        AccessControlList acl = this.getAccessControl(s3Path);
        block5: for (AccessMode accessMode : modes) {
            switch (accessMode) {
                case EXECUTE: {
                    throw new AccessDeniedException(s3Path.toString(), null, "file is not executable");
                }
                case READ: {
                    if (this.hasPermissions(acl, client.getS3AccountOwner(), EnumSet.of(Permission.FullControl, Permission.Read))) continue block5;
                    throw new AccessDeniedException(s3Path.toString(), null, "file is not readable");
                }
                case WRITE: {
                    if (this.hasPermissions(acl, client.getS3AccountOwner(), EnumSet.of(Permission.FullControl, Permission.Write))) continue block5;
                    throw new AccessDeniedException(s3Path.toString(), null, String.format("bucket '%s' is not writable", s3Path.getBucket()));
                }
            }
        }
    }

    private boolean hasPermissions(AccessControlList acl, Owner owner, EnumSet<Permission> permissions) {
        boolean result = false;
        for (Grant grant : acl.getGrants()) {
            if (!grant.getGrantee().getIdentifier().equals(owner.getId()) || !permissions.contains(grant.getPermission())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Preconditions.checkArgument((boolean)(path instanceof S3Path), (String)"path must be an instance of %s", (Object[])new Object[]{S3Path.class.getName()});
        S3Path s3Path = (S3Path)path;
        if (type == BasicFileAttributes.class) {
            S3ObjectSummary objectSummary = this.s3ObjectSummaryLookup.lookup(s3Path);
            FileTime lastModifiedTime = null;
            if (objectSummary.getLastModified() != null) {
                lastModifiedTime = FileTime.from(objectSummary.getLastModified().getTime(), TimeUnit.MILLISECONDS);
            }
            long size = objectSummary.getSize();
            boolean directory = false;
            boolean regularFile = false;
            String key = objectSummary.getKey();
            if (objectSummary.getKey().equals(s3Path.getKey() + "/") && objectSummary.getKey().endsWith("/")) {
                directory = true;
            } else if ((!objectSummary.getKey().equals(s3Path.getKey()) || "".equals(s3Path.getKey())) && objectSummary.getKey().startsWith(s3Path.getKey())) {
                directory = true;
                size = 0L;
                key = s3Path.getKey() + "/";
            } else {
                regularFile = true;
            }
            return (A)((BasicFileAttributes)type.cast(new S3FileAttributes(key, lastModifiedTime, size, directory, regularFile)));
        }
        throw new UnsupportedOperationException(String.format("only %s supported", BasicFileAttributes.class));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected ClientConfiguration createClientConfig(Properties props) {
        ClientConfiguration config = new ClientConfiguration();
        if (props == null) {
            return config;
        }
        if (props.containsKey("connection_timeout")) {
            log.trace("AWS client config - connection_timeout: {}", (Object)props.getProperty("connection_timeout"));
            config.setConnectionTimeout(Integer.parseInt(props.getProperty("connection_timeout")));
        }
        if (props.containsKey("max_connections")) {
            log.trace("AWS client config - max_connections: {}", (Object)props.getProperty("max_connections"));
            config.setMaxConnections(Integer.parseInt(props.getProperty("max_connections")));
        }
        if (props.containsKey("max_error_retry")) {
            log.trace("AWS client config - max_error_retry: {}", (Object)props.getProperty("max_error_retry"));
            config.setMaxErrorRetry(Integer.parseInt(props.getProperty("max_error_retry")));
        }
        if (props.containsKey("protocol")) {
            log.trace("AWS client config - protocol: {}", (Object)props.getProperty("protocol"));
            config.setProtocol(Protocol.valueOf((String)props.getProperty("protocol").toUpperCase()));
        }
        if (props.containsKey("proxy_domain")) {
            log.trace("AWS client config - proxy_domain: {}", (Object)props.getProperty("proxy_domain"));
            config.setProxyDomain(props.getProperty("proxy_domain"));
        }
        if (props.containsKey("proxy_host")) {
            log.trace("AWS client config - proxy_host: {}", (Object)props.getProperty("proxy_host"));
            config.setProxyHost(props.getProperty("proxy_host"));
        }
        if (props.containsKey("proxy_port")) {
            log.trace("AWS client config - proxy_port: {}", (Object)props.getProperty("proxy_port"));
            config.setProxyPort(Integer.parseInt(props.getProperty("proxy_port")));
        }
        if (props.containsKey("proxy_username")) {
            log.trace("AWS client config - proxy_username: {}", (Object)props.getProperty("proxy_username"));
            config.setProxyUsername(props.getProperty("proxy_username"));
        }
        if (props.containsKey("proxy_password")) {
            log.trace("AWS client config - proxy_password: {}", (Object)props.getProperty("proxy_password"));
            config.setProxyPassword(props.getProperty("proxy_password"));
        }
        if (props.containsKey("proxy_workstation")) {
            log.trace("AWS client config - proxy_workstation: {}", (Object)props.getProperty("proxy_workstation"));
            config.setProxyWorkstation(props.getProperty("proxy_workstation"));
        }
        if (props.containsKey("signer_override")) {
            log.debug("AWS client config - signerOverride: {}", (Object)props.getProperty("signer_override"));
            config.setSignerOverride(props.getProperty("signer_override"));
        }
        if (props.containsKey("socket_send_buffer_size_hints") || props.containsKey("socket_recv_buffer_size_hints")) {
            log.trace("AWS client config - socket_send_buffer_size_hints: {}, socket_recv_buffer_size_hints: {}", (Object)props.getProperty("socket_send_buffer_size_hints", "0"), (Object)props.getProperty("socket_recv_buffer_size_hints", "0"));
            int send = Integer.parseInt(props.getProperty("socket_send_buffer_size_hints", "0"));
            int recv = Integer.parseInt(props.getProperty("socket_recv_buffer_size_hints", "0"));
            config.setSocketBufferSizeHints(send, recv);
        }
        if (props.containsKey("socket_timeout")) {
            log.trace("AWS client config - socket_timeout: {}", (Object)props.getProperty("socket_timeout"));
            config.setSocketTimeout(Integer.parseInt(props.getProperty("socket_timeout")));
        }
        if (props.containsKey("user_agent")) {
            log.trace("AWS client config - user_agent: {}", (Object)props.getProperty("user_agent"));
            config.setUserAgent(props.getProperty("user_agent"));
        }
        return config;
    }

    protected S3FileSystem createFileSystem(URI uri, Object accessKey, Object secretKey) {
        return this.createFileSystem0(uri, accessKey, secretKey, null);
    }

    protected S3FileSystem createFileSystem(URI uri, Object accessKey, Object secretKey, Object sessionToken) {
        return this.createFileSystem0(uri, accessKey, secretKey, sessionToken);
    }

    protected S3FileSystem createFileSystem0(URI uri, Object accessKey, Object secretKey, Object sessionToken) {
        boolean usePathStyle;
        AmazonS3Client client;
        ClientConfiguration config = this.createClientConfig(this.props);
        if (accessKey == null && secretKey == null) {
            client = new AmazonS3Client((AmazonS3)new com.amazonaws.services.s3.AmazonS3Client(config));
        } else {
            BasicAWSCredentials credentials = sessionToken == null ? new BasicAWSCredentials(accessKey.toString(), secretKey.toString()) : new BasicSessionCredentials(accessKey.toString(), secretKey.toString(), sessionToken.toString());
            client = new AmazonS3Client((AmazonS3)new com.amazonaws.services.s3.AmazonS3Client((AWSCredentials)credentials, config));
        }
        boolean bl = usePathStyle = "true".equals(this.props.getProperty("s_3_path_style_access")) || "true".equals(this.props.getProperty("s3_path_style_access"));
        if (usePathStyle) {
            S3ClientOptions options = S3ClientOptions.builder().setPathStyleAccess(usePathStyle).build();
            client.client.setS3ClientOptions(options);
        }
        if (uri.getHost() != null) {
            client.setEndpoint(uri.getHost());
        } else if (this.props.getProperty("endpoint") != null) {
            client.setEndpoint(this.props.getProperty("endpoint"));
        }
        return new S3FileSystem(this, client, uri.getHost());
    }

    protected Properties loadAmazonProperties() {
        Properties props = new Properties();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("amazon.properties");){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private <T> void verifySupportedOptions(Set<? extends T> allowedOptions, Set<? extends T> actualOptions) {
        Sets.SetView unsupported = Sets.difference(actualOptions, allowedOptions);
        Preconditions.checkArgument((boolean)unsupported.isEmpty(), (String)"the following options are not supported: %s", (Object[])new Object[]{unsupported});
    }

    private boolean exists(S3Path path) {
        try {
            this.s3ObjectSummaryLookup.lookup(path);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    private AccessControlList getAccessControl(S3Path path) throws NoSuchFileException {
        S3ObjectSummary obj = this.s3ObjectSummaryLookup.lookup(path);
        return path.getFileSystem().getClient().getObjectAcl(obj.getBucketName(), obj.getKey());
    }

    protected Path createTempDir() throws IOException {
        return Files.createTempDirectory("temp-s3-", new FileAttribute[0]);
    }
}

