/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs.util;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartOptions<V extends S3MultipartOptions> {
    private static final Logger log = LoggerFactory.getLogger(S3MultipartOptions.class);
    public static final int DEFAULT_CHUNK_SIZE = 0x6400000;
    private int chunkSize = 0x6400000;
    private int maxThreads = Runtime.getRuntime().availableProcessors() * 3;
    private int maxAttempts = 5;
    private long retrySleep = 500L;

    public S3MultipartOptions() {
    }

    public S3MultipartOptions(Properties props) {
        this.setMaxThreads(props.getProperty("upload_max_threads"));
        this.setChunkSize(props.getProperty("upload_chunk_size"));
        this.setMaxAttempts(props.getProperty("upload_max_attempts"));
        this.setRetrySleep(props.getProperty("upload_retry_sleep"));
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getChunkSize(long objectSize) {
        int MAX_PARTS = 10000;
        long numOfParts = objectSize / (long)this.chunkSize;
        if (numOfParts > 10000L) {
            this.chunkSize = (int)objectSize / 10000;
        }
        return this.chunkSize;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public long getRetrySleep() {
        return this.retrySleep;
    }

    public V setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return (V)this;
    }

    public V setChunkSize(String chunkSize) {
        if (chunkSize == null) {
            return (V)this;
        }
        try {
            this.setChunkSize(Integer.parseInt(chunkSize));
        }
        catch (NumberFormatException e) {
            log.warn("Not a valid AWS S3 multipart upload chunk size: `{}` -- Using default", (Object)chunkSize);
        }
        return (V)this;
    }

    public V setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return (V)this;
    }

    public V setMaxThreads(String maxThreads) {
        if (maxThreads == null) {
            return (V)this;
        }
        try {
            this.setMaxThreads(Integer.parseInt(maxThreads));
        }
        catch (NumberFormatException e) {
            log.warn("Not a valid AWS S3 multipart upload max threads: `{}` -- Using default", (Object)maxThreads);
        }
        return (V)this;
    }

    public V setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return (V)this;
    }

    public V setMaxAttempts(String maxAttempts) {
        if (maxAttempts == null) {
            return (V)this;
        }
        try {
            this.maxAttempts = Integer.parseInt(maxAttempts);
        }
        catch (NumberFormatException e) {
            log.warn("Not a valid AWS S3 multipart upload max attempts value: `{}` -- Using default", (Object)maxAttempts);
        }
        return (V)this;
    }

    public V setRetrySleep(long retrySleep) {
        this.retrySleep = retrySleep;
        return (V)this;
    }

    public V setRetrySleep(String retrySleep) {
        if (retrySleep == null) {
            return (V)this;
        }
        try {
            this.retrySleep = Long.parseLong(retrySleep);
        }
        catch (NumberFormatException e) {
            log.warn("Not a valid AWS S3 multipart upload retry sleep value: `{}` -- Using default", (Object)retrySleep);
        }
        return (V)this;
    }

    public long getRetrySleepWithAttempt(int attempt) {
        return this.retrySleep * (long)(1 << attempt - 1);
    }

    public String toString() {
        return "chunkSize=" + this.chunkSize + "; maxThreads=" + this.maxThreads + "; maxAttempts=" + this.maxAttempts + "; retrySleep=" + this.retrySleep;
    }
}

