/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs.util;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.upplication.s3fs.AmazonS3Client;
import com.upplication.s3fs.S3Path;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ObjectSummaryLookup {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectSummary.class);

    public S3ObjectSummary lookup(S3Path s3Path) throws NoSuchFileException {
        S3ObjectSummary summary = s3Path.fetchObjectSummary();
        if (summary != null) {
            return summary;
        }
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        if ("".equals(s3Path.getKey())) {
            ObjectMetadata meta = client.getObjectMetadata(s3Path.getBucket(), "");
            if (meta == null) {
                throw new NoSuchFileException("s3://" + s3Path.getBucket());
            }
            summary = new S3ObjectSummary();
            summary.setBucketName(s3Path.getBucket());
            summary.setETag(meta.getETag());
            summary.setKey(s3Path.getKey());
            summary.setLastModified(meta.getLastModified());
            summary.setSize(meta.getContentLength());
            return summary;
        }
        String marker = null;
        while (true) {
            ObjectListing listing;
            List results;
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(s3Path.getBucket());
            request.setPrefix(s3Path.getKey());
            request.setMaxKeys(Integer.valueOf(250));
            if (marker != null) {
                request.setMarker(marker);
            }
            if ((results = (listing = client.listObjects(request)).getObjectSummaries()).isEmpty()) break;
            for (S3ObjectSummary item : results) {
                if (!this.matchName(s3Path.getKey(), item)) continue;
                return item;
            }
            if (!listing.isTruncated()) break;
            marker = listing.getNextMarker();
        }
        throw new NoSuchFileException("s3://" + s3Path.getBucket() + "/" + s3Path.toString());
    }

    private boolean matchName(String fileName, S3ObjectSummary summary) {
        String foundKey = summary.getKey();
        if (!foundKey.startsWith(fileName)) {
            return false;
        }
        if (foundKey.length() == fileName.length()) {
            return true;
        }
        return foundKey.charAt(fileName.length()) == '/';
    }

    public ObjectMetadata getS3ObjectMetadata(S3Path s3Path) {
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        try {
            return client.getObjectMetadata(s3Path.getBucket(), s3Path.getKey());
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    @Deprecated
    private S3Object getS3Object(S3Path s3Path) {
        AmazonS3Client client = s3Path.getFileSystem().getClient();
        S3Object object = this.getS3Object(s3Path.getBucket(), s3Path.getKey(), client);
        if (object != null) {
            return object;
        }
        return this.getS3Object(s3Path.getBucket(), s3Path.getKey() + "/", client);
    }

    private S3Object getS3Object(String bucket, String key, AmazonS3Client client) {
        try {
            S3Object object = client.getObject(bucket, key);
            if (object.getObjectContent() != null) {
                try {
                    object.getObjectContent().close();
                }
                catch (IOException e) {
                    log.debug("Error while closing S3Object for bucket: `{}` and key: `{}` -- Cause: {}", new Object[]{bucket, key, e.getMessage()});
                }
            }
            return object;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            return null;
        }
    }
}

