/*
 * Decompiled with CFR 0.152.
 */
package com.upplication.s3fs.util;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.StorageClass;
import com.upplication.s3fs.util.S3MultipartOptions;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3UploadRequest
extends S3MultipartOptions<S3UploadRequest> {
    private static final Logger log = LoggerFactory.getLogger(S3UploadRequest.class);
    private S3ObjectId objectId;
    private StorageClass storageClass;
    private ObjectMetadata metadata;

    public S3UploadRequest() {
    }

    public S3UploadRequest(Properties props) {
        super(props);
        this.setStorageClass(props.getProperty("upload_storage_class"));
        this.setStorageEncryption(props.getProperty("storage_encryption"));
    }

    public S3ObjectId getObjectId() {
        return this.objectId;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public S3UploadRequest setObjectId(S3ObjectId objectId) {
        this.objectId = objectId;
        return this;
    }

    public S3UploadRequest setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public S3UploadRequest setStorageClass(String storageClass) {
        if (storageClass == null) {
            return this;
        }
        try {
            this.setStorageClass(StorageClass.fromValue((String)storageClass));
        }
        catch (IllegalArgumentException e) {
            log.warn("Not a valid AWS S3 storage class: `{}` -- Using default", (Object)storageClass);
        }
        return this;
    }

    public S3UploadRequest setStorageEncryption(String storageEncryption) {
        if (storageEncryption == null) {
            return this;
        }
        if (!"AES256".equals(storageEncryption)) {
            log.warn("Not a valid S3 server-side encryption type: `{}` -- Currently only AES256 is supported", (Object)storageEncryption);
        } else {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
            this.setMetadata(objectMetadata);
        }
        return this;
    }

    public S3UploadRequest setMetadata(ObjectMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public String toString() {
        return "objectId=" + this.objectId + "storageClass=" + this.storageClass + "metadata=" + this.metadata + super.toString();
    }
}

