/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import io.nexusrpc.OperationState;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OperationInfo {
    private final String id;
    private final OperationState state;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OperationInfo info) {
        return new Builder(info);
    }

    private OperationInfo(String id, OperationState state) {
        this.id = id;
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public OperationState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationInfo that = (OperationInfo)o;
        return Objects.equals(this.id, that.id) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state});
    }

    public String toString() {
        return "OperationInfo{id='" + this.id + '\'' + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static class Builder {
        private @Nullable String id;
        private @Nullable OperationState state;

        private Builder() {
        }

        private Builder(OperationInfo info) {
            this.id = info.id;
            this.state = info.state;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setState(OperationState state) {
            this.state = state;
            return this;
        }

        public OperationInfo build() {
            Objects.requireNonNull(this.id, "ID required");
            Objects.requireNonNull(this.state, "State required");
            return new OperationInfo(this.id, this.state);
        }
    }
}

