/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public interface Serializer {
    public Content serialize(@Nullable Object var1);

    public @Nullable Object deserialize(Content var1, Type var2);

    public static class Content {
        private final byte[] data;
        private final Map<String, String> headers;

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(Content content) {
            return new Builder(content);
        }

        private Content(byte[] data, Map<String, String> headers) {
            this.data = data;
            this.headers = headers;
        }

        public byte[] getData() {
            return this.data;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Content content = (Content)o;
            return Objects.deepEquals(this.data, content.data) && Objects.equals(this.headers, content.headers);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.data), this.headers);
        }

        public static class Builder {
            private byte @Nullable [] data;
            private final Map<String, String> headers;

            private Builder() {
                this.headers = new HashMap<String, String>();
            }

            private Builder(Content content) {
                this.data = content.data;
                this.headers = new HashMap<String, String>(content.headers);
            }

            public Builder setData(byte[] data) {
                this.data = data;
                return this;
            }

            public Map<String, String> getHeaders() {
                return this.headers;
            }

            public Builder putHeader(String key, String value) {
                this.headers.put(key, value);
                return this;
            }

            public Content build() {
                Objects.requireNonNull(this.data, "Data required");
                return new Content(this.data, Collections.unmodifiableMap(new HashMap<String, String>(this.headers)));
            }
        }
    }
}

