/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class HandlerInputContent {
    private final AtomicReference<InputStream> dataStream;
    private final Map<String, String> headers;

    public static Builder newBuilder() {
        return new Builder();
    }

    private HandlerInputContent(InputStream dataStream, Map<String, String> headers) {
        this.dataStream = new AtomicReference<InputStream>(dataStream);
        this.headers = headers;
    }

    public InputStream consumeStream() {
        InputStream stream = this.dataStream.getAndSet(null);
        if (stream == null) {
            throw new IllegalStateException("Data already consumed");
        }
        return stream;
    }

    public byte[] consumeBytes() throws IOException {
        int nRead;
        InputStream stream = this.consumeStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private @Nullable InputStream dataStream;
        private final SortedMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

        private Builder() {
        }

        public Builder setDataStream(InputStream data) {
            this.dataStream = data;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public HandlerInputContent build() {
            Objects.requireNonNull(this.dataStream, "Data stream required");
            SortedMap normalizedHeaders = this.headers.entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).toLowerCase(), Map.Entry::getValue, (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
            return new HandlerInputContent(this.dataStream, Collections.unmodifiableMap(new TreeMap(normalizedHeaders)));
        }
    }
}

