/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import io.nexusrpc.handler.OperationMethodCancellationListener;
import io.nexusrpc.handler.OperationMethodCanceller;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class OperationContext {
    private final String service;
    private final String operation;
    private final Map<String, String> headers;
    private final @Nullable OperationMethodCanceller methodCanceller;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OperationContext context) {
        return new Builder(context);
    }

    private OperationContext(String service, String operation, Map<String, String> headers, @Nullable OperationMethodCanceller methodCanceller) {
        this.service = service;
        this.operation = operation;
        this.headers = headers;
        this.methodCanceller = methodCanceller;
    }

    public String getService() {
        return this.service;
    }

    public String getOperation() {
        return this.operation;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isMethodCancelled() {
        return this.getMethodCancellationReason() != null;
    }

    public @Nullable String getMethodCancellationReason() {
        return this.methodCanceller == null ? null : this.methodCanceller.getCancellationReason();
    }

    public void addMethodCancellationListener(OperationMethodCancellationListener listener) {
        if (this.methodCanceller != null) {
            this.methodCanceller.addListener(listener);
        }
    }

    public void removeMethodCancellationListener(OperationMethodCancellationListener listener) {
        if (this.methodCanceller != null) {
            this.methodCanceller.removeListener(listener);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationContext that = (OperationContext)o;
        return Objects.equals(this.service, that.service) && Objects.equals(this.operation, that.operation) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.operation, this.headers);
    }

    public String toString() {
        return "OperationContext{service='" + this.service + '\'' + ", operation='" + this.operation + '\'' + ", headers=" + this.headers + '}';
    }

    public static class Builder {
        private @Nullable String service;
        private @Nullable String operation;
        private final SortedMap<String, String> headers;
        private @Nullable OperationMethodCanceller methodCanceller;

        private Builder() {
            this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }

        private Builder(OperationContext context) {
            this.service = context.service;
            this.operation = context.operation;
            this.headers = new TreeMap<String, String>(context.headers);
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Builder putHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder setMethodCanceller(OperationMethodCanceller methodCanceller) {
            this.methodCanceller = methodCanceller;
            return this;
        }

        public OperationContext build() {
            Objects.requireNonNull(this.service, "Service required");
            Objects.requireNonNull(this.operation, "Operation required");
            SortedMap normalizedHeaders = this.headers.entrySet().stream().collect(Collectors.toMap(k -> ((String)k.getKey()).toLowerCase(), Map.Entry::getValue, (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
            return new OperationContext(this.service, this.operation, Collections.unmodifiableMap(new TreeMap(normalizedHeaders)), this.methodCanceller);
        }
    }
}

