/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import io.nexusrpc.Link;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class OperationStartResult<R> {
    private final @Nullable R syncResult;
    private final @Nullable String asyncOperationId;
    private final List<Link> links;

    public static <R> Builder<R> newSyncBuilder(@Nullable R value) {
        return new Builder().setSyncResult(value);
    }

    public static <R> Builder<R> newAsyncBuilder(String operationId) {
        return new Builder().setAsyncOperationId(operationId);
    }

    public static <R> Builder<R> newBuilder(OperationStartResult<R> request) {
        return new Builder(request);
    }

    public static <R> OperationStartResult<R> sync(@Nullable R value) {
        return OperationStartResult.newSyncBuilder(value).build();
    }

    public static <R> OperationStartResult<R> async(String operationId) {
        return OperationStartResult.newAsyncBuilder(operationId).build();
    }

    private OperationStartResult(@Nullable R syncResult, @Nullable String asyncOperationId, List<Link> links) {
        this.syncResult = syncResult;
        this.asyncOperationId = asyncOperationId;
        this.links = links;
    }

    public boolean isSync() {
        return this.asyncOperationId == null;
    }

    public @Nullable R getSyncResult() {
        return this.syncResult;
    }

    public @Nullable String getAsyncOperationId() {
        return this.asyncOperationId;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public static class Builder<R> {
        private R syncResult;
        private @Nullable String asyncOperationId;
        private final List<Link> links;

        private Builder() {
            this.links = new ArrayList<Link>();
        }

        private Builder(OperationStartResult<R> result) {
            this.syncResult = ((OperationStartResult)result).syncResult;
            this.asyncOperationId = ((OperationStartResult)result).asyncOperationId;
            this.links = new ArrayList<Link>(((OperationStartResult)result).links);
        }

        private Builder<R> setSyncResult(R syncResult) {
            this.syncResult = syncResult;
            return this;
        }

        private Builder<R> setAsyncOperationId(String asyncOperationId) {
            if (asyncOperationId == null || asyncOperationId.isEmpty()) {
                throw new IllegalArgumentException("Operation ID cannot be null or empty");
            }
            this.asyncOperationId = asyncOperationId;
            return this;
        }

        public Builder<R> addLink(Link link) {
            this.links.add(link);
            return this;
        }

        public List<Link> getLinks() {
            return this.links;
        }

        public OperationStartResult<R> build() {
            if (this.syncResult != null && this.asyncOperationId != null) {
                throw new IllegalStateException("Cannot have both sync result and async operation ID");
            }
            return new OperationStartResult(this.syncResult, this.asyncOperationId, this.links != null ? this.links : Collections.emptyList());
        }
    }
}

