/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import io.nexusrpc.OperationInfo;
import io.nexusrpc.OperationUnsuccessfulException;
import io.nexusrpc.handler.OperationCancelDetails;
import io.nexusrpc.handler.OperationContext;
import io.nexusrpc.handler.OperationFetchInfoDetails;
import io.nexusrpc.handler.OperationFetchResultDetails;
import io.nexusrpc.handler.OperationHandler;
import io.nexusrpc.handler.OperationStartDetails;
import io.nexusrpc.handler.OperationStartResult;
import io.nexusrpc.handler.SynchronousOperationFunction;
import org.jspecify.annotations.Nullable;

class SynchronousOperationHandler<T, R>
implements OperationHandler<T, R> {
    private final SynchronousOperationFunction<T, R> function;

    SynchronousOperationHandler(SynchronousOperationFunction<T, R> function) {
        this.function = function;
    }

    @Override
    public OperationStartResult<R> start(OperationContext context, OperationStartDetails details, @Nullable T param) throws OperationUnsuccessfulException {
        return OperationStartResult.sync(this.function.apply(context, details, param));
    }

    @Override
    public @Nullable R fetchResult(OperationContext context, OperationFetchResultDetails details) {
        throw new UnsupportedOperationException("Not supported on sync operation");
    }

    @Override
    public OperationInfo fetchInfo(OperationContext context, OperationFetchInfoDetails details) {
        throw new UnsupportedOperationException("Not supported on sync operation");
    }

    @Override
    public void cancel(OperationContext context, OperationCancelDetails details) {
        throw new UnsupportedOperationException("Not supported on sync operation");
    }
}

