/*
 * Decompiled with CFR 0.152.
 */
package io.nexusrpc.handler;

import java.time.Duration;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OperationFetchResultDetails {
    private final String operationId;
    private final @Nullable Duration timeout;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OperationFetchResultDetails details) {
        return new Builder(details);
    }

    private OperationFetchResultDetails(String operationId, @Nullable Duration timeout) {
        this.operationId = operationId;
        this.timeout = timeout;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFetchResultDetails that = (OperationFetchResultDetails)o;
        return Objects.equals(this.operationId, that.operationId) && Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.operationId, this.timeout);
    }

    public String toString() {
        return "OperationFetchResultDetails{operationToken='" + this.operationId + '\'' + ", timeout=" + this.timeout + '}';
    }

    public static class Builder {
        private @Nullable String operationToken;
        private @Nullable Duration timeout;

        private Builder() {
        }

        private Builder(OperationFetchResultDetails details) {
            this.operationToken = details.operationId;
        }

        public Builder setOperationToken(String operationToken) {
            this.operationToken = operationToken;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OperationFetchResultDetails build() {
            Objects.requireNonNull(this.operationToken, "Operation Token required");
            return new OperationFetchResultDetails(this.operationToken, this.timeout);
        }
    }
}

