/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.storage.db.DatabaseInitializer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class DatabaseConfiguration {
    public static final String NFLOW_DATABASE_INITIALIZER = "nflowDatabaseInitializer";
    private static final Logger logger = LoggerFactory.getLogger(DatabaseConfiguration.class);
    private final String dbType;

    protected DatabaseConfiguration(String dbType) {
        this.dbType = dbType;
    }

    @Bean
    @NFlow
    public DataSource nflowDatasource(Environment env, BeanFactory appCtx) {
        String url = this.property(env, "url");
        logger.info("Database connection to {} using {}", (Object)this.dbType, (Object)url);
        HikariConfig config = new HikariConfig();
        config.setPoolName("nflow");
        config.setDriverClassName(this.property(env, "driver"));
        config.setJdbcUrl(url);
        config.setUsername(this.property(env, "user"));
        config.setPassword(this.property(env, "password"));
        config.setMaximumPoolSize(this.property(env, "max_pool_size", Integer.class).intValue());
        config.setIdleTimeout(this.property(env, "idle_timeout_seconds", Long.class) * 1000L);
        config.setAutoCommit(true);
        this.setMetricRegistryIfBeanFoundOnClassPath(config, appCtx);
        HikariDataSource nflowDataSource = new HikariDataSource(config);
        this.checkDatabaseConfiguration(env, (DataSource)nflowDataSource);
        return nflowDataSource;
    }

    private void setMetricRegistryIfBeanFoundOnClassPath(HikariConfig config, BeanFactory appCtx) {
        try {
            Class<?> metricClass = Class.forName("com.codahale.metrics.MetricRegistry");
            Object metricRegistry = appCtx.getBean(metricClass);
            config.setMetricRegistry(metricRegistry);
        }
        catch (ClassNotFoundException | NoSuchBeanDefinitionException throwable) {
            // empty catch block
        }
    }

    @Bean
    @NFlow
    @Scope(value="prototype")
    @DependsOn(value={"nflowDatabaseInitializer"})
    public JdbcTemplate nflowJdbcTemplate(@NFlow DataSource nflowDataSource) {
        return new JdbcTemplate(nflowDataSource);
    }

    @Bean
    @NFlow
    @Scope(value="prototype")
    @DependsOn(value={"nflowDatabaseInitializer"})
    public NamedParameterJdbcTemplate nflowNamedParameterJdbcTemplate(@NFlow DataSource nflowDataSource) {
        return new NamedParameterJdbcTemplate(nflowDataSource);
    }

    @Bean
    @NFlow
    public TransactionTemplate nflowTransactionTemplate(PlatformTransactionManager platformTransactionManager) {
        return new TransactionTemplate(platformTransactionManager);
    }

    protected String property(Environment env, String key) {
        return this.property(env, key, String.class);
    }

    protected <T> T property(Environment env, String key, Class<T> type) {
        Object val = env.getProperty("nflow.db." + key, type);
        if (val == null && (val = env.getProperty("nflow.db." + this.dbType + "." + key, type)) == null) {
            throw new IllegalStateException("required key [nflow.db." + key + "] not found");
        }
        return (T)val;
    }

    @Bean(name={"nflowDatabaseInitializer"})
    @NFlow
    public DatabaseInitializer nflowDatabaseInitializer(@NFlow DataSource dataSource, Environment env) {
        return new DatabaseInitializer(this.dbType, dataSource, env, ";");
    }

    @SuppressFBWarnings(value={"ACEM_ABSTRACT_CLASS_EMPTY_METHODS"}, justification="Most databases do not check database configuration")
    protected void checkDatabaseConfiguration(Environment env, DataSource dataSource) {
    }
}

