/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.dao.DaoUtil;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.workflow.executor.WorkflowExecutor;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="common jdbctemplate practice")
public class ExecutorDao {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorDao.class);
    private final JdbcTemplate jdbc;
    final SQLVariants sqlVariants;
    private final int keepaliveIntervalSeconds;
    private DateTime nextUpdate = DateTime.now();
    final String executorGroup;
    private final String executorGroupCondition;
    final int timeoutSeconds;
    private int executorId = -1;
    private final int hostMaxLength;

    @Inject
    public ExecutorDao(SQLVariants sqlVariants, @NFlow JdbcTemplate nflowJdbcTemplate, Environment env) {
        this.sqlVariants = sqlVariants;
        this.jdbc = nflowJdbcTemplate;
        this.executorGroup = StringUtils.trimToNull((String)env.getRequiredProperty("nflow.executor.group"));
        this.executorGroupCondition = ExecutorDao.createWhereCondition(this.executorGroup);
        this.timeoutSeconds = (Integer)env.getRequiredProperty("nflow.executor.timeout.seconds", Integer.class);
        this.keepaliveIntervalSeconds = (Integer)env.getRequiredProperty("nflow.executor.keepalive.seconds", Integer.class);
        this.hostMaxLength = (Integer)env.getProperty("nflow.executor.host.length", Integer.class, (Object)-1);
    }

    private static String createWhereCondition(String group) {
        return "executor_group = '" + group + "'";
    }

    public boolean tick() {
        if (this.nextUpdate.isAfterNow()) {
            return false;
        }
        this.nextUpdate = DateTime.now().plusSeconds(this.keepaliveIntervalSeconds);
        this.updateActiveTimestamp();
        return true;
    }

    public String getExecutorGroup() {
        return this.executorGroup;
    }

    public String getExecutorGroupCondition() {
        return this.executorGroupCondition;
    }

    public synchronized int getExecutorId() {
        if (this.executorId == -1) {
            int hostNameMaxLength = this.hostMaxLength == -1 ? (Integer)this.jdbc.query("select host from nflow_executor where 1 = 0", (ResultSetExtractor)DaoUtil.firstColumnLengthExtractor) : this.hostMaxLength;
            this.executorId = this.allocateExecutorId(hostNameMaxLength);
        }
        return this.executorId;
    }

    public DateTime getMaxWaitUntil() {
        return this.nextUpdate;
    }

    @Transactional
    public boolean isTransactionSupportEnabled() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public boolean isAutoCommitEnabled() {
        return (Boolean)this.jdbc.execute(Connection::getAutoCommit);
    }

    @SuppressFBWarnings(value={"MDM_INETADDRESS_GETLOCALHOST", "WEM_WEAK_EXCEPTION_MESSAGING"}, justification="localhost is used for getting host name only, exception message is fine")
    private int allocateExecutorId(int hostNameMaxLength) {
        int pid;
        String host;
        try {
            host = StringUtils.left((String)InetAddress.getLocalHost().getCanonicalHostName(), (int)hostNameMaxLength);
            pid = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        catch (NumberFormatException | UnknownHostException ex) {
            throw new RuntimeException("Failed to obtain host name and pid of running jvm", ex);
        }
        logger.info("Joining executor group {}", (Object)this.executorGroup);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbc.update(new PreparedStatementCreator(){

            @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE", "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="findbugs does not trust jdbctemplate, sql is constant in practice")
            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                String sql = "insert into nflow_executor(host, pid, executor_group, active, expires) values (?, ?, ?, current_timestamp, " + ExecutorDao.this.sqlVariants.currentTimePlusSeconds(ExecutorDao.this.timeoutSeconds) + ")";
                PreparedStatement p = con.prepareStatement(sql, new String[]{"id"});
                p.setString(1, host);
                p.setInt(2, pid);
                p.setString(3, ExecutorDao.this.executorGroup);
                return p;
            }
        }, (KeyHolder)keyHolder);
        int allocatedExecutorId = keyHolder.getKey().intValue();
        logger.info("Joined executor group {} as executor {} running on host {} with process id {}.", new Object[]{this.executorGroup, allocatedExecutorId, host, pid});
        return allocatedExecutorId;
    }

    public void updateActiveTimestamp() {
        this.updateWithPreparedStatement("update nflow_executor set active=current_timestamp, expires=" + this.sqlVariants.currentTimePlusSeconds(this.timeoutSeconds) + " where id = " + this.getExecutorId());
    }

    private void updateWithPreparedStatement(String sql) {
        this.jdbc.update(sql, (PreparedStatementSetter)null);
    }

    public List<WorkflowExecutor> getExecutors() {
        return this.jdbc.query("select * from nflow_executor where executor_group = ? order by id asc", (RowMapper)new RowMapper<WorkflowExecutor>(){

            public WorkflowExecutor mapRow(ResultSet rs, int rowNum) throws SQLException {
                int id = rs.getInt("id");
                String host = rs.getString("host");
                int pid = rs.getInt("pid");
                DateTime started = ExecutorDao.this.sqlVariants.getDateTime(rs, "started");
                DateTime active = ExecutorDao.this.sqlVariants.getDateTime(rs, "active");
                DateTime expires = ExecutorDao.this.sqlVariants.getDateTime(rs, "expires");
                DateTime stopped = ExecutorDao.this.sqlVariants.getDateTime(rs, "stopped");
                return new WorkflowExecutor(id, host, pid, ExecutorDao.this.executorGroup, started, active, expires, stopped);
            }
        }, new Object[]{this.executorGroup});
    }

    public void markShutdown() {
        try {
            this.jdbc.update("update nflow_executor set expires=current_timestamp, stopped=current_timestamp where executor_group = ? and id = ?", new Object[]{this.executorGroup, this.getExecutorId()});
        }
        catch (DataAccessException e) {
            logger.warn("Failed to mark executor as expired", (Throwable)e);
        }
    }
}

