/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.dao.ExecutorDao;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.internal.workflow.StoredWorkflowDefinition;
import io.nflow.engine.workflow.definition.AbstractWorkflowDefinition;
import io.nflow.engine.workflow.definition.WorkflowState;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WorkflowDefinitionDao {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionDao.class);
    private final ExecutorDao executorInfo;
    private final NamedParameterJdbcTemplate namedJdbc;
    private final ObjectMapper nflowObjectMapper;
    private final SQLVariants sqlVariants;

    @Inject
    public WorkflowDefinitionDao(SQLVariants sqlVariants, @NFlow NamedParameterJdbcTemplate nflowNamedParameterJdbcTemplate, @NFlow ObjectMapper nflowObjectMapper, ExecutorDao executorDao) {
        this.sqlVariants = sqlVariants;
        this.namedJdbc = nflowNamedParameterJdbcTemplate;
        this.nflowObjectMapper = nflowObjectMapper;
        this.executorInfo = executorDao;
    }

    public void storeWorkflowDefinition(AbstractWorkflowDefinition<? extends WorkflowState> definition) {
        StoredWorkflowDefinition storedDefinition = this.convert(definition);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("type", (Object)definition.getType());
        String serializedDefinition = this.serializeDefinition(storedDefinition);
        params.addValue("definition_sha1", (Object)this.sha1(serializedDefinition));
        params.addValue("definition", (Object)serializedDefinition, this.sqlVariants.longTextType());
        params.addValue("modified_by", (Object)this.executorInfo.getExecutorId());
        params.addValue("executor_group", (Object)this.executorInfo.getExecutorGroup());
        String sql = "update nflow_workflow_definition set definition = :definition, modified_by = :modified_by, definition_sha1 = :definition_sha1 where type = :type and executor_group = :executor_group and definition_sha1 <> :definition_sha1";
        int updatedRows = this.namedJdbc.update(sql, (SqlParameterSource)params);
        if (updatedRows == 0) {
            sql = "insert into nflow_workflow_definition(type, definition_sha1, definition, modified_by, executor_group) values (:type, :definition_sha1, :definition, :modified_by, :executor_group)";
            try {
                this.namedJdbc.update(sql, (SqlParameterSource)params);
            }
            catch (DataIntegrityViolationException dex) {
                logger.debug("Another executor already stored the definition.", (Throwable)dex);
            }
        }
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="exception message is fine")
    private String sha1(String serializedDefinition) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(serializedDefinition.getBytes(StandardCharsets.UTF_8));
            return String.format("%040x", new BigInteger(1, digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 not supported", e);
        }
    }

    public List<StoredWorkflowDefinition> queryStoredWorkflowDefinitions(Collection<String> types) {
        String sql = "select definition from nflow_workflow_definition where " + this.executorInfo.getExecutorGroupCondition();
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (!CollectionUtils.isEmpty(types)) {
            sql = sql + " and type in (:types)";
            params.addValue("types", types);
        }
        return this.namedJdbc.query(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<StoredWorkflowDefinition>(){

            public StoredWorkflowDefinition mapRow(ResultSet rs, int rowNum) throws SQLException {
                return WorkflowDefinitionDao.this.deserializeDefinition(rs.getString("definition"));
            }
        });
    }

    StoredWorkflowDefinition convert(AbstractWorkflowDefinition<? extends WorkflowState> definition) {
        StoredWorkflowDefinition resp = new StoredWorkflowDefinition();
        resp.type = definition.getType();
        resp.description = definition.getDescription();
        resp.onError = definition.getErrorState().name();
        Map<String, StoredWorkflowDefinition.State> states = definition.getStates().stream().collect(Collectors.toMap(WorkflowState::name, state -> new StoredWorkflowDefinition.State(state.name(), state.getType().name(), state.getDescription())));
        for (Map.Entry<String, List<String>> entry2 : definition.getAllowedTransitions().entrySet()) {
            StoredWorkflowDefinition.State state2 = states.get(entry2.getKey());
            for (String targetState : entry2.getValue()) {
                state2.transitions.add(targetState);
            }
            Collections.sort(state2.transitions);
        }
        for (Map.Entry<String, Object> entry3 : definition.getFailureTransitions().entrySet()) {
            StoredWorkflowDefinition.State state2 = states.get(entry3.getKey());
            state2.onFailure = ((WorkflowState)entry3.getValue()).name();
        }
        resp.states = new ArrayList<StoredWorkflowDefinition.State>(states.values());
        Collections.sort(resp.states);
        resp.supportedSignals = definition.getSupportedSignals().entrySet().stream().map(entry -> {
            StoredWorkflowDefinition.Signal signal = new StoredWorkflowDefinition.Signal();
            signal.value = (Integer)entry.getKey();
            signal.description = (String)entry.getValue();
            return signal;
        }).sorted().collect(Collectors.toList());
        return resp;
    }

    private String serializeDefinition(StoredWorkflowDefinition storedDefinition) {
        try {
            return this.nflowObjectMapper.writeValueAsString((Object)storedDefinition);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize workflow definition " + storedDefinition.type, e);
        }
    }

    StoredWorkflowDefinition deserializeDefinition(String serializedDefinition) {
        try {
            return (StoredWorkflowDefinition)this.nflowObjectMapper.readValue(serializedDefinition, StoredWorkflowDefinition.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize workflow definition " + serializedDefinition, e);
        }
    }
}

