/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;

@SuppressFBWarnings(value={"LO_SUSPECT_LOG_PARAMETER"}, justification="we are wrapping the logger here")
public class PeriodicLogger {
    private long previousLogging;
    private final int periodInSeconds;
    private final Logger logger;

    public PeriodicLogger(Logger logger, int periodInSeconds) {
        this.logger = logger;
        this.periodInSeconds = periodInSeconds;
    }

    public void info(String message, Object ... parameters) {
        if (this.canLog()) {
            this.logger.info(message, parameters);
        }
    }

    public void warn(String message, Object ... parameters) {
        if (this.canLog()) {
            this.logger.warn(message, parameters);
        }
    }

    private boolean canLog() {
        long currentPeriod = this.periodNumber();
        if (this.previousLogging != currentPeriod) {
            this.previousLogging = currentPeriod;
            return true;
        }
        return false;
    }

    private long periodNumber() {
        return DateTimeUtils.currentTimeMillis() / 1000L / (long)this.periodInSeconds;
    }
}

