/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import io.nflow.engine.service.MaintenanceConfiguration;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MaintenanceWorkflowStarter {
    public static final String MAINTENANCE_WORKFLOW_DEFAULT_EXTERNAL_ID = "default";
    protected final WorkflowInstanceFactory workflowInstanceFactory;
    protected final WorkflowInstanceService instanceService;
    protected boolean insertOnStartup;
    protected String initialCronSchedule;
    protected MaintenanceConfiguration initialConfiguration;

    public MaintenanceWorkflowStarter(Environment env, WorkflowInstanceService instanceService, WorkflowInstanceFactory workflowInstanceFactory) {
        this.workflowInstanceFactory = workflowInstanceFactory;
        this.instanceService = instanceService;
        this.insertOnStartup = (Boolean)env.getRequiredProperty("nflow.maintenance.insertWorkflowIfMissing", Boolean.class);
        this.initialCronSchedule = env.getRequiredProperty("nflow.maintenance.initial.cron");
        MaintenanceConfiguration.Builder builder = new MaintenanceConfiguration.Builder();
        this.apply(env, "archive", builder::withArchiveWorkflows);
        this.apply(env, "delete", builder::withDeleteWorkflows);
        this.apply(env, "deleteArchived", builder::withDeleteArchivedWorkflows);
        this.initialConfiguration = builder.build();
    }

    private void apply(Environment env, String property, Supplier<MaintenanceConfiguration.ConfigurationItem.Builder> builderSupplier) {
        Optional.ofNullable(env.getProperty("nflow.maintenance.initial." + property + ".olderThan")).map(StringUtils::trimToNull).map(Period::parse).ifPresent(period -> ((MaintenanceConfiguration.ConfigurationItem.Builder)builderSupplier.get()).setOlderThanPeriod((ReadablePeriod)period).done());
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        if (this.insertOnStartup) {
            this.insertOnStartup = false;
            this.instanceService.insertWorkflowInstance(this.workflowInstanceFactory.newWorkflowInstanceBuilder().setType("nFlowMaintenance").putStateVariable("cron", this.initialCronSchedule).putStateVariable("config", this.initialConfiguration).setExternalId(MAINTENANCE_WORKFLOW_DEFAULT_EXTERNAL_ID).build());
        }
    }
}

