/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.workflow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.model.ModelObject;
import java.util.ArrayList;
import java.util.List;

public class StoredWorkflowDefinition
extends ModelObject {
    public String type;
    public String description;
    public String onError;
    public List<State> states;
    public List<Signal> supportedSignals = new ArrayList<Signal>();

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="serialized to database with object mapper")
    public static class Signal
    extends ModelObject
    implements Comparable<Signal> {
        public Integer value;
        public String description;

        @Override
        @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="This class has a natural ordering that is inconsistent with equals, signal value should never be null")
        public int compareTo(Signal o) {
            return this.value.compareTo(o.value);
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="serialized to database with object mapper")
    public static class State
    extends ModelObject
    implements Comparable<State> {
        public String id;
        public String type;
        public String description;
        public List<String> transitions = new ArrayList<String>();
        public String onFailure;

        public State() {
        }

        public State(String id, String type, String description) {
            this.id = id;
            this.type = type;
            this.description = description;
        }

        @Override
        @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="This class has a natural ordering that is inconsistent with equals")
        public int compareTo(State state) {
            return this.type.compareTo(state.type);
        }
    }
}

