/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.definition;

import io.nflow.engine.internal.workflow.WorkflowDefinitionScanner;
import io.nflow.engine.internal.workflow.WorkflowStateMethod;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.definition.NextAction;
import io.nflow.engine.workflow.definition.WorkflowSettings;
import io.nflow.engine.workflow.definition.WorkflowState;
import io.nflow.engine.workflow.definition.WorkflowStateType;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class AbstractWorkflowDefinition<S extends WorkflowState>
extends ModelObject {
    private final String type;
    private String name;
    private String description;
    private final S initialState;
    private final S errorState;
    private final WorkflowSettings settings;
    protected final Map<String, List<String>> allowedTransitions = new LinkedHashMap<String, List<String>>();
    protected final Map<String, WorkflowState> failureTransitions = new LinkedHashMap<String, WorkflowState>();
    private Map<String, WorkflowStateMethod> stateMethods;

    protected AbstractWorkflowDefinition(String type, S initialState, S errorState) {
        this(type, initialState, errorState, new WorkflowSettings.Builder().build());
    }

    protected AbstractWorkflowDefinition(String type, S initialState, S errorState, WorkflowSettings settings) {
        this(type, initialState, errorState, settings, null);
    }

    protected AbstractWorkflowDefinition(String type, S initialState, S errorState, WorkflowSettings settings, Map<String, WorkflowStateMethod> stateMethods) {
        Assert.notNull(initialState, (String)"initialState must not be null");
        Assert.isTrue((initialState.getType() == WorkflowStateType.start ? 1 : 0) != 0, (String)"initialState must be a start state");
        Assert.notNull(errorState, (String)"errorState must not be null");
        this.type = type;
        this.initialState = initialState;
        this.errorState = errorState;
        this.settings = settings;
        this.stateMethods = stateMethods != null ? stateMethods : new WorkflowDefinitionScanner().getStateMethods(this.getClass());
        this.requireStateMethodExists(initialState);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public S getInitialState() {
        return this.initialState;
    }

    public S getErrorState() {
        return this.errorState;
    }

    public abstract Set<S> getStates();

    public Map<String, List<String>> getAllowedTransitions() {
        return new LinkedHashMap<String, List<String>>(this.allowedTransitions);
    }

    public Map<String, WorkflowState> getFailureTransitions() {
        return new LinkedHashMap<String, WorkflowState>(this.failureTransitions);
    }

    protected AbstractWorkflowDefinition<S> permit(S originState, S targetState) {
        this.requireStateMethodExists(originState);
        this.requireStateMethodExists(targetState);
        this.allowedTransitionsFor(originState).add(targetState.name());
        return this;
    }

    protected AbstractWorkflowDefinition<S> permit(S originState, S targetState, S failureState) {
        Assert.notNull(failureState, (String)"Failure state can not be null");
        this.requireStateMethodExists(failureState);
        WorkflowState existingFailure = this.failureTransitions.put(originState.name(), (WorkflowState)failureState);
        Assert.isTrue((existingFailure == null || existingFailure.equals(failureState) ? 1 : 0) != 0, (String)("Different failureState '" + existingFailure + "' already defined for originState '" + originState.name() + "'"));
        return this.permit(originState, targetState);
    }

    private List<String> allowedTransitionsFor(S state) {
        String stateName = state.name();
        List<String> transitions = this.allowedTransitions.get(stateName);
        if (transitions == null) {
            transitions = new ArrayList<String>();
            this.allowedTransitions.put(stateName, transitions);
        }
        return transitions;
    }

    public WorkflowSettings getSettings() {
        return this.settings;
    }

    final void requireStateMethodExists(S state) {
        WorkflowStateMethod stateMethod = this.stateMethods.get(state.name());
        if (stateMethod == null && !state.getType().isFinal()) {
            String msg = String.format("Class '%s' is missing non-final state handling method 'public NextAction %s(StateExecution execution, ... args)'", this.getClass().getName(), state.name());
            throw new IllegalArgumentException(msg);
        }
        if (stateMethod != null) {
            WorkflowStateType stateType = state.getType();
            Class<?> returnType = stateMethod.method.getReturnType();
            if (!stateType.isFinal() && !NextAction.class.equals(returnType)) {
                String msg = String.format("Class '%s' has a non-final state method '%s' that does not return NextAction", this.getClass().getName(), state.name());
                throw new IllegalArgumentException(msg);
            }
            if (stateType.isFinal() && !Void.TYPE.equals(returnType)) {
                String msg = String.format("Class '%s' has a final state method '%s' that returns a value", this.getClass().getName(), state.name());
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public WorkflowStateMethod getMethod(String stateName) {
        return this.stateMethods.get(stateName);
    }

    public WorkflowState getState(String state) {
        for (WorkflowState s : this.getStates()) {
            if (!Objects.equals(s.name(), state)) continue;
            return s;
        }
        throw new IllegalStateException("No state '" + state + "' in workflow definiton " + this.getType());
    }

    public boolean isStartState(String state) {
        return this.getState(state).getType() == WorkflowStateType.start;
    }

    public boolean isAllowedNextAction(WorkflowInstance instance, NextAction nextAction) {
        if (nextAction.isRetry()) {
            return true;
        }
        List<String> allowedNextStates = this.allowedTransitions.get(instance.state);
        if (allowedNextStates != null && allowedNextStates.contains(nextAction.getNextState().name())) {
            return true;
        }
        if (nextAction.getNextState() == this.failureTransitions.get(instance.state)) {
            return true;
        }
        return nextAction.getNextState() == this.getErrorState();
    }

    public Map<Integer, String> getSupportedSignals() {
        return Collections.emptyMap();
    }
}

