/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.workflow.instance;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.model.ModelObject;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class WorkflowInstanceAction
extends ModelObject {
    public long id;
    public final long workflowInstanceId;
    public final int executorId;
    public final WorkflowActionType type;
    public final String state;
    public final String stateText;
    public final Map<String, String> updatedStateVariables;
    public final int retryNo;
    public final DateTime executionStart;
    public final DateTime executionEnd;

    WorkflowInstanceAction(Builder builder) {
        this.id = builder.id;
        this.workflowInstanceId = builder.workflowInstanceId;
        this.executorId = builder.executorId;
        this.type = builder.type;
        this.state = builder.state;
        this.stateText = builder.stateText;
        this.updatedStateVariables = Collections.unmodifiableMap(builder.updatedStateVariables);
        this.retryNo = builder.retryNo;
        this.executionStart = builder.executionStart;
        this.executionEnd = builder.executionEnd;
    }

    public static class Builder {
        long id;
        long workflowInstanceId;
        int executorId;
        WorkflowActionType type;
        String state;
        String stateText;
        int retryNo;
        DateTime executionStart;
        DateTime executionEnd;
        Map<String, String> updatedStateVariables = new LinkedHashMap<String, String>();

        public Builder() {
        }

        public Builder(WorkflowInstanceAction action) {
            this.id = action.id;
            this.executionEnd = action.executionEnd;
            this.executionStart = action.executionStart;
            this.executorId = action.executorId;
            this.retryNo = action.retryNo;
            this.type = action.type;
            this.state = action.state;
            this.stateText = action.stateText;
            this.updatedStateVariables.putAll(action.updatedStateVariables);
            this.workflowInstanceId = action.workflowInstanceId;
        }

        public Builder(WorkflowInstance instance) {
            this.workflowInstanceId = instance.id;
            this.state = instance.state;
            this.retryNo = instance.retries;
            this.executionStart = DateTime.now();
        }

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setWorkflowInstanceId(long workflowInstanceId) {
            this.workflowInstanceId = workflowInstanceId;
            return this;
        }

        public Builder setExecutorId(Integer executorId) {
            this.executorId = executorId;
            return this;
        }

        public Builder setType(WorkflowActionType actionType) {
            this.type = actionType;
            return this;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setStateText(String stateText) {
            this.stateText = stateText;
            return this;
        }

        public Builder setUpdatedStateVariables(Map<String, String> updatedStateVariables) {
            this.updatedStateVariables = updatedStateVariables;
            return this;
        }

        public Builder setRetryNo(int retryNo) {
            this.retryNo = retryNo;
            return this;
        }

        public Builder setExecutionStart(DateTime executionStart) {
            this.executionStart = executionStart;
            return this;
        }

        public Builder setExecutionEnd(DateTime executionEnd) {
            this.executionEnd = executionEnd;
            return this;
        }

        @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="exception message is ok")
        public WorkflowInstanceAction build() {
            if (this.type == null) {
                throw new IllegalStateException("Missing type");
            }
            return new WorkflowInstanceAction(this);
        }
    }

    public static enum WorkflowActionType {
        stateExecution,
        stateExecutionFailed,
        externalChange,
        recovery;

    }
}

