/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config.db;

import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.internal.dao.DaoUtil;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;

@Profile(value={"nflow.db.db2"})
@Configuration
public class Db2DatabaseConfiguration
extends DatabaseConfiguration {
    public Db2DatabaseConfiguration() {
        super("db2");
    }

    @Override
    @Bean
    public SQLVariants sqlVariants(Environment env) {
        return new Db2SQLVariants(this.property(env, "timezone"));
    }

    @Override
    protected void checkDatabaseConfiguration(Environment env, DataSource dataSource) {
        Long propsTimeZoneOffsetHours;
        JdbcTemplate jdbc = new JdbcTemplate(dataSource);
        Long dbTimeZoneOffsetHours = (Long)jdbc.queryForObject("select current timezone from sysibm.sysdummy1", Long.class);
        if (!Objects.equals(dbTimeZoneOffsetHours, propsTimeZoneOffsetHours = Long.valueOf(TimeUnit.HOURS.convert(TimeZone.getTimeZone(this.property(env, "timezone")).getOffset(System.currentTimeMillis()), TimeUnit.MILLISECONDS)))) {
            throw new RuntimeException("Database has unexpected time zone - hour offset in DB2 is " + dbTimeZoneOffsetHours + " but the expected hour offset based on timezone-property is " + propsTimeZoneOffsetHours + ". Change the timezone-property to match with your DB2 time zone.");
        }
    }

    public static class Db2SQLVariants
    implements SQLVariants {
        private final ZoneId dbTimeZoneId;

        public Db2SQLVariants(String dbTimeZoneIdStr) {
            this.dbTimeZoneId = ZoneId.of(dbTimeZoneIdStr);
        }

        @Override
        public String currentTimePlusSeconds(int seconds) {
            return "current_timestamp + " + seconds + " SECONDS";
        }

        @Override
        public boolean hasUpdateableCTE() {
            return false;
        }

        @Override
        public String nextActivationUpdate() {
            return "(case when ? is null then null when external_next_activation is null then ? else least(?, external_next_activation) end)";
        }

        @Override
        public String workflowStatus(WorkflowInstance.WorkflowInstanceStatus status) {
            return "'" + status.name() + "'";
        }

        @Override
        public String workflowStatus() {
            return "?";
        }

        @Override
        public String actionType() {
            return "?";
        }

        @Override
        public String castToText() {
            return "";
        }

        @Override
        public String forUpdateSkipLocked() {
            return "";
        }

        @Override
        public String limit(String query, long limit) {
            return query + " fetch first " + limit + " rows only";
        }

        @Override
        public int longTextType() {
            return 12;
        }

        @Override
        public boolean useBatchUpdate() {
            return true;
        }

        @Override
        public Object getTimestamp(ResultSet rs, String columnName) throws SQLException {
            return Optional.ofNullable(rs.getTimestamp(columnName)).map(ts -> new Timestamp(ts.getTime() + this.timeZoneMismatchInMillis())).orElse(null);
        }

        @Override
        public DateTime getDateTime(ResultSet rs, String columnName) throws SQLException {
            return Optional.ofNullable(rs.getTimestamp(columnName)).map(ts -> new DateTime(ts.getTime() + this.timeZoneMismatchInMillis())).orElse(null);
        }

        @Override
        public void setDateTime(PreparedStatement ps, int columnNumber, DateTime timestamp) throws SQLException {
            ps.setTimestamp(columnNumber, DaoUtil.toTimestamp((BaseDateTime)timestamp), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        }

        @Override
        public Object toTimestampObject(DateTime timestamp) {
            return Optional.ofNullable(timestamp).map(ts -> new Timestamp(timestamp.getMillis() - this.timeZoneMismatchInMillis())).orElse(null);
        }

        @Override
        public Object tuneTimestampForDb(Object timestamp) {
            return new Timestamp(((Timestamp)timestamp).getTime() - this.timeZoneMismatchInMillis());
        }

        private long timeZoneMismatchInMillis() {
            long now = System.currentTimeMillis();
            return TimeZone.getDefault().getOffset(now) - TimeZone.getTimeZone(this.dbTimeZoneId).getOffset(now);
        }
    }
}

